.\" Process this file with
.\" groff -man -Tutf8 akfavatar-term.de.man
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "akfavatar-term" 3 2012-07-21 AKFAvatar
.
.SH NAME
akfavatar-term \- Modul zum Ausfhren von Terminal-basierten Programmen in AKFAvatar
.
.SH SYNTAX
.PP
term = require "akfavatar-term"
.PP
.BR Hinweis :
Man muss eine globale Variable verwenden, wenn man die APC-Schnittstelle
verwenden will.
.PP
.SH BESCHREIBUNG
.PP
Dieses Modul kann man verwenden um allgemeine Terminal-basierte Programme
innerhalb von AKFAvatar laufen zu lassen.
Die Terminal-Emulation emuliert eine Linux-Textkonsole
(nicht nur auf Linux-basierten Systemen).
.PP
Es kann auch dafr verwendet werden, um spezifische Programme fr AKFAvatar zu
schreiben, in Programmiersprachen, die ansonsten nicht untersttzt werden.
Es gibt ein paar Mglichkeiten mit denen das ausfhrende Skript und das
auszufhrende Programm miteinander kommunizieren knnen.
.PP
.BR Achtung :
Dieses Modul steht nicht fr allen Plattformen zur Verfgung!
Insbesondere nicht fr Windows.
.PP
.TP
.BI term.startdir( [Verzeichnis] )
Legt das Anfangsverzeichnis fr den nchsten
.BR term.execute() -Befehl
fest.
Wenn kein
.I Verzeichnis
angegeben wird, wird die vorherige Einstellung dadurch gelscht.
.IP
.BR Hinweis :
Das Arbeitsverzeichnis des ausfhrenden Skriptes und des ausgefhrten
Programmes sind voneinander unabhngig!
.PP
.TP
.B term.homedir()
Setzt das Anfangsverzeichnis fr den nchsten
.BR term.execute() -Befehl
auf das Heimatverzeichnis des Benutzers.
.IP
.BR Hinweis :
Das Arbeitsverzeichnis des ausfhrenden Skriptes und des ausgefhrten
Programmes sind voneinander unabhngig!
.PP
.TP
.BI term.color( "true|false" )
Schaltet die Farbuntersttzung ein oder aus.
Der Terminal-Typ mit Farben ist \[Bq]linux\[lq],
ohne Farben \[Bq]linux-m\[lq].
.PP
.TP
.BI term.setenv( "Variable, Wert" )
Setzt die angegebene
.RI Umgebungs variable
auf den angegebenen
.IR Wert .
.br
Das hat auch Einfluss auf Programme, die mit
.BR os.execute() " oder " io.popen()
ausgefhrt werden.
.PP
.TP
.BI term.unsetenv( Variable )
Lscht die angegebene
.RI Umgebungs variable .
.br
Das hat auch Einfluss auf Programme, die mit
.BR os.execute() " oder " io.popen()
ausgefhrt werden.
.PP
.TP
.BI term.execute( "[Programm [, Argumente]]" )
Fhrt das angegebene
.I Programm
mit den angegebenen
.IR Argumente n
in der Terminal-Emulation aus.
Wenn kein
.I Programm
angegeben wird, wird die Standard-Shell ausgefhrt.
.PP
.SS APC-Schnittstelle
.PP
Die \[Bq]Application Program Command\[lq] (APC) Schnittstelle ist
eine Methode mit der das ausgefhrte Programm mit dem Lua-Interpreter
des ausfhrenden Programmes kommunizieren kann.
Um dies zu verwenden sendet das ausgefhrte Programm Escape-Sequenzen der Art,
wie ESC + \[Bq]_\[lq], gefolgt vom Befehl, abgeschlossen mit 
ESC + \[Bq]\\\[lq].
Die Ausgabe muss eventuell noch einen Flush bekommen, um einen sofortigen
Effekt zu erzielen.
.PP
Zum Beispiel in C:
.PP
.EX
static void
APC (const char *s)
{
  fprintf (stdout, "\\033_%s\\033\\\\", s);
  fflush (stdout);
}
.EE
.PP
Die Befehle knnen Lua-Funktionsaufrufe sein, insbesondere die 
\[Bq]avt.\[lq]-Befehle von \[Bq]lua-akfavatar\[lq]
(siehe \[Bq]lua-akfavatar-ref\[lq]).
.br
Bis zu 1024 Zeichen knnen gesendet werden.
Das bedeutet, man kann keinen komplizierten Code vom ausgefhrten Programm
senden.
Allerdings kann man im Lua-Skript, das das Programm aufruft globale Funktionen
definieren, die dann auch mit der APC-Schnittstelle aufrufbar sind.
.PP
Als Konvention sollte das aufrufende Skript eine Umgebungsvariable namens
.I "\[Bq]APC\[lq]"
definieren, die die verfgbaren Funktionen beschreibt.
.PP
Zum Beispiel:
.PP
.EX
  term.setenv("APC", _VERSION .. ", lua-akfavatar")
.EE
.PP
.TP
.BI term.send( String )
Sendet einen String an das ausgefhrte Programm, so als ob es von der
Tastatur eingegeben worden wre.
Das kann man nur von der APC-Schnittstelle (siehe oben) verwenden.
.br
Wenn das ausgefhrte Programm zeilenorientiert ist, sollte der String mit
einem \[Bq]\\r\[lq] (wie Return) abgeschlossen werden.
.PP
.TP
.BI term.decide( "String1 [,String2]" )
Zeige Plus-/Minus-Knpfe und abhngig von dieser Auswahl sende
.IR String1 " oder " String2
an das ausgefhrte Programm, so als ob es von Tastatur eingegeben
worden wre.
Das kann man nur von der APC-Schnittstelle (siehe oben) verwenden.
.br
Wenn das ausgefhrte Programm zeilenorientiert ist, sollten beide Strings
angegeben werden und beide mit einem \[Bq]\\r\[lq] (wie Return)
abgeschlossen werden.
.PP
.SH "SIEHE AUCH"
.BR lua-akfavatar (1)
.BR lua (1)
.BR lua-akfavatar-ref (3)
.BR akfavatar-graphic (3)
.BR akfavatar.utf8 (3)
