.\" Process this file with
.\" groff -man -Tutf8 akfavatar-graphic.de.man
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "akfavatar-graphic" 3 2013-08-09 AKFAvatar
.
.SH NAME
akfavatar-graphic \- Modul fr die Anzeige von Grafiken unter Lua-AKFAvatar
.
.SH SYNTAX
.PP
local graphic = require "akfavatar-graphic"
.PP
.SH BESCHREIBUNG
.PP
Modul fr Lua-AKFAvatar um Grafiken anzuzeigen.
.PP
.BR Hinweise :
.IP \(en 2
Koordinaten fangen mit 1, 1 in der oberen linken Ecke an.
.IP \(en
Man kann es auch nach Art der Turtle-Grafik verwenden.
.IP \(en
Die Stiftbreite, Position, Ausrichtung, Stiftfarbe und Hintergrundfarbe sind
fr jede Grafik einzeln festgelegt.
.IP \(en
Der Code ist nicht auf Geschwindigkeit optimiert.
Man kann zwar Animationen machen, aber es werden keine flieenden Bewegungen.
.PP
.SS Funktionen / Methoden
.TP
.BI "graphic.new(" "[Breite, Hhe] [, Hintergrundfarbe]" )
Erzeugt eine neue Grafik (eine Leinwand).
.IP
Wenn die 
.IR Breite " und " Hhe
nicht angegeben wird, wird das gesamte Fenster bzw. Bildschirm verwendet.
.br
Es wird ein dnner, schwarzer Stift ausgewhlt und die Position ist in der
Mitte, nach oben ausgerichtet.
.br
Wenn die
.I Hintergrundfarbe
nicht angegeben ist, wird diese von AKFAvatar bernommen.
.IP
Gibt die Grafik, die Breite und Hhe zurck (dh. drei Werte).
.IP
Beispiel:
.EX
local gr, width, height = graphic.new()
.EE
.PP
.TP
.B "graphic.fullsize()"
Gibt die erforderliche Breite und Hhe zurck, so dass das Bild das gesamte
Fenster fllt.
.PP
.TP
.BI "graphic.set_resize_key(" Taste )
Setzt einen Tasten-Code (als Zahl), die ausgegeben werden soll,
wenn die Fenstergre verndert wurde.
Gibt den vorherigen Tasten-Code zurck.
.IP
.B Hinweis:
Man kann einen Wert zwischen 0xE000 und 0xE9FF verwenden, um Konflikte
mit echten Tasten-Codes zu vermeiden.
.PP
.TP
.BI "graphic.set_pointer_buttons_key(" Taste )
Setzt einen Tasten-Code (als Zahl), die ausgegeben werden soll,
wenn eine Maustaste gedrckt wurde.
Gibt den vorherigen Tasten-Code zurck.
.IP
.B Hinweis:
Man kann einen Wert zwischen 0xE000 und 0xE9FF verwenden, um Konflikte
mit echten Tasten-Codes zu vermeiden.
.PP
.TP
.BI "graphic.set_pointer_motion_key(" Taste )
Setzt eine Tasten-Code (als Zahl), die ausgegeben werden soll,
wenn die Maus bewegt wurde.
Gibt den vorherigen Tasten-Code zurck.
.PP
.TP
.B "graphic.get_pointer_position()"
Gibt die x und y Koordinaten der Maus-Position zurck,
relativ zur zuletzt gezeigten Grafik.
.PP
.TP
.IB gr :show()
Zeigt die Grafik als Bild nach dem Zeichnen.
.IP
.BR Hinweis :
Man kann auch Zwischenschritte zeigen, dann weiter zeichnen, eine
Weile warten und dann den nchsten Schritt zeigen und so weiter.
Dadurch erzeugt man eine kleine Animation.
Man sollte die Schritte aber nicht zu klein whlen, sonst wird es
zu langsam auf langsamen Gerten.
.PP
.TP
.IB gr :size()
Gibt die Breite und Hhe der Grafik
.I gr
zurck.
.PP
.TP
.IB gr :width()
Gibt die Breite der Grafik
.I gr
zurck.
.PP
.TP
.IB gr :height()
Gibt die Hhe der Grafik
.I gr
zurck.
.PP
.TP
.IB gr :color( Farbname )
Legt die Zeichenfarbe fest.
.br
Die Farbe kann entweder ein vordefinierter englischsprachiger Name sein,
oder eine hexadezimale Angabe, wie zum Beispiel
.IR 0xFFFF00 " oder " "\[dq]#FFFF00\[dq]" .
.PP
.TP
.IB gr :rgb( "rot, grn, blau" )
Legt die Zeichenfarbe anhand von RGB-Werten fest.
.br
Die Werte mssen im Bereich von 0 bis 255 inklusive sein.
.br
Diese Methode ist schneller, als
.B gr:color()
zu verwenden.
.PP
.TP
.IB gr :eraser()
Setzt die Zeichenfarbe auf die Hintergrundfarbe (Radiergummi).
.PP
.TP
.IB gr :thickness( Wert )
Legt die Dicke des Stiftes fest.
Der
.I Wert
1 ist der dnnste.
.PP
.TP
.IB gr :clear( [Farbe] )
Lscht die Grafik.
.br
Wenn eine
.I Farbe
angegeben ist, wird diese zur neuen Hintergrundfarbe.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :border3d( "[gedrckt]" )
Zeichnet einen 3D-Rahmen um die Grafik.
Die Farbe basiert auf der Hintergrundfarbe der Grafik.
Die Einstellung der Stift-Dicke wird ignoriert,
der Rahmen ist immer 3 Pixel dick.
.IP
Wenn
.I gedrckt
auf
.B true
gesetzt wird, wird der Rahmen nach innen gedrckt dargestellt.
.IP
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :putpixel( "[x, y]" )
Setzt einen Pixel an den angegebenen Koordinaten, oder bei der aktuellen
Stift-Position.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :getpixel( "[x, y]" )
Gibt die Pixelfarbe an den angegebenen Koordinaten oder bei der aktuellen
Stift-Position zurck.
Die Farbe wird als String in hexadezimaler RGB-Schreibweise zurckgegeben.
Im Fehlerfall wird
.I nil
und eine Fehlermeldung zurckgegeben.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :getpixelrgb( "[x, y]" )
Gibt die Pixelfarbe an den angegebenen Koordinaten oder bei der aktuellen
Stift-Position zurck.
.br
Es werden drei Ganzzahlen fr rot, grn und blau, im Bereich von 
0 bis 255 zurckgegeben.
.br
Im Fehlerfall wird
.I nil
und eine Fehlermeldung zurckgegeben.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :putdot( "[x, y]" )
Setzt einen Punkt an den angegebenen Koordinaten, oder bei der aktuellen
Stift-Position.
.br
Wenn der Stift dnn ist, ist es das gleiche wie
.BR gr:putpixel() .
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :pen_position()
Gibt die x- und y-Position des Stiftes zurck
(dh. es werden zwei Werte zurckgegeben).
.PP
.TP
.IB gr :center()
.TQ
.IB gr :home()
Setzt den Stift auf die Mitte der Grafik, nach oben ausgerichtet.
.PP
.TP
.IB gr :moveto( "x, y" )
Bewegt den Stift nach
.I "x, y"
ohne zu zeichnen.
.PP
.TP
.IB gr :moverel( "x, y" )
Bewegt den Stift ohne zu zeichnen relativ zu seiner aktuellen Position.
.br
Ein postitiver
.IR x -Wert
bewegt ihn nach rechts,
.br
ein negativer
.IR x -Wert
bewegt ihn nach links.
.br
Ein postitiver
.IR y -Wert
bewegt ihn nach unten,
.br
ein negativer
.IR y -Wert
bewegt ihn nach oben.
.PP
.TP
.IB gr :lineto( "x, y" )
Zeichnet eine Linie von der aktuellen Stift-Position zu den absoluten
Koordinaten.
.br
Der Stift wird zu den neuen Koordinaten bewegt.
.PP
.TP
.IB gr :linerel( "x, y" )
Zeichnet eine Linie relativ zur aktuellen Stift-Position.
.br
Ein postitiver
.IR x -Wert
zeichnet nach rechts,
.br
ein negativer
.IR x -Wert
zeichnet nach links.
.br
Ein postitiver 
.IR y -Wert
zeichnet nach unten,
.br
ein negativer
.IR y -Wert
zeichnet nach oben.
.br
Der Stift wird dabei zu den neuen Koordinaten bewegt.
.PP
.TP
.IB gr :line( "x1, y1, x2, y2" )
Zeichnet eine Linie von
.IR "x1, y1" " nach " "x2, y2" .
.br
Der Stift wird auf
.I "x2, y2"
gesetzt.
.PP
.TP
.IB gr :bar( "x1, y1, x2, y2" )
Malt einen ausgefllten Balken mit
.I "x1, y1"
als obere linke Ecke und
.I "x2, y2"
als untere rechte Ecke.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :rectangle( "x1, y1, x2, y2" )
Zeichnet ein Rechteck mit
.I "x1, y1"
als obere linke Ecke und
.I "x2, y2"
als untere rechte Ecke.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :arc( "Radius [, Winkel1] [, Winkel2]" )
.TQ
.IB gr :circle( "Radius [, Winkel1] [, Winkel2]" )
Zeichnet einen Kreis oder Bogen mit dem angegebenen
.IR Radius .
.br
Die Stift-Position markiert den Mittelpunkt.
.IP
Man kann einen Teil des Kreises (einen Bogen) zeichnen, indem man einen oder
zwei Winkel in Grad angibt.
Wenn zwei Winkel angegeben sind, dann wird im Uhrzeigersinn vom ersten Winkel
bis zum zweiten gezeichnet.
Wenn nur ein Winkel angegebene ist, verwendet es die Stift-Ausrichtung als
Anfangswinkel (siehe unten bei
.BR Turtle-Grafik ).
.PP
.TP
.IB gr :disc( "Radius [, x, y]" )
Zeichnet eine Scheibe, dh. einen gefllten Kreis mit dem angegebenen
.I Radius
und den angegebenen Koordinaten als Mittelpunkt.
Sind keine Koordinaten angegeben, wird die aktuelle Stift-Position als
Mittelpunkt verwendet.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :text( "Text [, x, y]" )
Schreibt einen Text, ausgerichtet an der angegebenen Position oder der
Stift-Position.
.IP
Standardmig wird der Text an der Postion zentriert.
Aber das kann man mit
.B gr:textalign()
ndern.
.IP
Die Kodierung wird von den AKFAvatar-Einstellungen bernommen.
Andererseits werden keine anderen der dortigen Einstellungen verwendet.
Die Farbe ist die Zeichenfarbe fr die Grafik.
Es gibt momentan keine einfache Mglichkeit fr Fettdruck, Unterstreichen
oder inverse Dastellung.
.IP
Man kann smtliche darstellbaren Zeichen verwenden, aber Steuerzeichen
werden nicht untersttzt, nichtmal ein Zeilenumbruch.
.br
Die Stift-Position wird nicht verndert.
.PP
.TP
.IB gr :textalign( "[horizontal] [, vertikal]" )
Legt die Ausrichtung fr
.B gr:text()
fest.
.IP
Die horizontale Ausrichtung kann eines von "left", "center" oder "right"
sein.
Die Vorgabe ist "center".
.IP
Die vertikale Ausrichtung kann eines von "top", "center" oder "bottom" sein.
Die Vorgabe ist "center".
.IP
Die Ausrichtung bedeutet, wo der Bezugspunkt ist, zum Beispiel wenn man
angibt, dass es links ausgerichtet sein soll, ist der Bezugspunkt links,
aber der Text luft nach rechts.
.PP
.TP
.B "graphic.font_size()"
.TQ
.IB gr :font_size()
Gibt die Breite, Hhe und die Grundlinie eines Zeichens zurck.
Es handelt sich um einen Zeichensatz mit fester Breite, jedes Zeichen hat
die selbe Breite.
.PP
.TP
.IB gr :put( "Grafik [, x, y]" )
Kopiert eine Grafik auf die Grafik
.I gr
bei der angegebenen Position (obere linke Ecke).
Wenn keine Position angegeben ist, wird es in die obere linke Ecke gesetzt.
Der vorherige Inhalt wird berschrieben (keine Transparenz).
.IP
Eine Grafik mit der selben Breite und ohne Angabe einer Position zu
kopieren ist uerst effizient.
Das selbe gilt wenn die Grafik die selbe Breite hat und die
.IR x -Position
auf 1 gesetzt ist.
.PP
.TP
.IB gr :put_transparency( "Grafik [, x, y]" )
Legt eine Grafik ber die Grafik
.I gr
bei der angegebenen Position (obere linke Ecke).
.br
Wenn keine Position angegeben ist, wird es in die obere linke Ecke gesetzt.
.br
Pixel mit der Hintergrundfarbe werden nicht kopiert, die sind transparent.
.br
Dies ist wesentlich langsamer als
.BR gr:put() .
.PP
.TP
.IB gr :put_file( "Dateiname [, x, y]" )
Kopiert eine Grafik aus einer Datei auf die Grafik
.I gr
bei der angegebenen Position (obere linke Ecke).
.br
Wenn keine Position angegeben ist, wird es in die obere linke Ecke gesetzt.
.PP
.TP
.IB gr :put_image( "Daten [, x, y]" )
Kopiert eine Grafik aus den
.I Daten
auf die Grafik
.I gr
bei der angegebenen Position (obere linke Ecke).
.I Daten
kann ein String mit den Bilddaten sein,
oder eine Tabelle mit Strings von XPM-Daten.
.br
Wenn keine Position angegeben ist, wird es in die obere linke Ecke gesetzt.
.PP
.TP
.IB gr :get( "x1, y1, x2, y2" )
Gibt einen Bereich der Grafik
.I gr
als neue Grafik zurck.
.br
Die meisten Einstellungen werden ebenfalls kopiert, mit Ausnahme der Gre
und der Stift-Position.
.br
Der Stift wird auf die Mitte der neuen Grafik gesetzt, nach oben ausgerichtet.
.br
Alle Werte mssen im gltigen Bereich liegen.
.PP
.TP
.IB gr :duplicate()
Gibt ein exaktes Duplikat (eine Kopie) der Grafik 
.I gr
zurck.
.br
Die Grafik-spezifischen Einstellungen werden ebenfalls kopiert.
.br
Das geht schneller als mit
.BR gr:get() .
.IP
Man kann dies zum Beispiel verwenden, um erstmal einen festen Hintergrund zu
zeichnen und dann ein Duplikat zu erstellen.
Darauf zeichnet man dann einen Vordergrund.
Dann kann man den Hintergrund wieder darauf kopieren
.RB ( gr:put )
und einen neuen Vordergrund zeichnen.
.PP
.TP
.IB gr :shift_vertically( Zeilen )
Verschiebt die Grafik vertikal.
.br
Ein positiver Wert fr
.I Zeilen
schiebt sie nach unten.
.br
Ein negativer Wert fr
.I Zeilen
schiebt sie nach oben.
.br
Der Stift wird mitbewegt.
.PP
.TP
.IB gr :shift_horizontally( Spalten )
Verschiebt die Grafik horizontal.
.br
Ein positiver Wert fr
.I Spalten
schiebt sie nach rechts.
.br
Ein negativer Wert fr
.I Spalten
schiebt sie nach links.
.br
Der Stift wird mitbewegt.
.PP
.TP
.IB gr :export_ppm( filename )
Exportiert die Grafik als Portable Pixmap (PPM) Datei.
.IP
Das PPM-Format ist simpel zu implementieren, aber nicht sehr effizient.
Man kann aber die \[Bq]netpbm\[lq]-Werkzeuge oder \[Bq]ImageMagick\[lq]
verwenden,
um es in ein anderes Format umzuwandeln.
.IP
Das folgende Beispiel zeigt, wie man das macht:
.IP
.EX
function export(graphic, name)
  graphic:export_ppm(name..".ppm")
  if os.execute("pnmtopng "..name..".ppm > "..name..".png")
     or os.execute("convert "..name..".ppm "..name..".png") then
    os.remove(name..".ppm")
  end
end
.EE
.IP
Zunchst exportiert es die Grafik ins PPM-Format.
Dann versucht es dieses ins PNG-Format umzuwandeln.
Falls das gelingt, wird die PPM-Datei gelscht.
Wenn der Anwender \[Bq]netpbm\[lq] oder \[Bq]ImageMagick\[lq] aber
nicht installiert hat,
hat er am Ende immer noch die PPM-Datei.
.PP
.SS Turtle-Grafik
.PP
Um Turtle-Grafik (\[Bq]Schildkrten-Grafik\[lq], manchmal auch 
\[Bq]Igel-Grafik\[lq] genannt)
zu verstehen, muss man sich eine Schildkrte verstellen, die einen Stift trgt.
Man kann der Schildkrte dann Befehle erteilen in welche Richtung sie sich drehen
soll und wie weit sie sich zu bewegen hat.
.PP
.TP
.IB gr :heading( Ausrichtung )
Legt die Ausrichtung der Schildkrte fest.
Der Wert muss in Grad angegeben werden und die Schildkrte dreht sich im
Uhrzeigersinn.
Der Wert 0 bedeutet, sie ist nach oben ausgerichtet,
90 bedeutet nach rechts.
.PP
.TP
.IB gr :get_heading()
Gibt die Ausrichtung der Schildkrte zurck
(siehe
.BR "gr:heading()" ).
.PP
.TP
.IB gr :right( Winkel )
Drehe die Schildkrte im Uhrzeigersinn um den angegebenen
.I Winkel
in Grad.
.PP
.TP
.IB gr :left( Winkel )
Drehe die Schildkrte gegen den Uhrzeigersinn um den angegebenen
.I Winkel
in Grad.
.PP
.TP
.IB gr :draw( Schritte )
Zeichne eine Linie in die Richtung, in die die Schildkte ausgerichtet ist.
.PP
.TP
.IB gr :move( Schritte )
Bewege die Schildkrte in die Richtung in der sie ausgerichtet ist, ohne zu
zeichnen.
.PP
.TP
.IB gr :home()
Setzt die Schildkrte in die Mitte der Grafik, nach oben ausgerichtet.
.PP
.SH "SIEHE AUCH"
.BR lua-akfavatar (1)
.BR lua (1)
.BR lua-akfavatar-ref (3)
.BR akfavatar-term (3)
.BR akfavatar.utf8 (3)
