.\" Process this file with
.\" groff -man -Tutf8 lua-akfavatar.1
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "lua-akfavatar" 1 2013-07-11 AKFAvatar
.
.SH NAME
lua-akfavatar \- Lua interpreter for the AKFAvatar user interface
.
.SH SYNOPSIS
.BI "lua-akfavatar [" options "] [" " script " "[" args "] ]"
.
.SH DESCRIPTION
The program lua-akfavatar is the Lua interpreter for the AKFAvatar
user interface.
It loads and executes Lua scripts in source form (not bytecode).
Either Lua scripts can be loaded or
.RB \[dq] .avt \[dq]
demo files.
If no
.I script
is given, it starts with a file-selector.
.PP
The given
.I args
are available to
.I script
as strings in a global table named
.BR arg .
The
.I script
itself is in
.BR arg[0] ,
the first argument is
.B arg[1]
and so on.
.PP
You have to use the command
.BI "local " avt " = require " "\[dq]lua-akfavatar\[dq]"
to get access to the AKFAvatar specific functions.
.PP
With the file-selector you can also see documentation files
with the file extension
.RB \[dq] .about "\[dq]."
These can be simple text files encoded in UTF-8 or plain ASCII.
They can use the "overstrike" technique for bold or underlined text.
You can for example use the text-setting system "groff" to generate
such files.
.br
Furthermore GNU info files
with the file extension
.RB \[dq] .info \[dq]
can be shown as text (no support for hyperlinks).
.
.SH OPTIONS
.TP
-h
.TQ
--help
print a short help-message
.TP
-v
.TQ
--version
print version information
.TP
.RI "-l " "[var=]name"
call
.BI require( \[dq]name\[dq] )
before executing the script.
Sets a global variable with the
.IR name " or " var .
Typically used to load libraries.
.TP
-f
.TQ
--fullscreen
start in fullscreen mode
(only if no script is given)
.TP
-F
.TQ
--Fullscreen
start in fullscreen mode without switching the resolution
(only if no script is given)
.TP
.RI --dir= dir
start the file-selector in that directory
(only if no script is given)
.
.SH ENVIRONMENT
.TP
LUA_PATH_5_2
.TQ
LUA_PATH
searchpath for Lua modules.
Templates are separated with semicolons.
A question mark
.RB ( ? )
is replaced with the module name.
A dot in the module name is replaced with the directory separator.
Two semicolons
.B (;;)
add the default path.
.TP
LUA_CPATH_5_2
.TQ
LUA_CPATH
searchpath for C modules.  Syntax like in
.IR LUA_PATH .
.TP
AVTDATAPATH
searchpath for data files (images, audio, texts...).
It gets stored in the variable
.B avt.datapath
and can be used with the function
.BI avt.search( filename ) .
The directories are separated with semicolons.
Unlike the former paths there are no templates with question marks.
.
.SH EXAMPLE
.EX
local avt = require "lua-akfavatar"
avt.encoding("UTF-8")
avt.title("my first program")
avt.start()
avt.avatar_image("default")
avt.say("Hello there!\en")
local name = avt.ask("What's your name? ")
avt.say("Hello, ", name, ". Nice to meet you!\en")
avt.wait_button()
.EE
.
.SH SECURITY
Lua is a complete programming language.
There are no sandbox limitations.
Any such programming language can be misused to
write malicious code.
So keep in mind that Lua scripts are programs
and should be treated with the same care as other programs.
Some other input files for Lua-AKFAvatar could contain code, too.
.
.SH AUTHORS
.TP 16
AKFAvatar
.TQ
Lua-AKFAvatar
Andreas K. Foerster
.TP
Lua
R. Ierusalimschy, L. H. de Figueiredo, and W. Celes
.
.SH HOMEPAGE
http://akfavatar.nongnu.org/
.
.SH "SEE ALSO"
.BR lua (1)
.BR lua-akfavatar-ref (3)
.BR akfavatar-graphic (3)
.BR akfavatar-term (3)
.BR akfavatar.utf8 (3)
.PP
http://akfavatar.nongnu.org/manual/
.br
http://www.lua.org/manual/5.2/
