.\" Process this file with
.\" groff -man -Tutf8 lua-akfavatar-reference.de.man
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "Lua-AKFAvatar Referenz" 3 2013-07-09 AKFAvatar
.
.SH NAME
Lua-AKFAvatar Referenz \- AKFAvatar spezifische Funktionen fr Lua
.
.SH BESCHREIBUNG
Dies ist eine Referenz fr die Lua-Anbindung fr AKFAvatar.
Sie beschreibt nicht die Sprache Lua.
Eine Referenz-Anleitung fr die Sprache Lua findet man im Internet unter
.BR http://www.lua.org/manual/5.2/ ,
oder auf Deutsch unter
.BR http://lua.coders-online.net/ .
.PP
Keine Angst. Man muss nicht alles gleich verstehen oder gar lernen.
Man kann schon eine ganze Menge mit nur ganz wenigen Befehlen anfangen.
Einfach mal die Teile heraussuchen, die einen interessieren und damit
herumexperimentieren.
Es gibt viele Aspekte von Lua oder AKFAvatar, die man wahrscheinlich nie
bentigt.
.PP
.SS Datei-Formate
Fr Bilder werden die Formate
.BR XPM ", " XBM " und unkomprimiertes " BMP
auf jeden Fall untersttzt.
Weitere Formate werden untersttzt, wenn
.B SDL_image
und weitere Bibliotheken installiert sind.
.PP
Fr Audio werden die Formate
.BR AU " und " WAV
untersttzt.
Dateien knnen als PCM, \(*m-law oder A-law kodiert sein.
Es gibt auch ein Lua-Modul namens
.BR akfavatar-vorbis ,
welches Untersttzung fr Ogg Vorbis Audio-Dateien hinzufgt.
.PP
.SS Grundfunktionalitt
.TP
.B "local avt = require ""lua-akfavatar"""
Bevor man die AKFAvatar-Anbindung verwenden kann, muss man sie mit dieser
Anweisung erstmal laden.
ber die Tabelle
.I avt
kann man dann die folgenden Funktionen abrufen.
.PP
.TP
.BI "avt.encoding(" encoding )
Legt die Text-Kodierung fest.
Wenn diese Funktion nicht verwendet wird, wird nur "ASCII" untersttzt.
.IP
Untersttzte Kodierungen:
.br
ASCII, UTF-8,
.br
ISO-8859-1, -2, -3, -4, -5, -7, -8, -9, -10, -11, -13, -14, -15, -16,
.br
KOI8-R, KOI8-U,
.br
IBM437 (PC-8), IBM850 (DOS-Latin-1),
.br
WINDOWS-1250, WINDOWS-1251, WINDOWS-1252
.br
SYSTEM
.PP
.TP
.BI "avt.get_encoding()"
Fragt die Text-Kodierung ab.
.PP
.TP
.BI "avt.title(" "Titel [,Kurzname]" )
.TQ
.BI "avt.set_title(" "Titel [,Kurzname]" )
Legt den Titel und den Kurznamen fest.
.PP
.TP
.BI "avt.start(" Modus )
Diese Funktion ffnet das grafische Fenster oder wechselt in den Grafikmodus.
Falls es schon gestartet war, wird vieles zurck gesetzt.
.IP
.I Modus
ist entweder "auto", "window", "fullscreen", oder "fullscreen no switch".
Die Vorgabe ist "auto", die einen brauchbaren Modus verwendet, oder die
Einstellung unverndert lsst, wenn es bereits gestartet war.
.IP
Wenn man die Kodierung, den Titel oder die Hintergrund-Farbe setzen will,
sollte man es machen, bevor man
.B avt.start()
aufruft.
Alle anderen Funktionen sollten erst danach verwendet werden.
.IP
.B Beispiel:
.EX
local avt = require "lua-akfavatar"
avt.encoding("ISO-8859-1")
avt.title("Mein Programm")
avt.set_background_color("sky blue")
avt.start()
avt.start_audio()
avt.avatar_image("default")
avt.tell("Hallo Welt!")
avt.wait_button()
.EE
.IP
Viele der folgenden Funktionen rufen automatisch
.B avt.start()
auf, wenn es noch nicht gestartet ist.
.PP
.TP
.BI "avt.started()"
Gibt
.I true
zurck, wenn AKFAvatar bereits gestartet ist, ansonsten gibt es
.I false
zurck.
.PP
.TP
.BI "avt.avatar_image(" Daten )
Ldt das Avatar-Bild von den
.IR Daten .
Die
.I Daten
knnen entweder "default" oder "none" sein,
oder ein String mit Bilddaten,
oder eine Tabelle mit Strings von XPM-Daten.
.PP
.TP
.BI "avt.avatar_image_file(" Dateiname )
Ldt das Avatar-Bild aus einer Datei.
Die Strings "default" oder "none" werden auch akzeptiert.
.PP
.TP
.BI "avt.set_avatar_name(" [Name] )
Setzt den Namen fr den Avatar.
Dies muss nach dem Setzen des Bildes geschehen.
.PP
.TP
.BI "avt.set_avatar_mode(" Modus )
Legt den Avatar-Modus fest.
Der
.I Modus
ist entweder "say" (sagen), "think" (denken),
"header" (berschrift) oder "footer" (Fuzeile).
Der Avatar-Modus wird nur angewandt, wenn ein Avatar-Bild vorhanden ist.
.PP
.TP
.BI "avt.say(" ... )
.TQ
.BI "avt.write(" ... )
Schreibt Text in der Sprechblase.
.IP
Man kann Strings oder Zahlen verwenden.
Es funktioniert so hnlich wie
.BR io.write() ,
aber es schreibt halt in die Sprechblase anstatt auf die
Standardausgabe.
.IP
.B Beispiel:
.EX
avt.say("Drei pfel kosten ", 3 * Apfelpreis, " Euro.\en").
.EE
.PP
.TP
.BI "avt.print(" ... )
Schreibt Text in der Sprechblase.
Es funktioniert so hnlich wie
.BR print ,
aber es schreibt halt in die Sprechblase anstatt auf die
Standardausgabe.
.IP
Der Unterschied zu
.B avt.say()
ist, dass die Werte in der Ausgabe durch Tabulatoren getrennt werden
und jeder Wert automatisch durch
.B tostring()
umgewandelt wird. Auerdem wird die Zeile durch einen Zeilenumbruch
abgeschlossen.
.IP
Mann kann einfach den print-Befehl mit diesem Befehl ersetzen:
.BR "print = avt.print" .
(Das Skript `interactive_lua.lua' macht das so.)
.IP
Die Funktion
.B avt.say()
eignet sich besser fr Programme, whrend diese Funktion besser fr
die interaktive Verwendung und fr's Debuggen geeignet ist.
.PP
.TP
.BI "avt.tell(" ... )
Schreibt Text in der Sprechblase, aber zuvor wird die Gre der
Sprechblase angepasst, so dass der Text exakt reinpasst.
.IP
.B Beispiel:
.EX
avt.tell("Drei pfel kosten ", 3 * Apfelpreis, " Euro.").
.EE
.IP
.B Achtung:
Diese Funktion hat noch immer Probleme mit Tabulatoren ("\et").
.PP
.TP
.BI "avt.newline()"
Beginne eine neue Zeile.
Das selbe, wie "\en" in
.BR avt.say() ,
aber schneller.
.PP
.TP
.BI "avt.set_text_delay(" [Verzgerung] )
Aktiviere den Langsamschreibmodus.
Wenn
.I Verzgerung
nicht angegeben ist, wird ein Vorgabewert verwendet.
Um den Langsamschreibmodus zu daktivieren, kann man den Wert
0 fr die
.I Verzgerung
verwenden.
.PP
.TP
.BI "avt.clear()"
Lscht das Text-Feld oder den Bereich.
Wenn noch keine Sprechblase angezeigt wird, wird diese hierdurch gezeichnet.
.PP
.TP
.BI "avt.flip_page()"
Wartet eine Weile und lscht dann das Text-Feld.
Dasselbe wird durch "\ef" in
.B avt.say()
erreicht.
Siehe auch
.BR avt.set_flip_delay(delay) .
.PP
.TP
.BI "avt.move_in()"
Bewegt den Avatar herein.
.PP
.TP
.BI "avt.move_out()"
Bewegt den Avatar heraus.
.PP
.TP
.BI "avt.pager(" "Text [,Anfangszeile]" )
Zeigt einen lngeren Text in einer Textbetrachter-Anwendung.
.IP
Wenn die
.I Anfangszeile
angegeben und grer als 1 ist, dann fngt er in der Zeile an.
Man kann von da aus aber immer noch zurck scrollen.
.PP
.TP
.BI "avt.wait(" [Sekunden] )
Wartet eine angegebene Zeit an Sekunden (kann ein Dezeimalbruch sein).
.IP
Wenn kein Wert angegeben ist, wartet er eine gewisse Zeit.
.PP
.TP
.BI "avt.ticks()"
Gibt einen Wert zurck, der jede Millisekunde erhht wird.
Das kann fr Zeitsteuerung verwendet werden.
.PP
.TP
.BI "avt.show_avatar()"
Zeigt nur den Avatar ohne Sprechblase.
.PP
.TP
.BI "avt.bell()"
Gibt einen Ton aus, oder die Anzeige blinkt, wenn die Audio-Ausgabe nicht
initialisiert ist.
.PP
.TP
.BI "avt.flash()"
Die Anzeige blinkt einmal.
.PP
.TP
.BI "avt.show_image(" Daten )
Zeigt ein Bild von Bilddaten.
Die
.I Daten
knnen ein String mit Bilddaten sein,
oder eine Tabelle mit Strings von XPM-Daten.
Bei Erfolg wird
.IR true " zurckgegeben, oder " false " im Fehlerfall."
Bei Erfolg sollte entweder
.BR avt.wait() " oder " avt.wait_button() " oder " avt.get_key()
aufgerufen werden.
.PP
.TP
.BI "avt.show_image_file(" Dateiname )
Ldt ein Bild und zeigt es an.
Man kann mit
.I avt.search()
nach der Datei suchen lassen.
Bei Erfolg wird
.IR true " zurckgegeben, oder " false " im Fehlerfall."
Bei Erfolg sollte entweder
.BR avt.wait() " oder " avt.wait_button() " oder " avt.get_key()
aufgerufen werden.
.PP
.TP
.BI "avt.subprogram(" "function, [arg1, ...]" )
Ruft die Funktion als Unterprogramm auf.
.IP
Bei einer Beendigungsanfrage (dh. wenn man die <Esc>-Taste drckt,
oder den Schlie-Knopf des Fensters) kehrt es nur zum Hauptprogramm
zurck.
.IP
Bei Erfolg werden die Ergebnisse der Funktion zurckgegeben.
Bei einer Beendigungsanfrage wird nichts zurckgegeben.
.IP
Um ein Unterprogramm aus einer separaten Datei zu starten,
kann man
.B dofile
verwenden.
.EX
avt.subprogram(dofile, "unterprogramm.lua")
.EE
.PP
.TP
.BI "avt.optional(" modname )
Ldt ein Modul wie
.BR require ,
aber das Modul wird nicht bentigt, sondern es ist optional.
Das heit, es ist kein Fehler, wenn das Modul nicht geladen
werden kann.
.IP
Lua-AKFAvatar braucht nicht initialisiert sein, um diese
Funktion zu verwenden.
.PP
.SS Unicode
.TP
.BI "avt.say_unicode(" ... )
Schreibt Text in der Sprechblase mit spezieller Untersttzung fr 
Unicode-Zeichen.
.IP
Dieser Befehl ist hnlich wie
.BR avt.say() .
Strings werden auf die selbe Weise behandelt, abhngig von der eingestellten
Kodierung, aber Zahlen werden als Unicode-Codepoint interpretiert,
unabhngig von der eingestellten Kodierung.
.IP
Man kann das verwenden, um Zeichen zu verwenden, die in der eingestellten
Kodierung nicht zur Verfgung stehen.
Manchmal ist es aber auch einfach nur einfacher.
.IP
.B Beispiel:
.EX
avt.say_unicode("Drei pfel kosten ",
                tostring(3 * Apfelpreis), 0x20AC,
                ".\en").
.EE
.IP
Wie man hier sieht, muss man
.B tostring()
verwenden, wenn nummerische Angaben als solche angezeigt werden sollen.
Die Zahl
.I 0x20AC
hingegen reprsentiert hier das Euro-Whrungszeichen.
(Das `0x' leitet hexadezimale Zahlen ein.)
.IP
brigens werden eine Gruppe von Unicode-Zahlen effektiver verarbeitet
als Strings.
.PP
.TP
.BI "avt.printable(" Codepoint )
berprft ob der angegebene
.I Codepoint
ein druckbares Unicode-Zeichen darstellt.
Es gibt
.I true
zurck, wenn das der Fall ist, oder
.IR false ,
wenn die Schriftart kein druckbares Zeichen dafr hat
(es kann trotzdem ein untersttztes Steuerzeichen sein).
Diese Funktion ist unabhngig von der eingestellten Kodierung.
Sie kann zusammen mit
.B "avt.say_unicode(...)"
eingesetzt werden.
.PP
.TP
.BI "avt.combining(" Codepoint )
berprft ob der angegebene
.I Codepoint
ein kombinierendes Unicode-Zeichen darstellt
und als solches behandelt wird.
Es gibt
.I true
zurck, wenn das der Fall ist, oder
.IR false ,
wenn es nicht als solches untersttzt wird.
Das Ergebnis gilt nur fr untersttzte Zeichen.
.PP
.TP
.BI "avt.detect_utf8(" "String [, Maximallnge]" )
Prft, of
.I String
gltiges UTF-8 (oder ASCII) ist.
.IP
Geprft werden bis zu
.I Maximallnge
Bytes, aber eine unvollstndige Sequenz wird noch abgeschlossen.
.PP
.TP
.BI "avt.toutf8(" "Codepoint [, ...]" )
Nimmt einen oder mehrere angegebene Unicode
.I Codepoints
und gibt diese als UTF-8 kodierten String zurck.
.PP
.TP
.BI "avt.utf8codepoints(" str )
Kann verwendet werden, um alle Unicode Codepoints
von einem UTF-8 kodierten String als Zahlen zu erhalten.
.IP
Beispiel:
.EX
  for c in avt.utf8codepoints(s) do
    avt.say_unicode(c)
    avt.say(string.format(" = U+%04X", c))
    avt.newline()
  end
.EE
.PP
.SS Gren und Positionen
.TP
.BI "avt.set_balloon_size(" "[Hhe] [, Breite]" )
Legt die Gre der Sprechblase fest.
Wenn keine Werte angegeben sind, oder der Wert 0 verwendet wird,
wird die maximale Gre verwendet.
.PP
.TP
.BI "avt.set_balloon_width(" [Breite] )
Legt die Breite der Sprechblase fest.
Ohne Wert, oder bei dem Wert 0 wird das Maximum verwendet.
.PP
.TP
.BI "avt.set_balloon_height(" [Hhe] )
Legt die Hhe der Sprechblase fest.
Ohne Wert, oder bei dem Wert 0 wird das Maximum verwendet.
.PP
.TP
.BI "avt.get_max_x()"
Ermittelt die maximale x-Postion des Cursors in der Sprechblase
(also die Breite).
.PP
.TP
.BI "avt.get_max_y()"
Ermittelt die maximale y-Postion des Cursors in der Sprechblase
(also die Hhe).
.PP
.TP
.BI "avt.where_x()"
Ermittelt die x-Position des Cursors in der Sprechblase.
.PP
.TP
.BI "avt.where_y()"
Ermittelt die y-Position des Cursors in der Sprechblase.
.PP
.TP
.BI "avt.home_position()"
Gibt
.I true
zurck, wenn sich der Cursor auf der Startposition befindet,
oder
.IR false ,
wenn nicht.
(Das funktioniert auch fr rechts-nach-links-Schreibung.)
.PP
.TP
.BI "avt.move_x(" x )
Setzt den Curser auf die angegebene
.IR x -Position.
.PP
.TP
.BI "avt.move_y("y )
Setzt den Curser auf die angegebene
.IR y -Position.
.PP
.TP
.BI "avt.move_xy(" "x, y" )
Setzt den Curser auf die angegebene
.IR x " und " y " Position."
.PP
.TP
.BI "avt.save_position()"
Speichert die aktuelle Cursor-Position.
.PP
.TP
.BI "avt.restore_position()"
Stellt eine zuvor gespeicherte Cursor-Postion wieder her.
.PP
.TP
.BI "avt.next_tab()"
Setzt den Cursor auf die nchste Tabulator-Position.
.PP
.TP
.BI "avt.last_tab()"
Setzt den Cursor auf die vorhergehende Tabulator-Position.
.PP
.TP
.BI "avt.reset_tab_stops()"
Setzt die Tabulator-Positionen zurck auf jede achte Spalte.
.PP
.TP
.BI "avt.clear_tab_stops()"
Lscht alle Tabulator-Postionen
.PP
.TP
.BI "avt.set_tab(" "x, true" | false )
Setzt oder lscht einen Tabulator an der angegebenen Position
.IR x .
.PP
.TP
.BI "avt.delete_lines(" "Zeile, Anzahl" )
Lscht die angegebene
.I Anzahl
an Zeilen, angefangen bei
.IR Zeile ;
der Rest wird hochgescrollt.
.PP
.TP
.BI "avt.insert_lines(" "Zeile, Anzahl" )
Fgt die angegebene
.I Anzahl
an Zeilen ein, angefangen bei
.IR Zeile ;
der Rest wird runtergescrollt.
.PP
.TP
.BI "avt.insert_spaces(" Anzahl )
Fgt
.I Anzahl
an Leerzeichen bei der jetzigen Postion ein.
Der Rest der Zeile wird weiter gerckt.
.PP
.TP
.BI "avt.delete_characters(" Anzahl )
Lscht
.I Anzahl
an Zeichen an der jetzigen Cursor-Position.
Der Rest der Zeile wird zurck gerckt.
.PP
.TP
.BI "avt.erase_characters(" Anzahl )
Lscht
.I Anzahl
an Zeichen.
Die Zeichen werden mit Leerzeichen berschrieben.
.PP
.TP
.BI "avt.backspace()"
Geht ein Zeichen zurck.
Wenn der Cursor am Anfang der Zeile ist, passiert nichts.
.PP
.SS Text-Stil
.TP
.BI "avt.markup(" true | false )
Setzt den Auszeichnungs-Modus.
Im Auszeichnungs-Modus schaltet das Zeichen "_" das Unterstreichen
ein oder aus und das Zeichen "*" schaltet den Fettdruck-Modus
ein oder aus.
Die beiden Zeichen werden im Auszeichnungs-Modus niemals angezeigt!
.IP
Man kann immer die Overstrike-Technik verwenden, die keine Zeichen
reserviert.
Aber die ist schwerer zu benutzen.
.PP
.TP
.BI "avt.underlined(" true | false )
Schaltet das Unterstreichen ein oder aus.
.PP
.TP
.BI "avt.get_underlined()"
Gibt
.I true
zurck, wenn Unterstreichen eingeschaltet ist, oder
.IR false ,
wenn nicht.
.PP
.TP
.BI "avt.bold(" true | false )
Schaltet den Fettdruck an oder aus.
.PP
.TP
.BI "avt.get_bold()"
Gibt
.I true
zurck, wenn Fettdruck eingeschaltet ist, oder
.IR false ,
wenn nicht.
.PP
.TP
.BI "avt.inverse(" true | false )
Schaltet die invertierte Darstellung an oder aus.
.PP
.TP
.BI "avt.get_inverse()"
Gibt
.I true
zurck, wenn die invertierte Darstellung eingeschaltet ist, oder
.IR false ,
wenn nicht.
.PP
.TP
.BI "avt.normal_text()"
Setzt normale Einstellungen fr Text zurck.
.PP
.SS Farben
.TP
.BI "avt.set_background_color(" Farbe )
Setzt die Hintergrundfarbe fr den Bildschirm.
.IP
Farben knnen entweder ber ihren englischen Namen angegeben werden,
oder als RGB-Angabe 6 hexadezimalen Ziffern.
.IP
.B Beispiele:
.EX
avt.set_background_color("sky blue")
avt.set_background_color(0x8B4513)
avt.set_background_color("#8B4513") --> nicht empfohlen
avt.set_background_color("#555") --> nicht empfohlen
.EE
.PP
.TP
.BI "avt.set_balloon_color(" Farbe )
Setzt die Farbe der Sprechblase.
.PP
.TP
.BI "avt.set_text_color(" Farbe )
Setzt die Farbe des Textes.
.PP
.TP
.BI "avt.set_text_background_color(" Farbe )
Setzt die Hintergrundfarbe des Textes.
.PP
.TP
.BI "avt.set_text_background_ballooncolor()"
Setzt die Hintergrundfarbe des Textes auf die Farbe der Sprechblase.
.PP
.TP
.BI "avt.set_bitmap_color(" Farbe )
Setzt die Vordergrundfarbe fr Bitmaps (einfarbige Grafiken).
Der Hintergrund ist immer transparent.
.PP
.TP
.BI "avt.get_color(" Farbnummer )
Hole die Farbdefinition fr die angegebene Farbnummer.
.IP
AKFAvatar hat eine interne Palette mit englischsprachigen
Farbnamen, die man verwenden kann.
Mit dieser Funktion kann man diese Liste durchgehen.
Sie gibt den Namen und die RGB-Definition als String zurck,
oder es gibt nichts zurck, wenn die Farbnummer nicht existiert.
.PP
.TP
.BI "avt.colors()"
Iterator fr interne Farbnamen.
.IP
AKFAvatar hat eine interne Palette mit englischsprachigen
Farbnamen, die man verwenden kann.
Mit dieser Funktion kann man diese Liste mit einer
allgemeinen
.BR for "-Schleife durchgehen."
.IP
.EX
require "lua-akfavatar"
for nr, name, rgb in avt.colors() do
  avt.normal_text()
  avt.newline()
  avt.say(string.format("%3d) %5s, %-25s", nr, rgb, name))
  avt.set_text_background_color(name) -- name oder rgb
  avt.clear_eol()
  avt.wait(0.7)
end
avt.wait_button()
.EE
.IP
Wenn man den
.IR rgb "-Wert"
nicht bentigt, kann man die Variable weglassen.
.PP
.SS Interaktion
.TP
.BI "avt.wait_button()"
Wartet bis ein Knopf gedrckt wird.
.PP
.TP
.BI "avt.decide()"
Fragt den Benutzer nach einer positiven oder negativen Antwort.
Gibt etweder
.IR true " oder " false " zurck."
.PP
.TP
.BI "avt.ask(" [Frage] )
Zeigt die
.IR Frage ,
falls angegeben, und wartet bis der Benutzer etwas eingibt.
Gibt das Eingegebene als String zurck.
.IP
Das folgende Beispiel zeigt, wie man die Eingabe einer Zahl erzwingt:
.IP
.EX
require "lua-akfavatar"
avt.save_position()
repeat
  avt.restore_position()
  Zahl = tonumber(avt.ask("Gib eine Zahl ein: "))
until Zahl
avt.say("Die Zahl ist ", Zahl)
avt.wait_button()
.EE
.PP
.TP
.BI "avt.file_selection(" [Filter] )
Startet einen Dateiauswahl-Dialog in der Sprechblase.
Am Anfang zeigt er das aktuelle Arbeitsverzeichnis an.
Wenn ein Verzeichnis ausgewhlt wird, wird das zum Arbeitsverzeichnis.
Wenn eine Datei ausgewhlt wird, wird der Dateiname zurckgegeben
(die sich dann im dann aktuellen Arbeitsverzeichnis befindet),
oder im Fehlerfall wird 
.I nil
zurckgegeben.
.IP
Der
.IR Filter ,
falls angegeben, sollte eine Funktion sein.
Sie bekommt einen Dateinamen als Parameter.
Die Datei befindet sich immer im aktuellen Arbeitsverzeichnis.
Wenn die Filter-Funktion
.IR false " oder " nil
oder nichts zurckgibt, dann wird die Datei nicht angezeigt,
ansonsten wird sie angezeigt.
.IP
.B Beispiel:
.EX
 Textdatei = avt.file_selection(
    function(n)
      return string.find(n,"%.te?xt$")
    end)
.EE
.IP
Natrlich kann fr
.I Filter
auch einfach der Name einer zuvor definierten Funktion
angegeben werden.
.PP
.TP
.BI "avt.color_selection()"
Startet einen Farbauswahl-Dialog in der Sprechblase.
Es werden zwei Strings zurckgegeben: erstens der englische Name
fr die Farbe und zweitens die hexadezimale RGB-Definition.
Beide Werte knnen fr die Farbauswahl verwendet werden.
.PP
.TP
.BI "avt.get_key()"
Wartet auf einen Tastendruck und gibt den Unicode-Codepoint des
Zeichens zurck.
Fr einige Funktionstasten werden Werte aus einem Unicode-Bereich
fr den privaten Gebrauch zurckgegeben.
.PP
.TP
.BI "avt.key_pressed()"
Prft, ob eine Taste gedrckt wurde.
Um den Tasten-Code abzuholen kann man
.B avt.get_key()
verwenden.
.PP
.TP
.BI "avt.clear_keys()"
Lscht den Tastatur-Buffer
.PP
.TP
.BI "avt.push_key(" Codepoint )
Simuliert einen Tastendruck
.PP
.TP
.BI "avt.navigate(" buttons )
Zeigt eine Navigationsleiste mit den angegebenen Knpfen.
.IP
Fr die Knpfe kann man in einem String die folgenden Zeichen
verwenden:
.IP
.RS
.IP "l:"
links
.IP "r:"
rechts (abspielen)
.IP "d:"
runter
.IP "u:"
hoch
.IP "x:"
abbrechen
.IP "f:"
(schnell)vorwrts
.IP "b:"
(schnell)rckwrts
.IP "p:"
Pause
.IP "s:"
Stop
.IP "e:"
Auswurf
.IP "*:"
Kreis (Aufnahme)
.IP "+:"
Plus (hinzufgen)
.IP "-:"
Minus (entfernen)
.IP "?:"
Hilfe
.IP "' ':"
Platzhalter (kein Knopf)
.RE
.IP
Eine Taste mit einem dieser Zeichen zu drcken whlt diesen aus.
Fr die Richtungen kann man auch die Pfeiltasten verwenden.
Die <Pause>-Taste gibt "p" zurck.
Die <Hilfe>-Taste oder <F1> geben "?" zurck.
.IP
Es wird das entsprechende Zeichen zurckgegeben oder eine Zahl.
.IP
Wenn eine Audio-Ausgabe endet, whrend diese Funktion aktiv ist, wird
automatisch entweder "f" (vorwrts) oder "s" (Stop) ausgewhlt.
Falls beides vorhanden ist, hat "f" Vorrang.
.PP
.TP
.BI "avt.menu(" Menpunkte )
.TQ
.BI "avt.long_menu(" Menpunkte )
Zeigt ein Men mit den angegebenen 
.IR Menpunkte "n."
Die
.I Menpunkte
knnen zum Einen ein Array mit Strings sein.
Dann wird die Nummer (Position) des ausgewhlten Menpunktes
zurckgegeben.
.IP
Oder
.I Menpunkte
knnen ein Array mit weiteren Arrays sein.
Die inneren Arrays mssen dann mit einem String anfangen, gefolgt von
einem oder mehreren Egebnissen.
Die Ergebnisse knnen jeder beliebige Lua-Typ sein, einschlielich
Funktionen.
.IP
Das Men fngt in der Zeile der aktuellen Cursor-Position an.
Dadurch kann man eine berschrift vor das Men setzen.
.IP
.EX
avt.clear()
avt.say("Bitte das Liebligsessen auswhlen:\en")
local Menuepunkt = avt.long_menu {
  "Chicken",
  "Chips",
  "Pizza",
  "Spinach"}
.EE
.PP
.TP
.BI "avt.choice(" "Anfanszeile, Eintrge [, Taste] [, zurck] [, vorwrts]" )
Diese Funktion kann fr Mens verwendet werden.
Es ist eine grundlegendere Funktion, als
.BR avt.menu() .
Es gibt die Nummer den ausgewhlten Menpunktes zurck.
.IP
.RS
.TP
.IR Anfangszeile :
die Zeile, in der die Auswahl beginnt
.TP
.IR Eintrge :
Anzahl der Eintrge (Zeilen)
.TP
.IR Taste :
Anfangstaste, wie "1" oder "a", 0 fr keine Tastenuntersttzung
.TP
.IR zurck :
auf
.I true
zu setzen, wenn der erste Eintrag eine zurck-Funktion hat
.TP
.IR vorwrts :
auf
.I true
zu setzen, wenn der letzte Eintrag eine weiter-Funktion hat
.RE
.PP
.SS Audio-Ausgabe
.TP
.BI "avt.start_audio()"
Startet das Audio-Untersystem.
.IP
Bei Erfolg gibt es
.I true
zurck, im Fehlerfall gibt es
.I nil
und eine Fehlermeldung zurck.
.PP
.TP
.BI "avt.load_audio_file(" "[Dateiname [,Abspielmodus]]" )
.TQ
.BI "avt.load_base_audio_file(" "[Dateiname [,Abspielmodus]]" )
Liest Audio-Daten von einer Datei ein.
Man kann mit
.B avt.search()
nach der Datei suchen lassen.
.IP
Lua-Module knnen Untersttzung fr weitere Audio-Formate zu
.B "avt.load_audio_file()"
hinzufgen.
(Das tut zum Beispiel das Modul
.BR akfavatar-vorbis ).
.IP
Wenn kein
.I Dateiname
angegeben ist, oder der
.IR Dateiname " ist " nil
oder ein leerer String, wird ein Audio-Element mit Stille zurckgegeben,
das heit, man kann die Methoden aufrufen, aber es wird kein Klang ausgegeben.
.IP
.I Abspielmodus
kann entweder "load", "play" oder "loop" sein.
.IP
Bei Fehlern wird
.I nil
und eine Fehlermelung zurckgegeben.
(Anmerkung: in Version 0.19.0 wurde dann auch eine Stille zurckgegeben.)
.PP
.TP
.BI "avt.load_audio_stream(" "Datei [,Gre [,Abspielmodus]]" )
.TQ
.BI "avt.load_base_audio_stream(" "Datei [,Gre [,Abspielmodus]]" )
Liest Audio-Daten von einer geffneten Datei.
Die Datei muss durchsuchbar sein.
.IP
Lua-Module knnen Untersttzung fr weitere Audio-Formate zu
.B "avt.load_audio_stream()"
hinzufgen.
(Das tut zum Beispiel das Modul
.BR akfavatar-vorbis ).
.IP
Wenn keine Gre angegeben ist, wird davon ausgegangen, 
dass die Audio-Daten bis zum Ende der Datei gehen.
.IP
.I Abspielmodus
kann entweder "load", "play" oder "loop" sein.
.IP
Bei Fehlern wird
.I nil
und eine Fehlermelung zurckgegeben.
.PP
.TP
.BI "avt.load_audio(" "[Audiodaten [,Abspielmodus]]" )
.TQ
.BI "avt.load_base_audio(" "[Audiodaten [,Abspielmodus]]" )
Liest Audiodaten aus einem String.
Ansonsten das selbe, wie
.BR avt.load_audio_file() .
.IP
Lua-Module knnen Untersttzung fr weitere Audio-Formate zu
.B "avt.load_audio()"
hinzufgen.
(Das tut zum Beispiel das Modul
.BR akfavatar-vorbis ).
.IP
Wenn keine
.I Audiodaten
angegeben sind, oder
.IR Audiodaten " ist " nil
oder ein leerer String, wird ein Audio-Element mit Stille zurckgegeben,
das heit, man kann die Methoden aufrufen, aber es wird kein Klang ausgegeben.
.IP
.I Abspielmodus
kann entweder "load", "play" oder "loop" sein.
.IP
Bei Fehlern wird
.I nil
und eine Fehlermelung zurckgegeben.
(Anmerkung: in Version 0.19.0 wurde dann auch eine Stille zurckgegeben.)
.PP
.TP
.B avt.silent()
Gibt ein stilles Audio-Element zurck,
das heit, man kann die Methoden aufrufen, aber es wird kein Klang ausgegeben.
.IP
.B Beispiel:
.EX
audio = avt.load_audio_file(Dateiname) or avt.silent()
.EE
.IP
In diesem Beispiel bekommt man einen stillen Klang, wenn die Datei nicht
gelesen werden konnte.
.PP
.TP
.B avt.alert()
Gibt ein Pseudo-Audio-Element zurck, welches
.B avt.bell()
aufruft, wenn man es abspielt.
.PP
.TP
.BI "avt.audio_playing(" [Audiodaten] )
berprft, ob Audiodaten gerade abgespielt werden.
Wenn
.I Audiodaten
angegeben ist und nicht
.I nil
ist, dann wird berprft, ob die angegebenen Audiodaten abgespielt werden.
Das kann man brigens auch mit
.IB audio ":playing()"
berprfen.
.PP
.TP
.BI "avt.wait_audio_end()"
Wartet, bis die Audio-Ausgabe beendet ist.
.IP
Dadurch wird auch eine Audio-Schleife beendet, aber es spielt halt
noch bis zum Ende des aktuellen Klanges.
.PP
.TP
.BI "avt.stop_audio()"
Stoppt die Audio-Ausgabe sofort.
.PP
.TP
.BI "avt.pause_audio(" true | false )
Die Audio-Ausgabe wird
.RI "pausiert (" true ") oder weiter gespielt (" false ")"
.PP
.TP
.IB audio ":play()"
.TQ
.IB audio "()"
Spielt die Audiodaten
.I audio
ab.
Die Audiodaten
.I audio
mssen mit
.BR avt.load_audio_file() " oder " avt.load_audio_string()
geladen worden sein.
.IP
Es kann nur ein Klang gleichzeitig abgespielt werden.
Wenn man einen anderen Klang abspielt, wird der vorherige
dadurch abgebrochen.
Man kann
.B avt.wait_audio_end()
verwenden, um Klnge nacheinander abzuspielen.
.IP
Man kann den Klang auch abspielen, indem man die Audio-Variable
wie eine Funktion aufruft.
.IP
.EX
abspielen = function (Dateiname)
  local Klang = avt.load_audio_file(avt.search(Dateiname))
  if Klang then Klang:play() end
end
.EE
.PP
.TP
.IB audio ":loop()"
Spielt die Audiodaten
.I audio
in einer Schleife ab.
Die Audiodaten
.I audio
mssen mit
.BR avt.load_audio_file() " oder " avt.load_audio_string()
geladen worden sein.
.IP
Das ist zum Beispiel fr eine kurze Musik-Sequenz ntzlich.
.IP
Man kann die Audio-Schleife mit
.BR avt.wait_audio_end() " oder " avt.stop_audio()
beenden.
.PP
.TP
.IB audio ":playing()"
berprft, ob diese
.IR audio -Daten
gerade abgespielt werden.
Die Audiodaten
.I audio
mssen mit
.BR avt.load_audio_file() " oder " avt.load_audio_string()
geladen worden sein.
.IP
Diese Funktion ist identisch mit 
.BR "avt.audio_playing(audio)" .
.PP
.TP
.IB audio ":free()"
Gibt die
.IR audio -Daten
frei.
Falls diese
.IR audio -Daten
gerade abgespielt werden, wird die Audio-Ausgabe abgebrochen.
.IP
Audiodaten werden auch vom Garbage Collector freigegeben.
.PP
.TP
.BI "avt.set_audio_end_key (" Taste )
Definiere eine Taste, die automatisch gedrckt werden soll, wenn
die Audio-Ausgabe endet.
Die
.I Taste
sollte als Zahl fr den Unicode-Codepoint angegeben werden.
Durch den Wert
.I 0
kann man das wieder abschalten.
.IP
Die Funktion gibt den voher gesetzten Wert zurck.
.PP
.TP
.BI "avt.quit_audio()"
Das Audio-Untersystem beenden.
.IP
Das ist bei normalen Programmen nicht ntig.
Diese Funktion sollte nur verwendet werden, wenn man wei, was man tut.
.PP
.SS Dateisystem
.TP
.BI "avt.dirsep"
Diese Variable enthlt das Verzeichnis-Trennzeichen des Systems;
entweder "/" oder "\e".
.PP
.TP
.BI "avt.datapath"
Diese Variable enthlt den Standardsuchpfad fr die Funktion
.B avt.search()
(siehe unten).
Verzeichnisse werden durch Semikola getrennt.
Es gibt keine Muster, wie in den Pfaden fr Lua-Module,
sondern es werden nur Verzeichnisse angegeben.
Diese Variable wird entweder durch die Umgebungsvariable
.I AVTDATAPATH
initialisiert,
oder sie bekommt eine systemspezifische Vorgabeeinstellung.
.PP
.TP
.BI "avt.search(" "Dateiname [,Pfad]" )
Sucht eine Datei mit dem angegebenen
.IR Dateiname n
im angegebenen
.IR Pfad .
Wenn kein
.I Pfad
angegeben ist, wird die Variable
.I avt.datapath
verwendet.
.IP
Wenn die Datei gefunden wurde, wird der vollstndige Pfad der
Datei zurckgegeben.
Wenn die Datei nicht gefunden wurde, wird
.I nil
und eine Fehlermeldung zurckgegeben.
.PP
.TP
.BI "avt.get_directory()"
.TQ
.BI "avt.getcwd()"
Gibt das aktuelle Arbeitsverzeichnis zurck.
Im Fehlerfall wird
.I nil
und eine Fehlermeldung zurckgegeben.
.PP
.TP
.BI "avt.set_directory(" directory )
.TQ
.BI "avt.chdir(" Verzeichnis )
Setzt das Arbeitsverzeichnis auf
.IR Verzeichnis .
.RI "Wenn " Verzeichnis " " nil
ist, ein Leerstring oder nicht angegeben ist, wird nichts ausgefhrt.
.IP
Gibt bei Erfolg
.I true
zurck oder bei einem Fehler
.I nil
und eine Fehlermeldung.
.IP
.B Beispiel:
.EX
avt.set_directory(os.getenv("HOME") or os.getenv("USERPROFILE"))
.EE
.PP
.TP
.BI "avt.directory_entries(" [Verzeichnis] )
Hole eine Liste von Verzeichniseintrgen vom angegebenen
.I Verzeichnis
oder dem aktuellen Arbeitsverzeichnis, wenn keins angegeben ist.
.IP
Bei Erfolg gibt es ein Array mit den Verzeichniseintrgen zurck
und die Anzahl der Eintrge.
Im Fehlerfall wird
.I nil
und eine Fehlermeldung zurckgegeben.
.IP
Die Liste enthlt sowohl normale Dateinamen, einschlielich
verstecken Dateien, Unterverzeichnisse und andere Arten von Eintrgen.
Die Eintrge "." oder ".." sind nicht mit drin.
.IP
Achtung: Die Namen sind in einer systemspezifischen Kodierung.
Um die Namen anzeigen zu knnen, muss man entweder die Kodierung
der Anzeige mit
.B "avt.encoding(""SYSTEM"")"
ndern, oder die Namen wie folgt konvertieren:
.BR "avt.say(avt.recode(name, ""SYSTEM""))" .
.PP
.TP
.BI "avt.entry_type(" Eintrag )
Ermittle die Art eines Verzeichniseintrags und seine Gre.
.IP
Bei Erfolg gibt es die Art des Verzeichniseintrags als String
zurck und die Gre als Zahl.
Die Art ist entweder "file", "directory", "character device", 
"block device", "fifo", "socket" oder "unknown".
.IP
Im Fehlerfall wird
.I nil
und eine Fehlermeldung zurckgegeben.
.IP
Symbolische Links werden ausgewertet.
Das bedeutet, man bekommt die Art des resultierenden Eintrags.
Kaputte Links werden wie nicht existierende Eintrge behandelt.
.PP
.SS Verschiedenes
.TP
.BI "avt.language"
Diese Variable enthlt einen Sprachcode fr Meldungen.
Es sollte sich um eine Kennung mit zwei Buchstaben gem
ISO 639-1 handeln.
Wenn die Sprache nicht ermittelt werden konnte, ist die Variable
nicht gesetzt.
.PP
.TP
.BI "avt.translate(" Text )
bersetzt den
.IR Text ,
falls mglich.
.IP
Wie man bersetzungen angeben kann, steht im Abschnitt
.BR bersetzungen .
.PP
.TP
.BI "avt.recode(" "String, Quellkodierung [,Zielkodierung]" )
Konvertiert den angegebenen
.IR String ,
der in
.I Quellkodierung
kodiert ist, in einen String der in
.I Zielkodierung
kodiert ist.
Wenn nur eine Kodierung angegeben ist, kovertiert es in die 
aktuell gesetzte Kodierung.
Falls man von der aktuellen Kodierung in etwas anderes kovertieren will,
kann man
.IR nil " fr die " Quellkodierung
angeben.
.IP
Um in die oder aus der Standardkodierung des Systems umzukodieren
(zum Beispiel fr Dateinamen), kann man einen leeren String
.RI ( """""" ") oder " """SYSTEM"""
angeben.
.IP
Gibt den kodierten String zurck, oder
.IR nil ,
bei schweren Fehlern.
.IP
.B Achtung:
Nach UTF-8 zu konvertieren ist immer mglich.
Nach anderen Kodierungen zu konvertieren, kann jedoch fehlschlagen.
Zeichen, die nicht konvertiert werden knnen,
werden durch das Steuerzeichen
.IR "SUB " ( """\ex1A""" )
ersetzt.
Um sicher zu stellen, dass die Konvertierung verlustfrei ablief,
kann man berprfen, dass dieses Zeichen im Ausgabestring
nicht vorkommt.
.PP
.TP
.BI "avt.right_to_left(" true | false )
Aktiviert, oder deaktiviert den rechts-nach-links-Schreibmodus.
.IP
.B Achtung:
Dies ist noch experimentell und funktioniert nur eingeschrnkt.
.PP
.TP
.BI "avt.set_flip_page_delay(" [delay] )
Setzt eine Verzgerung fr
.B avt.flip_page()
oder "\ef".
Ohne Angabe eines Wertes wird auf die Vorgabe zurckgesetzt.
Der Wert 0 schaltet die Verzgerung ganz aus.
.PP
.TP
.BI "avt.activate_cursor(" true | false )
Legt fest, ob der Cursor angezeigt wird, oder nicht.
.PP
.TP
.BI "avt.clear_screen()"
Lscht den gesamten Bildschirm, bzw. das Fenster
(nicht nur die Sprechblase!).
.PP
.TP
.BI "avt.clear_down()"
Lscht von der Cursor-Postition nach unten im Anzeigebereich.
Wenn noch keine Sprechblase angezeigt wird, wird sie gezeichnet.
.PP
.TP
.BI "avt.clear_eol()"
Lscht das Ende der Zeile (abhngig von der Text-Richtung).
.PP
.TP
.BI "avt.clear_bol()"
Lscht den Anfang der Zeile (abhngig von der Text-Richtung).
.PP
.TP
.BI "avt.clear_line()"
Lscht die Zeile.
.PP
.TP
.BI "avt.clear_up()"
Lscht von der Cursor-Postition nach oben im Anzeigebereich.
Wenn noch keine Sprechblase angezeigt wird, wird sie gezeichnet.
.PP
.TP
.BI "avt.reserve_single_keys(" true | false )
Reserviert Einzeltasten, wie <ESC> oder <F11>.
.PP
.TP
.BI "avt.switch_mode(" mode )
ndert den Fenster-Modus.
Man kann es entwerder auf
.IR """window""" ", oder " """fullscreen"""
setzen.
.IP
(Die Modi 
.IR """auto""" " und  " """fullscreen no switch"""
funktionieren hiermit nicht.)
.PP
.TP
.BI "avt.get_mode()"
Gibt den Fenster-Modus zurck
(siehe
.BR "avt.switch_mode (mode)" ).
.PP
.TP
.BI "avt.toggle_fullscreen()"
Schaltet den Vollbild-Modus ein oder aus.
.PP
.TP
.BI "avt.update()"
Aktualisiert alles und reagiert auf Ereignisse.
Dies sollte innehalb von Schleifen ausgefhrt werden, whrend das
Programm mit anderem beschftigt ist.
.PP
.TP
.BI "avt.credits(" "text, centered" )
Zeigt einen Abspann.
.IP
Wenn der zweite Parameter
.I true
ist, wird jede Zeile zentriert.
.PP
.TP
.BI "avt.viewport(" "x, y, width, height" )
Setzt einen Anzeigebereich (einen Unterbereich des Textbereiches).
Die obere linke Ecke hat die Koordinaten 1, 1.
.PP
.TP
.BI "avt.set_scroll_mode(" Modus )
Setzt den Rollmodus, dh. wie er reagiert, wenn man hinter der
letzten Zeile weiter schreibt.
Der
.I Modus
ist entweder -1 fr "nichts tun" oder 0 fr "Seite umblttern"
oder 1 fr "hochrollen".
.PP
.TP
.BI "avt.get_scroll_mode()"
Gibt den Rollmodus zurck
(siehe
.BR "avt.set_scroll_mode()" ")."
.PP
.TP
.BI "avt.newline_mode(" true | false )
Wenn der Neue-Zeile-Modus aktiviert ist (Vorgabe), dann setzt ein
Zeilenvorschub-Zeichen den Cursor an den Anfang einer neuen Zeile.
Wenn er aus ist, geht der Cursor in die nchste Zeile, bleibt aber
in der selben horizontalen Position.
.PP
.TP
.BI "avt.set_auto_margin(" true | false )
Setzt den Modus fr automatischen Zeilenumbruch, dh. ob
eine neue Zeile angefangen werden soll, wenn der Text nicht
in eine Zeile passt.
.PP
.TP
.BI "avt.get_auto_margin()"
Gibt den Modus fr automatischen Zeilenumbruch zurck.
.PP
.TP
.BI "avt.set_origin_mode(" true | false )
Setzt den Ursprungs-Modus.
Wenn der Ursprungs-Modus eingeschaltet ist, sind die Koordinaten
1, 1 immer oben links in der Sprechblase, auch dann, wenn der
Anzeigebereich (viewport) nicht dort beginnt.
Wenn der Ursprungs-Modus ausgeschaltet ist, sind die Koordinaten
1, 1 oben links im Anzeigebereich (viewport).
.PP
.TP
.BI "avt.get_origin_mode()"
Gibt den Ursprings-Modus zurck
(siehe
.BR "avt.set_origin_mode" ")."
.PP
.TP
.BI "avt.set_mouse_visible(" true | false )
Legt fest, ob der Mauszeiger sichtbar sein soll, oder nicht.
.IP
.B Anmerkung:
Wenn die Anwendung in einem Fenster luft, gilt das nur,
wenn sich der Mauszeiger innerhalb des Fensters befindet.
.PP
.TP
.BI "avt.lock_updates(" true | false )
Blockiert Aktualisierungen innerhalb der Sprechblase.
Das kann man verwenden um die Geschwindigkeit zu erhhen.
.PP
.TP
.BI "avt.version()"
Gibt die Version von AKFAvatar als String zurck.
.PP
.TP
.BI "avt.copyright()"
Gibt die Copyright-Meldung fr AKFAvatar als String zurck.
.PP
.TP
.BI "avt.license()"
Gibt die Lizenz-Meldung fr AKFAvatar als String zurck.
.PP
.TP
.BI "avt.quit()"
Beendet das AKFAvatar Untersystem (schliet das Fenster).
Das Audio-Untersystem wird ebenfalls beendet.
.IP
Diese Funktion wird nicht in normalen Programmen bentigt.
Man sollte sie nur verwenden, wenn das Programm ohne sichbares
Fenster weiter laufen soll.
.PP
.TP
.BI "avt.launch(" "Programm [,Argumente ...]" )
Beendet AKFAvatar und fhrt das angegebene 
.I Programm
aus.
Diese Funktion kehrt niemals zurck.
Entweder das Programm luft, oder es wird ein fataler Fehler angezeigt.
.IP
Wenn man Fehler mit
.B pcall
abfangen will, muss man danach AKFAvatar neu initialisieren...
.PP
.SH bersetzungen
Um bersetzungen fr Lua-AKFAvatar Skripte zu schreiben, muss man erstmal die
Variable
.B avt.translations
definieren.
Es handelt sich dabei um eine verschachtelte Tabelle.
Nun, die ist schwer zu beschreiben, aber das Beispiel-Skript weiter unten
sollte es verstndlich machen.
.PP
Die zu verwendende Sprache wird durch die Variable
.B avt.language
festgelegt.
Diese Variable sollte von Lua-AKFAvatar automatisch initialisiert worden sein,
sie kann aber auch im Skript gendert werden.
Sie enthlt eine Sprach-Kennung mit zwei Buchstaben gem ISO 639-1.
.PP
Die Funktion
.BI avt.translate( Text )
gibt dann den bersetzten Text zurck.
Falls keine bersetzung zur Verfgung steht, wird der Text unverndert zurck
gegeben.
.PP
Es ist ratsam, einen lokalen Alias namens
.BR L " fr " avt.translate
anzulegen:
.EX
  local L = avt.translate
.EE
Dann kann man einfach eine String-Konstante damit einleiten.
.PP
.BR Beispiel :
.EX
local avt = require "lua-akfavatar"

avt.encoding("UTF-8")

avt.translations = {

  ["Hello world!"] = {
    es="Hola mundo!",
    fr="Bonjour le monde!",
    de="Hallo Welt!",
    sv="Hej Vrlden!",
    },

  ["That's live!"] = {
    de="So ist das Leben!",
    fr="C'est la vie!" },
}

local L = avt.translate

-- avt.language = "de"

avt.start()
avt.avatar_image("default")
avt.tell(L"Hello world!", "\en", L"That's live!");
avt.wait_button ()
.EE
.PP
.BR Tipps :
.IP \(en 2
Obwohl es nicht notwendig ist, sollte man Englisch als Ausgangssprache
verwenden.
.IP \(en
Wenn man Text mit Variablen dazwischen hat, ist es kein guter Ansatz, den Text
in Teile aufzuteilen.
Es ist besser einen Format-String fr
.B string.format()
zu definieren.
.IP \(en
Der bersetzbare String muss exakt bereinstimmen.
Bitte daran denken, wenn man die Strings im Programm abndert,
dass man dann auch die bersetzungstabelle anpassen muss!
.IP \(en
Der String kann auch ein Dateiname fr eine Textdatei oder eine
Sprachaufnahme sein.
.PP
brigens, diese Implementierung wurde von GNU gettext inspiriert.
.PP
.SH "SIEHE AUCH"
.BR lua-akfavatar (1)
.BR lua (1)
.BR akfavatar-graphic (3)
.BR akfavatar-term (3)
.BR akfavatar.utf8 (3)
.br
.B http://lua.coders-online.net/
.br
.B http://www.lua.org/manual/5.2/
.br
.B http://akfavatar.nongnu.org/manual/
