.\" Process this file with
.\" groff -man -Tutf8 lua-akfavatar.1
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "lua-akfavatar" 1 2013-07-11 AKFAvatar
.
.SH NAME
lua-akfavatar \- Lua-Interpreter fr die AKFAvatar-Benutzeroberflche
.
.SH SYNTAX
.BI "lua-akfavatar [" Optionen "] [" " Skript " "[" Argumente "] ]"
.
.SH BESCHREIBUNG
Das Programm Lua-AKFAvatar ist der Lua Interpreter fr die 
AKFAvatar-Benutzeroberflche.
Es ldt und fhrt Lua-Skripte in Form von Quellcode aus
(kein Bytecode).
Es knnen entweder Lua-Skripte geladen werden oder
.RB \[Bq] .avt \[lq]-Demo-Dateien.
Wenn kein
.I Skript
angegeben ist, wird ein Dateiauswahl-Dialog angezeigt.
.PP
Die angegebenen
.I Argumente
sind im
.I Skript
als Strings in der globalen Tabelle namens
.B arg
verfgbar.
Der Name des
.IR Skript es
selber befindet sich in
.BR arg[0] ,
das erste Argument ist
.B arg[1]
und so weiter.
.PP
Um Zugang zu den AKFAvatar-spezifischen Funktionen zu bekommen,
muss man erstmal den Befehl
.BI "local " avt " = require " "\[dq]lua-akfavatar\[dq]"
verwenden.
.PP
Mit dem Dateiauswahl-Dialog kann man auch Anleitungen
mit der Dateiendung
.RB \[Bq] .about \[lq]
sehen.
Das knnen einfache Textdateien sein, die in UTF-8 oder reinem ASCII
kodiert sind.
Man kann auch die \[Bq]overstrike\[lq]-Technik verwenden, um Text fett
oder unterstrichen darstellen zu knnen.
Man kann zum Beispiel das Textsatzsystem \[Bq]groff\[lq] verwenden,
um solche Dateien zu erstellen.
.br
Auerdem knnen GNU info Dateien
mit der Dateiendung
.RB \[dq] .info \[dq]
als Text dargestellt werden
(keine Untersttzung fr Querverweise).

.
.SH OPTIONEN
.TP
-h
.TQ
--help
zeigt eine kurze Hilfe an
.TP
-v
.TQ
--version
zeigt die Version an
.TP
.RI "-l " "[var=]Name"
ruft
.BI require( \[dq]name\[dq] )
auf, bevor das Skript ausgefhrt wird.
Definiert eine globale Variable mit dem Namen
.IR Name " oder " var .
Das wird blicherweise verwendet, um Bibliotheken zu laden.
.TP
-f
.TQ
--fullscreen
starte im Vollbild Modus
(nur wenn kein Skript angegeben ist)
.TP
-F
.TQ
--Fullscreen
starte im Vollbild Modus ohne die Auflsung umzustellen
(nur wenn kein Skript angegeben ist)
.TP
.RI --dir= Verzeichnis
starte den Dateiauswahl-Dialog in diesem Verzeichnis
(nur wenn kein Skript angegeben ist)
.
.SH UMGEBUNG
.TP
LUA_PATH_5_2
.TQ
LUA_PATH
Suchpfad fr Lua-Module.
Die Suchmuster werden durch Semikola getrennt.
Ein Fragezeichen
.RB ( ? )
wird durch den Namen des Modules ersetzt.
Ein Punkt im Modul-Namen wird durch das Verzeichnis-Trennzeichen
des Systems ersetzt.
Zwei Semikola
.RB ( ;; )
fgen den Standard-Pfad hinzu.
.TP
LUA_CPATH_5_2
.TQ
LUA_CPATH
Suchpfad fr C-Module.
Die Syntax ist die selbe wie bei
.IR LUA_PATH .
.TP
AVTDATAPATH
Suchpfad fr Datendateien (Bilder, Audio, Texte...).
Er wird in der Variable
.B avt.datapath
abgelegt und kann mit der Funktion
.BI avt.search( Dateiname )
verwendet werden.
Die Verzeichnisse werden durch Semikola getrennt.
Im Gegensatz zu den vorherigen Pfaden gibt es keine Suchmuster
mit Fragezeichen.
.
.SH BEISPIEL
.EX
local avt = require "lua-akfavatar"
avt.encoding("UTF-8")
avt.title("Mein erstes Programm")
avt.start()
avt.avatar_image("default")
avt.say("Hallo du!\en")
local Name = avt.ask("Wie heit du denn? ")
avt.say("Hallo, ", Name, ". Schn dich zu sehen!\en")
avt.wait_button()
.EE
.
.SH SICHERHEIT
Lua ist eine vollstndige Programmiersprache.
Es gibt keine Sandbox-Beschrnkungen.
Jede vollstndige, unbeschrnkte Programmiersprache kann dafr
missbraucht werden, um Schadcode zu schreiben.
Man sollte also immer daran denken, dass Lua-Skripte
Programme sind und mit der selben Sorgfalt wie andere
Programme zu behandeln sind.
Einige andere Dateien fr Lua-AKFAvatar knnen ebenfalls
Code enthalten.
.
.SH AUTOREN
.TP 16
AKFAvatar
.TQ
Lua-AKFAvatar
Andreas K. Frster
.IP "Lua"
R. Ierusalimschy, L. H. de Figueiredo, and W. Celes
.
.SH HOMEPAGE
http://akfavatar.nongnu.org/
.
.SH "SIEHE AUCH"
.BR lua (1)
.BR lua-akfavatar-ref (3)
.BR akfavatar-graphic (3)
.BR akfavatar-term (3)
.BR akfavatar.utf8 (3)
.PP
http://akfavatar.nongnu.org/manual/
.br
http://www.lua.org/manual/5.2/
.br
http://lua.coders-online.net/
