Client-side document rewriting, redirection, or other sensitive
action, using untrusted data, should be avoided wherever possible, as
these may not be inspected by server side filtering.

To remedy DOM
XSS vulnerabilities where these sensitive document actions must be
used, it is essential to:

1. Ensure any untrusted data is treated as text, as opposed to being
interpreted as code or mark-up within the page.

2. Escape untrusted data prior to being used within the page. Escaping
methods will vary depending on where the untrusted data is being used.
(See references for details.)

3. Use `document.createElement`, `element.setAttribute`,
`element.appendChild`, etc. to build dynamic interfaces as opposed
to HTML rendering methods such as `document.write`,
`document.writeIn`, `element.innerHTML`, or `element.outerHTML `etc.
