/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openrdf.repository.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryResult<T>
extends CloseableIterationBase<T, RepositoryException> {
    private volatile Iteration<? extends T, RepositoryException> wrappedIter;

    public RepositoryResult(CloseableIteration<? extends T, RepositoryException> iter) {
        assert (iter != null);
        this.wrappedIter = iter;
    }

    @Override
    public boolean hasNext() throws RepositoryException {
        return this.wrappedIter.hasNext();
    }

    @Override
    public T next() throws RepositoryException {
        return this.wrappedIter.next();
    }

    @Override
    public void remove() throws RepositoryException {
        this.wrappedIter.remove();
    }

    @Override
    protected void handleClose() throws RepositoryException {
        super.handleClose();
        Iterations.closeCloseable(this.wrappedIter);
    }

    public void enableDuplicateFilter() throws RepositoryException {
        if (this.wrappedIter instanceof DistinctIteration) {
            return;
        }
        this.wrappedIter = new DistinctIteration<T, RepositoryException>(this.wrappedIter);
    }

    public List<T> asList() throws RepositoryException {
        return this.addTo(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Collection<T>> C addTo(C collection) throws RepositoryException {
        try {
            while (this.hasNext()) {
                collection.add(this.next());
            }
            C c = collection;
            return c;
        }
        finally {
            this.close();
        }
    }
}

