//-------------------------------------------------------------------------
/*
Copyright (C) 1997, 2005 - 3D Realms Entertainment

This file is part of Shadow Warrior version 1.2

Shadow Warrior is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Original Source: 1997 - Frank Maddin and Jim Norwood
Prepared for public release: 03/28/2005 - Charlie Wiederhold, 3D Realms
*/
//-------------------------------------------------------------------------

#ifdef DIGI_TABLE
#define DIGI_ENTRY(name, id, id_num, pri, pitch_lo, pitch_hi, voc_num, voc_dist, voc_flags) { name, NULL, 0, pitch_lo, pitch_hi, pri, voc_num, voc_dist, voc_flags, 0,0},
#endif

#ifdef DIGI_ENUM
#define DIGI_ENTRY(name, id, id_num, pri, pitch_lo, pitch_hi, voc_num, voc_dist, voc_flags) id = id_num,
#endif

// !JIM! 09/20/95
// NOTE: HIGHER priority numbers have the highest precedence in the play list.
#define PRI_MAX                 100
#define PRI_PLAYERDEATH         51
#define PRI_PLAYERVOICE         50
#define PRI_HI_PLAYERWEAP       49
#define PRI_LOW_PLAYERWEAP      48
#define PRI_PLAYERAMBIENT       40
#define PRI_NPCDEATH            49
#define PRI_NPCWEAP             47
#define PRI_NPCATTACK           42
#define PRI_NPCAMBIENT          39
#define PRI_ITEM                41
#define PRI_SWITCH              PRI_MAX  // To give a clue to player location
#define PRI_SECTOROBJ           30
#define PRI_ENVIRONMENT         20
#define PRI_AMBIENT             10

// Distance definitions for effective sound ranges
// Note: These are some useful constants, but you can type in whatever you want!
#define DIST_NORMAL             0        // Just play sound normaly
#define DIST_MAXNORMAL          16384    // This is max distance constant for normal sounds
// This is the limiting constant in Sound_Dist function.
#define DIST_WIDE               65536    // Half Level at full volume before sound begins to fade.
#define DIST_LEVELWIDE          131072   // Full Level

// VOC Flag definitions
#define VF_NORMAL               0
#define VF_LOOP                 1

// WEAPONS ////////////////////////////////////////////////////////////////////

// NULL Entry used to detect a sound's presence in sprite attrib structs.
DIGI_ENTRY("NULL.VOC",      DIGI_NULL,              0,      0,                    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// SWORD
DIGI_ENTRY("SWRDSTR1.VOC",  DIGI_SWORDSWOOSH,       1,      PRI_HI_PLAYERWEAP,    -200,   200, 0, DIST_NORMAL, VF_NORMAL)

// SHURIKEN
DIGI_ENTRY("THROW.VOC",     DIGI_STAR,              2,      PRI_HI_PLAYERWEAP, -100,    100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("STRCLNK.VOC",   DIGI_STARCLINK,         3,      PRI_PLAYERAMBIENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
//DIGI_ENTRY("STRWIZ.VOC",    DIGI_STARWIZ,           4,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP )
DIGI_ENTRY("NULL.VOC",      DIGI_NULL_STARWIZ,      4,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)

// UZI
DIGI_ENTRY("UZIFIRE1.VOC",  DIGI_UZIFIRE,           5,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RICH1.VOC",     DIGI_RICHOCHET1,        6,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RICH2.VOC",     DIGI_RICHOCHET2,        7,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RMVCLIP.VOC",   DIGI_REMOVECLIP,        8,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RPLCLIP.VOC",   DIGI_REPLACECLIP,       9,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
// SPENT SHELL HITTING FLOOR
DIGI_ENTRY("SHELL.VOC",     DIGI_SHELL,            10,      PRI_NPCATTACK,     -200,    200, 0, DIST_NORMAL, VF_NORMAL)

// CROSSRIOT
DIGI_ENTRY("RIOTFIR1.VOC",   DIGI_RIOTFIRE,        11,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SHOTGUN.VOC",    DIGI_RIOTFIRE2,       12,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIOTRLD.VOC",    DIGI_RIOTRELOAD,      13,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("EXPMED.VOC",     DIGI_BOLTEXPLODE,     14,      PRI_HI_PLAYERWEAP, -100,    100, 0, DIST_MAXNORMAL, VF_NORMAL)
DIGI_ENTRY("RIOTWIZ.VOC",    DIGI_BOLTWIZ,         15,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)

// 30MM GRENADE LAUNCHER
DIGI_ENTRY("40MMFIR2.VOC",   DIGI_30MMFIRE,        16,      PRI_HI_PLAYERWEAP, -100,    100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIOTRLD.VOC",    DIGI_30MMRELOAD,      17,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("40MMEXP2.VOC",   DIGI_30MMEXPLODE,     18,      PRI_HI_PLAYERWEAP, -100,    100, 0, DIST_WIDE, VF_NORMAL)
DIGI_ENTRY("RIOTWIZ.VOC",    DIGI_30MMWIZ,         19,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)

// GORO HEAD
DIGI_ENTRY("GHFIR1.VOC",    DIGI_HEADFIRE,         20,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GHWIZ.VOC",     DIGI_HEADSHOTWIZ,      21,      PRI_PLAYERAMBIENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("EXPSML.VOC",    DIGI_HEADSHOTHIT,      22,      PRI_LOW_PLAYERWEAP,-100,    100, 0, DIST_NORMAL, VF_NORMAL)

// MINES
DIGI_ENTRY("THROW.VOC",     DIGI_MINETHROW,        23,      PRI_HI_PLAYERWEAP,-100,    100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PHITGRND.VOC",  DIGI_MINEBOUNCE,       24,      PRI_LOW_PLAYERWEAP,-100,    100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("EXPLRG.VOC",    DIGI_MINEBLOW,         25,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_WIDE, VF_NORMAL)
DIGI_ENTRY("STSCAN2.VOC",   DIGI_MINEBEEP,         26,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)

// HEART ATTACK
DIGI_ENTRY("HBLOOP1.VOC",     DIGI_HEARTBEAT,      27,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
//#ifndef SW_SHAREWARE
DIGI_ENTRY("HSQUEEZ1.VOC",  DIGI_HEARTFIRE,        28,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
//#else
//DIGI_ENTRY("NULL.VOC",      DIGI_HEARTFIRE,        28,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL )
//#endif
DIGI_ENTRY("HRTWIZ.VOC",    DIGI_HEARTWIZ,         29,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)

// MISSILE BATTERY
DIGI_ENTRY("RIOTFIR1.VOC",  DIGI_MISSLFIRE,        30,      PRI_HI_PLAYERWEAP,  -75,     75, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("EXPMED.VOC",    DIGI_MISSLEXP,         31,      PRI_HI_PLAYERWEAP, -100,    100, 0, DIST_WIDE, VF_NORMAL)

// RING OF FIRE SPELL
//#ifndef SW_SHAREWARE
DIGI_ENTRY("RFWIZ.VOC",     DIGI_RFWIZ,            32,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
//#else
//DIGI_ENTRY("NULL.VOC",      DIGI_NULL_RFWIZ,       32,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL )
//#endif

// NAPALM SPELL
DIGI_ENTRY("NAPFIRE.VOC",   DIGI_NAPFIRE,          33,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NAPTWIZ.VOC",   DIGI_NAPWIZ,           34,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("NAPPUFF.VOC",   DIGI_NAPPUFF,          35,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_NORMAL)

// MAGIC MIRV SPELL
DIGI_ENTRY("MMFIRE.VOC",    DIGI_MIRVFIRE,         36,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MMWIZ.VOC",     DIGI_MIRVWIZ,          37,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)

// SPIRAL SPELL
DIGI_ENTRY("SPRLFIRE.VOC",  DIGI_SPIRALFIRE,       38,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPRLWIZ.VOC",   DIGI_SPIRALWIZ,        39,      PRI_LOW_PLAYERWEAP,   0,      0, 0, DIST_NORMAL, VF_LOOP)

// MAGIC SOUNDS, GENERIC
// (USED FOR MAGIC CARPET RIDES,ETC.)
DIGI_ENTRY("MAGIC1.VOC",    DIGI_MAGIC1,           40,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MAGIC2.VOC",    DIGI_MAGIC2,           41,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MAGIC3.VOC",    DIGI_MAGIC3,           42,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MAGIC4.VOC",    DIGI_MAGIC4,           43,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MAGIC5.VOC",    DIGI_MAGIC5,           44,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MAGIC6.VOC",    DIGI_MAGIC6,           45,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MAGIC7.VOC",    DIGI_MAGIC7,           46,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// SHADOW WARRIOR SPELL
//#ifndef SW_SHAREWARE
DIGI_ENTRY("SWSPELL.VOC",   DIGI_SWCLOAKUNCLOAK,   47,      PRI_LOW_PLAYERWEAP,-100,   100, 0, DIST_NORMAL, VF_NORMAL)
//#else
//DIGI_ENTRY("NULL.VOC",      DIGI_NULL_SWCLOAK,     47,      PRI_LOW_PLAYERWEAP,-100,   100, 0, DIST_NORMAL, VF_NORMAL  )
//#endif

// PLAYER DEAD HEAD
DIGI_ENTRY("DHVOMIT.VOC",   DIGI_DHVOMIT,          48,      PRI_PLAYERAMBIENT,  0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("DHCLUNK.VOC",   DIGI_DHCLUNK,          49,      PRI_PLAYERAMBIENT,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)
//DIGI_ENTRY("DHSQSH.VOC",  DIGI_DHSQUISH,         50,      PRI_PLAYERAMBIENT,  0,      0, 0, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("NULL.VOC",      DIGI_NULL_DHSQUISH,    50,      PRI_PLAYERAMBIENT,  0,      0, 0, DIST_NORMAL, VF_NORMAL)

// WEAPON RELATED
DIGI_ENTRY("LAVAHIT.VOC",   DIGI_PROJECTILELAVAHIT,51,      PRI_PLAYERAMBIENT,-100,   100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("STSPL01.VOC",   DIGI_PROJECTILEWATERHIT,52,     PRI_PLAYERAMBIENT,-100,   100, 0, DIST_NORMAL, VF_NORMAL)

// ITEMS
DIGI_ENTRY("KEY.VOC",       DIGI_KEY,              53,      PRI_ITEM,           0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ITEM5A.VOC",    DIGI_ITEM,             54,      PRI_ITEM,           0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ITEMBIG2.VOC",  DIGI_BIGITEM,          55,      PRI_ITEM,        -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// DEATH/HURT
DIGI_ENTRY("BODY9.VOC",     DIGI_BODYFALL1,        56,      PRI_PLAYERDEATH,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PHITGRND.VOC",  DIGI_HITGROUND,        57,      PRI_PLAYERAMBIENT,  0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BODY2.VOC",     DIGI_BODYSQUISH1,      58,      PRI_PLAYERAMBIENT,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BURN1.VOC",     DIGI_BODYBURN,         59,      PRI_PLAYERAMBIENT,  0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BURNSCRM.VOC",  DIGI_BODYBURNSCREAM,   60,      PRI_PLAYERDEATH,    -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BODY3.VOC",     DIGI_BODYCRUSHED1,     61,      PRI_PLAYERAMBIENT,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BODY4.VOC",     DIGI_BODYHACKED1,      62,      PRI_PLAYERAMBIENT,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BURN2.VOC",     DIGI_BODYSINGED,       63,      PRI_PLAYERAMBIENT,  0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("DROWN1.VOC",    DIGI_DROWN,            64,      PRI_PLAYERDEATH,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SCREAM1.VOC",   DIGI_SCREAM1,          65,      PRI_PLAYERDEATH,    -200,   400, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SCREAM2.VOC",   DIGI_SCREAM2,          66,      PRI_PLAYERDEATH,    -200,   400, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SCREAM3.VOC",   DIGI_SCREAM3,          67,      PRI_PLAYERDEATH,    -200,   400, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HIT1.VOC",      DIGI_HIT1,             68,      PRI_LOW_PLAYERWEAP, -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ELECTRC1.VOC",  DIGI_ELECTRICUTE1,     69,      PRI_PLAYERAMBIENT,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWDIE02.VOC",   DIGI_REMOVEME,         70,      PRI_PLAYERDEATH,    -200,   500, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("IMPALE1.VOC",   DIGI_IMPALED,          71,      PRI_PLAYERDEATH,    -200,   200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("OOF1.VOC",      DIGI_OOF1,             72,      PRI_PLAYERAMBIENT,  -200,   200, 0, DIST_NORMAL, VF_NORMAL)

// ACTOR SOUNDS THAT USER
// PLAYER SOUNDS AT A LOWER PRIORITY
DIGI_ENTRY("BODY1.VOC",     DIGI_ACTORBODYFALL1,   73,      PRI_NPCWEAP,        0,      0, DIGI_BODYFALL1, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HITGRND.VOC", DIGI_ACTORHITGROUND,   74,      PRI_NPCWEAP,        0,      0, DIGI_HITGROUND, DIST_NORMAL, VF_NORMAL)

// NPC'S //////////////////////////////////////////////////////////////////////

// COOLIE
DIGI_ENTRY("COLEXP.VOC",    DIGI_COOLIEEXPLODE,    75,      PRI_NPCDEATH,    -100,    100, 0, DIST_MAXNORMAL, VF_NORMAL)
DIGI_ENTRY("COLSCRM.VOC",   DIGI_COOLIESCREAM,     76,      PRI_NPCATTACK,   -100,    100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("COLALRT.VOC",   DIGI_COOLIEALERT,      77,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("COLAMB.VOC",    DIGI_COOLIEAMBIENT,    78,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("COLPAIN.VOC",   DIGI_COOLIEPAIN,       79,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// COOLIE GHOST
DIGI_ENTRY("CGMAT.VOC",     DIGI_CGMATERIALIZE,    80,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGALRT.VOC",    DIGI_CGALERT,          81,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGWHACK.VOC",   DIGI_CGTHIGHBONE,      82,      PRI_NPCWEAP,      -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGAMB.VOC",     DIGI_CGAMBIENT,        83,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGPAIN.VOC",    DIGI_CGPAIN,           84,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGSHOOT.VOC",   DIGI_CGMAGIC,          85,      PRI_NPCWEAP,      -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGHIT.VOC",     DIGI_CGMAGICHIT,       86,      PRI_NPCWEAP,      -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CGSCRM.VOC",    DIGI_CGSCREAM,         87,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// NINJA
DIGI_ENTRY("NINAMB.VOC",    DIGI_NINJAAMBIENT,     88,      PRI_NPCAMBIENT,  -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NINSTAR.VOC",   DIGI_NINJASTAR,        89,      PRI_NPCWEAP,     -100,    100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NINPAIN.VOC",   DIGI_NINJAPAIN,        90,      PRI_NPCWEAP,     -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NINSCRM.VOC",   DIGI_NINJASCREAM,      91,      PRI_NPCDEATH,    -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NINALRT.VOC",   DIGI_NINJAALERT,       92,      PRI_NPCATTACK,   -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NINSHOOT.VOC",  DIGI_NINJAUZIATTACK,   93,      PRI_NPCWEAP,        0,      0, DIGI_UZIFIRE, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIOTFIR1.VOC",  DIGI_NINJARIOTATTACK,  94,      PRI_NPCWEAP,        0,      0, DIGI_RIOTFIRE, DIST_NORMAL, VF_NORMAL)

// RIPPER
DIGI_ENTRY("RIPAMB.VOC",    DIGI_RIPPERAMBIENT,    95,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIPALRT.VOC",   DIGI_RIPPERALERT,      96,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIPATCK.VOC",   DIGI_RIPPERATTACK,     97,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIPPAIN.VOC",   DIGI_RIPPERPAIN,       98,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIPSCRM.VOC",   DIGI_RIPPERSCREAM,     99,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIPHRT.VOC",    DIGI_RIPPERHEARTOUT,  100,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// GUARDIAN
DIGI_ENTRY("GRDAMB.VOC",    DIGI_GRDAMBIENT,      101,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GRDALRT.VOC",   DIGI_GRDALERT,        102,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GRDPAIN.VOC",   DIGI_GRDPAIN,         103,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GRDSCRM.VOC",   DIGI_GRDSCREAM,       104,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GRDFIR.VOC",    DIGI_GRDFIREBALL,     105,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GRDAXE.VOC",    DIGI_GRDSWINGAXE,     106,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GRDAXHT.VOC",   DIGI_GRDAXEHIT,       107,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// SKELETOR PRIEST
DIGI_ENTRY("SPAMB.VOC",     DIGI_SPAMBIENT,       108,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPALRT.VOC",    DIGI_SPALERT,         109,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPPAIN.VOC",    DIGI_SPPAIN,          110,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPSCRM.VOC",    DIGI_SPSCREAM,        111,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPBLADE.VOC",   DIGI_SPBLADE,         112,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPELEC.VOC",    DIGI_SPELEC,          113,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPTLPRT.VOC",   DIGI_SPTELEPORT,      114,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// ACCURSED HEAD
DIGI_ENTRY("AHAMB.VOC",     DIGI_AHAMBIENT,       115,      PRI_NPCAMBIENT,     0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AHSCRM.VOC",    DIGI_AHSCREAM,        116,      PRI_NPCDEATH,       0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AHEXP.VOC",     DIGI_AHEXPLODE,       117,      PRI_NPCDEATH,       0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AHSHWSH.VOC",   DIGI_AHSWOOSH,      118,      PRI_NPCATTACK,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// HORNET
DIGI_ENTRY("HBUZZ.VOC",     DIGI_HORNETBUZZ,      119,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("HSTING.VOC",    DIGI_HORNETSTING,     120,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HPAIN.VOC",     DIGI_HORNETPAIN,      121,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HDEATH.VOC",    DIGI_HORNETDEATH,     122,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// SERPENT GOD BOSS
DIGI_ENTRY("SGAMB.VOC",     DIGI_SERPAMBIENT,     123,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGALRT.VOC",    DIGI_SERPALERT,       124,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGPAIN.VOC",    DIGI_SERPPAIN,        125,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGSCRM.VOC",    DIGI_SERPSCREAM,      126,      PRI_MAX,          -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGDETH.VOC",    DIGI_SERPDEATHEXPLODE,127,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGSWORD.VOC",   DIGI_SERPSWORDATTACK, 128,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGMAGIC.VOC",   DIGI_SERPMAGICLAUNCH, 129,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGHEADS.VOC",   DIGI_SERPSUMMONHEADS, 130,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGTAUNT.VOC",   DIGI_SERPTAUNTYOU,    131,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// LAVA BOSS
DIGI_ENTRY("LVAMB.VOC",     DIGI_LAVABOSSAMBIENT, 132,      PRI_NPCAMBIENT,     0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVSWIM.VOC",    DIGI_LAVABOSSSWIM,    133,      PRI_NPCAMBIENT,     0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVRISE.VOC",    DIGI_LAVABOSSRISE,    134,      PRI_NPCAMBIENT,     0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVALRT.VOC",    DIGI_LAVABOSSALERT,   135,      PRI_NPCATTACK,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVFLAME.VOC",   DIGI_LAVABOSSFLAME,   136,      PRI_NPCATTACK,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVMETEOR.VOC",  DIGI_LAVABOSSMETEOR,  137,      PRI_NPCATTACK,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVMETEXP.VOC",  DIGI_LAVABOSSMETEXP,  138,      PRI_NPCATTACK,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVPAIN.VOC",    DIGI_LAVABOSSPAIN,    139,      PRI_NPCATTACK,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVSIZZLE.VOC",  DIGI_LAVABOSSSIZZLE,  140,      PRI_NPCAMBIENT,     0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LVEXPL.VOC",    DIGI_LAVABOSSEXPLODE, 141,      PRI_NPCDEATH,       0,      0, 0, DIST_NORMAL, VF_NORMAL)

// LEVEL AND SECTOR OBJECT SOUNDS ///////////

// MOTOR BOAT
DIGI_ENTRY("BTSTRT.VOC",    DIGI_BOATSTART,       142,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BTRUN01.VOC",   DIGI_BOATRUN,         143,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("BTSTOP.VOC",    DIGI_BOATSTOP,        144,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BTFIRE.VOC",    DIGI_BOATFIRE,        145,      PRI_HI_PLAYERWEAP,  0,      0, 0, DIST_NORMAL, VF_NORMAL)

// ARMY TANK
DIGI_ENTRY("TNKSTRT.VOC",   DIGI_TANKSTART,       146,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TNKRUN.VOC",    DIGI_TANKRUN,         147,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("TNKSTOP.VOC",   DIGI_TANKSTOP,        148,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TNKIDLE.VOC",   DIGI_TANKIDLE,        149,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("TNKFIRE.VOC",   DIGI_TANKFIRE,        150,      PRI_HI_PLAYERWEAP,  0,      0, 0, DIST_NORMAL, VF_NORMAL)

// ARMY TRUCK
DIGI_ENTRY("TRUKRUN.VOC",    DIGI_TRUKRUN,        151,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("TRUKIDLE.VOC",   DIGI_TRUKIDLE,       152,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// SUBMARINE
DIGI_ENTRY("SUBRUN.VOC",    DIGI_SUBRUN,          153,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("SUBIDLE.VOC",   DIGI_SUBIDLE,         154,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("SUBDOOR.VOC",   DIGI_SUBDOOR,         155,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)

// WWII JAP BOMBER PLANE
DIGI_ENTRY("BMBFLY.VOC",    DIGI_BOMBRFLYING,     156,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("BMBDROP.VOC",   DIGI_BOMBRDROPBOMB,   157,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)

// BUBBLES
DIGI_ENTRY("BUBBLE.VOC",    DIGI_BUBBLES,         158,      PRI_AMBIENT,      -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// CHAIN MOVING
// SOUND NOT AVAILABLE -- DELTED
DIGI_ENTRY("CHAIN.VOC",     DIGI_CHAIN,           159,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// CHAIN DOOR
DIGI_ENTRY("CHNDOOR.VOC",   DIGI_CHAINDOOR,       160,      PRI_ENVIRONMENT,    0,      0, 0, 8000, VF_NORMAL)

// CRICKETS
DIGI_ENTRY("CRCKT2.VOC",     DIGI_CRICKETS,        161,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// WOOD DOOR OPEN/CLOSE
DIGI_ENTRY("DRWOODO.VOC",   DIGI_WOODDOOROPEN,    162,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)
DIGI_ENTRY("DRWOODC.VOC",   DIGI_WOODDOORCLOSE,   163,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)

// METAL DOOR OPEN/CLOSE
DIGI_ENTRY("DRMETO.VOC",    DIGI_METALDOOROPEN,   164,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)
DIGI_ENTRY("DRMETC.VOC",    DIGI_METALDOORCLOSE,  165,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)

// SLIDING DOOR OPEN/CLOSE
DIGI_ENTRY("DRSLDO.VOC",    DIGI_SLIDEDOOROPEN,   166,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)
DIGI_ENTRY("DRSLDC.VOC",    DIGI_SLIDEDOORCLOSE,  167,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)

// STONE SLIDING DOOR OPEN/CLOSE
DIGI_ENTRY("DRSTNO.VOC",    DIGI_STONEDOOROPEN,   168,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)
DIGI_ENTRY("DRSTNC.VOC",    DIGI_STONEDOORCLOSE,  169,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)

// SQUEAKY DOOR OPEN/CLOSE
DIGI_ENTRY("DRSQKO.VOC",    DIGI_SQUEAKYDOOROPEN, 170,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)
DIGI_ENTRY("DRSQKC.VOC",    DIGI_SQUEAKYDOORCLOSE,171,      PRI_ENVIRONMENT,  -100,     100, 0, 8000, VF_NORMAL)

// GIANT DRILL MACHINE
DIGI_ENTRY("DRILL.VOC",     DIGI_DRILL,           172,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// AMBIENT WATER DRIPPING IN CAVE
DIGI_ENTRY("CAVE1.VOC",     DIGI_CAVEDRIP1,       173,      PRI_AMBIENT,      -100,     100, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("CAVE2.VOC",     DIGI_CAVEDRIP2,       174,      PRI_AMBIENT,      -100,     100, 0, DIST_NORMAL, VF_LOOP)

DIGI_ENTRY("DRIP.VOC",      DIGI_DRIP,            175,      PRI_AMBIENT,      -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// WATER FALL
DIGI_ENTRY("WTRFAL1.VOC",   DIGI_WATERFALL1,      176,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
// THERE IS NO WTRFAL2 -- DELETED!!!
DIGI_ENTRY("WTRFAL2.VOC",   DIGI_WATERFALL2,      177,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// WATER FLOWING
DIGI_ENTRY("WTRFLW1.VOC",   DIGI_WATERFLOW1,      178,      PRI_AMBIENT,      -100,     100, 0, DIST_NORMAL, VF_LOOP)
// THERE IS NO WTRFLW2 -- DELETED!!!
DIGI_ENTRY("WTRFLW2.VOC",   DIGI_WATERFLOW2,      179,      PRI_AMBIENT,      -100,     100, 0, DIST_NORMAL, VF_LOOP)

// ELEVATOR START/STOP
DIGI_ENTRY("ELEV1.VOC",     DIGI_ELEVATOR,        180,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// SMALL EXP
DIGI_ENTRY("EXPSML.VOC",    DIGI_SMALLEXP,        181,      PRI_ENVIRONMENT,    -200,     200, 0, DIST_NORMAL, VF_NORMAL)

// MEDIUM EXP
DIGI_ENTRY("EXPMED.VOC",    DIGI_MEDIUMEXP,       182,      PRI_ENVIRONMENT,    -200,     200, 0, DIST_WIDE, VF_NORMAL)

// LARGE EXP
DIGI_ENTRY("EXPLRG.VOC",    DIGI_LARGEEXP,        183,      PRI_ENVIRONMENT,    -200,     200, 0, DIST_WIDE, VF_NORMAL)

// HUGE EXP
//DIGI_ENTRY("BIGEXP.VOC",    DIGI_HUGEEXP,       184,      PRI_ENVIRONMENT,    -200,     200, 0, DIST_WIDE, VF_NORMAL  )
DIGI_ENTRY("NULL.VOC",      DIGI_NULL_HUGEEXP,    184,      PRI_ENVIRONMENT,    -200,     200, 0, DIST_WIDE, VF_NORMAL)

// CRACKLING FIRE FOR CONTINUOUS BURN
DIGI_ENTRY("FIRE1.VOC",     DIGI_FIRE1,           185,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// POWERFULL HIGH HEAT CONTINUOUS BURN
DIGI_ENTRY("FIRE2.VOC",     DIGI_FIRE2,           186,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// SHOOTING FIREBALL FOR FIREBALL TRAP
DIGI_ENTRY("FBALL1.VOC",    DIGI_FIREBALL1,       187,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// SHOOTING FIREBALL FOR FIREBALL TRAP
DIGI_ENTRY("FIREBALL1.VOC", DIGI_FIREBALL2,       188,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// SECTOR GEAR COG TURNING
DIGI_ENTRY("GEAR1.VOC",     DIGI_GEAR1,           189,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_LOOP)

// AMBIENT GONG FOR USE IN TEMPLE/PALACE LEVELS
DIGI_ENTRY("GONG.VOC",      DIGI_GONG,            190,      PRI_HI_PLAYERWEAP,-100,    100, 0, 32336, VF_NORMAL)

// AMBIENT LAVA FLOW
DIGI_ENTRY("LAVAFLW1.VOC",  DIGI_LAVAFLOW1,       191,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// GENERIC SECTOR OBJECT MACHINE RUNNING
DIGI_ENTRY("MACHN1.VOC",    DIGI_MACHINE1,        192,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// AMBIENT MUD BUBBLES
DIGI_ENTRY("MUD1.VOC",      DIGI_MUBBUBBLES1,     193,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// AMBIENT EARTH QUAKE
DIGI_ENTRY("QUAKE1.VOC",    DIGI_EARTHQUAKE,      194,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// YUCKY SEWER FLOW
DIGI_ENTRY("SEWER1.VOC",    DIGI_SEWERFLOW1,      195,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// WATER SPLASHING
//(USE FOR PLAYER/NPC'S JUMPING AROUND IN WATER)
DIGI_ENTRY("SPLASH1.VOC",   DIGI_SPLASH1,         196,      PRI_ENVIRONMENT, -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// STEAM FLOW
DIGI_ENTRY("STEAM1.VOC",    DIGI_STEAM1,          197,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// VOLCANIC STEAM VENT
DIGI_ENTRY("VOLSTM1.VOC",   DIGI_VOLCANOSTEAM1,   198,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// STOMPER THUD SECTOR OBJECT
DIGI_ENTRY("STMPR.VOC",     DIGI_STOMPER,         199,      PRI_SECTOROBJ,   -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// SCARY AMBIENT SWAMP SOUNDS
DIGI_ENTRY("SWAMP1.VOC",    DIGI_SWAMP,           200,      PRI_AMBIENT,     -100,    100, 0, DIST_NORMAL, VF_LOOP)

// FLIP SWITCH
DIGI_ENTRY("SWITCH1.VOC",   DIGI_REGULARSWITCH,   201,      PRI_ENVIRONMENT, -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// FLIP LARGE SWITCH
DIGI_ENTRY("SWITCH2.VOC",   DIGI_BIGSWITCH,       202,      PRI_ENVIRONMENT, -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// STONE SWITCH
DIGI_ENTRY("SWITCH3.VOC",   DIGI_STONESWITCH,     203,      PRI_ENVIRONMENT, -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// BREAKABLE GLASS SWITCH
DIGI_ENTRY("SWITCH4.VOC",   DIGI_GLASSSWITCH,     204,      PRI_ENVIRONMENT, -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// HUGE ECHOING SWITCH
DIGI_ENTRY("SWITCH5.VOC",   DIGI_HUGESWITCH,      205,      PRI_ENVIRONMENT, -100,    100, 0, DIST_NORMAL, VF_NORMAL)

// AMBIENT ROLLING THUNDER
DIGI_ENTRY("THUNDR.VOC",    DIGI_THUNDER,         206,      PRI_AMBIENT,     -200,    200, 0, DIST_LEVELWIDE, VF_NORMAL)

// TELEPORTER
DIGI_ENTRY("TELPORT.VOC",   DIGI_TELEPORT,        207,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// UNDERWATER AMBIENCE
DIGI_ENTRY("UNDRWTR.VOC",   DIGI_UNDERWATER,      208,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// UNLOCK BIG LOCKED DOOR
DIGI_ENTRY("UNLOCK.VOC",    DIGI_UNLOCK,          209,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// SQUEAKY VALVE TURNING
DIGI_ENTRY("VALVE.VOC",     DIGI_SQUEAKYVALVE,    210,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// SPOOKY ETHERAL void AMBIENCE
//(NETHERWORLDLY SOUNDS)
DIGI_ENTRY("VOID1.VOC",     DIGI_VOID1,           211,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("VOID2.VOC",     DIGI_VOID2,           212,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("VOID3.VOC",     DIGI_VOID3,           213,      PRI_NPCWEAP,        0,      0, 0, -8000, VF_NORMAL)
DIGI_ENTRY("VOID4.VOC",     DIGI_VOID4,           214,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("VOID5.VOC",     DIGI_VOID5,           215,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// VOLCANIC ERUPTION
DIGI_ENTRY("ERUPT.VOC",     DIGI_ERUPTION,        216,      PRI_AMBIENT,        0,      0, 0, DIST_MAXNORMAL, VF_LOOP)

// VOLCANIC SIZZLING PROJECTILES FLYING THROUGH AIR
DIGI_ENTRY("VOLPRJCT.VOC",  DIGI_VOLCANOPROJECTILE, 217,    PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// LIGHT WIND AMBIENCE
DIGI_ENTRY("WIND1.VOC",     DIGI_LIGHTWIND,       218,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// STRONG BLOWING WIND AMBIENCE
DIGI_ENTRY("WIND2.VOC",     DIGI_STRONGWIND,      219,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// BREAKING WOOD AMBIENCE
DIGI_ENTRY("WOODBRK.VOC",   DIGI_BREAKINGWOOD,    220,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// BREAKING, TUMBLING STONES FALLING AMBIENCE
DIGI_ENTRY("STONEBRK.VOC",  DIGI_BREAKSTONES,     221,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// ENGINE ROOM SOUND
DIGI_ENTRY("ENGROOM1.VOC",  DIGI_ENGROOM1,        222,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("ENGROOM2.VOC",  DIGI_ENGROOM2,        223,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("ENGROOM3.VOC",  DIGI_ENGROOM3,        224,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("ENGROOM4.VOC",  DIGI_ENGROOM4,        225,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("ENGROOM5.VOC",  DIGI_ENGROOM5,        226,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// BREAKING GLASS, LARGE WINDOW PANE
DIGI_ENTRY("GLASS3.VOC",    DIGI_BREAKGLASS,      227,      PRI_NPCDEATH,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// MUSICAL STINGER
DIGI_ENTRY("MUSSTING.VOC",  DIGI_MUSSTING,        228,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// HELICOPTER LIKE SOUND
DIGI_ENTRY("HELI.VOC",      DIGI_HELI,            229,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// HUGE ECHOING HEART LIKE AMBIENCE
DIGI_ENTRY("BIGHART.VOC",   DIGI_BIGHART,         230,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// EERIE ETHERAL TYPE WIND
DIGI_ENTRY("WIND4.VOC",     DIGI_WIND4,           231,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// SPOOKY SINE WAVE SOUND
DIGI_ENTRY("SPOOKY1.VOC",   DIGI_SPOOKY1,         232,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

// SPOOKY SINE WAVE SOUND
DIGI_ENTRY("DRILL1.VOC",    DIGI_DRILL1,          233,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_LOOP)

// JET ENGINE
DIGI_ENTRY("JET.VOC",       DIGI_JET,             234,      PRI_AMBIENT,        0,      0, 0, DIST_MAXNORMAL, VF_LOOP)

// CERIMONIAL DRUM CHANT
DIGI_ENTRY("DRUMCHNT.VOC",  DIGI_DRUMCHANT,       235,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)

DIGI_ENTRY("FLY.VOC",       DIGI_BUZZZ,           236,      PRI_MAX,            0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("UZICLK.VOC",    DIGI_CHOP_CLICK,      237,      PRI_MAX,            0,      0, 0, DIST_NORMAL, VF_NORMAL)

// !IMPORTANT!  Make sure all player voices stay together
DIGI_ENTRY("STICKY2R.VOC",  DIGI_SWORD_UP,        238,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("UZI1R.VOC",     DIGI_UZI_UP,          239,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SHOTG1R.VOC",   DIGI_SHOTGUN_UP,      240,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BOLT1R.VOC",    DIGI_ROCKET_UP,       241,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BOLT1R.VOC",    DIGI_GRENADE_UP,      242,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BOLT1R.VOC",    DIGI_RAIL_UP,         243,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("STICKY1R.VOC",  DIGI_MINE_UP,         244,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("",              DIGI_FIRSTPLAYERVOICE,245,      0,                  0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BADMAN04.VOC",  DIGI_TAUNTAI1,        246,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("COMEGET2.VOC",  DIGI_TAUNTAI2,        247,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GHOP07.VOC",    DIGI_TAUNTAI3,        248,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GOODDAY4.VOC",  DIGI_TAUNTAI4,        249,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("KILLU05.VOC",   DIGI_TAUNTAI5,        250,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NATURAL4.VOC",  DIGI_TAUNTAI6,        251,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NOHONOR6.VOC",  DIGI_TAUNTAI7,        252,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SAYON09.VOC",   DIGI_TAUNTAI8,        253,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TAKSAN1.VOC",   DIGI_TAUNTAI9,        254,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SNATCH01.VOC",  DIGI_TAUNTAI10,       255,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("CHOTO7.VOC",    DIGI_PLAYERPAIN1,     256,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWPAIN05.VOC",  DIGI_PLAYERPAIN2,     257,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWPAIN03.VOC",  DIGI_PLAYERPAIN3,     258,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWPAIN07.VOC",  DIGI_PLAYERPAIN4,     259,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWPAIN22.VOC",  DIGI_PLAYERPAIN5,     260,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("SWYELL03.VOC",  DIGI_PLAYERYELL1,     261,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL05.VOC",  DIGI_PLAYERYELL2,     262,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL06.VOC",  DIGI_PLAYERYELL3,     263,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("GRUNT06.VOC",   DIGI_SEARCHWALL,      264,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("NOWAY1.VOC",    DIGI_NOURINAL,        265,      PRI_PLAYERVOICE,    0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("SWDIE02.VOC",   DIGI_FALLSCREAM,      266,      PRI_PLAYERDEATH, -100, 100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AHSO5.VOC",     DIGI_GOTITEM1,        267,      PRI_PLAYERDEATH,    0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("",              DIGI_LASTPLAYERVOICE, 268,      0,                  0,   0, 0, DIST_NORMAL, VF_NORMAL)

//#ifndef SW_SHAREWARE
// was RAILB10.VOC
DIGI_ENTRY("HSHOT1.VOC",    DIGI_RAILFIRE,        269,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_NORMAL)
//#else
//DIGI_ENTRY("NULL.VOC",      DIGI_NULL_RAILFIRE,   269,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_NORMAL  )
//#endif
DIGI_ENTRY("RAIL2.VOC",     DIGI_RAILREADY,       270,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("RAILUP09.VOC",  DIGI_RAILPWRUP,       271,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("HBOMB2.VOC",    DIGI_NUCLEAREXP,      272,      PRI_MAX,              0,   0, 0, DIST_LEVELWIDE, VF_NORMAL)
DIGI_ENTRY("STANDBY.VOC",   DIGI_NUKESTDBY,       273,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CDOWN.VOC",     DIGI_NUKECDOWN,       274,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SYSREAD.VOC",   DIGI_NUKEREADY,       275,      PRI_HI_PLAYERWEAP,    0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("HISS1.VOC",     DIGI_CHEMGAS,         276,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("CHBNCE1.VOC",   DIGI_CHEMBOUNCE,      277,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("THROW.VOC",     DIGI_THROW,           278,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PULL.VOC",      DIGI_PULL,            279,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("STSCAN2.VOC",   DIGI_MINEARM,         280,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HBDOWN1.VOC",   DIGI_HEARTDOWN,       281,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
//DIGI_ENTRY("TOOLUSE1.VOC",  DIGI_TOOLBOX,         282,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("NULL.VOC",      DIGI_NULL_TOOLBOX,    282,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GASPOP.VOC",    DIGI_GASPOP,          283,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("40MMBNCE.VOC",  DIGI_40MMBNCE,        284,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BURGALRM.VOC",  DIGI_BURGLARALARM,    285,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("CARALRM2.VOC",  DIGI_CARALARM,        286,      PRI_LOW_PLAYERWEAP,   0,   0, 0, 25000, VF_NORMAL)
DIGI_ENTRY("CAOFF1.VOC",    DIGI_CARALARMOFF,     287,      PRI_LOW_PLAYERWEAP,   0,   0, 0, 25000, VF_NORMAL)
DIGI_ENTRY("TACK1.VOC",     DIGI_CALTROPS,        288,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NVON3.VOC",     DIGI_NIGHTON,         289,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NVOFF2.VOC",    DIGI_NIGHTOFF,        290,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SGSH01.VOC",    DIGI_SHOTSHELLSPENT,  291,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SKID3.VOC",     DIGI_BUSSKID,         292,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CRASH4.VOC",    DIGI_BUSCRASH,        293,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BUS1.VOC",      DIGI_BUSENGINE,       294,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BIMP01.VOC",    DIGI_ARMORHIT,        295,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("ASIREN1.VOC",   DIGI_ASIREN1,         296,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("FIRETRK1.VOC",  DIGI_FIRETRK1,        297,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAFFIC1.VOC",  DIGI_TRAFFIC1,        298,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAFFIC2.VOC",  DIGI_TRAFFIC2,        299,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAFFIC3.VOC",  DIGI_TRAFFIC3,        300,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAFFIC4.VOC",  DIGI_TRAFFIC4,        301,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAFFIC5.VOC",  DIGI_TRAFFIC5,        302,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAFFIC6.VOC",  DIGI_TRAFFIC6,        303,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HELI1.VOC",     DIGI_HELI1,           304,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JET1.VOC",      DIGI_JET1,            305,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MOTO1.VOC",     DIGI_MOTO1,           306,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MOTO2.VOC",     DIGI_MOTO2,           307,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NEON1.VOC",     DIGI_NEON1,           308,      PRI_AMBIENT,        0,      0, 0, -8000, VF_NORMAL)
DIGI_ENTRY("SUBWAY1.VOC",   DIGI_SUBWAY,          309,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAINS01.VOC",  DIGI_TRAIN1,          310,      PRI_PLAYERDEATH,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("COIN.VOC",      DIGI_COINS,           311,      PRI_LOW_PLAYERWEAP,   0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWRDSMK1.VOC",  DIGI_SWORDCLANK,      312,      PRI_HI_PLAYERWEAP,    -200,   200, 0, DIST_NORMAL, VF_NORMAL)
// RIPPER2
DIGI_ENTRY("RIP2AMB.VOC",    DIGI_RIPPER2AMBIENT, 313,      PRI_NPCAMBIENT,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIP2ALRT.VOC",   DIGI_RIPPER2ALERT,   314,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIP2ATCK.VOC",   DIGI_RIPPER2ATTACK,  315,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIP2PAIN.VOC",   DIGI_RIPPER2PAIN,    316,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIP2SCRM.VOC",   DIGI_RIPPER2SCREAM,  317,      PRI_NPCDEATH,     -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIP2HRT.VOC",    DIGI_RIPPER2HEARTOUT,318,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("M60.VOC",        DIGI_M60,            319,      PRI_NPCATTACK,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// SUMO
DIGI_ENTRY("SUMSCRM.VOC",   DIGI_SUMOSCREAM,      320,      PRI_MAX,         -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SUMALRT.VOC",   DIGI_SUMOALERT,       321,      PRI_NPCATTACK,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SUMAMB.VOC",    DIGI_SUMOAMBIENT,     322,      PRI_NPCAMBIENT,  -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SUMPAIN.VOC",   DIGI_SUMOPAIN,        323,      PRI_NPCATTACK,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)

// UNLOCK RAM LOCKED DOOR
DIGI_ENTRY("RAMLOCK.VOC",   DIGI_RAMUNLOCK,       324,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
// UNLOCK CARD LOCKED DOOR
DIGI_ENTRY("CARDLOCK.VOC",  DIGI_CARDUNLOCK,      325,      PRI_ENVIRONMENT,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// More player voices
DIGI_ENTRY("ACS10.VOC",     DIGI_ANCIENTSECRET,   326,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AMDRIV01.VOC",  DIGI_AMERICANDRIVER,  327,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BABOON03.VOC",  DIGI_DRIVELIKEBABOON, 328,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BBURN04.VOC",   DIGI_BURNBABY,        329,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BIGWPN01.VOC",  DIGI_LIKEBIGWEAPONS,  330,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CBUNG01.VOC",   DIGI_COWABUNGA,       331,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CHARAD09.VOC",  DIGI_NOCHARADE,       332,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("DTIME.VOC",     DIGI_TIMETODIE,       333,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("EAT02.VOC",     DIGI_EATTHIS,         334,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("FCRACK01.VOC",  DIGI_FIRECRACKERUPASS,335,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HCOW03.VOC",    DIGI_HOLYCOW,         336,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HCOW06.VOC",    DIGI_HOLYPEICESOFCOW, 337,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HSHIT03.VOC",   DIGI_HOLYSHIT,        338,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HSHIT04.VOC",   DIGI_HOLYPEICESOFSHIT,339,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("IHOPE01.VOC",   DIGI_PAYINGATTENTION, 340,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ILIKE01.VOC",   DIGI_EVERYBODYDEAD,   341,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("KUNGFU06.VOC",  DIGI_KUNGFU,          342,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LMOVE01.VOC",   DIGI_HOWYOULIKEMOVE,  343,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LWANG05.VOC",   DIGI_NOMESSWITHWANG,  344,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RAW01.VOC",     DIGI_RAWREVENGE,      345,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("STUPID01.VOC",  DIGI_YOULOOKSTUPID,   346,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TDICK02.VOC",   DIGI_TINYDICK,        347,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TOURN01.VOC",   DIGI_NOTOURNAMENT,    348,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("WWANG11.VOC",   DIGI_WHOWANTSWANG,    349,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("YAK02.VOC",     DIGI_MOVELIKEYAK,     350,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("REFLEX08.VOC",  DIGI_ALLINREFLEXES,   351,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("EVADE01.VOC",   DIGI_EVADEFOREVER,    352,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MFLY03.VOC",    DIGI_MRFLY,           353,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SHISEI03.VOC",  DIGI_SHISEISI,        354,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("FWORKS01.VOC",  DIGI_LIKEFIREWORKS,   355,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HIRO03.VOC",    DIGI_LIKEHIROSHIMA,   356,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NAGA06.VOC",    DIGI_LIKENAGASAKI,    357,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PEARL03.VOC",   DIGI_LIKEPEARL,       358,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("IAM01.VOC",     DIGI_IAMSHADOW,       359,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LIKNUK01.VOC",  DIGI_ILIKENUKES,      360,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LIKSRD01.VOC",  DIGI_ILIKESWORD,      361,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LIKSHK02.VOC",  DIGI_ILIKESHURIKEN,   362,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LUCK06.VOC",    DIGI_BADLUCK,         363,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MCHAN01.VOC",   DIGI_NOMOVIEMRCHAN,   364,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RCHAN13.VOC",   DIGI_REALLIFEMRCHAN,  365,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MUSIC03.VOC",   DIGI_NOLIKEMUSIC,     366,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NODIFF07.VOC",  DIGI_NODIFFERENCE,    367,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NOFEAR01.VOC",  DIGI_NOFEAR,          368,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("NOPAIN.VOC",    DIGI_NOPAIN,          369,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("REPMAN15.VOC",  DIGI_NOREPAIRMAN,     370,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SOB15.VOC",     DIGI_SONOFABITCH,     371,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("WEAK03.VOC",    DIGI_PAINFORWEAK,     372,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SPEED04.VOC",   DIGI_GOSPEEDY,        373,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("STIFF01.VOC",   DIGI_GETTINGSTIFF,    374,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TOMB05.VOC",    DIGI_TOMBRAIDER,      375,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSTICK01.VOC",  DIGI_STICKYGOTU1,     376,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSTICK05.VOC",  DIGI_STICKYGOTU2,     377,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSTICK07.VOC",  DIGI_STICKYGOTU3,     378,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSTICK10.VOC",  DIGI_STICKYGOTU4,     379,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSWORD05.VOC",  DIGI_SWORDGOTU1,      380,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSWORD08.VOC",  DIGI_SWORDGOTU2,      381,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TSWORD01.VOC",  DIGI_SWORDGOTU3,      382,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL22.VOC",  DIGI_HURTBAD1,        383,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL14.VOC",  DIGI_HURTBAD2,        384,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL23.VOC",  DIGI_HURTBAD3,        385,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL16.VOC",  DIGI_HURTBAD4,        386,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SWYELL13.VOC",  DIGI_HURTBAD5,        387,      PRI_PLAYERVOICE, -200, 200, 0, DIST_NORMAL, VF_NORMAL)

// TOILETGIRL
DIGI_ENTRY("TGSCRM.VOC",   DIGI_TOILETGIRLSCREAM, 388,      PRI_NPCATTACK,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TGALRT.VOC",   DIGI_TOILETGIRLALERT,  389,      PRI_NPCATTACK,   -300, 300, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TGAMB.VOC",    DIGI_TOILETGIRLAMBIENT,390,      PRI_NPCAMBIENT,  -300, 300, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TGPAIN.VOC",   DIGI_TOILETGIRLPAIN,   391,      PRI_NPCATTACK,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TGTNT1.VOC",   DIGI_TOILETGIRLTAUNT1, 392,      PRI_NPCATTACK,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TGTNT2.VOC",   DIGI_TOILETGIRLTAUNT2, 393,      PRI_NPCATTACK,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)
// MORE SUMO
DIGI_ENTRY("SUMOFART.VOC", DIGI_SUMOFART,         394,      PRI_PLAYERVOICE, -100, 100, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("GIBS04.VOC",   DIGI_GIBS1,            395,      PRI_LOW_PLAYERWEAP,   -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GIBS05.VOC",   DIGI_GIBS2,            396,      PRI_LOW_PLAYERWEAP,   -200, 200, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("BIRDS01.VOC",  DIGI_BIRDS1,           397,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BIRDS02.VOC",  DIGI_BIRDS2,           398,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TOILET01.VOC", DIGI_TOILET,           399,      PRI_AMBIENT,        -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("FLIDLE.VOC",   DIGI_FORKLIFTIDLE,     400,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("FLRUN01.VOC",  DIGI_FORKLIFTRUN,      401,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TOYCAR03.VOC", DIGI_TOYCAR,           402,      PRI_LOW_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("PRESS03.VOC",  DIGI_UZIMATIC,         403,      PRI_AMBIENT,        -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("COMPON01.VOC", DIGI_COMPUTERPOWER,    404,      PRI_LOW_PLAYERWEAP, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TURBON01.VOC", DIGI_GENERATORON,      405,      PRI_LOW_PLAYERWEAP, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TURBRN01.VOC", DIGI_GENERATORRUN,     406,      PRI_HI_PLAYERWEAP,  0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("BIGDRL03.VOC", DIGI_BIGDRILL,         407,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("FLUOR01.VOC",  DIGI_FLUORLIGHT,       408,      PRI_AMBIENT,        -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AMOEBA03.VOC", DIGI_AMOEBA,           409,      PRI_SECTOROBJ,      -200, 200, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("BODY6.VOC",    DIGI_BODYFALL2,        410,      PRI_PLAYERDEATH,    -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("GIBS01.VOC",   DIGI_GIBS3,            411,      PRI_LOW_PLAYERWEAP, -200, 200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("CHOK01.VOC",   DIGI_NINJACHOKE,       412,      PRI_NPCDEATH,       -200, 200, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("TRAIN3.VOC",   DIGI_TRAIN3,           413,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAINR02.VOC", DIGI_TRAINR02,         414,      PRI_PLAYERDEATH,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TRAIN8.VOC",   DIGI_TRAIN8,           415,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TCLID01.VOC",  DIGI_TRASHLID,         416,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_NORMAL)

// player voices
DIGI_ENTRY("ACCU01.VOC",   DIGI_GETMEDKIT,        417,      PRI_PLAYERVOICE,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("AHH03.VOC",    DIGI_AHH,              418,      PRI_PLAYERVOICE,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

// Pachinko
DIGI_ENTRY("PALARM1.VOC",  DIGI_PALARM,           419,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PFLIP4.VOC",   DIGI_PFLIP,            420,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PROLL1.VOC",   DIGI_PROLL1,           421,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PROLL2.VOC",   DIGI_PROLL2,           422,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("PROLL3.VOC",   DIGI_PROLL3,           423,      PRI_SECTOROBJ,      0,      0, 0, DIST_NORMAL, VF_NORMAL)

// BUNNY
DIGI_ENTRY("RABATK1.VOC",  DIGI_BUNNYATTACK,      424,      PRI_NPCATTACK,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RABDIE1.VOC",  DIGI_BUNNYDIE1,        425,      PRI_NPCDEATH,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RABDIE2.VOC",  DIGI_BUNNYDIE2,        426,      PRI_NPCDEATH,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RABDIE3.VOC",  DIGI_BUNNYDIE3,        427,      PRI_NPCDEATH,    -100,     100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RABAMB.VOC",   DIGI_BUNNYAMBIENT,     428,      PRI_NPCAMBIENT,  -100,     100, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("STONE2.VOC",   DIGI_STONESLIDE,       429,      PRI_AMBIENT,        0,       0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("NINCUT3.VOC",  DIGI_NINJAINHALF,      430,      PRI_NPCDEATH,    -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("RIPCHST1.VOC", DIGI_RIPPER2CHEST,     431,      PRI_NPCATTACK,   -100,     100, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("WHIPIN2.VOC",  DIGI_WHIPME,           432,      PRI_AMBIENT,        0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("ENDLEV3.VOC",  DIGI_ENDLEV,           433,      PRI_PLAYERVOICE,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MDALARM1.VOC", DIGI_MDALARM,          434,      PRI_PLAYERDEATH,    0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("METALBRK.VOC", DIGI_BREAKMETAL,       435,      PRI_AMBIENT,     -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("DEBRIBRK.VOC", DIGI_BREAKDEBRIS,      436,      PRI_AMBIENT,     -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MARBELS.VOC",  DIGI_BREAKMARBELS,     437,      PRI_AMBIENT,     -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BANZAI1.VOC",  DIGI_BANZAI,           438,      PRI_PLAYERDEATH,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HAHA19.VOC",   DIGI_HAHA1,            439,      PRI_PLAYERDEATH,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HAHA11.VOC",   DIGI_HAHA2,            440,      PRI_PLAYERDEATH,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("HAHA15.VOC",   DIGI_HAHA3,            441,      PRI_PLAYERDEATH,    0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TELEPT02.VOC", DIGI_ITEM_SPAWN,       442,      PRI_ITEM,           0,      0, 0, DIST_NORMAL, VF_NORMAL)

// More Player Voices
DIGI_ENTRY("JG1075.VOC",   DIGI_NOREPAIRMAN2,     443,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG1082.VOC",   DIGI_NOPOWER,          444,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG1087.VOC",   DIGI_DOUBLEUZI,        445,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG1088.VOC",   DIGI_NOTORDBUNNY,      446,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG1103.VOC",   DIGI_CANBEONLYONE,     447,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2000.VOC",   DIGI_MIRROR1,          448,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2005.VOC",   DIGI_MIRROR2,          449,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2020.VOC",   DIGI_HITTINGWALLS,     450,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2032.VOC",   DIGI_GOTRAILGUN,       451,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2053.VOC",   DIGI_RABBITHUMP1,      452,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2054.VOC",   DIGI_RABBITHUMP2,      453,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2045.VOC",   DIGI_RABBITHUMP3,      454,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2087.VOC",   DIGI_RABBITHUMP4,      455,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2074.VOC",   DIGI_FAGRABBIT1,       456,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2075.VOC",   DIGI_FAGRABBIT2,       457,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2078.VOC",   DIGI_FAGRABBIT3,       458,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG3005.VOC",   DIGI_STINKLIKEBABBOON, 459,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG3017.VOC",   DIGI_WHATYOUEATBABY,   460,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG3047.VOC",   DIGI_WHATDIEDUPTHERE,  461,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG3022.VOC",   DIGI_YOUGOPOOPOO,      462,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG6053.VOC",   DIGI_PULLMYFINGER,     463,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG3059.VOC",   DIGI_SOAPYOUGOOD,      464,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG4012.VOC",   DIGI_WASHWANG,         465,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG3070.VOC",   DIGI_DROPSOAP,         466,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG6051.VOC",   DIGI_REALTITS,         467,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG4002.VOC",   DIGI_MSTRLEEP,         468,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG4024.VOC",   DIGI_SEEKLEEPADVICE,   469,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG5042.VOC",   DIGI_AVENGELEEPDEATH,  470,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG5049A.VOC",  DIGI_LEEPGHOST,        471,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("WDOOR02.VOC",  DIGI_DOOR1,            472,      PRI_SECTOROBJ,   -200, 200, 0, 8000, VF_NORMAL)
DIGI_ENTRY("MDOOR03.VOC",  DIGI_DOOR2,            473,      PRI_SECTOROBJ,   -200, 200, 0, 8000, VF_NORMAL)
DIGI_ENTRY("603981_1.VOC", DIGI_DOOR3,            474,      PRI_SECTOROBJ,   -200, 200, 0, 8000, VF_NORMAL)
DIGI_ENTRY("FLAG03.VOC",   DIGI_FLAGWAVE,         475,      PRI_SECTOROBJ,      0,   0, 0, DIST_NORMAL, VF_LOOP)

DIGI_ENTRY("JG7009.VOC",   DIGI_SURFACE,          476,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG7001.VOC",   DIGI_GASHURT,          477,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG2001.VOC",   DIGI_BONUS_GRAB,       478,      PRI_PLAYERVOICE,    0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("ACHCRY04.VOC", DIGI_ANIMECRY,         479,      PRI_SECTOROBJ,      0,   0, 0, -8000, VF_LOOP)
DIGI_ENTRY("ACHS010.VOC",  DIGI_ANIMESING1,       480,      PRI_SECTOROBJ,      0,   0, 0, -8000, VF_NORMAL)
DIGI_ENTRY("ACHT1006.VOC", DIGI_ANIMEMAD1,        481,      PRI_SECTOROBJ,      0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ACHS016.VOC",  DIGI_ANIMESING2,       482,      PRI_SECTOROBJ,      0,   0, 0, -8000, VF_NORMAL)
DIGI_ENTRY("ACHT120A.VOC", DIGI_ANIMEMAD2,        483,      PRI_SECTOROBJ,      0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("TELEPT02.VOC", DIGI_PLAYER_TELEPORT,  484,      PRI_LOW_PLAYERWEAP, 0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SLASH1.VOC",   DIGI_INTRO_SLASH,      485,      PRI_PLAYERVOICE,    0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("WARNING.VOC",  DIGI_WARNING,          486,      PRI_HI_PLAYERWEAP,  0,   0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("WHIRL1.VOC",   DIGI_INTRO_WHIRL,      487,      PRI_HI_PLAYERWEAP,  0,   0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("ACHF1003.VOC", DIGI_TOILETGIRLFART1,  488,      PRI_NPCAMBIENT,  -300, 300, 0, -16000, VF_NORMAL)
DIGI_ENTRY("ACHF1002.VOC", DIGI_TOILETGIRLFART2,  489,      PRI_NPCAMBIENT,  -300, 300, 0, -16000, VF_NORMAL)
DIGI_ENTRY("ACHF1016.VOC", DIGI_TOILETGIRLFART3,  490,      PRI_NPCAMBIENT,  -300, 300, 0, -16000, VF_NORMAL)

DIGI_ENTRY("CHIMES4.VOC",  DIGI_WINDCHIMES,       491,      PRI_SECTOROBJ,      0,   0, 0, -8000, VF_LOOP)

// Yet more LoWang voices
DIGI_ENTRY("JGB023.VOC",   DIGI_MADATCARPET,      492,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB020.VOC",   DIGI_JUMPONCARPET,     493,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB080.VOC",   DIGI_USEBROKENVEHICLE, 494,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB106.VOC",   DIGI_STEPONCALTROPS,   495,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB130.VOC",   DIGI_WANGSEESERP,      496,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGSB4.VOC",    DIGI_SERPTAUNTWANG,    497,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB166.VOC",   DIGI_WANGTAUNTSERP1,   498,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB156.VOC",   DIGI_WANGTAUNTSERP2,   499,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB193.VOC",   DIGI_WANGORDER1,       500,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB202.VOC",   DIGI_WANGORDER2,       501,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JGB340A.VOC",  DIGI_WANGDROWNING,     502,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("JGEN06.VOC",   DIGI_ZILLAREGARDS,     503,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("MSG9.VOC",     DIGI_PMESSAGE,         504,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("UGLY1A.VOC",   DIGI_SHAREND_UGLY1,    505,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("UGLY1B.VOC",   DIGI_SHAREND_UGLY2,    506,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("TELEPT07.VOC", DIGI_SHAREND_TELEPORT, 507,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("GOROSW1.VOC",  DIGI_HOTHEADSWITCH,    508,      PRI_HI_PLAYERWEAP, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BTCREAK2.VOC", DIGI_BOATCREAK,        509,      PRI_AMBIENT,     0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("BTRUN05.VOC",  DIGI_BOATRUN2,         510,      PRI_SECTOROBJ,   0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("BTIDLE4.VOC",  DIGI_BOATIDLE,         511,      PRI_SECTOROBJ,   0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("SHIPBELL.VOC", DIGI_SHIPBELL,         512,      PRI_AMBIENT,   0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("SHIPHRN1.VOC", DIGI_FOGHORN,          513,      PRI_AMBIENT,   0,      0, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("EXP3.VOC",     DIGI_CANNON,           514,      PRI_HI_PLAYERWEAP,    0,      0, 0, DIST_WIDE, VF_NORMAL)

// Yet even more player voices!
DIGI_ENTRY("JG41001.VOC",  DIGI_JG41001,          515,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41012.VOC",  DIGI_JG41012,          516,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41018.VOC",  DIGI_JG41018,          517,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41028.VOC",  DIGI_JG41028,          518,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41048.VOC",  DIGI_JG41048,          519,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41052.VOC",  DIGI_JG41052,          520,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41058.VOC",  DIGI_JG41058,          521,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41060.VOC",  DIGI_JG41060,          522,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG41075.VOC",  DIGI_JG41075,          523,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42004.VOC",  DIGI_JG42004,          524,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42019.VOC",  DIGI_JG42019,          525,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42021.VOC",  DIGI_JG42021,          526,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42028.VOC",  DIGI_JG42028,          527,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42033.VOC",  DIGI_JG42033,          528,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42034.VOC",  DIGI_JG42034,          529,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42050.VOC",  DIGI_JG42050,          530,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42056.VOC",  DIGI_JG42056,          531,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG42061.VOC",  DIGI_JG42061,          532,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG43004.VOC",  DIGI_JG43004,          533,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG43015.VOC",  DIGI_JG43015,          534,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG43019.VOC",  DIGI_JG43019,          535,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG43021.VOC",  DIGI_JG43021,          536,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44011.VOC",  DIGI_JG44011,          537,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44014.VOC",  DIGI_JG44014,          538,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44027.VOC",  DIGI_JG44027,          539,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44038.VOC",  DIGI_JG44038,          540,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44039.VOC",  DIGI_JG44039,          541,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44048.VOC",  DIGI_JG44048,          542,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44052.VOC",  DIGI_JG44052,          543,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45014.VOC",  DIGI_JG45014,          544,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG44068.VOC",  DIGI_JG44068,          545,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45010.VOC",  DIGI_JG45010,          546,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45018.VOC",  DIGI_JG45018,          547,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45030.VOC",  DIGI_JG45030,          548,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45033.VOC",  DIGI_JG45033,          549,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45043.VOC",  DIGI_JG45043,          550,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45053.VOC",  DIGI_JG45053,          551,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG45067.VOC",  DIGI_JG45067,          552,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG46005.VOC",  DIGI_JG46005,          553,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG46010.VOC",  DIGI_JG46010,          554,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

// And the girls talk back to Wang
// Car Girl
DIGI_ENTRY("LANI049.VOC", DIGI_LANI049,           555,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI051.VOC", DIGI_LANI051,           556,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI052.VOC", DIGI_LANI052,           557,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI054.VOC", DIGI_LANI054,           558,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)

// Sailor Moon
DIGI_ENTRY("LANI060.VOC", DIGI_LANI060,           559,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI063.VOC", DIGI_LANI063,           560,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI065.VOC", DIGI_LANI065,           561,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI066.VOC", DIGI_LANI066,           562,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)

// Mechanic
DIGI_ENTRY("LANI073.VOC", DIGI_LANI073,           563,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI075.VOC", DIGI_LANI075,           564,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI077.VOC", DIGI_LANI077,           565,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI079.VOC", DIGI_LANI079,           566,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)

// Prune
DIGI_ENTRY("LANI089.VOC", DIGI_LANI089,           567,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI091.VOC", DIGI_LANI091,           568,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI093.VOC", DIGI_LANI093,           569,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("LANI095.VOC", DIGI_LANI095,           570,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)

DIGI_ENTRY("AD5.VOC",     DIGI_VENTWALK,          571,      PRI_ENVIRONMENT, -300,     300, 0, 8000, VF_NORMAL)
DIGI_ENTRY("AD6.VOC",     DIGI_CARWALK,           572,      PRI_ENVIRONMENT, -300,     300, 0, 8000, VF_NORMAL)
DIGI_ENTRY("JET05.VOC",   DIGI_JETSOAR,           573,      PRI_SECTOROBJ,   -100,     100, 0, 8000, VF_NORMAL)
DIGI_ENTRY("VC04.VOC",    DIGI_VACUUM,            574,      PRI_SECTOROBJ,   -100,     100, 0, DIST_NORMAL, VF_LOOP)

// GIRL NINJA
DIGI_ENTRY("LANI017.VOC", DIGI_GIRLNINJAALERTT,   575,      PRI_NPCATTACK,   -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LANI033.VOC", DIGI_GIRLNINJASCREAM,   576,      PRI_NPCDEATH,    -200,    200, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("LANI001.VOC", DIGI_GIRLNINJAALERT,    577,      PRI_NPCATTACK,   -200,    200, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("CACKLE.VOC",  DIGI_PRUNECACKLE,       578,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("CACKLE2.VOC", DIGI_PRUNECACKLE2,      579,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)
DIGI_ENTRY("CACKLE3.VOC", DIGI_PRUNECACKLE3,      580,      PRI_NPCAMBIENT,  -200, 200, 0, -16000, VF_NORMAL)

DIGI_ENTRY("SUMO058.VOC", DIGI_SUMOSTOMP,         581,      PRI_NPCATTACK,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ELEV01.VOC",  DIGI_VATOR,             582,      PRI_SECTOROBJ,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)

DIGI_ENTRY("JG9009.VOC",  DIGI_JG9009,            583,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z16004.VOC",  DIGI_Z16004,            584,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z16012.VOC",  DIGI_Z16012,            585,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z16022.VOC",  DIGI_Z16022,            586,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z16027.VOC",  DIGI_Z16027,            587,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG93030.VOC", DIGI_JG93030,           588,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG94002.VOC", DIGI_JG94002,           589,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z17010.VOC",  DIGI_Z17010,            590,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z17052.VOC",  DIGI_Z17052,            591,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z17025.VOC",  DIGI_Z17025,            592,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ML25014.VOC", DIGI_ML25014,           593,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ML250101.VOC",DIGI_ML250101,          594,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG9022.VOC",  DIGI_JG9022,            595,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG9032.VOC",  DIGI_JG9032,            596,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG9038.VOC",  DIGI_JG9038,            597,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG9055.VOC",  DIGI_JG9055,            598,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG9060.VOC",  DIGI_JG9060,            599,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG92055.VOC", DIGI_JG92055,           600,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ML25032.VOC", DIGI_ML25032,           601,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG92036.VOC", DIGI_JG92036,           602,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG92042.VOC", DIGI_JG92042,           603,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ML26001.VOC", DIGI_ML26001,           604,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG93000.VOC", DIGI_JG93000,           605,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG93011.VOC", DIGI_JG93011,           606,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG93018.VOC", DIGI_JG93018,           607,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG93023.VOC", DIGI_JG93023,           608,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ML26008.VOC", DIGI_ML26008,           609,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ML26011.VOC", DIGI_ML26011,           610,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG94007.VOC", DIGI_JG94007,           611,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG94024.VOC", DIGI_JG94024,           612,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG94039.VOC", DIGI_JG94039,           613,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("JG95012.VOC", DIGI_JG95012,           614,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZWALK5.VOC",  DIGI_ZILLASTOMP,        615,      PRI_NPCATTACK,   -100, 100, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC1.VOC",     DIGI_ZC1,               616,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC2.VOC",     DIGI_ZC2,               617,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC3.VOC",     DIGI_ZC3,               618,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC4.VOC",     DIGI_ZC4,               619,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC5.VOC",     DIGI_ZC5,               620,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC6.VOC",     DIGI_ZC6,               621,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC7.VOC",     DIGI_ZC7,               622,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_LOOP)
DIGI_ENTRY("ZC8.VOC",     DIGI_ZC8,               623,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("ZC9.VOC",     DIGI_ZC9,               624,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)
DIGI_ENTRY("Z16043.VOC",  DIGI_Z16043,            625,      PRI_PLAYERVOICE, 0,      0, 0, DIST_NORMAL, VF_NORMAL)

#undef DIGI_ENTRY
