/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *
 * Modify: 2013/03/19  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * WMCONFIG.H
 *
 * Configuration things for the WM configurator
 */

#ifndef _WMCONFIG_H
#define _WMCONFIG_H

/* where the system wide configuration resides
#ifndef DEFAULT_SYS_CONFDIR
#define DEFAULT_SYS_CONFDIR	"/etc/X11/wmconfig"
#endif DEFAULT_SYS_CONFDIR */

/* Commented out - read the directory from sysconfdir */

/*
 * where the user configuration files are kept
 * Note: this is relative to the user's home directory !
 */
#ifndef DEFAULT_USER_CONFDIR
#define DEFAULT_USER_CONFDIR	".wmconfig"
#endif /* DEFAULT_USER_CONFDIR */

/*
 * How the root menu is called...
 */
#ifndef DEFAULT_ROOT_NAME
#define DEFAULT_ROOT_NAME	"Wmconfig"
#endif /* DEFAULT_ROOT_NAME */

/*
 * Where start menu directories generate
 */
#ifndef DEFAULT_OUTPUTDIR
#define DEFAULT_OUTPUTDIR "wmconfig"
#endif /* DEFAULT_OUTPUTDIR */

/* Maximum items per group */
#define MAX_GROUPITEMS		200

/*
 * maximum packages we want to read (well, it sizes itself
 * dinamically if we have more, but we have to start with...)
 */
#define MAX_PACKAGES		1024

/* Some flags to alter the behavior... */
#define		FLAG_NO_ICONS			(1 << 0) /* don't use icons either */
#define		FLAG_NO_MINI_ICONS		(1 << 1) /* don't use mini-icons */
#define		FLAG_DIRECTORIES		(1 << 2) /* create a directory structure */
#define		FLAG_PROMOTE			(1 << 3) /* promote apps from menus with only one entry */
#define		FLAG_NO_SYSDIR			(1 << 4) /* don't parse the files from the system directory */
#define		FLAG_NO_USERDIR			(1 << 5) /* don't parse the files fromm the user directory */
#define		FLAG_NEWSTYLE_DIRECTORIES	(1 << 6) /* create a directory structure for Afterstep >= 1.5 */
#define		FLAG_OUTPUT_DIR			(1 << 7) /* specify output directory for afterstep menu */
#define		FLAG_NO_CHECK_EXISTENCE		(1 << 8) /* check existence of programs */

/*  Macros to use with the above FLAGS... */
#define	is_set(X)	(flags & FLAG_##X)

#include "prototypes.h"
#include "package.h"
#include "parse.h"
#include "config.h"

#if ENABLE_NLS
#include <libintl.h>
#else
#define gettext(Msgid) ((const char *) (Msgid))
#define textdomain(Domainname) ((const char *) (Domainname))
#define bindtextdomain(Domainname, Dirname) ((const char *) (Dirname))
#endif

#endif /* _WMCONFIG_H */
