/*
 * Copyright (C) 2002-2015 Tommy Scheunemann
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <strings.h>

/*
 Output function for twm, required by wmconfig.c
*/

void output_twm(struct group *root,const char *use_term, const int twm_type)
{
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }

    /* create entry for the root menu */
    switch (twm_type) {
	case 2:
	    /* Menu entry for Piewm */
	    printf("piemenu \"%s\" {\n", root->name);
	break;
	case 3:
	    /* Menu entry for Ctwm with support for pin-able menus */
	    printf("menu \"%s\"\n{\n \"%s\" f.title\n", root->name, root->name);
	    printf(" \"Pin menu\" f.pin\n \"\" f.nop\n");
	break;
	default:
	    /* Menu entry for other TWM like WM's */
	    printf("menu \"%s\"\n{\n \"%s\" f.title\n", root->name, root->name);
    }

    item = root->items;

    /* read the complete input data and create menus */
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;
	    tmp = (struct group *)item->data;

	    switch (twm_type) {
		case '2':
		    /* Menu entry for Piewm */
		    printf(" \"%s\" f.piemenu \"%s\"\n", tmp->name, tmp->name);
		break;
		default:
		    /* Menu entry for other TWM like WM's */
		    printf(" \"%s\" f.menu \"%s\"\n", tmp->name, tmp->name);
	    }
	}
	item++;
    }
    item = root->items;

    /* this will read the input data and creates the application entries */
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;

	    /* Check if we want to restart, quit, start another WM */
	    if (app->restart) {
		if (strncasecmp(app->restart, "restart", 7) == 0) {
		    printf(" \"%s\" f.restart\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    printf(" \"%s\" f.quit\n", app->name);
		} else {
		    if (twm_type == 0) {
			printf(" \"%s\" f.startwm \"%s\"\n", app->name, app->exec);
		    }
		}
	    } else {
		/* or create a normal menu entry */
		if (app->name && app->exec && app->terminal) {
		    /* Terminal required */
		    printf(" \"%s\" f.exec \"%s -e %s\"\n", app->name, use_term, app->exec);
		} else {
		    /* Usual menu item */
		    printf (" \"%s\" f.exec \"%s\"\n", app->name, app->exec);
		}
	    }
	}
	item++;
    }

    /* menu / submenu finished */
    printf("}\n\n");
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_twm(item->data, use_term, twm_type);
	}
	item++;
    }
    return;
}
