/*
 * Copyright (C) 2002-2013 Tommy Scheunemann
 *
 * Modify:  2014/12/16  Tommy Scheunemann <net@arrishq.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

extern unsigned int flags;

/* Qvwm output support */

static void qvwm(struct group *root, int level, const char *use_term)
{
    int i;
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	    printf("\"%s\"\n+\n", root->name);
	}
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    qvwm(item->data, level+1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app != NULL) {
		for (i=0; i<level; i++) {
		    printf(" ");
		}
		if (app->restart) {
		    /* restart menu entry */
		    if (strncasecmp(app->restart, "restart", 7) == 0) {
			/* mini-icon check */
			if ((app->mini_icon != NULL) || (!is_set(NO_MINI_ICONS))) {
			    printf(" \"%s\" \"\" QVWM_RESTART\n", app->name);
			} else {
			    printf(" \"%s\" \"%s\" QVWM_RESTART\n", app->name, app->mini_icon);
			}
		    /* quit menu entry */
		    } else if (strncasecmp(app->restart, "quit", 4) == 0) {
			if ((app->mini_icon != NULL) || (!is_set(NO_MINI_ICONS))) {
			    printf(" \"%s\" QVWM_EXIT\n", app->name);
			} else {
			    printf(" \"%s\" \"%s\" QVWM_EXIT\n", app->name, app->mini_icon);
			}
		    }
		} else {
		    if (app->terminal) {
			if ((app->mini_icon != NULL) || (!is_set(NO_MINI_ICONS))) {
			    printf(" \"%s\" \"\" \"%s -e %s\"\n", app->name, use_term, app->exec);
			} else {
			    printf(" \"%s\" \"%s\" \"%s -e %s\"\n", app->name, app->mini_icon, use_term, app->exec);
			}
		    } else {
			if ((app->mini_icon != NULL) || (!is_set(NO_MINI_ICONS))) {
			    printf(" \"%s\" \"\" \"%s\"\n", app->name, app->exec);
			} else {
			    printf(" \"%s\" \"%s\" \"%s\"\n", app->name, app->mini_icon, app->exec);
			}
		    }
		}
	    }
	}
	item++;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("-\n");
    }
}
void output_qvwm(struct group *root, const char *use_term)
{
    qvwm(root, 0, use_term);
}
