/*
 * Copyright (C) 1997-2000 Red Hat, Inc.
 *	Cristian Gafton <gafton@redhat.com>
 *
 * Modify:  2012/12/18 Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing a DEBUG configuration
 */

#include <stdio.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#define print_line(string, element) { 					\
    for (i=0; i<tab_level; i++) {					\
         printf("|");							\
         printf("  ");							\
    }									\
    printf("%s: %s\n", string, app->element?app->element:"");		\
}

/*
 * Here are coming the debugging functions	
 */
static void print_app(struct package *app, int tab_level)
{
    int i;

    if (app == (struct package *)NULL) {
	return;
    }

    print_line("+-package   ", __package);
    print_line("|  group    ", group);
    print_line("|  name     ", name);
    print_line("|  icon     ", icon);
    print_line("|  mini_icon", mini_icon);
    print_line("|  exec     ", exec);
    print_line("|  desc     ", description);
    print_line("|  Xresource", Xresource);
    print_line("|  copy     ", copy);
    print_line("|  mimetype ", mimetype);
    print_line("|  terminal ", terminal);
    print_line("|  restart  ", restart);
}

static void debug(struct group *root, int level)
{
    int i;
    struct item *item;

    if (root == (struct group *)NULL) {
	return;
    }

    for (i=0; i<level; i++) {
	printf("|");
	printf("  ");
    }

    printf("+-%s:\n", root->name);
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    debug(item->data, level+1);
	} else if (item->type == ITEM_APP) {
	    struct package *app;

	    app = (struct package *)item->data;
	    print_app(app, level+1);
	}
	item++;
    }
}

void output_debug(struct group *root)
{
    debug(root, 0);
}
