/*
 * Copyright (C) 1997-2000 Red Hat, Inc.
 *	Cristian Gafton <gafton@redhat.com>
 *
 * Modify: 2006/24/13	Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing an AFTERSTEP configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <strings.h>

extern unsigned int flags;

/*
 * Outputs on stdout the AFTERSTEP-compatible configuration
 */
void output_afterstep(struct group *root,const char *use_term)
{
    struct item *item;
    int debug_icon = 0;

    if (root == (struct group *)NULL) {
	return;
    }

    /* First pass, recursive output... (Afterstep requires menus to be
     * defined before first use...)
     */
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_afterstep(item->data, use_term);
	}
	item++;
    }

    /* second pass, the icons... */
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;

	    if (!debug_icon) {
		printf("# Icon specification for Apps installed for \"%s\" menu\n", root->name);
		debug_icon++;
	    }
	    app = (struct package *)item->data;
	    if ((app->name && app->icon) && (!is_set(NO_ICONS))) {
		printf("Icon\t\"%s\"\t\"%s\"\n", app->name, app->icon);
	    }
	}
	item++;
    }

    /* third pass - the menu */
    item = root->items;
    printf("Popup\t\"%s\"\n\tTitle\t\"%s\"\n", root->name, root->name);
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;

	    tmp = (struct group *)item->data;
	    printf("\tPopup\t\"%s\"\t%s\n", tmp->name, tmp->name);
	} else if (item->type == ITEM_APP) {
	    struct package *app;

	    app = (struct package *)item->data;
	    if (app->restart) {
		if (strncasecmp(app->restart, "restart", 7) == 0) {
		    printf(" Restart \"%s\" afterstep\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    printf(" Quit \"%s\"\n", app->name);
		} else {
		    printf(" Restart \"%s\" %s\n", app->name, app->exec);
		}
	    } else {
		if (app->name && app->exec) {
		    if (app->terminal) {
			printf("\tExec\t\"%s\"\texec %s -e %s\n", app->name, use_term, app->exec);
		    } else {
			printf("\tExec\t\"%s\"\texec %s\n", app->name, app->exec);
		    }
		}
	    }
	}
	item++;
    }
    printf("EndPopup\n\n");

    return;
}
