/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.io.RepeatableFileInputStream;
import org.jets3t.service.model.BaseS3Object;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.utils.ServiceUtils;

public class S3Object
extends BaseS3Object
implements Cloneable {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$model$S3Object == null ? (class$org$jets3t$service$model$S3Object = S3Object.class$("org.jets3t.service.model.S3Object")) : class$org$jets3t$service$model$S3Object);
    private String key = null;
    private String bucketName = null;
    private transient InputStream dataInputStream = null;
    private AccessControlList acl = null;
    private boolean isMetadataComplete = false;
    private File dataInputFile = null;
    static /* synthetic */ Class class$org$jets3t$service$model$S3Object;

    public S3Object(String key) {
        this.key = key;
    }

    public S3Object() {
    }

    public String toString() {
        return new StringBuffer().append("S3Object [key=").append(this.getKey()).append(",bucket=").append(this.bucketName == null ? "<Unknown>" : this.bucketName).append(",lastModified=").append(this.getLastModifiedDate()).append(", dataInputStream=").append(this.dataInputStream).append("] Metadata=").append(this.getMetadataMap()).toString();
    }

    public InputStream getDataInputStream() throws S3ServiceException {
        if (this.dataInputStream == null && this.dataInputFile != null) {
            try {
                this.dataInputStream = new RepeatableFileInputStream(this.dataInputFile);
            }
            catch (FileNotFoundException e) {
                throw new S3ServiceException("Cannot open file input stream", e);
            }
        }
        return this.dataInputStream;
    }

    public void setDataInputStream(InputStream dataInputStream) {
        this.dataInputFile = null;
        this.dataInputStream = dataInputStream;
    }

    public void closeDataInputStream() throws IOException {
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
    }

    public String getETag() {
        String etag = (String)this.getMetadata("ETag");
        if (etag != null && etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    public void setETag(String etag) {
        this.addMetadata("ETag", etag);
    }

    public Date getLastModifiedDate() {
        Date lastModifiedDate = (Date)this.getMetadata("Last-Modified");
        if (lastModifiedDate == null) {
            lastModifiedDate = (Date)this.getMetadata("Date");
        }
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.addMetadata("Last-Modified", lastModifiedDate);
    }

    public S3Owner getOwner() {
        return (S3Owner)this.getMetadata("Owner");
    }

    public void setOwner(S3Owner owner) {
        this.addMetadata("Owner", owner);
    }

    public long getContentLength() {
        Object contentLength = this.getMetadata("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return Long.parseLong(contentLength.toString());
    }

    public void setContentLength(long size) {
        this.addMetadata("Content-Length", String.valueOf(size));
    }

    public void setStorageClass(String storageClass) {
        this.addMetadata("Storage-Class", storageClass);
    }

    public String getContentType() {
        return (String)this.getMetadata("Content-Type");
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMetadataComplete(boolean isMetadataComplete) {
        this.isMetadataComplete = isMetadataComplete;
    }

    public void addMetadata(String name, Object value) {
        block5: {
            try {
                if ("Last-Modified".equals(name) && !(value instanceof Date)) {
                    value = ServiceUtils.parseRfc822Date(value.toString());
                } else if ("Date".equals(name) && !(value instanceof Date)) {
                    value = ServiceUtils.parseRfc822Date(value.toString());
                }
            }
            catch (ParseException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error(new StringBuffer().append("Unable to parse value we expect to be a valid date: ").append(name).append("=").append(value).toString(), e);
            }
        }
        super.addMetadata(name, value);
    }

    public void addAllMetadata(Map metadata) {
        for (Map.Entry entry : metadata.entrySet()) {
            this.addMetadata(entry.getKey().toString(), entry.getValue());
        }
    }

    public Map getModifiableMetadata() {
        HashMap objectMetadata = new HashMap(this.getMetadataMap());
        objectMetadata.remove("Content-Length");
        objectMetadata.remove("Date");
        objectMetadata.remove("ETag");
        objectMetadata.remove("Last-Modified");
        objectMetadata.remove("Owner");
        objectMetadata.remove("id-2");
        objectMetadata.remove("request-id");
        return objectMetadata;
    }

    public Object clone() {
        S3Object clone = new S3Object(this.key);
        clone.bucketName = this.bucketName;
        clone.dataInputStream = this.dataInputStream;
        clone.acl = this.acl;
        clone.isMetadataComplete = this.isMetadataComplete;
        clone.dataInputFile = this.dataInputFile;
        clone.addAllMetadata(this.getMetadataMap());
        return clone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

