/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.util.Map;

public class BytesProgressWatcher {
    private boolean isStarted;
    private long bytesToTransfer;
    private long startTimeAllTransfersMS;
    private long totalBytesInAllTransfers;
    private long startTimeCurrentTransferMS;
    private long totalBytesInCurrentTransfer;
    private long endTimeCurrentTransferMS;
    private Map historyOfBytesBySecond;
    private long earliestHistorySecond;

    public synchronized void resetWatcher() {
        this.startTimeCurrentTransferMS = System.currentTimeMillis();
        if (this.startTimeAllTransfersMS == -1L) {
            this.startTimeAllTransfersMS = this.startTimeCurrentTransferMS;
        }
        this.endTimeCurrentTransferMS = -1L;
        this.totalBytesInCurrentTransfer = 0L;
        this.isStarted = true;
    }

    public synchronized void updateBytesTransferred(long byteCount) {
        Long currentSecond;
        Long bytesInSecond;
        if (!this.isStarted) {
            this.resetWatcher();
        }
        this.totalBytesInCurrentTransfer += byteCount;
        this.totalBytesInAllTransfers += byteCount;
        if (this.totalBytesInCurrentTransfer >= this.bytesToTransfer) {
            this.endTimeCurrentTransferMS = System.currentTimeMillis();
        }
        if ((bytesInSecond = (Long)this.historyOfBytesBySecond.get(currentSecond = new Long(System.currentTimeMillis() / 1000L))) != null) {
            this.historyOfBytesBySecond.put(currentSecond, new Long(byteCount + bytesInSecond));
        } else {
            this.historyOfBytesBySecond.put(currentSecond, new Long(byteCount));
        }
        if (currentSecond < this.earliestHistorySecond) {
            this.earliestHistorySecond = currentSecond;
        }
        long removeHistoryBeforeSecond = currentSecond - 5L;
        for (long sec = this.earliestHistorySecond; sec < removeHistoryBeforeSecond; ++sec) {
            this.historyOfBytesBySecond.remove(new Long(sec));
        }
        this.earliestHistorySecond = removeHistoryBeforeSecond;
    }
}

