/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.HttpException;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.AWSRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.HttpClientAndConnectionManager;
import org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import org.jets3t.service.model.CreateBucketConfiguration;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class RestS3Service
extends S3Service
implements AWSRequestAuthorizer {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$impl$rest$httpclient$RestS3Service == null ? (class$org$jets3t$service$impl$rest$httpclient$RestS3Service = RestS3Service.class$("org.jets3t.service.impl.rest.httpclient.RestS3Service")) : class$org$jets3t$service$impl$rest$httpclient$RestS3Service);
    protected HttpClient httpClient = null;
    protected HttpConnectionManager connectionManager = null;
    protected CredentialsProvider credentialsProvider = null;
    static /* synthetic */ Class class$org$jets3t$service$impl$rest$httpclient$RestS3Service;

    public RestS3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, (String)null, (CredentialsProvider)null);
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, new HostConfiguration());
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws S3ServiceException {
        super(awsCredentials, invokingApplicationDescription, jets3tProperties);
        this.credentialsProvider = credentialsProvider;
        HttpClientAndConnectionManager initHttpResult = this.initHttpConnection(hostConfig);
        this.httpClient = initHttpResult.getHttpClient();
        this.connectionManager = initHttpResult.getHttpConnectionManager();
        this.setRequesterPaysEnabled(this.jets3tProperties.getBoolProperty("httpclient.requester-pays-buckets-enabled", false));
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient);
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
        }
    }

    protected HttpClientAndConnectionManager initHttpConnection(HostConfiguration hostConfig) {
        return RestUtils.initHttpConnection(this, hostConfig, this.jets3tProperties, this.getInvokingApplicationDescription(), this.credentialsProvider);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected boolean isXmlContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("application/xml".toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRequest(HttpMethodBase httpMethod, int[] expectedResponseCodes) throws S3ServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Performing ").append(httpMethod.getName()).append(" request for '").append(httpMethod.getURI().toString()).append("', expecting response codes: ").append("[").append(ServiceUtils.join(expectedResponseCodes, ",")).append("]").toString());
            }
            boolean completedWithoutRecoverableError = true;
            int internalErrorCount = 0;
            int requestTimeoutErrorCount = 0;
            int redirectCount = 0;
            boolean wasRecentlyRedirected = false;
            int responseCode = -1;
            do {
                if (!wasRecentlyRedirected) {
                    this.authorizeHttpRequest(httpMethod);
                } else {
                    wasRecentlyRedirected = false;
                }
                responseCode = this.httpClient.executeMethod(httpMethod);
                if (responseCode == 307) {
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    httpMethod.setURI(new URI(locationHeader.getValue(), true));
                    completedWithoutRecoverableError = false;
                    wasRecentlyRedirected = true;
                    if (++redirectCount > 5) {
                        throw new S3ServiceException("Exceeded 307 redirect limit (5).");
                    }
                } else if (responseCode == 500 || responseCode == 503) {
                    completedWithoutRecoverableError = false;
                    this.sleepOnInternalError(++internalErrorCount);
                } else {
                    completedWithoutRecoverableError = true;
                }
                String contentType = "";
                if (httpMethod.getResponseHeader("Content-Type") != null) {
                    contentType = httpMethod.getResponseHeader("Content-Type").getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Response for '").append(httpMethod.getPath()).append("'. Content-Type: ").append(contentType).append(", Headers: ").append(Arrays.asList(httpMethod.getResponseHeaders())).toString());
                }
                boolean didReceiveExpectedResponseCode = false;
                for (int i = 0; i < expectedResponseCodes.length && !didReceiveExpectedResponseCode; ++i) {
                    if (responseCode != expectedResponseCodes[i]) continue;
                    didReceiveExpectedResponseCode = true;
                }
                if (didReceiveExpectedResponseCode) continue;
                if (log.isWarnEnabled()) {
                    String requestDescription = new StringBuffer().append(httpMethod.getName()).append(" '").append(httpMethod.getPath()).append("'").append(" -- ResponseCode: ").append(httpMethod.getStatusCode()).append(", ResponseStatus: ").append(httpMethod.getStatusText()).append(", Request Headers: [").append(ServiceUtils.join(httpMethod.getRequestHeaders(), ", ")).append("]").append(", Response Headers: [").append(ServiceUtils.join(httpMethod.getResponseHeaders(), ", ")).append("]").toString();
                    requestDescription = requestDescription.replaceAll("[\\n\\r\\f]", "");
                    log.warn(new StringBuffer().append("Error Response: ").append(requestDescription).toString());
                }
                if (this.isXmlContentType(contentType) && httpMethod.getResponseBodyAsStream() != null && httpMethod.getResponseContentLength() != 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug(new StringBuffer().append("Response '").append(httpMethod.getPath()).append("' - Received error response with XML message").toString());
                    }
                    StringBuffer sb = new StringBuffer();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(new HttpMethodReleaseInputStream(httpMethod)));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            sb.append(new StringBuffer().append(line).append("\n").toString());
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    httpMethod.releaseConnection();
                    S3ServiceException exception = new S3ServiceException("S3 Error Message.", sb.toString());
                    exception.setResponseHeaders(RestUtils.convertHeadersToMap(httpMethod.getResponseHeaders()));
                    if ("RequestTimeout".equals(exception.getS3ErrorCode())) {
                        int retryMaxCount = this.jets3tProperties.getIntProperty("httpclient.retry-max", 5);
                        if (requestTimeoutErrorCount < retryMaxCount) {
                            ++requestTimeoutErrorCount;
                            if (log.isWarnEnabled()) {
                                log.warn(new StringBuffer().append("Retrying connection that failed with RequestTimeout error, attempt number ").append(requestTimeoutErrorCount).append(" of ").append(retryMaxCount).toString());
                            }
                            completedWithoutRecoverableError = false;
                            continue;
                        }
                        if (log.isErrorEnabled()) {
                            log.error(new StringBuffer().append("Exceeded maximum number of retries for RequestTimeout errors: ").append(retryMaxCount).toString());
                        }
                        throw exception;
                    }
                    if ("RequestTimeTooSkewed".equals(exception.getS3ErrorCode())) {
                        this.timeOffset = RestUtils.getAWSTimeAdjustment();
                        if (log.isWarnEnabled()) {
                            log.warn(new StringBuffer().append("Adjusted time offset in response to RequestTimeTooSkewed error. Local machine and S3 server disagree on the time by approximately ").append(this.timeOffset / 1000L).append(" seconds. Retrying connection.").toString());
                        }
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    if (responseCode == 500 || responseCode == 503) continue;
                    if (responseCode == 307) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug(new StringBuffer().append("Following Temporary Redirect to: ").append(httpMethod.getURI().toString()).toString());
                        continue;
                    }
                    throw exception;
                }
                String responseText = null;
                byte[] responseBody = httpMethod.getResponseBody();
                if (responseBody != null && responseBody.length > 0) {
                    responseText = new String(responseBody);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Releasing error response without XML content");
                }
                httpMethod.releaseConnection();
                if (responseCode == 500 || responseCode == 503) continue;
                HttpException httpException = new HttpException(httpMethod.getStatusCode(), httpMethod.getStatusText());
                S3ServiceException exception = new S3ServiceException(new StringBuffer().append("Request Error").append(responseText != null ? new StringBuffer().append(" [").append(responseText).append("].").toString() : ".").toString(), httpException);
                exception.setResponseHeaders(RestUtils.convertHeadersToMap(httpMethod.getResponseHeaders()));
                throw exception;
            } while (!completedWithoutRecoverableError);
            if ((httpMethod.getResponseBodyAsStream() == null || httpMethod.getResponseBodyAsStream().available() == 0) && httpMethod.getResponseContentLength() == 0L) {
                byte[] responseBody;
                if (log.isDebugEnabled()) {
                    log.debug("Releasing response without content");
                }
                if ((responseBody = httpMethod.getResponseBody()) != null && responseBody.length > 0) {
                    throw new S3ServiceException("Oops, too keen to release connection with a non-empty response body");
                }
                httpMethod.releaseConnection();
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Releasing HttpClient connection after error: ").append(t.getMessage()).toString());
            }
            httpMethod.releaseConnection();
            S3ServiceException s3ServiceException = null;
            if (t instanceof S3ServiceException) {
                s3ServiceException = (S3ServiceException)t;
            } else {
                MxDelegate.getInstance().registerS3ServiceExceptionEvent();
                s3ServiceException = new S3ServiceException("Request Error.", t);
            }
            if (!s3ServiceException.isParsedFromXmlMessage() && httpMethod.getResponseHeader("x-amz-request-id") != null && httpMethod.getResponseHeader("x-amz-id-2") != null) {
                s3ServiceException.setS3RequestAndHostIds(httpMethod.getResponseHeader("x-amz-request-id").getValue(), httpMethod.getResponseHeader("x-amz-id-2").getValue());
            }
            s3ServiceException.setRequestVerb(httpMethod.getName());
            s3ServiceException.setRequestPath(httpMethod.getPath());
            try {
                s3ServiceException.setResponseCode(httpMethod.getStatusCode());
                s3ServiceException.setResponseStatus(httpMethod.getStatusText());
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (httpMethod.getRequestHeader("Host") != null) {
                s3ServiceException.setRequestHost(httpMethod.getRequestHeader("Host").getValue());
            }
            if (httpMethod.getResponseHeader("Date") != null) {
                s3ServiceException.setResponseDate(httpMethod.getResponseHeader("Date").getValue());
            }
            if (log.isErrorEnabled()) {
                log.error("Request Failed.", s3ServiceException);
            }
            throw s3ServiceException;
        }
    }

    public void authorizeHttpRequest(HttpMethod httpMethod) throws Exception {
        String queryString;
        String hostname;
        block9: {
            if (this.getAWSCredentials() != null) {
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Adding authorization for AWS Access Key '").append(this.getAWSCredentials().getAccessKey()).append("'.").toString());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Service has no AWS Credential and is un-authenticated, skipping authorization");
                }
                return;
            }
            hostname = null;
            try {
                hostname = httpMethod.getURI().getHost();
            }
            catch (URIException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error("Unable to determine hostname target for request", e);
            }
        }
        String fullUrl = httpMethod.getPath();
        if (!Constants.S3_HOSTNAME.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf(new StringBuffer().append(".").append(Constants.S3_HOSTNAME).toString());
            fullUrl = subdomainOffset > 0 ? new StringBuffer().append("/").append(hostname.substring(0, subdomainOffset)).append(httpMethod.getPath()).toString() : new StringBuffer().append("/").append(hostname).append(httpMethod.getPath()).toString();
        }
        if ((queryString = httpMethod.getQueryString()) != null && queryString.length() > 0) {
            fullUrl = new StringBuffer().append(fullUrl).append("?").append(queryString).toString();
        }
        httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        String canonicalString = RestUtils.makeS3CanonicalString(httpMethod.getName(), fullUrl, this.convertHeadersToMap(httpMethod.getRequestHeaders()), null);
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Canonical string ('|' is a newline): ").append(canonicalString.replace('\n', '|')).toString());
        }
        String signedCanonical = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), canonicalString);
        String authorizationString = new StringBuffer().append("AWS ").append(this.getAWSCredentials().getAccessKey()).append(":").append(signedCanonical).toString();
        httpMethod.setRequestHeader("Authorization", authorizationString);
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map requestParameters) throws S3ServiceException {
        if (requestParameters != null) {
            for (Map.Entry entry : requestParameters.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                urlPath = new StringBuffer().append(urlPath).append(urlPath.indexOf("?") < 0 ? "?" : "&").append(RestUtils.encodeUrlString(key.toString())).toString();
                if (value != null && value.toString().length() > 0) {
                    urlPath = new StringBuffer().append(urlPath).append("=").append(RestUtils.encodeUrlString(value.toString())).toString();
                    if (!log.isDebugEnabled()) continue;
                    log.debug(new StringBuffer().append("Added request parameter: ").append(key).append("=").append(value).toString());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(new StringBuffer().append("Added request parameter without value: ").append(key).toString());
            }
        }
        return urlPath;
    }

    protected void addRequestHeadersToConnection(HttpMethodBase httpMethod, Map requestHeaders) {
        if (requestHeaders != null) {
            for (Map.Entry entry : requestHeaders.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                httpMethod.setRequestHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug(new StringBuffer().append("Added request header to connection: ").append(key).append("=").append(value).toString());
            }
        }
    }

    private Map convertHeadersToMap(Header[] headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; headers != null && i < headers.length; ++i) {
            map.put(headers[i].getName(), headers[i].getValue());
        }
        return map;
    }

    protected void addMetadataToHeaders(HttpMethodBase httpMethod, Map metadata) throws S3ServiceException {
        HashMap headersAlreadySeenMap = new HashMap(metadata.size());
        for (Map.Entry entry : metadata.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || !(value instanceof String)) continue;
            boolean validAscii = false;
            UnsupportedEncodingException encodingException = null;
            try {
                byte[] asciiBytes = key.getBytes("ASCII");
                byte[] utf8Bytes = key.getBytes("UTF-8");
                validAscii = Arrays.equals(asciiBytes, utf8Bytes);
            }
            catch (UnsupportedEncodingException e) {
                encodingException = e;
            }
            if (!validAscii) {
                String message = new StringBuffer().append("User metadata name is incompatible with the S3 REST interface, only ASCII characters are allowed in HTTP headers: ").append(key).toString();
                if (encodingException == null) {
                    throw new S3ServiceException(message);
                }
                throw new S3ServiceException(message, encodingException);
            }
            String duplicateValue = (String)headersAlreadySeenMap.get(key.toLowerCase());
            if (duplicateValue != null && !duplicateValue.equals(value)) {
                throw new S3ServiceException(new StringBuffer().append("HTTP header name occurs multiple times in request with different values, probably due to mismatched capitalization when setting metadata names. Duplicate metadata name: '").append(key).append("', All metadata: ").append(metadata).toString());
            }
            httpMethod.setRequestHeader(key, (String)value);
            headersAlreadySeenMap.put(key.toLowerCase(), value);
        }
    }

    protected void verifyExpectedAndActualETagValues(String expectedETag, S3Object uploadedObject) throws S3ServiceException {
        if (!expectedETag.equals(uploadedObject.getETag())) {
            throw new S3ServiceException(new StringBuffer().append("Mismatch between MD5 hash of uploaded data (").append(expectedETag).append(") and ETag returned by S3 (").append(uploadedObject.getETag()).append(") for object key: ").append(uploadedObject.getKey()).toString());
        }
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Object upload was automatically verified, the calculated MD5 hash value matched the ETag returned by S3: ").append(uploadedObject.getKey()).toString());
        }
    }

    protected HttpMethodBase performRestHead(String bucketName, String objectKey, Map requestParameters, Map requestHeaders) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("HEAD", bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        this.performRequest(httpMethod, new int[]{200});
        return httpMethod;
    }

    protected HttpMethodBase performRestGet(String bucketName, String objectKey, Map requestParameters, Map requestHeaders) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("GET", bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        int expectedStatusCode = 200;
        if (requestHeaders != null && requestHeaders.containsKey("Range")) {
            expectedStatusCode = 206;
        }
        this.performRequest(httpMethod, new int[]{expectedStatusCode});
        return httpMethod;
    }

    protected HttpMethodAndByteCount performRestPut(String bucketName, String objectKey, Map metadata, Map requestParameters, RequestEntity requestEntity, boolean autoRelease) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("PUT", bucketName, objectKey, requestParameters);
        Map renamedMetadata = RestUtils.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(httpMethod, renamedMetadata);
        long contentLength = 0L;
        if (requestEntity != null) {
            ((PutMethod)httpMethod).setRequestEntity(requestEntity);
        } else {
            httpMethod.setRequestHeader("Content-Length", "0");
        }
        this.performRequest(httpMethod, new int[]{200});
        if (requestEntity != null) {
            contentLength = ((PutMethod)httpMethod).getRequestEntity().getContentLength();
        }
        if (autoRelease) {
            httpMethod.releaseConnection();
        }
        return new HttpMethodAndByteCount(httpMethod, contentLength);
    }

    protected HttpMethodBase performRestDelete(String string, String string2) throws S3ServiceException {
        HttpMethodBase httpMethodBase = this.setupConnection("DELETE", string, string2, null);
        this.performRequest(httpMethodBase, new int[]{204, 200});
        if (log.isDebugEnabled()) {
            log.debug("Releasing HttpMethod after delete");
        }
        httpMethodBase.releaseConnection();
        return httpMethodBase;
    }

    protected HttpMethodBase setupConnection(String string, String string2, String string3, Map map) throws S3ServiceException {
        Object object;
        int n;
        if (string2 == null) {
            throw new S3ServiceException("Cannot connect to S3 Service with a null path");
        }
        boolean bl = this.jets3tProperties.getBoolProperty("s3service.disable-dns-buckets", false);
        String string4 = RestS3Service.generateS3HostnameForBucket(string2, bl);
        String string5 = this.jets3tProperties.getStringProperty("s3service.s3-endpoint-virtual-path", "");
        String string6 = "/";
        if (string4.equals(Constants.S3_HOSTNAME) && string2 != null && string2.length() > 0) {
            string6 = new StringBuffer().append(string6).append(string2).append("/").toString();
        }
        string6 = new StringBuffer().append(string6).append(string3 != null ? RestUtils.encodeUrlString(string3) : "").toString();
        String string7 = null;
        if (this.isHttpsOnly()) {
            n = this.jets3tProperties.getIntProperty("s3service.s3-endpoint-https-port", 443);
            string7 = new StringBuffer().append("https://").append(string4).append(":").append(n).append(string5).append(string6).toString();
        } else {
            n = this.jets3tProperties.getIntProperty("s3service.s3-endpoint-http-port", 80);
            string7 = new StringBuffer().append("http://").append(string4).append(":").append(n).append(string5).append(string6).toString();
        }
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("S3 URL: ").append(string7).toString());
        }
        string7 = this.addRequestParametersToUrlPath(string7, map);
        HttpMethodBase httpMethodBase = null;
        if ("PUT".equals(string)) {
            httpMethodBase = new PutMethod(string7);
        } else if ("HEAD".equals(string)) {
            httpMethodBase = new HeadMethod(string7);
        } else if ("GET".equals(string)) {
            httpMethodBase = new GetMethod(string7);
        } else if ("DELETE".equals(string)) {
            httpMethodBase = new DeleteMethod(string7);
        } else {
            throw new IllegalArgumentException(new StringBuffer().append("Unrecognised HTTP method name: ").append(string).toString());
        }
        if (httpMethodBase.getRequestHeader("Date") == null) {
            httpMethodBase.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        if (httpMethodBase.getRequestHeader("Content-Type") == null) {
            httpMethodBase.setRequestHeader("Content-Type", "");
        }
        if (this.getDevPayUserToken() != null || this.getDevPayProductToken() != null) {
            if (this.getDevPayProductToken() != null) {
                object = new StringBuffer().append(this.getDevPayUserToken()).append(",").append(this.getDevPayProductToken()).toString();
                httpMethodBase.setRequestHeader("x-amz-security-token", (String)object);
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Including DevPay user and product tokens in request: x-amz-security-token=").append((String)object).toString());
                }
            } else {
                httpMethodBase.setRequestHeader("x-amz-security-token", this.getDevPayUserToken());
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Including DevPay user token in request: x-amz-security-token=").append(this.getDevPayUserToken()).toString());
                }
            }
        }
        if (this.isRequesterPaysEnabled()) {
            object = "x-amz-request-payer=requester".split("=");
            httpMethodBase.setRequestHeader(object[0], object[1]);
            if (log.isDebugEnabled()) {
                log.debug("Including Requester Pays header in request: x-amz-request-payer=requester");
            }
        }
        return httpMethodBase;
    }

    protected S3Bucket[] listAllBucketsImpl() throws S3ServiceException {
        String string;
        HttpMethodBase httpMethodBase;
        String string2;
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Listing all buckets for AWS user: ").append(this.getAWSCredentials().getAccessKey()).toString());
        }
        if (!this.isXmlContentType(string2 = (httpMethodBase = this.performRestGet(string = "", null, null, null)).getResponseHeader("Content-Type").getValue())) {
            throw new S3ServiceException(new StringBuffer().append("Expected XML document response from S3 but received content type ").append(string2).toString());
        }
        S3Bucket[] s3BucketArray = new XmlResponsesSaxParser(this.jets3tProperties).parseListMyBucketsResponse(new HttpMethodReleaseInputStream(httpMethodBase)).getBuckets();
        return s3BucketArray;
    }

    protected S3ObjectsChunk listObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws S3ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, completeListing, priorLastKey);
    }

    protected S3ObjectsChunk listObjectsInternal(String string, String string2, String string3, long l, boolean bl, String string4) throws S3ServiceException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 != null) {
            hashMap.put("prefix", string2);
        }
        if (string3 != null) {
            hashMap.put("delimiter", string3);
        }
        if (l > 0L) {
            hashMap.put("max-keys", String.valueOf(l));
        }
        ArrayList<S3Object> arrayList = new ArrayList<S3Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl2 = true;
        int n = 0;
        while (bl2) {
            if (string4 != null) {
                hashMap.put("marker", string4);
            } else {
                hashMap.remove("marker");
            }
            HttpMethodBase httpMethodBase = this.performRestGet(string, null, hashMap, null);
            XmlResponsesSaxParser.ListBucketHandler listBucketHandler = null;
            try {
                listBucketHandler = new XmlResponsesSaxParser(this.jets3tProperties).parseListBucketObjectsResponse(new HttpMethodReleaseInputStream(httpMethodBase));
                n = 0;
            }
            catch (S3ServiceException s3ServiceException) {
                if (s3ServiceException.getCause() instanceof IOException && n < 5) {
                    ++n;
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Retrying bucket listing failure due to IO error", s3ServiceException);
                    continue;
                }
                throw s3ServiceException;
            }
            S3Object[] s3ObjectArray = listBucketHandler.getObjects();
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Found ").append(s3ObjectArray.length).append(" objects in one batch").toString());
            }
            arrayList.addAll(Arrays.asList(s3ObjectArray));
            String[] stringArray = listBucketHandler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Found ").append(stringArray.length).append(" common prefixes in one batch").toString());
            }
            arrayList2.addAll(Arrays.asList(stringArray));
            bl2 = listBucketHandler.isListingTruncated();
            if (bl2) {
                string4 = listBucketHandler.getMarkerForNextListing();
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Yet to receive complete listing of bucket contents, last key for prior chunk: ").append(string4).toString());
                }
            } else {
                string4 = null;
            }
            if (bl) continue;
            break;
        }
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Found ").append(arrayList.size()).append(" objects in total").toString());
            }
            return new S3ObjectsChunk(string2, string3, arrayList.toArray(new S3Object[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), null);
        }
        return new S3ObjectsChunk(string2, string3, arrayList.toArray(new S3Object[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), string4);
    }

    protected void deleteObjectImpl(String bucketName, String objectKey) throws S3ServiceException {
        this.performRestDelete(bucketName, objectKey);
    }

    protected void putAclImpl(String string, String string2, AccessControlList accessControlList) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Setting Access Control List for bucketName=").append(string).append(", objectKey=").append(string2).toString());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("acl", "");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("Content-Type", "text/plain");
        try {
            String string3 = accessControlList.toXml();
            hashMap2.put("Content-Length", String.valueOf(string3.length()));
            this.performRestPut(string, string2, hashMap2, hashMap, new StringRequestEntity(string3, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new S3ServiceException("Unable to encode ACL XML document", unsupportedEncodingException);
        }
    }

    protected S3Bucket createBucketImpl(String string, String string2, AccessControlList accessControlList) throws S3ServiceException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Creating bucket with name: ").append(string).toString());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringRequestEntity stringRequestEntity = null;
        if (string2 != null && !"US".equalsIgnoreCase(string2)) {
            hashMap.put("Content-Type", "text/xml");
            try {
                object = new CreateBucketConfiguration(string2);
                hashMap.put("Content-Length", String.valueOf(((CreateBucketConfiguration)object).toXml().length()));
                stringRequestEntity = new StringRequestEntity(((CreateBucketConfiguration)object).toXml(), "text/xml", Constants.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new S3ServiceException("Unable to encode CreateBucketConfiguration XML document", unsupportedEncodingException);
            }
        }
        object = this.createObjectImpl(string, null, null, stringRequestEntity, hashMap, accessControlList);
        S3Bucket s3Bucket = new S3Bucket(string, string2);
        s3Bucket.setAcl(accessControlList);
        s3Bucket.replaceAllMetadata((Map)object);
        return s3Bucket;
    }

    protected void deleteBucketImpl(String bucketName) throws S3ServiceException {
        this.performRestDelete(bucketName, null);
    }

    protected S3Object putObjectImpl(String string, S3Object s3Object) throws S3ServiceException {
        Map map;
        RequestEntity requestEntity;
        boolean bl;
        block9: {
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Creating Object with key ").append(s3Object.getKey()).append(" in bucket ").append(string).toString());
            }
            bl = s3Object.getMetadata("Content-MD5") == null;
            requestEntity = null;
            if (s3Object.getDataInputStream() != null) {
                if (s3Object.containsMetadata("Content-Length")) {
                    if (log.isDebugEnabled()) {
                        log.debug(new StringBuffer().append("Uploading object data with Content-Length: ").append(s3Object.getContentLength()).toString());
                    }
                    requestEntity = new RepeatableRequestEntity(s3Object.getKey(), s3Object.getDataInputStream(), s3Object.getContentType(), s3Object.getContentLength(), this.jets3tProperties, bl);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn("Content-Length of data stream not set, will automatically determine data length in memory");
                    }
                    requestEntity = new InputStreamRequestEntity(s3Object.getDataInputStream(), -2L);
                }
            }
            map = this.createObjectImpl(string, s3Object.getKey(), s3Object.getContentType(), requestEntity, s3Object.getMetadataMap(), s3Object.getAcl());
            try {
                s3Object.closeDataInputStream();
            }
            catch (IOException iOException) {
                if (!log.isWarnEnabled()) break block9;
                log.warn(new StringBuffer().append("Unable to close data input stream for object '").append(s3Object.getKey()).append("'").toString(), iOException);
            }
        }
        s3Object.replaceAllMetadata(map);
        if (bl && requestEntity instanceof RepeatableRequestEntity) {
            String string2 = ServiceUtils.toHex(((RepeatableRequestEntity)requestEntity).getMD5DigestOfData());
            this.verifyExpectedAndActualETagValues(string2, s3Object);
        }
        return s3Object;
    }

    protected Map createObjectImpl(String string, String string2, String string3, RequestEntity requestEntity, Map hashMap, AccessControlList accessControlList) throws S3ServiceException {
        hashMap = hashMap == null ? new HashMap<String, String>() : new HashMap(hashMap);
        if (string3 != null) {
            hashMap.put("Content-Type", string3);
        } else {
            hashMap.put("Content-Type", "application/octet-stream");
        }
        boolean bl = false;
        if (accessControlList != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "authenticated-read");
            } else {
                bl = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Creating object bucketName=").append(string).append(", objectKey=").append(string2).append(".").append(" Content-Type=").append(hashMap.get("Content-Type")).append(" Including data? ").append(requestEntity != null).append(" Metadata: ").append(hashMap).append(" ACL: ").append(accessControlList).toString());
        }
        HttpMethodAndByteCount httpMethodAndByteCount = this.performRestPut(string, string2, hashMap, null, requestEntity, true);
        HttpMethodBase httpMethodBase = httpMethodAndByteCount.getHttpMethod();
        Map<String, String> map = new HashMap<String, String>();
        map.putAll(hashMap);
        map.putAll(this.convertHeadersToMap(httpMethodBase.getResponseHeaders()));
        map.put("Content-Length", String.valueOf(httpMethodAndByteCount.getByteCount()));
        map = ServiceUtils.cleanRestMetadataMap(map);
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(string, string2, accessControlList);
        }
        return map;
    }

    protected Map copyObjectImpl(String string, String string2, String string3, String string4, AccessControlList accessControlList, Map map, Calendar calendar, Calendar calendar2, String[] stringArray, String[] stringArray2) throws S3ServiceException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Copying Object from ").append(string).append(":").append(string2).append(" to ").append(string3).append(":").append(string4).toString());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("x-amz-copy-source", RestUtils.encodeUrlString(new StringBuffer().append(string).append("/").append(string2).toString()));
        if (map != null) {
            hashMap.put("x-amz-metadata-directive", "REPLACE");
            hashMap.putAll(map);
            if (!hashMap.containsKey("Content-Type")) {
                hashMap.put("Content-Type", "application/octet-stream");
            }
        } else {
            hashMap.put("x-amz-metadata-directive", "COPY");
        }
        boolean bl = false;
        if (accessControlList != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(accessControlList)) {
                hashMap.put("x-amz-acl", "authenticated-read");
            } else {
                bl = true;
            }
        }
        if (calendar != null) {
            hashMap.put("x-amz-copy-source-if-modified-since", ServiceUtils.formatRfc822Date(calendar.getTime()));
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only copy object if-modified-since:").append(calendar).toString());
            }
        }
        if (calendar2 != null) {
            hashMap.put("x-amz-copy-source-if-unmodified-since", ServiceUtils.formatRfc822Date(calendar2.getTime()));
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only copy object if-unmodified-since:").append(calendar2).toString());
            }
        }
        if (stringArray != null) {
            object = ServiceUtils.join(stringArray, ",");
            hashMap.put("x-amz-copy-source-if-match", (String)object);
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only copy object based on hash comparison if-match:").append((String)object).toString());
            }
        }
        if (stringArray2 != null) {
            object = ServiceUtils.join(stringArray2, ",");
            hashMap.put("x-amz-copy-source-if-none-match", (String)object);
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only copy object based on hash comparison if-none-match:").append((String)object).toString());
            }
        }
        object = this.performRestPut(string3, string4, hashMap, null, null, false);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = new XmlResponsesSaxParser(this.jets3tProperties).parseCopyObjectResponse(new HttpMethodReleaseInputStream(((HttpMethodAndByteCount)object).getHttpMethod()));
        ((HttpMethodAndByteCount)object).getHttpMethod().releaseConnection();
        if (copyObjectResultHandler.isErrorResponse()) {
            throw new S3ServiceException(new StringBuffer().append("Copy failed: Code=").append(copyObjectResultHandler.getErrorCode()).append(", Message=").append(copyObjectResultHandler.getErrorMessage()).append(", RequestId=").append(copyObjectResultHandler.getErrorRequestId()).append(", HostId=").append(copyObjectResultHandler.getErrorHostId()).toString());
        }
        Map<String, Object> map2 = new HashMap<String, Object>();
        map2.put("Last-Modified", copyObjectResultHandler.getLastModified());
        map2.put("ETag", copyObjectResultHandler.getETag());
        map2.putAll(this.convertHeadersToMap(((HttpMethodAndByteCount)object).getHttpMethod().getResponseHeaders()));
        map2 = ServiceUtils.cleanRestMetadataMap(map2);
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(string3, string4, accessControlList);
        }
        return map2;
    }

    protected S3Object getObjectDetailsImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        return this.getObjectImpl(true, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null, null);
    }

    protected S3Object getObjectImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        return this.getObjectImpl(false, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    private S3Object getObjectImpl(boolean bl, String string, String string2, Calendar calendar, Calendar calendar2, String[] stringArray, String[] stringArray2, Long l, Long l2) throws S3ServiceException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Retrieving ").append(bl ? "Head" : "All").append(" information for bucket ").append(string).append(" and object ").append(string2).toString());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (calendar != null) {
            hashMap.put("If-Modified-Since", ServiceUtils.formatRfc822Date(calendar.getTime()));
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only retrieve object if-modified-since:").append(calendar).toString());
            }
        }
        if (calendar2 != null) {
            hashMap.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(calendar2.getTime()));
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only retrieve object if-unmodified-since:").append(calendar2).toString());
            }
        }
        if (stringArray != null) {
            object = ServiceUtils.join(stringArray, ",");
            hashMap.put("If-Match", object);
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only retrieve object based on hash comparison if-match:").append((String)object).toString());
            }
        }
        if (stringArray2 != null) {
            object = ServiceUtils.join(stringArray2, ",");
            hashMap.put("If-None-Match", object);
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only retrieve object based on hash comparison if-none-match:").append((String)object).toString());
            }
        }
        if (l != null || l2 != null) {
            object = new StringBuffer().append("bytes=").append(l != null ? l.toString() : "").append("-").append(l2 != null ? l2.toString() : "").toString();
            hashMap.put("Range", object);
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Only retrieve object if it is within range:").append((String)object).toString());
            }
        }
        object = null;
        object = bl ? this.performRestHead(string, string2, null, hashMap) : this.performRestGet(string, string2, null, hashMap);
        HashMap hashMap2 = new HashMap();
        hashMap2.putAll(this.convertHeadersToMap(((HttpMethodBase)object).getResponseHeaders()));
        S3Object s3Object = new S3Object(string2);
        s3Object.setBucketName(string);
        s3Object.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(hashMap2));
        s3Object.setMetadataComplete(true);
        if (!bl) {
            HttpMethodReleaseInputStream httpMethodReleaseInputStream = new HttpMethodReleaseInputStream((HttpMethod)object);
            s3Object.setDataInputStream(httpMethodReleaseInputStream);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Releasing HttpMethod after HEAD");
            }
            ((HttpMethodBase)object).releaseConnection();
        }
        return s3Object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    public class HttpMethodAndByteCount {
        private HttpMethodBase httpMethod = null;
        private long byteCount = 0L;

        public HttpMethodAndByteCount(HttpMethodBase httpMethod, long byteCount) {
            this.httpMethod = httpMethod;
            this.byteCount = byteCount;
        }

        public HttpMethodBase getHttpMethod() {
            return this.httpMethod;
        }

        public long getByteCount() {
            return this.byteCount;
        }
    }
}

