/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.acl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Owner;

public class AccessControlList
implements Serializable {
    public static final AccessControlList REST_CANNED_PRIVATE = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ_WRITE = new AccessControlList();
    public static final AccessControlList REST_CANNED_AUTHENTICATED_READ = new AccessControlList();
    private HashSet grants = new HashSet();
    private S3Owner owner = null;

    public String toString() {
        return new StringBuffer().append("AccessControlList [owner=").append(this.owner).append(", grants=").append(this.getGrants()).append("]").toString();
    }

    public Set getGrants() {
        return this.grants;
    }

    public String toXml() throws S3ServiceException {
        if (this.owner == null) {
            throw new S3ServiceException("Invalid AccessControlList: missing an S3Owner");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(new StringBuffer().append("<AccessControlPolicy xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Owner><ID>").append(this.owner.getId()).append("</ID>").append("<DisplayName>").append(this.owner.getDisplayName()).append("</DisplayName>").append("</Owner>").append("<AccessControlList>").toString());
        for (GrantAndPermission gap : this.grants) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            sb.append(new StringBuffer().append("<Grant>").append(grantee.toXml()).append("<Permission>").append(permission).append("</Permission>").append("</Grant>").toString());
        }
        sb.append("</AccessControlList></AccessControlPolicy>");
        return sb.toString();
    }
}

