/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jets3t.service.mx.MxDelegate;

public class S3ServiceException
extends Exception {
    private String xmlMessage = null;
    private String s3ErrorCode = null;
    private String s3ErrorMessage = null;
    private String s3ErrorRequestId = null;
    private String s3ErrorHostId = null;
    private Map s3Headers = null;
    private int responseCode = -1;
    private String responseStatus = null;
    private String responseDate = null;
    private String requestVerb = null;
    private String requestPath = null;
    private String requestHost = null;

    public S3ServiceException(String message, String xmlMessage) {
        super(message);
        this.parseS3XmlMessage(xmlMessage);
        MxDelegate.getInstance().registerS3ServiceExceptionEvent(this.getS3ErrorCode());
    }

    public S3ServiceException() {
    }

    public S3ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public S3ServiceException(String message) {
        super(message);
    }

    public S3ServiceException(Throwable cause) {
        super(cause);
    }

    public String toString() {
        String myString = super.toString();
        if (this.requestVerb != null) {
            myString = new StringBuffer().append(myString).append(" ").append(this.requestVerb).append(" '").append(this.requestPath).append("'").append(this.requestHost != null ? new StringBuffer().append(" on Host '").append(this.requestHost).append("'").toString() : "").append(this.responseDate != null ? new StringBuffer().append(" @ '").append(this.responseDate).append("'").toString() : "").toString();
        }
        if (this.responseCode != -1) {
            myString = new StringBuffer().append(myString).append(" -- ResponseCode: ").append(this.responseCode).append(", ResponseStatus: ").append(this.responseStatus).toString();
        }
        if (this.isParsedFromXmlMessage()) {
            myString = new StringBuffer().append(myString).append(", XML Error Message: ").append(this.xmlMessage).toString();
        } else if (this.s3ErrorRequestId != null) {
            myString = new StringBuffer().append(myString).append(", RequestId: ").append(this.s3ErrorRequestId).append(", HostId: ").append(this.s3ErrorHostId).toString();
        }
        return myString;
    }

    private String findXmlElementText(String xmlMessage, String elementName) {
        Pattern pattern = Pattern.compile(new StringBuffer().append(".*<").append(elementName).append(">(.*)</").append(elementName).append(">.*").toString());
        Matcher matcher = pattern.matcher(xmlMessage);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private void parseS3XmlMessage(String xmlMessage) {
        this.xmlMessage = xmlMessage = xmlMessage.replaceAll("\n", "");
        this.s3ErrorCode = this.findXmlElementText(xmlMessage, "Code");
        this.s3ErrorMessage = this.findXmlElementText(xmlMessage, "Message");
        this.s3ErrorRequestId = this.findXmlElementText(xmlMessage, "RequestId");
        this.s3ErrorHostId = this.findXmlElementText(xmlMessage, "HostId");
    }

    public String getS3ErrorCode() {
        return this.s3ErrorCode;
    }

    public boolean isParsedFromXmlMessage() {
        return this.xmlMessage != null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResponseStatus(String responseStatus) {
        this.responseStatus = responseStatus;
    }

    public void setResponseDate(String responseDate) {
        this.responseDate = responseDate;
    }

    public void setRequestVerb(String requestVerb) {
        this.requestVerb = requestVerb;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public void setS3RequestAndHostIds(String errorRequestId, String errorHostId) {
        this.s3ErrorRequestId = errorRequestId;
        this.s3ErrorHostId = errorHostId;
    }

    public void setResponseHeaders(Map s3Headers) {
        this.s3Headers = s3Headers;
    }
}

