/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.SerializationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static SerializationFactory serialFactory = null;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static long previousLogTime = 0L;
    private static ThreadLocal<CopyInCopyOutBuffer> cloneBuffers = new ThreadLocal<CopyInCopyOutBuffer>(){

        @Override
        protected synchronized CopyInCopyOutBuffer initialValue() {
            return new CopyInCopyOutBuffer();
        }
    };

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null) {
            if (theObject instanceof Configurable) {
                ((Configurable)theObject).setConf(conf);
            }
            ReflectionUtils.setJobConf(theObject, conf);
        }
    }

    private static void setJobConf(Object theObject, Configuration conf) {
        try {
            Class<?> jobConfClass = conf.getClassByName("org.apache.hadoop.mapred.JobConf");
            Class<?> jobConfigurableClass = conf.getClassByName("org.apache.hadoop.mapred.JobConfigurable");
            if (jobConfClass.isAssignableFrom(conf.getClass()) && jobConfigurableClass.isAssignableFrom(theObject.getClass())) {
                Method configureMethod = jobConfigurableClass.getMethod("configure", jobConfClass);
                configureMethod.invoke(theObject, conf);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error in configuring object", e);
        }
    }

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result, conf);
        return (T)result;
    }

    private static class CopyInCopyOutBuffer {
        DataOutputBuffer outBuffer = new DataOutputBuffer();
        DataInputBuffer inBuffer = new DataInputBuffer();

        private CopyInCopyOutBuffer() {
        }
    }
}

