/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class DataChecksum
implements Checksum {
    private final int type;
    private final int size;
    private final Checksum summer;
    private final int bytesPerChecksum;
    private int inSum = 0;

    public static DataChecksum newDataChecksum(int type, int bytesPerChecksum) {
        if (bytesPerChecksum <= 0) {
            return null;
        }
        switch (type) {
            case 0: {
                return new DataChecksum(0, new ChecksumNull(), 0, bytesPerChecksum);
            }
            case 1: {
                return new DataChecksum(1, new CRC32(), 4, bytesPerChecksum);
            }
        }
        return null;
    }

    public static DataChecksum newDataChecksum(DataInputStream in) throws IOException {
        int bpc;
        byte type = in.readByte();
        DataChecksum summer = DataChecksum.newDataChecksum(type, bpc = in.readInt());
        if (summer == null) {
            throw new IOException("Could not create DataChecksum of type " + type + " with bytesPerChecksum " + bpc);
        }
        return summer;
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        out.writeInt(this.bytesPerChecksum);
    }

    public int writeValue(byte[] buf, int offset, boolean reset) throws IOException {
        if (this.size <= 0) {
            return 0;
        }
        if (this.type != 1) {
            throw new IOException("Unknown Checksum " + this.type);
        }
        int checksum = (int)this.summer.getValue();
        buf[offset + 0] = (byte)(checksum >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(checksum >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(checksum >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(checksum & 0xFF);
        if (reset) {
            this.reset();
        }
        return this.size;
    }

    public boolean compare(byte[] buf, int offset) {
        if (this.size > 0 && this.type == 1) {
            int checksum = (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            return checksum == (int)this.summer.getValue();
        }
        return this.size == 0;
    }

    private DataChecksum(int checksumType, Checksum checksum, int sumSize, int chunkSize) {
        this.type = checksumType;
        this.summer = checksum;
        this.size = sumSize;
        this.bytesPerChecksum = chunkSize;
    }

    public int getChecksumType() {
        return this.type;
    }

    public int getChecksumSize() {
        return this.size;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public static int getChecksumHeaderSize() {
        return 5;
    }

    public long getValue() {
        return this.summer.getValue();
    }

    public void reset() {
        this.summer.reset();
        this.inSum = 0;
    }

    public void update(byte[] b, int off, int len) {
        if (len > 0) {
            this.summer.update(b, off, len);
            this.inSum += len;
        }
    }

    public void update(int b) {
        this.summer.update(b);
        ++this.inSum;
    }

    static class ChecksumNull
    implements Checksum {
        public long getValue() {
            return 0L;
        }

        public void reset() {
        }

        public void update(byte[] b, int off, int len) {
        }

        public void update(int b) {
        }
    }
}

