/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UnixUserGroupInformation;

public abstract class UserGroupInformation
implements Principal,
Writable {
    public static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private static UserGroupInformation LOGIN_UGI = null;
    private static final ThreadLocal<Subject> currentUser = new ThreadLocal();

    public static UserGroupInformation getCurrentUGI() {
        Subject subject = UserGroupInformation.getCurrentUser();
        if (subject == null && (subject = currentUser.get()) == null) {
            return null;
        }
        Set<UserGroupInformation> set = subject.getPrincipals(UserGroupInformation.class);
        UserGroupInformation userGroupInformation = null;
        if (set != null && set.size() == 1) {
            userGroupInformation = set.iterator().next();
            if (userGroupInformation == null) {
                throw new RuntimeException("Cannot find _current user_ UGI in the Subject!");
            }
        } else {
            throw new RuntimeException("Cannot resolve current user from subject, which had " + set.size() + " UGI principals!");
        }
        return userGroupInformation;
    }

    static Subject getCurrentUser() {
        return Subject.getSubject(AccessController.getContext());
    }

    public abstract String getUserName();

    public abstract String[] getGroupNames();

    public static UserGroupInformation login(Configuration conf) throws LoginException {
        if (LOGIN_UGI == null) {
            LOGIN_UGI = UnixUserGroupInformation.login(conf);
        }
        return LOGIN_UGI;
    }

    public static UserGroupInformation readFrom(Configuration conf) throws IOException {
        try {
            return UnixUserGroupInformation.readFromConf(conf, "hadoop.job.ugi");
        }
        catch (LoginException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

