/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import org.apache.hadoop.net.Node;

public class NodeBase
implements Node {
    protected String name;
    protected String location;
    protected int level;
    protected Node parent;

    public NodeBase() {
    }

    public NodeBase(String path) {
        path = NodeBase.normalize(path);
        int index = path.lastIndexOf(47);
        if (index == -1) {
            this.set("", path);
        } else {
            this.set(path.substring(index + 1), path.substring(0, index));
        }
    }

    public NodeBase(String name, String location, Node parent, int level) {
        this.set(name, NodeBase.normalize(location));
        this.parent = parent;
        this.level = level;
    }

    private void set(String name, String location) {
        if (name != null && name.contains("/")) {
            throw new IllegalArgumentException("Network location name contains /: " + name);
        }
        this.name = name == null ? "" : name;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkLocation() {
        return this.location;
    }

    public static String getPath(Node node) {
        return node.getNetworkLocation() + "/" + node.getName();
    }

    public String toString() {
        return NodeBase.getPath(this);
    }

    public static String normalize(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Network Location path does not start with /: " + path);
        }
        int len = path.length();
        if (path.charAt(len - 1) == '/') {
            return path.substring(0, len - 1);
        }
        return path;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

