/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public abstract class MetricsDynamicMBeanBase
implements DynamicMBean {
    private MetricsRegistry metricsRegistry;
    private MBeanInfo mbeanInfo;
    private Map<String, MetricsBase> metricsRateAttributeMod;
    private int numEntriesInRegistry;
    private String mbeanDescription;

    private void updateMbeanInfoIfMetricsListChanged() {
        if (this.numEntriesInRegistry != this.metricsRegistry.size()) {
            this.createMBeanInfo();
        }
    }

    private void createMBeanInfo() {
        this.metricsRateAttributeMod = new HashMap<String, MetricsBase>();
        boolean bl = false;
        ArrayList<MBeanAttributeInfo> arrayList = new ArrayList<MBeanAttributeInfo>();
        MBeanOperationInfo[] mBeanOperationInfoArray = null;
        this.numEntriesInRegistry = this.metricsRegistry.size();
        for (MetricsBase metricsBase : this.metricsRegistry.getMetricsList()) {
            if (MetricsTimeVaryingRate.class.isInstance(metricsBase)) {
                arrayList.add(new MBeanAttributeInfo(metricsBase.getName() + "NumOps", "java.lang.Integer", metricsBase.getDescription(), true, false, false));
                arrayList.add(new MBeanAttributeInfo(metricsBase.getName() + "AvgTime", "java.lang.Long", metricsBase.getDescription(), true, false, false));
                arrayList.add(new MBeanAttributeInfo(metricsBase.getName() + "MinTime", "java.lang.Long", metricsBase.getDescription(), true, false, false));
                arrayList.add(new MBeanAttributeInfo(metricsBase.getName() + "MaxTime", "java.lang.Long", metricsBase.getDescription(), true, false, false));
                bl = true;
                this.metricsRateAttributeMod.put(metricsBase.getName() + "NumOps", metricsBase);
                this.metricsRateAttributeMod.put(metricsBase.getName() + "AvgTime", metricsBase);
                this.metricsRateAttributeMod.put(metricsBase.getName() + "MinTime", metricsBase);
                this.metricsRateAttributeMod.put(metricsBase.getName() + "MaxTime", metricsBase);
            } else if (MetricsIntValue.class.isInstance(metricsBase) || MetricsTimeVaryingInt.class.isInstance(metricsBase)) {
                arrayList.add(new MBeanAttributeInfo(metricsBase.getName(), "java.lang.Integer", metricsBase.getDescription(), true, false, false));
            } else if (MetricsLongValue.class.isInstance(metricsBase) || MetricsTimeVaryingLong.class.isInstance(metricsBase)) {
                arrayList.add(new MBeanAttributeInfo(metricsBase.getName(), "java.lang.Long", metricsBase.getDescription(), true, false, false));
            } else {
                MetricsUtil.LOG.error("unknown metrics type: " + metricsBase.getClass().getName());
            }
            if (!bl) continue;
            mBeanOperationInfoArray = new MBeanOperationInfo[]{new MBeanOperationInfo("resetAllMinMax", "Reset (zero) All Min Max", null, "void", 1)};
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[arrayList.size()];
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), this.mbeanDescription, arrayList.toArray(mBeanAttributeInfoArray), null, mBeanOperationInfoArray, null);
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException();
        }
        this.updateMbeanInfoIfMetricsListChanged();
        MetricsBase o = this.metricsRateAttributeMod.get(attributeName);
        if (o == null) {
            o = this.metricsRegistry.get(attributeName);
        }
        if (o == null) {
            throw new AttributeNotFoundException();
        }
        if (o instanceof MetricsIntValue) {
            return ((MetricsIntValue)o).get();
        }
        if (o instanceof MetricsLongValue) {
            return ((MetricsLongValue)o).get();
        }
        if (o instanceof MetricsTimeVaryingInt) {
            return ((MetricsTimeVaryingInt)o).getPreviousIntervalValue();
        }
        if (o instanceof MetricsTimeVaryingLong) {
            return ((MetricsTimeVaryingLong)o).getPreviousIntervalValue();
        }
        if (o instanceof MetricsTimeVaryingRate) {
            MetricsTimeVaryingRate or = (MetricsTimeVaryingRate)o;
            if (attributeName.endsWith("NumOps")) {
                return or.getPreviousIntervalNumOps();
            }
            if (attributeName.endsWith("AvgTime")) {
                return or.getPreviousIntervalAverageTime();
            }
            if (attributeName.endsWith("MinTime")) {
                return or.getMinTime();
            }
            if (attributeName.endsWith("MaxTime")) {
                return or.getMaxTime();
            }
            MetricsUtil.LOG.error("Unexpected attrubute suffix");
            throw new AttributeNotFoundException();
        }
        MetricsUtil.LOG.error("unknown metrics type: " + o.getClass().getName());
        throw new AttributeNotFoundException();
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null || attributeNames.length == 0) {
            throw new IllegalArgumentException();
        }
        this.updateMbeanInfoIfMetricsListChanged();
        AttributeList result = new AttributeList(attributeNames.length);
        for (String iAttributeName : attributeNames) {
            try {
                Object value = this.getAttribute(iAttributeName);
                result.add(new Attribute(iAttributeName, value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException();
        }
        if (!string.equals("resetAllMinMax") || this.mbeanInfo.getOperations().length != 1) {
            throw new ReflectionException(new NoSuchMethodException(string));
        }
        for (MetricsBase metricsBase : this.metricsRegistry.getMetricsList()) {
            if (!MetricsTimeVaryingRate.class.isInstance(metricsBase)) continue;
            ((MetricsTimeVaryingRate)MetricsTimeVaryingRate.class.cast(metricsBase)).resetMinMax();
        }
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new ReflectionException(new NoSuchMethodException("set" + attribute));
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

