/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPC {
    private static final Log LOG = LogFactory.getLog(RPC.class);
    private static ClientCache CLIENTS = new ClientCache();

    private RPC() {
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory) throws IOException {
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.login(conf);
        }
        catch (LoginException le) {
            throw new RuntimeException("Couldn't login!");
        }
        return RPC.getProxy(protocol, clientVersion, addr, ugi, conf, factory);
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        VersionedProtocol proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(addr, ticket, conf, factory));
        long serverVersion = proxy.getProtocolVersion(protocol.getName(), clientVersion);
        if (serverVersion == clientVersion) {
            return proxy;
        }
        throw new VersionMismatch(protocol.getName(), clientVersion, serverVersion);
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.getProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    public static void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    public static class VersionMismatch
    extends IOException {
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private InetSocketAddress address;
        private UserGroupInformation ticket;
        private Client client;
        private boolean isClosed = false;

        public Invoker(InetSocketAddress address, UserGroupInformation ticket, Configuration conf, SocketFactory factory) {
            this.address = address;
            this.ticket = ticket;
            this.client = CLIENTS.getClient(conf, factory);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean logDebug = LOG.isDebugEnabled();
            long startTime = 0L;
            if (logDebug) {
                startTime = System.currentTimeMillis();
            }
            ObjectWritable value = (ObjectWritable)this.client.call(new Invocation(method, args), this.address, method.getDeclaringClass(), this.ticket);
            if (logDebug) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug("Call: " + method.getName() + " " + callTime);
            }
            return value.get();
        }

        private synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, Client> clients = new HashMap<SocketFactory, Client>();

        private ClientCache() {
        }

        private synchronized Client getClient(Configuration configuration, SocketFactory socketFactory) {
            Client client = this.clients.get(socketFactory);
            if (client == null) {
                client = new Client(ObjectWritable.class, configuration, socketFactory);
                this.clients.put(socketFactory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopClient(Client client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }

    private static class Invocation
    implements Configurable,
    Writable {
        private String methodName;
        private Class[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
        }

        public void readFields(DataInput in) throws IOException {
            this.methodName = UTF8.readString(in);
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            ObjectWritable objectWritable = new ObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = ObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        public void write(DataOutput out) throws IOException {
            UTF8.writeString(out, this.methodName);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                ObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            return buffer.toString();
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }
    }
}

