/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.HashMap;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableComparator
implements RawComparator {
    private static HashMap<Class, WritableComparator> comparators = new HashMap();
    private final Class<? extends WritableComparable> keyClass;
    private final WritableComparable key1;
    private final WritableComparable key2;
    private final DataInputBuffer buffer;

    public static synchronized void define(Class c, WritableComparator comparator) {
        comparators.put(c, comparator);
    }

    protected WritableComparator(Class<? extends WritableComparable> keyClass) {
        this(keyClass, false);
    }

    protected WritableComparator(Class<? extends WritableComparable> keyClass, boolean createInstances) {
        this.keyClass = keyClass;
        if (createInstances) {
            this.key1 = this.newKey();
            this.key2 = this.newKey();
            this.buffer = new DataInputBuffer();
        } else {
            this.key2 = null;
            this.key1 = null;
            this.buffer = null;
        }
    }

    public WritableComparable newKey() {
        return ReflectionUtils.newInstance(this.keyClass, null);
    }

    public int compare(WritableComparable a, WritableComparable b) {
        return a.compareTo(b);
    }

    public int compare(Object a, Object b) {
        return this.compare((WritableComparable)a, (WritableComparable)b);
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int hashBytes(byte[] bytes, int length) {
        int hash = 1;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }
}

