/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class ObjectWritable
implements Configurable,
Writable {
    private Class declaredClass;
    private Object instance;
    private Configuration conf;
    private static final Map<String, Class<?>> PRIMITIVE_NAMES = new HashMap();

    public Object get() {
        return this.instance;
    }

    public Class getDeclaredClass() {
        return this.declaredClass;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    public void readFields(DataInput in) throws IOException {
        ObjectWritable.readObject(in, this, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        ObjectWritable.writeObject(out, this.instance, this.declaredClass, this.conf);
    }

    public static void writeObject(DataOutput dataOutput, Object object, Class clazz, Configuration configuration) throws IOException {
        if (object == null) {
            object = new NullInstance(clazz, configuration);
            clazz = Writable.class;
        }
        UTF8.writeString(dataOutput, clazz.getName());
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            dataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                ObjectWritable.writeObject(dataOutput, Array.get(object, i), clazz.getComponentType(), configuration);
            }
        } else if (clazz == String.class) {
            UTF8.writeString(dataOutput, (String)object);
        } else if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                dataOutput.writeBoolean((Boolean)object);
            } else if (clazz == Character.TYPE) {
                dataOutput.writeChar(((Character)object).charValue());
            } else if (clazz == Byte.TYPE) {
                dataOutput.writeByte(((Byte)object).byteValue());
            } else if (clazz == Short.TYPE) {
                dataOutput.writeShort(((Short)object).shortValue());
            } else if (clazz == Integer.TYPE) {
                dataOutput.writeInt((Integer)object);
            } else if (clazz == Long.TYPE) {
                dataOutput.writeLong((Long)object);
            } else if (clazz == Float.TYPE) {
                dataOutput.writeFloat(((Float)object).floatValue());
            } else if (clazz == Double.TYPE) {
                dataOutput.writeDouble((Double)object);
            } else if (clazz != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + clazz);
            }
        } else if (clazz.isEnum()) {
            UTF8.writeString(dataOutput, ((Enum)object).name());
        } else if (Writable.class.isAssignableFrom(clazz)) {
            UTF8.writeString(dataOutput, object.getClass().getName());
            ((Writable)object).write(dataOutput);
        } else {
            throw new IOException("Can't write: " + object + " as " + clazz);
        }
    }

    public static Object readObject(DataInput in, Configuration conf) throws IOException {
        return ObjectWritable.readObject(in, null, conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(DataInput dataInput, ObjectWritable objectWritable, Configuration configuration) throws IOException {
        Object object;
        String string = UTF8.readString(dataInput);
        Class clazz = PRIMITIVE_NAMES.get(string);
        if (clazz == null) {
            try {
                clazz = configuration.getClassByName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("readObject can't find class " + string, classNotFoundException);
            }
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                object = dataInput.readBoolean();
            } else if (clazz == Character.TYPE) {
                object = Character.valueOf(dataInput.readChar());
            } else if (clazz == Byte.TYPE) {
                object = dataInput.readByte();
            } else if (clazz == Short.TYPE) {
                object = dataInput.readShort();
            } else if (clazz == Integer.TYPE) {
                object = dataInput.readInt();
            } else if (clazz == Long.TYPE) {
                object = dataInput.readLong();
            } else if (clazz == Float.TYPE) {
                object = Float.valueOf(dataInput.readFloat());
            } else if (clazz == Double.TYPE) {
                object = dataInput.readDouble();
            } else {
                if (clazz != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + clazz);
                object = null;
            }
        } else if (clazz.isArray()) {
            int n = dataInput.readInt();
            object = Array.newInstance(clazz.getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, ObjectWritable.readObject(dataInput, configuration));
            }
        } else if (clazz == String.class) {
            object = UTF8.readString(dataInput);
        } else if (clazz.isEnum()) {
            object = Enum.valueOf(clazz, UTF8.readString(dataInput));
        } else {
            Class<?> clazz2 = null;
            String string2 = "";
            try {
                string2 = UTF8.readString(dataInput);
                clazz2 = configuration.getClassByName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("readObject can't find class " + string2, classNotFoundException);
            }
            Writable writable = WritableFactories.newInstance(clazz2, configuration);
            writable.readFields(dataInput);
            object = writable;
            if (clazz2 == NullInstance.class) {
                clazz = ((NullInstance)object).declaredClass;
                object = null;
            }
        }
        if (objectWritable == null) return object;
        objectWritable.declaredClass = clazz;
        objectWritable.instance = object;
        return object;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    static {
        PRIMITIVE_NAMES.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAMES.put("byte", Byte.TYPE);
        PRIMITIVE_NAMES.put("char", Character.TYPE);
        PRIMITIVE_NAMES.put("short", Short.TYPE);
        PRIMITIVE_NAMES.put("int", Integer.TYPE);
        PRIMITIVE_NAMES.put("long", Long.TYPE);
        PRIMITIVE_NAMES.put("float", Float.TYPE);
        PRIMITIVE_NAMES.put("double", Double.TYPE);
        PRIMITIVE_NAMES.put("void", Void.TYPE);
    }

    private static class NullInstance
    extends Configured
    implements Writable {
        private Class<?> declaredClass;

        public NullInstance() {
            super(null);
        }

        public NullInstance(Class declaredClass, Configuration conf) {
            super(conf);
            this.declaredClass = declaredClass;
        }

        public void readFields(DataInput in) throws IOException {
            String className = UTF8.readString(in);
            this.declaredClass = (Class)PRIMITIVE_NAMES.get(className);
            if (this.declaredClass == null) {
                try {
                    this.declaredClass = this.getConf().getClassByName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }

        public void write(DataOutput out) throws IOException {
            UTF8.writeString(out, this.declaredClass.getName());
        }
    }
}

