/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class BlockMetaDataInfo
extends Block {
    static final WritableFactory FACTORY = new WritableFactory(){

        public Writable newInstance() {
            return new BlockMetaDataInfo();
        }
    };
    private long lastScanTime;

    public BlockMetaDataInfo() {
    }

    public BlockMetaDataInfo(Block b, long lastScanTime) {
        super(b);
        this.lastScanTime = lastScanTime;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.lastScanTime);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.lastScanTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(BlockMetaDataInfo.class, FACTORY);
    }
}

