/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.Daemon;

class PendingReplicationBlocks {
    private Map<Block, PendingBlockInfo> pendingReplications;
    private ArrayList<Block> timedOutItems;
    Daemon timerThread = null;
    private volatile boolean fsRunning = true;
    private long timeout = 300000L;
    private long defaultRecheckInterval = 300000L;

    PendingReplicationBlocks() {
        this.init();
    }

    void init() {
        this.pendingReplications = new HashMap<Block, PendingBlockInfo>();
        this.timedOutItems = new ArrayList();
        this.timerThread = new Daemon(new PendingReplicationMonitor());
        this.timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found != null) {
                FSNamesystem.LOG.debug("Removing pending replication for block" + block);
                found.decrementReplicas();
                if (found.getNumReplicas() <= 0) {
                    this.pendingReplications.remove(block);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumReplicas(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found != null) {
                return found.getNumReplicas();
            }
        }
        return 0;
    }

    class PendingReplicationMonitor
    implements Runnable {
        PendingReplicationMonitor() {
        }

        public void run() {
            while (PendingReplicationBlocks.this.fsRunning) {
                long period = Math.min(PendingReplicationBlocks.this.defaultRecheckInterval, PendingReplicationBlocks.this.timeout);
                try {
                    this.pendingReplicationCheck();
                    Thread.sleep(period);
                }
                catch (InterruptedException ie) {
                    FSNamesystem.LOG.debug("PendingReplicationMonitor thread received exception. " + ie);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pendingReplicationCheck() {
            Map map = PendingReplicationBlocks.this.pendingReplications;
            synchronized (map) {
                Iterator iter = PendingReplicationBlocks.this.pendingReplications.entrySet().iterator();
                long now = FSNamesystem.now();
                FSNamesystem.LOG.debug("PendingReplicationMonitor checking Q");
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    PendingBlockInfo pendingBlock = (PendingBlockInfo)entry.getValue();
                    if (now <= pendingBlock.getTimeStamp() + PendingReplicationBlocks.this.timeout) continue;
                    Block block = (Block)entry.getKey();
                    ArrayList arrayList = PendingReplicationBlocks.this.timedOutItems;
                    synchronized (arrayList) {
                        PendingReplicationBlocks.this.timedOutItems.add(block);
                    }
                    FSNamesystem.LOG.warn("PendingReplicationMonitor timed out block " + block);
                    iter.remove();
                }
            }
        }
    }

    static class PendingBlockInfo {
        private long timeStamp;
        private int numReplicasInProgress;

        long getTimeStamp() {
            return this.timeStamp;
        }

        void decrementReplicas() {
            --this.numReplicasInProgress;
            assert (this.numReplicasInProgress >= 0);
        }

        int getNumReplicas() {
            return this.numReplicasInProgress;
        }
    }
}

