/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaseManager {
    public static final Log LOG = LogFactory.getLog(LeaseManager.class);
    private final FSNamesystem fsnamesystem;
    private long softLimit;
    private SortedMap<String, Lease> leases;
    private SortedSet<Lease> sortedLeases;
    private SortedMap<String, Lease> sortedLeasesByPath;

    Lease getLease(String holder) {
        return (Lease)this.leases.get(holder);
    }

    synchronized void addLease(String holder, String src) {
        Lease lease = this.getLease(holder);
        if (lease == null) {
            lease = new Lease(holder);
            this.leases.put(holder, lease);
            this.sortedLeases.add(lease);
        } else {
            this.renewLease(lease);
        }
        this.sortedLeasesByPath.put(src, lease);
        lease.paths.add(src);
    }

    synchronized void removeLease(Lease lease, String src) {
        this.sortedLeasesByPath.remove(src);
        if (!lease.removePath(src)) {
            LOG.error(src + " not found in lease.paths (=" + lease.paths + ")");
        }
        if (!lease.hasPath()) {
            this.leases.remove(lease.holder);
            if (!this.sortedLeases.remove(lease)) {
                LOG.error(lease + " not found in sortedLeases");
            }
        }
    }

    synchronized void removeLease(String holder, String src) {
        Lease lease = this.getLease(holder);
        if (lease != null) {
            this.removeLease(lease, src);
        }
    }

    synchronized String findPath(INodeFileUnderConstruction pendingFile) throws IOException {
        String src;
        Lease lease = this.getLease(pendingFile.clientName);
        if (lease != null && (src = lease.findPath(pendingFile)) != null) {
            return src;
        }
        throw new IOException("pendingFile (=" + pendingFile + ") not found." + "(lease=" + lease + ")");
    }

    synchronized void renewLease(String holder) {
        this.renewLease(this.getLease(holder));
    }

    synchronized void renewLease(Lease lease) {
        if (lease != null) {
            this.sortedLeases.remove(lease);
            lease.renew();
            this.sortedLeases.add(lease);
        }
    }

    synchronized void changeLease(String src, String dst, String overwrite, String replaceBy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getClass().getSimpleName() + ".changelease: " + " src=" + src + ", dest=" + dst + ", overwrite=" + overwrite + ", replaceBy=" + replaceBy);
        }
        int len = overwrite.length();
        for (Map.Entry<String, Lease> entry : LeaseManager.findLeaseWithPrefixPath(src, this.sortedLeasesByPath)) {
            String oldpath = entry.getKey();
            Lease lease = entry.getValue();
            String newpath = replaceBy + oldpath.substring(len);
            if (LOG.isDebugEnabled()) {
                LOG.debug("changeLease: replacing " + oldpath + " with " + newpath);
            }
            lease.replacePath(oldpath, newpath);
            this.sortedLeasesByPath.remove(oldpath);
            this.sortedLeasesByPath.put(newpath, lease);
        }
    }

    synchronized void removeLeaseWithPrefixPath(String string) {
        for (Map.Entry<String, Lease> entry : LeaseManager.findLeaseWithPrefixPath(string, this.sortedLeasesByPath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(LeaseManager.class.getSimpleName() + ".removeLeaseWithPrefixPath: entry=" + entry);
            }
            this.removeLease(entry.getValue(), entry.getKey());
        }
    }

    private static List<Map.Entry<String, Lease>> findLeaseWithPrefixPath(String string, SortedMap<String, Lease> sortedMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(LeaseManager.class.getSimpleName() + ".findLease: prefix=" + string);
        }
        ArrayList<Map.Entry<String, Lease>> arrayList = new ArrayList<Map.Entry<String, Lease>>();
        int n = string.length();
        for (Map.Entry<String, Lease> entry : sortedMap.tailMap(string).entrySet()) {
            String string2 = entry.getKey();
            if (!string2.startsWith(string)) {
                return arrayList;
            }
            if (string2.length() != n && string2.charAt(n) != '/') continue;
            arrayList.add(entry);
        }
        return arrayList;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "= {" + "\n leases=" + this.leases + "\n sortedLeases=" + this.sortedLeases + "\n sortedLeasesByPath=" + this.sortedLeasesByPath + "\n}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Lease
    implements Comparable<Lease> {
        private final String holder;
        private long lastUpdate;
        private final Collection<String> paths = new TreeSet<String>();

        private Lease(String holder) {
            this.holder = holder;
            this.renew();
        }

        private void renew() {
            this.lastUpdate = FSNamesystem.now();
        }

        public boolean expiredSoftLimit() {
            return FSNamesystem.now() - this.lastUpdate > LeaseManager.this.softLimit;
        }

        private String findPath(INodeFileUnderConstruction pendingFile) {
            for (String src : this.paths) {
                if (((LeaseManager)LeaseManager.this).fsnamesystem.dir.getFileINode(src) != pendingFile) continue;
                return src;
            }
            return null;
        }

        boolean hasPath() {
            return !this.paths.isEmpty();
        }

        boolean removePath(String src) {
            return this.paths.remove(src);
        }

        public String toString() {
            return "[Lease.  Holder: " + this.holder + ", pendingcreates: " + this.paths.size() + "]";
        }

        @Override
        public int compareTo(Lease o) {
            Lease l1 = this;
            Lease l2 = o;
            long lu1 = l1.lastUpdate;
            long lu2 = l2.lastUpdate;
            if (lu1 < lu2) {
                return -1;
            }
            if (lu1 > lu2) {
                return 1;
            }
            return l1.holder.compareTo(l2.holder);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Lease)) {
                return false;
            }
            Lease obj = (Lease)o;
            return this.lastUpdate == obj.lastUpdate && this.holder.equals(obj.holder);
        }

        public int hashCode() {
            return this.holder.hashCode();
        }

        void replacePath(String oldpath, String newpath) {
            this.paths.remove(oldpath);
            this.paths.add(newpath);
        }
    }
}

