/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredDatanodeException;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.Host2NodesMap;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.PendingReplicationBlocks;
import org.apache.hadoop.hdfs.server.namenode.PermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.ReplicationTargetChooser;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.UpgradeManagerNamenode;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSNamesystem
implements FSConstants {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<Formatter> auditFormatter = new ThreadLocal<Formatter>(){

        @Override
        protected Formatter initialValue() {
            return new Formatter(new StringBuilder("ugi=%s\tip=%s\tcmd=%s\tsrc=%s\tdst=%s\tperm=%s".length() * 4));
        }
    };
    public static final Log auditLog = LogFactory.getLog(FSNamesystem.class.getName() + ".audit");
    private boolean isPermissionEnabled;
    private UserGroupInformation fsOwner;
    private String supergroup;
    private long capacityTotal;
    private long capacityUsed;
    private long capacityRemaining;
    private int totalLoad;
    volatile long excessBlocksCount;
    volatile long pendingDeletionBlocksCount;
    public FSDirectory dir;
    final BlocksMap blocksMap;
    public CorruptReplicasMap corruptReplicas;
    NavigableMap<String, DatanodeDescriptor> datanodeMap;
    private Map<String, Collection<Block>> recentInvalidateSets;
    Map<String, Collection<Block>> excessReplicateMap;
    Random r;
    ArrayList<DatanodeDescriptor> heartbeats;
    private UnderReplicatedBlocks neededReplications;
    private PendingReplicationBlocks pendingReplications;
    public LeaseManager leaseManager;
    Daemon smmthread;
    private volatile boolean fsRunning;
    long systemStart;
    private int maxReplication;
    private int maxReplicationStreams;
    private int minReplication;
    private boolean supportAppends;
    public static FSNamesystem fsNamesystemObject;
    private SafeModeInfo safeMode;
    private Host2NodesMap host2DataNodeMap;
    NetworkTopology clusterMap;
    private DNSToSwitchMapping dnsToSwitchMapping;
    ReplicationTargetChooser replicator;
    private HostsFileReader hostsReader;
    private long maxFsObjects;
    private final GenerationStamp generationStamp;
    private int blockInvalidateLimit;
    private long accessTimePrecision;
    static Random randBlockId;
    UpgradeManagerNamenode upgradeManager;

    private static final void logAuditEvent(UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, FileStatus stat2) {
        Formatter fmt = auditFormatter.get();
        ((StringBuilder)fmt.out()).setLength(0);
        auditLog.info(fmt.format("ugi=%s\tip=%s\tcmd=%s\tsrc=%s\tdst=%s\tperm=%s", ugi, addr, cmd, src, dst, stat2 == null ? null : stat2.getOwner() + ':' + stat2.getGroup() + ':' + stat2.getPermission()).toString());
    }

    public static FSNamesystem getFSNamesystem() {
        return fsNamesystemObject;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    private int getReplication(Block block) {
        INodeFile iNodeFile = this.blocksMap.getINode(block);
        if (iNodeFile == null) {
            return 0;
        }
        assert (!iNodeFile.isDirectory()) : "Block cannot belong to a directory.";
        return iNodeFile.getReplication();
    }

    synchronized void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        NumberReplicas repl = this.countNodes(block);
        int curExpectedReplicas = this.getReplication(block);
        this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
    }

    public synchronized void setPermission(String string, FsPermission fsPermission) throws IOException {
        this.checkOwner(string);
        this.dir.setPermission(string, fsPermission);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            FileStatus fileStatus = this.dir.getFileInfo(string);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "setPermission", string, null, fileStatus);
        }
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws IOException {
        LocatedBlocks blocks;
        if (this.isPermissionEnabled) {
            this.checkPathAccess(src, FsAction.READ);
        }
        if ((blocks = this.getBlockLocations(src, offset, length, true)) != null) {
            DatanodeDescriptor client = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            for (LocatedBlock b : blocks.getLocatedBlocks()) {
                this.clusterMap.pseudoSortByDistance(client, b.getLocations());
            }
        }
        return blocks;
    }

    public LocatedBlocks getBlockLocations(String string, long l, long l2, boolean bl) throws IOException {
        if (l < 0L) {
            throw new IOException("Negative offset is not supported. File: " + string);
        }
        if (l2 < 0L) {
            throw new IOException("Negative length is not supported. File: " + string);
        }
        LocatedBlocks locatedBlocks = this.getBlockLocationsInternal(string, this.dir.getFileINode(string), l, l2, Integer.MAX_VALUE, bl);
        if (auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "open", string, null, null);
        }
        return locatedBlocks;
    }

    private synchronized LocatedBlocks getBlockLocationsInternal(String string, INodeFile iNodeFile, long l, long l2, int n, boolean bl) throws IOException {
        BlocksMap.BlockInfo[] blockInfoArray;
        if (iNodeFile == null) {
            return null;
        }
        if (bl && this.isAccessTimeSupported()) {
            this.dir.setTimes(string, iNodeFile, -1L, FSNamesystem.now(), false);
        }
        if ((blockInfoArray = iNodeFile.getBlocks()) == null) {
            return null;
        }
        if (blockInfoArray.length == 0) {
            return iNodeFile.createLocatedBlocks(new ArrayList<LocatedBlock>(blockInfoArray.length));
        }
        ArrayList<LocatedBlock> arrayList = new ArrayList<LocatedBlock>(blockInfoArray.length);
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = blockInfoArray[0].getNumBytes() == 0L ? 0 : blockInfoArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            l4 = blockInfoArray[n2].getNumBytes();
            assert (l4 > 0L) : "Block of size 0";
            if (l3 + l4 > l) break;
            l3 += l4;
        }
        if (n3 > 0 && n2 == n3) {
            return null;
        }
        long l5 = l + l2;
        do {
            int n4;
            int n5 = this.blocksMap.numNodes(blockInfoArray[n2]);
            int n6 = this.countNodes(blockInfoArray[n2]).corruptReplicas();
            if (n6 != (n4 = this.corruptReplicas.numCorruptReplicas(blockInfoArray[n2]))) {
                LOG.warn("Inconsistent number of corrupt replicas for " + blockInfoArray[n2] + "blockMap has " + n6 + " but corrupt replicas map has " + n4);
            }
            boolean bl2 = n6 == n5;
            int n7 = bl2 ? n5 : n5 - n6;
            DatanodeInfo[] datanodeInfoArray = new DatanodeDescriptor[n7];
            if (n7 > 0) {
                n5 = 0;
                Iterator<DatanodeDescriptor> iterator = this.blocksMap.nodeIterator(blockInfoArray[n2]);
                while (iterator.hasNext()) {
                    DatanodeDescriptor datanodeDescriptor = iterator.next();
                    boolean bl3 = this.corruptReplicas.isReplicaCorrupt(blockInfoArray[n2], datanodeDescriptor);
                    if (!bl2 && (bl2 || bl3)) continue;
                    datanodeInfoArray[n5++] = datanodeDescriptor;
                }
            }
            arrayList.add(new LocatedBlock(blockInfoArray[n2], datanodeInfoArray, l3, bl2));
        } while ((l3 += blockInfoArray[++n2].getNumBytes()) < l5 && n2 < blockInfoArray.length && arrayList.size() < n);
        return iNodeFile.createLocatedBlocks(arrayList);
    }

    public synchronized void setTimes(String string, long l, long l2) throws IOException {
        INodeFile iNodeFile;
        if (!this.isAccessTimeSupported() && l2 != -1L) {
            throw new IOException("Access time for hdfs is not configured.  Please set dfs.support.accessTime configuration parameter.");
        }
        if (this.isPermissionEnabled) {
            this.checkPathAccess(string, FsAction.WRITE);
        }
        if ((iNodeFile = this.dir.getFileINode(string)) != null) {
            this.dir.setTimes(string, iNodeFile, l, l2, true);
            if (auditLog.isInfoEnabled()) {
                FileStatus fileStatus = this.dir.getFileInfo(string);
                FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "setTimes", string, null, fileStatus);
            }
        } else {
            throw new FileNotFoundException("File " + string + " does not exist.");
        }
    }

    private void verifyReplication(String string, short s, String string2) throws IOException {
        String string3 = "file " + string + (string2 != null ? " on client " + string2 : "") + ".\n" + "Requested replication " + s;
        if (s > this.maxReplication) {
            throw new IOException(string3 + " exceeds maximum " + this.maxReplication);
        }
        if (s < this.minReplication) {
            throw new IOException(string3 + " is less than the required minimum " + this.minReplication);
        }
    }

    void startFile(String string, PermissionStatus permissionStatus, String string2, String string3, boolean bl, short s, long l) throws IOException {
        this.startFileInternal(string, permissionStatus, string2, string3, bl, false, s, l);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            FileStatus fileStatus = this.dir.getFileInfo(string);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "create", string, null, fileStatus);
        }
    }

    private synchronized void startFileInternal(String string, PermissionStatus permissionStatus, String string2, String string3, boolean bl, boolean bl2, short s, long l) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.startFile: src=" + string + ", holder=" + string2 + ", clientMachine=" + string3 + ", replication=" + s + ", overwrite=" + bl + ", append=" + bl2);
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create file" + string, this.safeMode);
        }
        if (!DFSUtil.isValidName(string)) {
            throw new IOException("Invalid file name: " + string);
        }
        boolean bl3 = this.dir.exists(string);
        if (bl3 && this.dir.isDir(string)) {
            throw new IOException("Cannot create file " + string + "; already exists as a directory.");
        }
        if (this.isPermissionEnabled) {
            if (bl2 || bl && bl3) {
                this.checkPathAccess(string, FsAction.WRITE);
            } else {
                this.checkAncestorAccess(string, FsAction.WRITE);
            }
        }
        try {
            INodeFile iNodeFile = this.dir.getFileINode(string);
            if (iNodeFile != null && iNodeFile.isUnderConstruction()) {
                INodeFileUnderConstruction iNodeFileUnderConstruction = (INodeFileUnderConstruction)iNodeFile;
                LeaseManager.Lease lease = this.leaseManager.getLease(string2);
                if (lease != null) {
                    throw new AlreadyBeingCreatedException("failed to create file " + string + " for " + string2 + " on client " + string3 + " because current leaseholder is trying to recreate file.");
                }
                lease = this.leaseManager.getLease(iNodeFileUnderConstruction.clientName);
                if (lease == null) {
                    throw new AlreadyBeingCreatedException("failed to create file " + string + " for " + string2 + " on client " + string3 + " because pendingCreates is non-null but no leases found.");
                }
                if (lease.expiredSoftLimit()) {
                    LOG.info("startFile: recover lease " + lease + ", src=" + string);
                    this.internalReleaseLease(lease, string);
                }
                throw new AlreadyBeingCreatedException("failed to create file " + string + " for " + string2 + " on client " + string3 + ", because this file is already being created by " + iNodeFileUnderConstruction.getClientName() + " on " + iNodeFileUnderConstruction.getClientMachine());
            }
            try {
                this.verifyReplication(string, s, string3);
            }
            catch (IOException iOException) {
                throw new IOException("failed to create " + iOException.getMessage());
            }
            if (bl2) {
                if (iNodeFile == null) {
                    throw new FileNotFoundException("failed to append to non-existent file " + string + " on client " + string3);
                }
                if (((INode)iNodeFile).isDirectory()) {
                    throw new IOException("failed to append to directory " + string + " on client " + string3);
                }
            } else if (!this.dir.isValidToCreate(string)) {
                if (bl) {
                    this.delete(string, true);
                } else {
                    throw new IOException("failed to create file " + string + " on client " + string3 + " either because the filename is invalid or the file exists");
                }
            }
            DatanodeDescriptor datanodeDescriptor = this.host2DataNodeMap.getDatanodeByHost(string3);
            if (bl2) {
                INodeFile iNodeFile2 = iNodeFile;
                INodeFileUnderConstruction iNodeFileUnderConstruction = new INodeFileUnderConstruction(iNodeFile2.getLocalNameBytes(), iNodeFile2.getReplication(), iNodeFile2.getModificationTime(), iNodeFile2.getPreferredBlockSize(), iNodeFile2.getBlocks(), iNodeFile2.getPermissionStatus(), string2, string3, datanodeDescriptor);
                this.dir.replaceNode(string, iNodeFile2, iNodeFileUnderConstruction);
                this.leaseManager.addLease(iNodeFileUnderConstruction.clientName, string);
            } else {
                this.checkFsObjectLimit();
                long l2 = this.nextGenerationStamp();
                INodeFileUnderConstruction iNodeFileUnderConstruction = this.dir.addFile(string, permissionStatus, s, l, string2, string3, datanodeDescriptor, l2);
                if (iNodeFileUnderConstruction == null) {
                    throw new IOException("DIR* NameSystem.startFile: Unable to add file to namespace.");
                }
                this.leaseManager.addLease(iNodeFileUnderConstruction.clientName, string);
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* NameSystem.startFile: add " + string + " to namespace for " + string2);
                }
            }
        }
        catch (IOException iOException) {
            NameNode.stateChangeLog.warn("DIR* NameSystem.startFile: " + iOException.getMessage());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock appendFile(String string, String string2, String string3) throws IOException {
        if (!this.supportAppends) {
            throw new IOException("Append to hdfs not supported. Please refer to dfs.support.append configuration parameter.");
        }
        this.startFileInternal(string, null, string2, string3, false, true, (short)this.maxReplication, 0L);
        this.getEditLog().logSync();
        LocatedBlock locatedBlock = null;
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            INodeFileUnderConstruction iNodeFileUnderConstruction = (INodeFileUnderConstruction)this.dir.getFileINode(string);
            BlocksMap.BlockInfo[] blockInfoArray = iNodeFileUnderConstruction.getBlocks();
            if (blockInfoArray != null && blockInfoArray.length > 0) {
                BlocksMap.BlockInfo blockInfo = blockInfoArray[blockInfoArray.length - 1];
                BlocksMap.BlockInfo blockInfo2 = this.blocksMap.getStoredBlock(blockInfo);
                if (iNodeFileUnderConstruction.getPreferredBlockSize() > blockInfo2.getNumBytes()) {
                    long l = iNodeFileUnderConstruction.computeContentSummary().getLength();
                    DatanodeInfo[] datanodeInfoArray = new DatanodeDescriptor[this.blocksMap.numNodes(blockInfo)];
                    Iterator<DatanodeDescriptor> iterator = this.blocksMap.nodeIterator(blockInfo);
                    int n = 0;
                    while (iterator != null && iterator.hasNext()) {
                        datanodeInfoArray[n] = iterator.next();
                        ++n;
                    }
                    for (n = 0; n < datanodeInfoArray.length; ++n) {
                        datanodeInfoArray[n].removeBlock(blockInfo2);
                    }
                    iNodeFileUnderConstruction.setLastBlock(blockInfo2, (DatanodeDescriptor[])datanodeInfoArray);
                    locatedBlock = new LocatedBlock(blockInfo, datanodeInfoArray, l - blockInfo2.getNumBytes());
                    this.updateNeededReplications(blockInfo, 0, 0);
                    for (Collection<Block> collection : this.recentInvalidateSets.values()) {
                        if (!collection.remove(blockInfo)) continue;
                        --this.pendingDeletionBlocksCount;
                    }
                }
            }
        }
        if (locatedBlock != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.appendFile: file " + string + " for " + string2 + " at " + string3 + " block " + locatedBlock.getBlock() + " block size " + locatedBlock.getBlock().getNumBytes());
        }
        if (auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "append", string, null, null);
        }
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatedBlock getAdditionalBlock(String string, String string2) throws IOException {
        DatanodeDescriptor datanodeDescriptor = null;
        Block block = null;
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.getAdditionalBlock: file " + string + " for " + string2);
        DatanodeInfo[] datanodeInfoArray = this;
        synchronized (this) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + string, this.safeMode);
            }
            this.checkFsObjectLimit();
            DatanodeInfo[] datanodeInfoArray2 = this.checkLease(string, string2);
            if (!this.checkFileProgress((INodeFile)datanodeInfoArray2, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + string);
            }
            long l = datanodeInfoArray2.computeContentSummary().getLength();
            long l2 = datanodeInfoArray2.getPreferredBlockSize();
            datanodeDescriptor = datanodeInfoArray2.getClientNode();
            short s = datanodeInfoArray2.getReplication();
            // ** MonitorExit[datanodeInfoArray] (shouldn't be in output)
            datanodeInfoArray = this.replicator.chooseTarget(s, datanodeDescriptor, null, l2);
            if (datanodeInfoArray.length < this.minReplication) {
                throw new IOException("File " + string + " could only be replicated to " + datanodeInfoArray.length + " nodes, instead of " + this.minReplication);
            }
            datanodeInfoArray2 = this;
            synchronized (this) {
                INode[] iNodeArray = this.dir.getExistingPathINodes(string);
                int n = iNodeArray.length;
                super.checkLease(string, string2, iNodeArray[n - 1]);
                INodeFileUnderConstruction iNodeFileUnderConstruction = (INodeFileUnderConstruction)iNodeArray[n - 1];
                if (!this.checkFileProgress(iNodeFileUnderConstruction, false)) {
                    throw new NotReplicatedYetException("Not replicated yet:" + string);
                }
                block = super.allocateBlock(string, iNodeArray);
                iNodeFileUnderConstruction.setTargets((DatanodeDescriptor[])datanodeInfoArray);
                for (DatanodeDescriptor datanodeDescriptor2 : datanodeInfoArray) {
                    datanodeDescriptor2.incBlocksScheduled();
                }
                // ** MonitorExit[datanodeInfoArray2] (shouldn't be in output)
                return new LocatedBlock(block, datanodeInfoArray, l);
            }
        }
    }

    public synchronized boolean abandonBlock(Block block, String string, String string2) throws IOException {
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: " + block + "of file " + string);
        INodeFileUnderConstruction iNodeFileUnderConstruction = this.checkLease(string, string2);
        this.dir.removeBlock(string, iNodeFileUnderConstruction, block);
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: " + block + " is removed from pendingCreates");
        return true;
    }

    private INodeFileUnderConstruction checkLease(String src, String holder) throws IOException {
        INodeFile file = this.dir.getFileINode(src);
        this.checkLease(src, holder, file);
        return (INodeFileUnderConstruction)file;
    }

    private void checkLease(String string, String string2, INode iNode) throws IOException {
        if (iNode == null || iNode.isDirectory()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(string2);
            throw new LeaseExpiredException("No lease on " + string + " File does not exist. " + (lease != null ? lease.toString() : "Holder " + string2 + " does not have any open files."));
        }
        if (!iNode.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(string2);
            throw new LeaseExpiredException("No lease on " + string + " File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + string2 + " does not have any open files."));
        }
        INodeFileUnderConstruction iNodeFileUnderConstruction = (INodeFileUnderConstruction)iNode;
        if (string2 != null && !iNodeFileUnderConstruction.getClientName().equals(string2)) {
            throw new LeaseExpiredException("Lease mismatch on " + string + " owned by " + iNodeFileUnderConstruction.getClientName() + " but is accessed by " + string2);
        }
    }

    public CompleteFileStatus completeFile(String src, String holder) throws IOException {
        CompleteFileStatus status = this.completeFileInternal(src, holder);
        this.getEditLog().logSync();
        return status;
    }

    private synchronized CompleteFileStatus completeFileInternal(String string, String string2) throws IOException {
        NameNode.stateChangeLog.debug("DIR* NameSystem.completeFile: " + string + " for " + string2);
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot complete file " + string, this.safeMode);
        }
        INodeFile iNodeFile = this.dir.getFileINode(string);
        INodeFileUnderConstruction iNodeFileUnderConstruction = null;
        Block[] blockArray = null;
        if (iNodeFile != null && iNodeFile.isUnderConstruction()) {
            iNodeFileUnderConstruction = (INodeFileUnderConstruction)iNodeFile;
            blockArray = this.dir.getFileBlocks(string);
        }
        if (blockArray == null) {
            NameNode.stateChangeLog.warn("DIR* NameSystem.completeFile: failed to complete " + string + " because dir.getFileBlocks() is null " + " and pendingFile is " + (iNodeFileUnderConstruction == null ? "null" : "from " + iNodeFileUnderConstruction.getClientMachine()));
            return CompleteFileStatus.OPERATION_FAILED;
        }
        if (!this.checkFileProgress(iNodeFileUnderConstruction, true)) {
            return CompleteFileStatus.STILL_WAITING;
        }
        this.finalizeINodeFileUnderConstruction(string, iNodeFileUnderConstruction);
        NameNode.stateChangeLog.info("DIR* NameSystem.completeFile: file " + string + " is closed by " + string2);
        return CompleteFileStatus.COMPLETE_SUCCESS;
    }

    private void checkReplicationFactor(INodeFile file) {
        short numExpectedReplicas = file.getReplication();
        BlocksMap.BlockInfo[] pendingBlocks = file.getBlocks();
        int nrBlocks = pendingBlocks.length;
        for (int i = 0; i < nrBlocks; ++i) {
            NumberReplicas number = this.countNodes(pendingBlocks[i]);
            if (number.liveReplicas() >= numExpectedReplicas) continue;
            this.neededReplications.add(pendingBlocks[i], number.liveReplicas(), number.decommissionedReplicas, numExpectedReplicas);
        }
    }

    private Block allocateBlock(String string, INode[] iNodeArray) throws IOException {
        Block block = new Block(randBlockId.nextLong(), 0L, 0L);
        while (this.isValidBlock(block)) {
            block.setBlockId(randBlockId.nextLong());
        }
        block.setGenerationStamp(this.getGenerationStamp());
        block = this.dir.addBlock(string, iNodeArray, block);
        NameNode.stateChangeLog.info("BLOCK* NameSystem.allocateBlock: " + string + ". " + block);
        return block;
    }

    synchronized boolean checkFileProgress(INodeFile v, boolean checkall) {
        if (checkall) {
            for (BlocksMap.BlockInfo block : v.getBlocks()) {
                if (this.blocksMap.numNodes(block) >= this.minReplication) continue;
                return false;
            }
        } else {
            Block b = v.getPenultimateBlock();
            if (b != null && this.blocksMap.numNodes(b) < this.minReplication) {
                return false;
            }
        }
        return true;
    }

    void removeFromInvalidates(String storageID) {
        Collection<Block> blocks = this.recentInvalidateSets.remove(storageID);
        if (blocks != null) {
            this.pendingDeletionBlocksCount -= (long)blocks.size();
        }
    }

    void addToInvalidates(Block block, DatanodeInfo datanodeInfo) {
        this.addToInvalidatesNoLog(block, datanodeInfo);
        NameNode.stateChangeLog.info("BLOCK* NameSystem.addToInvalidates: " + block.getBlockName() + " is added to invalidSet of " + datanodeInfo.getName());
    }

    private void addToInvalidatesNoLog(Block b, DatanodeInfo n) {
        Collection<Block> invalidateSet = this.recentInvalidateSets.get(n.getStorageID());
        if (invalidateSet == null) {
            invalidateSet = new HashSet<Block>();
            this.recentInvalidateSets.put(n.getStorageID(), invalidateSet);
        }
        if (invalidateSet.add(b)) {
            ++this.pendingDeletionBlocksCount;
        }
    }

    private void addToInvalidates(Block b) {
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            this.addToInvalidates(b, node);
        }
    }

    public synchronized void markBlockAsCorrupt(Block block, DatanodeInfo datanodeInfo) throws IOException {
        DatanodeDescriptor datanodeDescriptor = this.getDatanode(datanodeInfo);
        if (datanodeDescriptor == null) {
            throw new IOException("Cannot mark block" + block.getBlockName() + " as corrupt because datanode " + datanodeInfo.getName() + " does not exist. ");
        }
        BlocksMap.BlockInfo blockInfo = this.blocksMap.getStoredBlock(block);
        if (blockInfo == null) {
            NameNode.stateChangeLog.info("BLOCK NameSystem.markBlockAsCorrupt: block " + block + " could not be marked " + "as corrupt as it does not exists in " + "blocksMap");
        } else {
            INodeFile iNodeFile = blockInfo.getINode();
            if (iNodeFile == null) {
                NameNode.stateChangeLog.info("BLOCK NameSystem.markBlockAsCorrupt: block " + block + " could not be marked " + "as corrupt as it does not belong to " + "any file");
                this.addToInvalidates(blockInfo, datanodeDescriptor);
                return;
            }
            this.corruptReplicas.addToCorruptReplicasMap(blockInfo, datanodeDescriptor);
            if (this.countNodes(blockInfo).liveReplicas() > iNodeFile.getReplication()) {
                this.invalidateBlock(blockInfo, datanodeDescriptor);
            } else {
                this.updateNeededReplications(blockInfo, -1, 0);
            }
        }
    }

    public synchronized void invalidateBlock(Block block, DatanodeInfo datanodeInfo) throws IOException {
        NameNode.stateChangeLog.info("DIR* NameSystem.invalidateBlock: " + block + " on " + datanodeInfo.getName());
        DatanodeDescriptor datanodeDescriptor = this.getDatanode(datanodeInfo);
        if (datanodeDescriptor == null) {
            throw new IOException("Cannot invalidate block " + block + " because datanode " + datanodeInfo.getName() + " does not exist.");
        }
        int n = this.countNodes(block).liveReplicas();
        if (n > 1) {
            this.addToInvalidates(block, datanodeInfo);
            this.removeStoredBlock(block, datanodeDescriptor);
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.invalidateBlocks: " + block + " on " + datanodeInfo.getName() + " listed for deletion.");
        } else {
            NameNode.stateChangeLog.info("BLOCK* NameSystem.invalidateBlocks: " + block + " on " + datanodeInfo.getName() + " is the only copy and was not deleted.");
        }
    }

    public boolean renameTo(String string, String string2) throws IOException {
        boolean bl = this.renameToInternal(string, string2);
        this.getEditLog().logSync();
        if (bl && auditLog.isInfoEnabled()) {
            FileStatus fileStatus = this.dir.getFileInfo(string2);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "rename", string, string2, fileStatus);
        }
        return bl;
    }

    private synchronized boolean renameToInternal(String string, String string2) throws IOException {
        Object object;
        NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: " + string + " to " + string2);
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + string, this.safeMode);
        }
        if (!DFSUtil.isValidName(string2)) {
            throw new IOException("Invalid name: " + string2);
        }
        if (this.isPermissionEnabled) {
            object = this.dir.isDir(string2) ? string2 + "/" + new Path(string).getName() : string2;
            this.checkParentAccess(string, FsAction.WRITE);
            this.checkAncestorAccess((String)object, FsAction.WRITE);
        }
        object = this.dir.getFileInfo(string2);
        if (this.dir.renameTo(string, string2)) {
            this.changeLease(string, string2, (FileStatus)object);
            return true;
        }
        return false;
    }

    public boolean delete(String string, boolean bl) throws IOException {
        if (!bl && !this.dir.isDirEmpty(string)) {
            throw new IOException(string + " is non empty");
        }
        boolean bl2 = this.deleteInternal(string, true);
        this.getEditLog().logSync();
        if (bl2 && auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "delete", string, null, null);
        }
        return bl2;
    }

    synchronized boolean deleteInternal(String string, boolean bl) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.delete: " + string);
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot delete " + string, this.safeMode);
        }
        if (bl && this.isPermissionEnabled) {
            this.checkPermission(string, false, null, FsAction.WRITE, null, FsAction.ALL);
        }
        return this.dir.delete(string) != null;
    }

    void removePathAndBlocks(String src, List<Block> blocks) throws IOException {
        this.leaseManager.removeLeaseWithPrefixPath(src);
        for (Block b : blocks) {
            this.blocksMap.removeINode(b);
            this.corruptReplicas.removeFromCorruptReplicasMap(b);
            this.addToInvalidates(b);
        }
    }

    FileStatus getFileInfo(String src) throws IOException {
        if (this.isPermissionEnabled) {
            this.checkTraverse(src);
        }
        return this.dir.getFileInfo(src);
    }

    public boolean mkdirs(String string, PermissionStatus permissionStatus) throws IOException {
        boolean bl = this.mkdirsInternal(string, permissionStatus);
        this.getEditLog().logSync();
        if (bl && auditLog.isInfoEnabled()) {
            FileStatus fileStatus = this.dir.getFileInfo(string);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "mkdirs", string, null, fileStatus);
        }
        return bl;
    }

    private synchronized boolean mkdirsInternal(String string, PermissionStatus permissionStatus) throws IOException {
        NameNode.stateChangeLog.debug("DIR* NameSystem.mkdirs: " + string);
        if (this.isPermissionEnabled) {
            this.checkTraverse(string);
        }
        if (this.dir.isDir(string)) {
            return true;
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create directory " + string, this.safeMode);
        }
        if (!DFSUtil.isValidName(string)) {
            throw new IOException("Invalid directory name: " + string);
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(string, FsAction.WRITE);
        }
        this.checkFsObjectLimit();
        if (!this.dir.mkdirs(string, permissionStatus, false, FSNamesystem.now())) {
            throw new IOException("Invalid directory name: " + string);
        }
        return true;
    }

    void internalReleaseLease(LeaseManager.Lease lease, String string) throws IOException {
        LOG.info("Recovering lease=" + lease + ", src=" + string);
        INodeFile iNodeFile = this.dir.getFileINode(string);
        if (iNodeFile == null) {
            String string2 = "DIR* NameSystem.internalReleaseCreate: attempt to release a create lock on " + string + " file does not exist.";
            NameNode.stateChangeLog.warn(string2);
            throw new IOException(string2);
        }
        if (!iNodeFile.isUnderConstruction()) {
            String string3 = "DIR* NameSystem.internalReleaseCreate: attempt to release a create lock on " + string + " but file is already closed.";
            NameNode.stateChangeLog.warn(string3);
            throw new IOException(string3);
        }
        INodeFileUnderConstruction iNodeFileUnderConstruction = (INodeFileUnderConstruction)iNodeFile;
        if (iNodeFileUnderConstruction.getTargets() == null || iNodeFileUnderConstruction.getTargets().length == 0) {
            if (iNodeFileUnderConstruction.getBlocks().length == 0) {
                this.finalizeINodeFileUnderConstruction(string, iNodeFileUnderConstruction);
                NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: No blocks found, lease removed.");
                return;
            }
            BlocksMap.BlockInfo[] blockInfoArray = iNodeFileUnderConstruction.getBlocks();
            BlocksMap.BlockInfo blockInfo = blockInfoArray[blockInfoArray.length - 1];
            DatanodeDescriptor[] datanodeDescriptorArray = new DatanodeDescriptor[this.blocksMap.numNodes(blockInfo)];
            Iterator<DatanodeDescriptor> iterator = this.blocksMap.nodeIterator(blockInfo);
            int n = 0;
            while (iterator != null && iterator.hasNext()) {
                datanodeDescriptorArray[n] = iterator.next();
                ++n;
            }
            iNodeFileUnderConstruction.setTargets(datanodeDescriptorArray);
        }
        iNodeFileUnderConstruction.assignPrimaryDatanode();
        this.leaseManager.renewLease(lease);
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFileUnderConstruction pendingFile) throws IOException {
        this.leaseManager.removeLease(pendingFile.clientName, src);
        INodeFile newFile = pendingFile.convertToInodeFile();
        this.dir.replaceNode(src, pendingFile, newFile);
        this.dir.closeFile(src, newFile);
        this.checkReplicationFactor(newFile);
    }

    synchronized void commitBlockSynchronization(Block block, long l, long l2, boolean bl, boolean bl2, DatanodeID[] datanodeIDArray) throws IOException {
        Object object;
        LOG.info("commitBlockSynchronization(lastblock=" + block + ", newgenerationstamp=" + l + ", newlength=" + l2 + ", newtargets=" + Arrays.asList(datanodeIDArray) + ", closeFile=" + bl + ", deleteBlock=" + bl2 + ")");
        BlocksMap.BlockInfo blockInfo = this.blocksMap.getStoredBlock(block);
        if (blockInfo == null) {
            throw new IOException("Block (=" + block + ") not found");
        }
        INodeFile iNodeFile = blockInfo.getINode();
        if (!iNodeFile.isUnderConstruction()) {
            throw new IOException("Unexpected block (=" + block + ") since the file (=" + iNodeFile.getLocalName() + ") is not under construction");
        }
        INodeFileUnderConstruction iNodeFileUnderConstruction = (INodeFileUnderConstruction)iNodeFile;
        this.blocksMap.removeBlock(blockInfo);
        if (bl2) {
            iNodeFileUnderConstruction.removeBlock(block);
        } else {
            int n;
            block.set(block.getBlockId(), l2, l);
            object = this.blocksMap.addINode(block, iNodeFileUnderConstruction);
            DatanodeDescriptor[] datanodeDescriptorArray = null;
            if (datanodeIDArray.length > 0) {
                datanodeDescriptorArray = new DatanodeDescriptor[datanodeIDArray.length];
                for (n = 0; n < datanodeIDArray.length; ++n) {
                    datanodeDescriptorArray[n] = this.getDatanode(datanodeIDArray[n]);
                }
            }
            if (bl) {
                for (n = 0; n < datanodeDescriptorArray.length; ++n) {
                    datanodeDescriptorArray[n].addBlock((BlocksMap.BlockInfo)object);
                }
                iNodeFileUnderConstruction.setLastBlock((BlocksMap.BlockInfo)object, null);
            } else {
                iNodeFileUnderConstruction.setLastBlock((BlocksMap.BlockInfo)object, datanodeDescriptorArray);
            }
        }
        object = this.leaseManager.findPath(iNodeFileUnderConstruction);
        if (!bl) {
            if (this.supportAppends) {
                this.dir.persistBlocks((String)object, iNodeFileUnderConstruction);
                this.getEditLog().logSync();
            }
            LOG.info("commitBlockSynchronization(" + block + ") successful");
            return;
        }
        this.finalizeINodeFileUnderConstruction((String)object, iNodeFileUnderConstruction);
        this.getEditLog().logSync();
        LOG.info("commitBlockSynchronization(newblock=" + block + ", file=" + (String)object + ", newgenerationstamp=" + l + ", newlength=" + l2 + ", newtargets=" + Arrays.asList(datanodeIDArray) + ") successful");
    }

    void renewLease(String string) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot renew lease for " + string, this.safeMode);
        }
        this.leaseManager.renewLease(string);
    }

    public FileStatus[] getListing(String string) throws IOException {
        if (this.isPermissionEnabled) {
            if (this.dir.isDir(string)) {
                this.checkPathAccess(string, FsAction.READ_EXECUTE);
            } else {
                this.checkTraverse(string);
            }
        }
        if (auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "listStatus", string, null, null);
        }
        return this.dir.getListing(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerDatanode(DatanodeRegistration datanodeRegistration) throws IOException {
        String string = Server.getRemoteAddress();
        if (string == null) {
            string = datanodeRegistration.getHost();
        }
        if (!this.verifyNodeRegistration(datanodeRegistration, string)) {
            throw new DisallowedDatanodeException(datanodeRegistration);
        }
        String string2 = datanodeRegistration.getHost();
        DatanodeID datanodeID = new DatanodeID(string + ":" + datanodeRegistration.getPort(), datanodeRegistration.getStorageID(), datanodeRegistration.getInfoPort(), datanodeRegistration.getIpcPort());
        datanodeRegistration.updateRegInfo(datanodeID);
        NameNode.stateChangeLog.info("BLOCK* NameSystem.registerDatanode: node registration from " + datanodeRegistration.getName() + " storage " + datanodeRegistration.getStorageID());
        DatanodeDescriptor datanodeDescriptor = (DatanodeDescriptor)this.datanodeMap.get(datanodeRegistration.getStorageID());
        DatanodeDescriptor datanodeDescriptor2 = this.host2DataNodeMap.getDatanodeByName(datanodeRegistration.getName());
        if (datanodeDescriptor2 != null && datanodeDescriptor2 != datanodeDescriptor) {
            NameNode.LOG.info("BLOCK* NameSystem.registerDatanode: node from name: " + datanodeDescriptor2.getName());
            this.removeDatanode(datanodeDescriptor2);
            this.wipeDatanode(datanodeDescriptor2);
            datanodeDescriptor2 = null;
        }
        if (datanodeDescriptor != null) {
            if (datanodeDescriptor2 == datanodeDescriptor) {
                NameNode.stateChangeLog.debug("BLOCK* NameSystem.registerDatanode: node restarted.");
            } else {
                NameNode.stateChangeLog.info("BLOCK* NameSystem.registerDatanode: node " + datanodeDescriptor.getName() + " is replaced by " + datanodeRegistration.getName() + " with the same storageID " + datanodeRegistration.getStorageID());
            }
            this.clusterMap.remove(datanodeDescriptor);
            datanodeDescriptor.updateRegInfo(datanodeRegistration);
            datanodeDescriptor.setHostName(string2);
            this.resolveNetworkLocation(datanodeDescriptor);
            this.clusterMap.add(datanodeDescriptor);
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                if (!this.heartbeats.contains(datanodeDescriptor)) {
                    this.heartbeats.add(datanodeDescriptor);
                    datanodeDescriptor.updateHeartbeat(0L, 0L, 0L, 0);
                    datanodeDescriptor.isAlive = true;
                }
            }
            return;
        }
        if (datanodeRegistration.getStorageID().equals("")) {
            datanodeRegistration.storageID = this.newStorageID();
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.registerDatanode: new storageID " + datanodeRegistration.getStorageID() + " assigned.");
        }
        DatanodeDescriptor datanodeDescriptor3 = new DatanodeDescriptor(datanodeRegistration, "/default-rack", string2);
        this.resolveNetworkLocation(datanodeDescriptor3);
        this.unprotectedAddDatanode(datanodeDescriptor3);
        this.clusterMap.add(datanodeDescriptor3);
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            this.heartbeats.add(datanodeDescriptor3);
            datanodeDescriptor3.isAlive = true;
        }
    }

    private void resolveNetworkLocation(DatanodeDescriptor datanodeDescriptor) {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            arrayList.add(datanodeDescriptor.getHost());
        } else {
            object = datanodeDescriptor.getHostName();
            int n = ((String)object).indexOf(":");
            object = n == -1 ? object : ((String)object).substring(0, n);
            arrayList.add((String)object);
        }
        object = this.dnsToSwitchMapping.resolve(arrayList);
        if (object == null) {
            LOG.error("The resolve call returned null! Using /default-rack for host " + arrayList);
            string = "/default-rack";
        } else {
            string = (String)object.get(0);
        }
        datanodeDescriptor.setNetworkLocation(string);
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage);
    }

    private String newStorageID() {
        String string = null;
        while (string == null) {
            string = "DS" + Integer.toString(this.r.nextInt());
            if (this.datanodeMap.get(string) == null) continue;
            string = null;
        }
        return string;
    }

    private void setDatanodeDead(DatanodeDescriptor node) throws IOException {
        node.setLastUpdate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeCommand[] handleHeartbeat(DatanodeRegistration datanodeRegistration, long l, long l2, long l3, int n, int n2) throws IOException {
        DatanodeCommand datanodeCommand = null;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
            synchronized (navigableMap) {
                DatanodeDescriptor datanodeDescriptor = null;
                try {
                    datanodeDescriptor = this.getDatanode(datanodeRegistration);
                }
                catch (UnregisteredDatanodeException unregisteredDatanodeException) {
                    return new DatanodeCommand[]{DatanodeCommand.REGISTER};
                }
                if (datanodeDescriptor != null && this.shouldNodeShutdown(datanodeDescriptor)) {
                    this.setDatanodeDead(datanodeDescriptor);
                    throw new DisallowedDatanodeException(datanodeDescriptor);
                }
                if (datanodeDescriptor == null || !datanodeDescriptor.isAlive) {
                    return new DatanodeCommand[]{DatanodeCommand.REGISTER};
                }
                this.updateStats(datanodeDescriptor, false);
                datanodeDescriptor.updateHeartbeat(l, l2, l3, n);
                this.updateStats(datanodeDescriptor, true);
                datanodeCommand = datanodeDescriptor.getLeaseRecoveryCommand(Integer.MAX_VALUE);
                if (datanodeCommand != null) {
                    return new DatanodeCommand[]{datanodeCommand};
                }
                ArrayList<BlockCommand> arrayList2 = new ArrayList<BlockCommand>(2);
                datanodeCommand = datanodeDescriptor.getReplicationCommand(this.maxReplicationStreams - n2);
                if (datanodeCommand != null) {
                    arrayList2.add((BlockCommand)datanodeCommand);
                }
                if ((datanodeCommand = datanodeDescriptor.getInvalidateBlocks(this.blockInvalidateLimit)) != null) {
                    arrayList2.add((BlockCommand)datanodeCommand);
                }
                if (!arrayList2.isEmpty()) {
                    return arrayList2.toArray(new DatanodeCommand[arrayList2.size()]);
                }
            }
        }
        datanodeCommand = this.getDistributedUpgradeCommand();
        if (datanodeCommand != null) {
            return new DatanodeCommand[]{datanodeCommand};
        }
        return null;
    }

    private void updateStats(DatanodeDescriptor node, boolean isAdded) {
        assert (Thread.holdsLock(this.heartbeats));
        if (isAdded) {
            this.capacityTotal += node.getCapacity();
            this.capacityUsed += node.getDfsUsed();
            this.capacityRemaining += node.getRemaining();
            this.totalLoad += node.getXceiverCount();
        } else {
            this.capacityTotal -= node.getCapacity();
            this.capacityUsed -= node.getDfsUsed();
            this.capacityRemaining -= node.getRemaining();
            this.totalLoad -= node.getXceiverCount();
        }
    }

    public synchronized void removeDatanode(DatanodeID datanodeID) throws IOException {
        DatanodeDescriptor datanodeDescriptor = this.getDatanode(datanodeID);
        if (datanodeDescriptor != null) {
            this.removeDatanode(datanodeDescriptor);
        } else {
            NameNode.stateChangeLog.warn("BLOCK* NameSystem.removeDatanode: " + datanodeID.getName() + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatanode(DatanodeDescriptor nodeInfo) {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (nodeInfo.isAlive) {
                this.updateStats(nodeInfo, false);
                this.heartbeats.remove(nodeInfo);
                nodeInfo.isAlive = false;
            }
        }
        Iterator<Block> it = nodeInfo.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), nodeInfo);
        }
        this.unprotectedRemoveDatanode(nodeInfo);
        this.clusterMap.remove(nodeInfo);
    }

    void unprotectedRemoveDatanode(DatanodeDescriptor datanodeDescriptor) {
        datanodeDescriptor.resetBlocks();
        this.removeFromInvalidates(datanodeDescriptor.getStorageID());
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.unprotectedRemoveDatanode: " + datanodeDescriptor.getName() + " is out of service now.");
    }

    void unprotectedAddDatanode(DatanodeDescriptor datanodeDescriptor) {
        this.host2DataNodeMap.remove(this.datanodeMap.put(datanodeDescriptor.getStorageID(), datanodeDescriptor));
        this.host2DataNodeMap.add(datanodeDescriptor);
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.unprotectedAddDatanode: node " + datanodeDescriptor.getName() + " is added to datanodeMap.");
    }

    void wipeDatanode(DatanodeID datanodeID) throws IOException {
        String string = datanodeID.getStorageID();
        this.host2DataNodeMap.remove((DatanodeDescriptor)this.datanodeMap.remove(string));
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.wipeDatanode: " + datanodeID.getName() + " storage " + string + " is removed from datanodeMap.");
    }

    FSImage getFSImage() {
        return this.dir.fsImage;
    }

    FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    public synchronized void processReport(DatanodeID datanodeID, BlockListAsLongs blockListAsLongs) throws IOException {
        DatanodeDescriptor datanodeDescriptor;
        long l = FSNamesystem.now();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.processReport: from " + datanodeID.getName() + " " + blockListAsLongs.getNumberOfBlocks() + " blocks");
        }
        if ((datanodeDescriptor = this.getDatanode(datanodeID)) == null) {
            throw new IOException("ProcessReport from unregisterted node: " + datanodeID.getName());
        }
        if (this.shouldNodeShutdown(datanodeDescriptor)) {
            this.setDatanodeDead(datanodeDescriptor);
            throw new DisallowedDatanodeException(datanodeDescriptor);
        }
        LinkedList<Block> linkedList = new LinkedList<Block>();
        LinkedList<Block> linkedList2 = new LinkedList<Block>();
        LinkedList<Block> linkedList3 = new LinkedList<Block>();
        datanodeDescriptor.reportDiff(this.blocksMap, blockListAsLongs, linkedList, linkedList2, linkedList3);
        for (Block block : linkedList2) {
            this.removeStoredBlock(block, datanodeDescriptor);
        }
        for (Block block : linkedList) {
            this.addStoredBlock(block, datanodeDescriptor, null);
        }
        for (Block block : linkedList3) {
            NameNode.stateChangeLog.info("BLOCK* NameSystem.processReport: block " + block + " on " + datanodeDescriptor.getName() + " size " + block.getNumBytes() + " does not belong to any file.");
            this.addToInvalidates(block, datanodeDescriptor);
        }
        NameNode.getNameNodeMetrics().blockReport.inc((int)(FSNamesystem.now() - l));
    }

    synchronized Block addStoredBlock(Block block, DatanodeDescriptor datanodeDescriptor, DatanodeDescriptor datanodeDescriptor2) {
        int n;
        DatanodeDescriptor[] datanodeDescriptorArray;
        BlocksMap.BlockInfo blockInfo = this.blocksMap.getStoredBlock(block);
        if (blockInfo == null || blockInfo.getINode() == null) {
            NameNode.stateChangeLog.info("BLOCK* NameSystem.addStoredBlock: addStoredBlock request received for " + block + " on " + datanodeDescriptor.getName() + " size " + block.getNumBytes() + " But it does not belong to any file.");
            return block;
        }
        boolean bl = datanodeDescriptor.addBlock(blockInfo);
        assert (blockInfo != null) : "Block must be stored by now";
        if (block != blockInfo) {
            if (block.getNumBytes() >= 0L) {
                long l;
                Object object;
                long l2 = blockInfo.getNumBytes();
                if (l2 == 0L) {
                    blockInfo.setNumBytes(block.getNumBytes());
                } else if (l2 != block.getNumBytes()) {
                    LOG.warn("Inconsistent size for block " + block + " reported from " + datanodeDescriptor.getName() + " current size is " + l2 + " reported size is " + block.getNumBytes());
                    try {
                        if (l2 > block.getNumBytes()) {
                            LOG.warn("Mark new replica " + block + " from " + datanodeDescriptor.getName() + "as corrupt because its length is shorter than existing ones");
                            this.markBlockAsCorrupt(block, datanodeDescriptor);
                        } else {
                            int n2 = this.blocksMap.numNodes(block);
                            int n3 = 0;
                            datanodeDescriptorArray = new DatanodeDescriptor[n2];
                            object = this.blocksMap.nodeIterator(block);
                            while (object != null && object.hasNext()) {
                                DatanodeDescriptor datanodeDescriptor3 = (DatanodeDescriptor)object.next();
                                if (datanodeDescriptor3.equals(datanodeDescriptor)) continue;
                                datanodeDescriptorArray[n3++] = datanodeDescriptor3;
                            }
                            for (n = 0; n < n3; ++n) {
                                LOG.warn("Mark existing replica " + block + " from " + datanodeDescriptor.getName() + " as corrupt because its length is shorter than the new one");
                                this.markBlockAsCorrupt(block, datanodeDescriptorArray[n]);
                            }
                            blockInfo = this.blocksMap.getStoredBlock(block);
                            if (blockInfo == null) {
                                LOG.warn("Block " + block + " reported from " + datanodeDescriptor.getName() + " does not exist in blockMap. Surprise! Surprise!");
                            } else {
                                blockInfo.setNumBytes(block.getNumBytes());
                            }
                        }
                    }
                    catch (IOException iOException) {
                        LOG.warn("Error in deleting bad block " + block + iOException);
                    }
                }
                INodeFile iNodeFile = blockInfo != null ? blockInfo.getINode() : null;
                long l3 = l = iNodeFile == null ? 0L : iNodeFile.getPreferredBlockSize() - blockInfo.getNumBytes();
                if (l > 0L && iNodeFile.isUnderConstruction() && l2 < blockInfo.getNumBytes()) {
                    try {
                        object = this.leaseManager.findPath((INodeFileUnderConstruction)iNodeFile);
                        this.dir.updateSpaceConsumed((String)object, 0L, -l * (long)iNodeFile.getReplication());
                    }
                    catch (IOException iOException) {
                        LOG.warn("Unexpected exception while updating disk space : " + iOException.getMessage());
                    }
                }
            }
            block = blockInfo;
        }
        assert (blockInfo == block) : "Block must be stored by now";
        int n4 = 0;
        if (bl) {
            n4 = 1;
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info("BLOCK* NameSystem.addStoredBlock: blockMap updated: " + datanodeDescriptor.getName() + " is added to " + block + " size " + block.getNumBytes());
            }
        } else {
            NameNode.stateChangeLog.warn("BLOCK* NameSystem.addStoredBlock: Redundant addStoredBlock request received for " + block + " on " + datanodeDescriptor.getName() + " size " + block.getNumBytes());
        }
        NumberReplicas numberReplicas = this.countNodes(blockInfo);
        int n5 = numberReplicas.liveReplicas();
        int n6 = n5 + this.pendingReplications.getNumReplicas(block);
        this.incrementSafeBlockCount(n6);
        datanodeDescriptorArray = null;
        datanodeDescriptorArray = blockInfo.getINode();
        if (datanodeDescriptorArray.isUnderConstruction()) {
            return block;
        }
        if (this.isInSafeMode()) {
            return block;
        }
        short s = datanodeDescriptorArray.getReplication();
        if (n6 >= s) {
            this.neededReplications.remove(block, n6, numberReplicas.decommissionedReplicas, s);
        } else {
            this.updateNeededReplications(block, n4, 0);
        }
        if (n6 > s) {
            this.processOverReplicatedBlock(block, s, datanodeDescriptor, datanodeDescriptor2);
        }
        n = this.corruptReplicas.numCorruptReplicas(block);
        int n7 = numberReplicas.corruptReplicas();
        if (n7 != n) {
            LOG.warn("Inconsistent number of corrupt replicas for " + block + "blockMap has " + n7 + " but corrupt replicas map has " + n);
        }
        if (n > 0 && n5 >= s) {
            this.invalidateCorruptReplicas(block);
        }
        return block;
    }

    void invalidateCorruptReplicas(Block block) {
        Collection<DatanodeDescriptor> collection = this.corruptReplicas.getNodes(block);
        boolean bl = false;
        if (collection == null) {
            return;
        }
        for (DatanodeDescriptor datanodeDescriptor : collection) {
            try {
                this.invalidateBlock(block, datanodeDescriptor);
            }
            catch (IOException iOException) {
                NameNode.stateChangeLog.info("NameNode.invalidateCorruptReplicas error in deleting bad block " + block + " on " + datanodeDescriptor + iOException);
                bl = true;
            }
        }
        if (!bl) {
            this.corruptReplicas.removeFromCorruptReplicasMap(block);
        }
    }

    private synchronized void processMisReplicatedBlocks() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.neededReplications.clear();
        for (BlocksMap.BlockInfo blockInfo : this.blocksMap.getBlocks()) {
            INodeFile iNodeFile = blockInfo.getINode();
            if (iNodeFile == null) {
                ++l;
                this.addToInvalidates(blockInfo);
                continue;
            }
            short s = iNodeFile.getReplication();
            NumberReplicas numberReplicas = this.countNodes(blockInfo);
            int n = numberReplicas.liveReplicas();
            if (this.neededReplications.add(blockInfo, n, numberReplicas.decommissionedReplicas(), s)) {
                ++l3;
            }
            if (n <= s) continue;
            ++l2;
            this.processOverReplicatedBlock(blockInfo, s, null, null);
        }
        LOG.info("Total number of blocks = " + this.blocksMap.size());
        LOG.info("Number of invalid blocks = " + l);
        LOG.info("Number of under-replicated blocks = " + l3);
        LOG.info("Number of  over-replicated blocks = " + l2);
    }

    private void processOverReplicatedBlock(Block block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeDescriptor> nonExcess = new ArrayList<DatanodeDescriptor>();
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            nonExcess.add(cur);
        }
        this.chooseExcessReplicates(nonExcess, block, replication, addedNode, delNodeHint);
    }

    /*
     * WARNING - void declaration
     */
    void chooseExcessReplicates(Collection<DatanodeDescriptor> collection, Block block, short s, DatanodeDescriptor datanodeDescriptor, DatanodeDescriptor datanodeDescriptor2) {
        HashMap<Object, void> hashMap = new HashMap<Object, void>();
        for (DatanodeDescriptor object22 : collection) {
            void var10_12;
            String bl = object22.getNetworkLocation();
            ArrayList arrayList = (ArrayList)hashMap.get(bl);
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
            }
            var10_12.add(object22);
            hashMap.put(bl, var10_12);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList4 = (ArrayList)entry.getValue();
            if (arrayList4.size() == 1) {
                arrayList3.add(arrayList4.get(0));
                continue;
            }
            arrayList.addAll(arrayList4);
        }
        boolean bl = true;
        while (collection.size() - s > 0) {
            void var10_22;
            Object object;
            Object object2;
            Object var10_18 = null;
            long l = Long.MAX_VALUE;
            if (bl && datanodeDescriptor2 != null && collection.contains(datanodeDescriptor2) && (arrayList.contains(datanodeDescriptor2) || datanodeDescriptor != null && !arrayList.contains(datanodeDescriptor))) {
                DatanodeDescriptor datanodeDescriptor3 = datanodeDescriptor2;
            } else {
                Object object3 = object2 = arrayList.isEmpty() ? arrayList3.iterator() : arrayList.iterator();
                while (object2.hasNext()) {
                    object = (DatanodeDescriptor)object2.next();
                    long l2 = ((DatanodeInfo)object).getRemaining();
                    if (l <= l2) continue;
                    l = l2;
                    Object object4 = object;
                }
            }
            bl = false;
            object2 = var10_22.getNetworkLocation();
            object = (ArrayList)hashMap.get(object2);
            ((ArrayList)object).remove(var10_22);
            if (((ArrayList)object).isEmpty()) {
                hashMap.remove(object2);
            }
            if (arrayList.remove(var10_22)) {
                if (((ArrayList)object).size() == 1) {
                    arrayList.remove(((ArrayList)object).get(0));
                    arrayList3.add(((ArrayList)object).get(0));
                }
            } else {
                arrayList3.remove(var10_22);
            }
            collection.remove(var10_22);
            Collection<Block> collection2 = this.excessReplicateMap.get(var10_22.getStorageID());
            if (collection2 == null) {
                collection2 = new TreeSet<Block>();
                this.excessReplicateMap.put(var10_22.getStorageID(), collection2);
            }
            if (collection2.add(block)) {
                ++this.excessBlocksCount;
                NameNode.stateChangeLog.debug("BLOCK* NameSystem.chooseExcessReplicates: (" + var10_22.getName() + ", " + block + ") is added to excessReplicateMap");
            }
            this.addToInvalidatesNoLog(block, (DatanodeInfo)var10_22);
            NameNode.stateChangeLog.info("BLOCK* NameSystem.chooseExcessReplicates: (" + var10_22.getName() + ", " + block + ") is added to recentInvalidateSets");
        }
    }

    synchronized void removeStoredBlock(Block block, DatanodeDescriptor datanodeDescriptor) {
        Collection<Block> collection;
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.removeStoredBlock: " + block + " from " + datanodeDescriptor.getName());
        if (!this.blocksMap.removeNode(block, datanodeDescriptor)) {
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.removeStoredBlock: " + block + " has already been removed from node " + datanodeDescriptor);
            return;
        }
        INodeFile iNodeFile = this.blocksMap.getINode(block);
        if (iNodeFile != null) {
            this.decrementSafeBlockCount(block);
            this.updateNeededReplications(block, -1, 0);
        }
        if ((collection = this.excessReplicateMap.get(datanodeDescriptor.getStorageID())) != null && collection.remove(block)) {
            --this.excessBlocksCount;
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.removeStoredBlock: " + block + " is removed from excessBlocks");
            if (collection.size() == 0) {
                this.excessReplicateMap.remove(datanodeDescriptor.getStorageID());
            }
        }
        this.corruptReplicas.removeFromCorruptReplicasMap(block, datanodeDescriptor);
    }

    public synchronized void blockReceived(DatanodeID datanodeID, Block block, String string) throws IOException {
        DatanodeDescriptor datanodeDescriptor = this.getDatanode(datanodeID);
        if (datanodeDescriptor == null) {
            NameNode.stateChangeLog.warn("BLOCK* NameSystem.blockReceived: " + block + " is received from an unrecorded node " + datanodeID.getName());
            throw new IllegalArgumentException("Unexpected exception.  Got blockReceived message from node " + block + ", but there is no info for it");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.blockReceived: " + block + " is received from " + datanodeID.getName());
        }
        if (this.shouldNodeShutdown(datanodeDescriptor)) {
            this.setDatanodeDead(datanodeDescriptor);
            throw new DisallowedDatanodeException(datanodeDescriptor);
        }
        datanodeDescriptor.decBlocksScheduled();
        DatanodeDescriptor datanodeDescriptor2 = null;
        if (string != null && string.length() != 0 && (datanodeDescriptor2 = (DatanodeDescriptor)this.datanodeMap.get(string)) == null) {
            NameNode.stateChangeLog.warn("BLOCK* NameSystem.blockReceived: " + block + " is expected to be removed from an unrecorded node " + string);
        }
        this.pendingReplications.remove(block);
        this.addStoredBlock(block, datanodeDescriptor, datanodeDescriptor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalLoad() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalLoad;
        }
    }

    private void startDecommission(DatanodeDescriptor datanodeDescriptor) throws IOException {
        if (!datanodeDescriptor.isDecommissionInProgress() && !datanodeDescriptor.isDecommissioned()) {
            LOG.info("Start Decommissioning node " + datanodeDescriptor.getName());
            datanodeDescriptor.startDecommission();
            Iterator<Block> iterator = datanodeDescriptor.getBlockIterator();
            while (iterator.hasNext()) {
                Block block = iterator.next();
                this.updateNeededReplications(block, -1, 0);
            }
        }
    }

    private NumberReplicas countNodes(Block b, Iterator<DatanodeDescriptor> nodeIter) {
        int count = 0;
        int live = 0;
        int corrupt = 0;
        int excess = 0;
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
                continue;
            }
            if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++count;
                continue;
            }
            Collection<Block> blocksExcess = this.excessReplicateMap.get(node.getStorageID());
            if (blocksExcess != null && blocksExcess.contains(b)) {
                ++excess;
                continue;
            }
            ++live;
        }
        return new NumberReplicas(live, count, corrupt, excess);
    }

    NumberReplicas countNodes(Block b) {
        return this.countNodes(b, this.blocksMap.nodeIterator(b));
    }

    private boolean isReplicationInProgress(DatanodeDescriptor srcNode) {
        boolean status = false;
        Iterator<Block> i = srcNode.getBlockIterator();
        while (i.hasNext()) {
            Block block = i.next();
            INodeFile fileINode = this.blocksMap.getINode(block);
            if (fileINode == null) continue;
            NumberReplicas num = this.countNodes(block);
            int curReplicas = num.liveReplicas();
            int curExpectedReplicas = this.getReplication(block);
            if (curExpectedReplicas <= curReplicas) continue;
            status = true;
            if (this.neededReplications.contains(block) || this.pendingReplications.getNumReplicas(block) != 0) continue;
            this.neededReplications.add(block, curReplicas, num.decommissionedReplicas(), curExpectedReplicas);
        }
        return status;
    }

    boolean checkDecommissionStateInternal(DatanodeDescriptor datanodeDescriptor) {
        if (datanodeDescriptor.isDecommissionInProgress() && !this.isReplicationInProgress(datanodeDescriptor)) {
            datanodeDescriptor.setDecommissioned();
            LOG.info("Decommission complete for node " + datanodeDescriptor.getName());
        }
        return datanodeDescriptor.isDecommissioned();
    }

    private boolean inHostsList(DatanodeID node, String ipAddr) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || ipAddr != null && hostsList.contains(ipAddr) || hostsList.contains(node.getHost()) || hostsList.contains(node.getName()) || node instanceof DatanodeInfo && hostsList.contains(((DatanodeInfo)node).getHostName());
    }

    private boolean inExcludedHostsList(DatanodeID node, String ipAddr) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return ipAddr != null && excludeList.contains(ipAddr) || excludeList.contains(node.getHost()) || excludeList.contains(node.getName()) || node instanceof DatanodeInfo && excludeList.contains(((DatanodeInfo)node).getHostName());
    }

    private synchronized boolean verifyNodeRegistration(DatanodeRegistration datanodeRegistration, String string) throws IOException {
        if (!this.inHostsList(datanodeRegistration, string)) {
            return false;
        }
        if (this.inExcludedHostsList(datanodeRegistration, string)) {
            DatanodeDescriptor datanodeDescriptor = this.getDatanode(datanodeRegistration);
            if (datanodeDescriptor == null) {
                throw new IOException("verifyNodeRegistration: unknown datanode " + datanodeRegistration.getName());
            }
            if (!this.checkDecommissionStateInternal(datanodeDescriptor)) {
                this.startDecommission(datanodeDescriptor);
            }
        }
        return true;
    }

    private boolean shouldNodeShutdown(DatanodeDescriptor node) {
        return node.isDecommissioned();
    }

    public DatanodeDescriptor getDatanode(DatanodeID datanodeID) throws IOException {
        UnregisteredDatanodeException unregisteredDatanodeException = null;
        DatanodeDescriptor datanodeDescriptor = (DatanodeDescriptor)this.datanodeMap.get(datanodeID.getStorageID());
        if (datanodeDescriptor == null) {
            return null;
        }
        if (!datanodeDescriptor.getName().equals(datanodeID.getName())) {
            unregisteredDatanodeException = new UnregisteredDatanodeException(datanodeID, datanodeDescriptor);
            NameNode.stateChangeLog.fatal("BLOCK* NameSystem.getDatanode: " + unregisteredDatanodeException.getLocalizedMessage());
            throw unregisteredDatanodeException;
        }
        return datanodeDescriptor;
    }

    static long now() {
        return System.currentTimeMillis();
    }

    boolean isInSafeMode() {
        if (this.safeMode == null) {
            return false;
        }
        return this.safeMode.isOn();
    }

    void incrementSafeBlockCount(int replication) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.incrementSafeBlockCount((short)replication);
    }

    void decrementSafeBlockCount(Block b) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.decrementSafeBlockCount((short)this.countNodes(b).liveReplicas());
    }

    public long getBlocksTotal() {
        return this.blocksMap.size();
    }

    synchronized void leaveSafeMode(boolean bl) throws SafeModeException {
        if (!this.isInSafeMode()) {
            NameNode.stateChangeLog.info("STATE* Safe mode is already OFF.");
            return;
        }
        if (this.getDistributedUpgradeState()) {
            throw new SafeModeException("Distributed upgrade is in progress", this.safeMode);
        }
        this.safeMode.leave(bl);
    }

    private boolean isValidBlock(Block b) {
        return this.blocksMap.getINode(b) != null;
    }

    UpgradeCommand processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.upgradeManager.processUpgradeCommand(comm);
    }

    int getDistributedUpgradeVersion() {
        return this.upgradeManager.getUpgradeVersion();
    }

    UpgradeCommand getDistributedUpgradeCommand() throws IOException {
        return this.upgradeManager.getBroadcastCommand();
    }

    boolean getDistributedUpgradeState() {
        return this.upgradeManager.getUpgradeState();
    }

    short getDistributedUpgradeStatus() {
        return this.upgradeManager.getUpgradeStatus();
    }

    boolean startDistributedUpgradeIfNeeded() throws IOException {
        return this.upgradeManager.startUpgrade();
    }

    private PermissionChecker checkOwner(String path) throws AccessControlException {
        return this.checkPermission(path, true, null, null, null, null);
    }

    private PermissionChecker checkPathAccess(String path, FsAction access) throws AccessControlException {
        return this.checkPermission(path, false, null, null, access, null);
    }

    private PermissionChecker checkParentAccess(String path, FsAction access) throws AccessControlException {
        return this.checkPermission(path, false, null, access, null, null);
    }

    private PermissionChecker checkAncestorAccess(String path, FsAction access) throws AccessControlException {
        return this.checkPermission(path, false, access, null, null, null);
    }

    private PermissionChecker checkTraverse(String path) throws AccessControlException {
        return this.checkPermission(path, false, null, null, null, null);
    }

    private PermissionChecker checkPermission(String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException {
        PermissionChecker pc = new PermissionChecker(this.fsOwner.getUserName(), this.supergroup);
        if (!pc.isSuper) {
            this.dir.waitForReady();
            pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess);
        }
        return pc;
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    public long getGenerationStamp() {
        return this.generationStamp.getStamp();
    }

    long nextGenerationStamp() {
        long gs = this.generationStamp.nextStamp();
        this.getEditLog().logGenerationStamp(gs);
        return gs;
    }

    synchronized long nextGenerationStampForBlock(Block block) throws IOException {
        BlocksMap.BlockInfo blockInfo = this.blocksMap.getStoredBlock(block);
        if (blockInfo == null) {
            String string = block + " is already commited, storedBlock == null.";
            LOG.info(string);
            throw new IOException(string);
        }
        INodeFile iNodeFile = blockInfo.getINode();
        if (!iNodeFile.isUnderConstruction()) {
            String string = block + " is already commited, !fileINode.isUnderConstruction().";
            LOG.info(string);
            throw new IOException(string);
        }
        if (!((INodeFileUnderConstruction)iNodeFile).setLastRecoveryTime(FSNamesystem.now())) {
            String string = block + " is beening recovered, ignoring this request.";
            LOG.info(string);
            throw new IOException(string);
        }
        return this.nextGenerationStamp();
    }

    void changeLease(String string, String string2, FileStatus fileStatus) throws IOException {
        String string3;
        String string4;
        boolean bl = true;
        if (fileStatus == null) {
            bl = false;
        }
        if (bl && fileStatus.isDir()) {
            Path path = new Path(string);
            string4 = path.getParent().toString() + "/";
            string3 = string2 + "/";
        } else {
            string4 = string;
            string3 = string2;
        }
        this.leaseManager.changeLease(string, string2, string4, string3);
    }

    static {
        randBlockId = new Random();
    }

    class SafeModeMonitor
    implements Runnable {
        SafeModeMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning && FSNamesystem.this.safeMode != null && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            try {
                FSNamesystem.this.leaveSafeMode(true);
            }
            catch (SafeModeException es) {
                String msg = "SafeModeMonitor may not run during distributed upgrade.";
                assert (false) : msg;
                throw new RuntimeException(msg, es);
            }
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold = 1.5;
        private int extension = Integer.MAX_VALUE;
        private int safeReplication = 32768;
        private long reached = -1L;
        int blockTotal = -1;
        private int blockSafe = -1;
        private long lastStatusReport = 0L;

        private SafeModeInfo() {
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        synchronized boolean isOn() {
            try {
                assert (this.isConsistent()) : " SafeMode: Inconsistent filesystem state: Total num of blocks, active blocks, or total safe blocks don't match.";
            }
            catch (IOException e) {
                System.err.print(StringUtils.stringifyException(e));
            }
            return this.reached >= 0L;
        }

        void enter() {
            this.reached = 0L;
        }

        synchronized void leave(boolean checkForUpgrades) {
            if (checkForUpgrades) {
                boolean needUpgrade = false;
                try {
                    needUpgrade = FSNamesystem.this.startDistributedUpgradeIfNeeded();
                }
                catch (IOException e) {
                    LOG.error(StringUtils.stringifyException(e));
                }
                if (needUpgrade) {
                    FSNamesystem.this.safeMode = new SafeModeInfo();
                    return;
                }
            }
            FSNamesystem.this.processMisReplicatedBlocks();
            long timeInSafemode = FSNamesystem.now() - FSNamesystem.this.systemStart;
            NameNode.stateChangeLog.info("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs.");
            NameNode.getNameNodeMetrics().safeModeTime.set((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info("STATE* Safe mode is OFF.");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NameNode.stateChangeLog.info("STATE* Network topology has " + FSNamesystem.this.clusterMap.getNumOfRacks() + " racks and " + FSNamesystem.this.clusterMap.getNumOfLeaves() + " datanodes");
            NameNode.stateChangeLog.info("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.neededReplications.size() + " blocks");
        }

        synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (FSNamesystem.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return false;
            }
            return !this.needEnter();
        }

        boolean needEnter() {
            return (double)this.getSafeBlockRatio() < this.threshold;
        }

        private float getSafeBlockRatio() {
            return this.blockTotal == 0 ? 1.0f : (float)this.blockSafe / (float)this.blockTotal;
        }

        private void checkMode() {
            if (this.needEnter()) {
                this.enter();
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave(true);
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = FSNamesystem.now();
            FSNamesystem.this.smmthread = new Daemon(new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
            this.reportStatus("STATE* Safe mode extension entered.", true);
        }

        synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
            }
            this.checkMode();
        }

        synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
            }
            this.checkMode();
        }

        boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        String getTurnOffTip() {
            String leaveMsg = "Safe mode will be turned off automatically";
            if (this.reached < 0L) {
                return "Safe mode is OFF.";
            }
            if (this.isManual()) {
                if (FSNamesystem.this.getDistributedUpgradeState()) {
                    return leaveMsg + " upon completion of " + "the distributed upgrade: upgrade progress = " + FSNamesystem.this.getDistributedUpgradeStatus() + "%";
                }
                leaveMsg = "Use \"hadoop dfsadmin -safemode leave\" to turn safe mode off";
            }
            if (this.blockTotal < 0) {
                return leaveMsg + ".";
            }
            String safeBlockRatioMsg = String.format("The ratio of reported blocks %.4f has " + (this.reached == 0L ? "not " : "") + "reached the threshold %.4f. ", Float.valueOf(this.getSafeBlockRatio()), this.threshold) + leaveMsg;
            if (this.reached == 0L || this.isManual()) {
                return safeBlockRatioMsg + ".";
            }
            return safeBlockRatioMsg + " in " + Math.abs(this.reached + (long)this.extension - FSNamesystem.now()) / 1000L + " seconds.";
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = FSNamesystem.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info(msg + " \n" + this.getTurnOffTip());
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe block ratio = " + this.getSafeBlockRatio() + ". Target threshold = " + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        boolean isConsistent() throws IOException {
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return true;
            }
            int activeBlocks = FSNamesystem.this.blocksMap.size() - (int)FSNamesystem.this.pendingDeletionBlocksCount;
            return this.blockTotal == activeBlocks || this.blockSafe >= 0 && this.blockSafe <= this.blockTotal;
        }
    }

    static class NumberReplicas {
        private int liveReplicas;
        private int decommissionedReplicas;
        private int corruptReplicas;
        private int excessReplicas;

        NumberReplicas() {
            this.initialize(0, 0, 0, 0);
        }

        NumberReplicas(int live, int decommissioned, int corrupt, int excess) {
            this.initialize(live, decommissioned, corrupt, excess);
        }

        void initialize(int live, int decommissioned, int corrupt, int excess) {
            this.liveReplicas = live;
            this.decommissionedReplicas = decommissioned;
            this.corruptReplicas = corrupt;
            this.excessReplicas = excess;
        }

        int liveReplicas() {
            return this.liveReplicas;
        }

        int decommissionedReplicas() {
            return this.decommissionedReplicas;
        }

        int corruptReplicas() {
            return this.corruptReplicas;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompleteFileStatus {
        OPERATION_FAILED,
        STILL_WAITING,
        COMPLETE_SUCCESS;

    }
}

