/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.management.ObjectName;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeBlockInfo;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDataset
implements FSConstants,
FSDatasetInterface {
    FSVolumeSet volumes;
    private HashMap<Block, ActiveFile> ongoingCreates;
    private int maxBlocksPerDir;
    private HashMap<Block, DatanodeBlockInfo> volumeMap;
    static Random random = new Random();
    private ObjectName mbeanName;

    static String getMetaFileName(String blockFileName, long genStamp) {
        return blockFileName + "_" + genStamp + ".meta";
    }

    static File getMetaFile(File f, Block b) {
        return new File(FSDataset.getMetaFileName(f.getAbsolutePath(), b.getGenerationStamp()));
    }

    protected File getMetaFile(Block b) throws IOException {
        return FSDataset.getMetaFile(this.getBlockFile(b), b);
    }

    private static File findMetaFile(File blockFile) throws IOException {
        final String prefix = blockFile.getName() + "_";
        final File parent = blockFile.getParentFile();
        File[] matches = parent.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return dir.equals(parent) && name.startsWith(prefix) && name.endsWith(".meta");
            }
        });
        if (matches == null || matches.length == 0) {
            throw new IOException("Meta file not found, blockFile=" + blockFile);
        }
        if (matches.length > 1) {
            throw new IOException("Found more than one meta files: " + Arrays.asList(matches));
        }
        return matches[0];
    }

    private static long parseGenerationStamp(File blockFile, File metaFile) throws IOException {
        String metaname = metaFile.getName();
        String gs = metaname.substring(blockFile.getName().length() + 1, metaname.length() - ".meta".length());
        try {
            return Long.parseLong(gs);
        }
        catch (NumberFormatException nfe) {
            throw (IOException)new IOException("blockFile=" + blockFile + ", metaFile=" + metaFile).initCause(nfe);
        }
    }

    public File findBlockFile(long blockId) {
        Block b = new Block(blockId);
        File blockfile = null;
        ActiveFile activefile = this.ongoingCreates.get(b);
        if (activefile != null) {
            blockfile = activefile.file;
        }
        if (blockfile == null) {
            blockfile = this.getFile(b);
        }
        if (blockfile == null && DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug("ongoingCreates=" + this.ongoingCreates);
            DataNode.LOG.debug("volumeMap=" + this.volumeMap);
        }
        return blockfile;
    }

    @Override
    public synchronized Block getStoredBlock(long blkid) throws IOException {
        File blockfile = this.findBlockFile(blkid);
        if (blockfile == null) {
            return null;
        }
        File metafile = FSDataset.findMetaFile(blockfile);
        return new Block(blkid, blockfile.length(), FSDataset.parseGenerationStamp(blockfile, metafile));
    }

    @Override
    public boolean metaFileExists(Block b) throws IOException {
        return this.getMetaFile(b).exists();
    }

    @Override
    public FSDatasetInterface.MetaDataInputStream getMetaDataInputStream(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return new FSDatasetInterface.MetaDataInputStream(new FileInputStream(checksumFile), checksumFile.length());
    }

    @Override
    public long getDfsUsed() throws IOException {
        return this.volumes.getDfsUsed();
    }

    @Override
    public long getCapacity() throws IOException {
        return this.volumes.getCapacity();
    }

    @Override
    public long getRemaining() throws IOException {
        return this.volumes.getRemaining();
    }

    @Override
    public long getLength(Block b) throws IOException {
        return this.getBlockFile(b).length();
    }

    public synchronized File getBlockFile(Block b) throws IOException {
        File f = this.validateBlockFile(b);
        if (f == null) {
            if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
                InterDatanodeProtocol.LOG.debug("b=" + b + ", volumeMap=" + this.volumeMap);
            }
            throw new IOException("Block " + b + " is not valid.");
        }
        return f;
    }

    @Override
    public synchronized InputStream getBlockInputStream(Block b, long seekOffset) throws IOException {
        File blockFile = this.getBlockFile(b);
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (seekOffset > 0L) {
            blockInFile.seek(seekOffset);
        }
        return new FileInputStream(blockInFile.getFD());
    }

    @Override
    public synchronized FSDatasetInterface.BlockInputStreams getTmpInputStreams(Block b, long blkOffset, long ckoff) throws IOException {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info == null) {
            throw new IOException("Block " + b + " does not exist in volumeMap.");
        }
        FSVolume v = info.getVolume();
        File blockFile = v.getTmpFile(b);
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (blkOffset > 0L) {
            blockInFile.seek(blkOffset);
        }
        File metaFile = FSDataset.getMetaFile(blockFile, b);
        RandomAccessFile metaInFile = new RandomAccessFile(metaFile, "r");
        if (ckoff > 0L) {
            metaInFile.seek(ckoff);
        }
        return new FSDatasetInterface.BlockInputStreams(new FileInputStream(blockInFile.getFD()), new FileInputStream(metaInFile.getFD()));
    }

    private FSDatasetInterface.BlockWriteStreams createBlockWriteStreams(File f, File metafile) throws IOException {
        return new FSDatasetInterface.BlockWriteStreams(new FileOutputStream(new RandomAccessFile(f, "rw").getFD()), new FileOutputStream(new RandomAccessFile(metafile, "rw").getFD()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detachBlock(Block block, int numLinks) throws IOException {
        DatanodeBlockInfo info = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            info = this.volumeMap.get(block);
        }
        return info.detachBlock(block, numLinks);
    }

    private static <T> void updateBlockMap(Map<Block, T> blockmap, Block oldblock, Block newblock) throws IOException {
        if (blockmap.containsKey(oldblock)) {
            T value = blockmap.remove(oldblock);
            blockmap.put(newblock, value);
        }
    }

    @Override
    public void updateBlock(Block oldblock, Block newblock) throws IOException {
        if (oldblock.getBlockId() != newblock.getBlockId()) {
            throw new IOException("Cannot update oldblock (=" + oldblock + ") to newblock (=" + newblock + ").");
        }
        List<Thread> threads;
        block2: while ((threads = this.tryUpdateBlock(oldblock, newblock)) != null) {
            for (Thread t : threads) {
                t.interrupt();
            }
            Iterator<Thread> i$ = threads.iterator();
            while (true) {
                Thread t;
                if (!i$.hasNext()) continue block2;
                t = i$.next();
                try {
                    t.join();
                    continue;
                }
                catch (InterruptedException e) {
                    DataNode.LOG.warn("interruptOngoingCreates: t=" + t, e);
                    continue;
                }
                break;
            }
            break;
        }
        return;
    }

    private synchronized List<Thread> tryUpdateBlock(Block oldblock, Block newblock) throws IOException {
        File newMetaFile;
        File blockFile;
        ActiveFile activefile = this.ongoingCreates.get(oldblock);
        if (activefile != null && !activefile.threads.isEmpty()) {
            Iterator<Thread> i = activefile.threads.iterator();
            while (i.hasNext()) {
                Thread t = i.next();
                if (t.isAlive()) continue;
                i.remove();
            }
            if (!activefile.threads.isEmpty()) {
                return new ArrayList<Thread>(activefile.threads);
            }
        }
        if ((blockFile = this.findBlockFile(oldblock.getBlockId())) == null) {
            throw new IOException("Block " + oldblock + " does not exist.");
        }
        File oldMetaFile = FSDataset.findMetaFile(blockFile);
        long oldgs = FSDataset.parseGenerationStamp(blockFile, oldMetaFile);
        File tmpMetaFile = new File(oldMetaFile.getParent(), oldMetaFile.getName() + "_tmp" + newblock.getGenerationStamp());
        if (!oldMetaFile.renameTo(tmpMetaFile)) {
            throw new IOException("Cannot rename block meta file to " + tmpMetaFile);
        }
        if (oldgs > newblock.getGenerationStamp()) {
            throw new IOException("Cannot update block (id=" + newblock.getBlockId() + ") generation stamp from " + oldgs + " to " + newblock.getGenerationStamp());
        }
        if (newblock.getNumBytes() > oldblock.getNumBytes()) {
            throw new IOException("Cannot update block file (=" + blockFile + ") length from " + oldblock.getNumBytes() + " to " + newblock.getNumBytes());
        }
        if (newblock.getNumBytes() < oldblock.getNumBytes()) {
            FSDataset.truncateBlock(blockFile, tmpMetaFile, oldblock.getNumBytes(), newblock.getNumBytes());
        }
        if (!tmpMetaFile.renameTo(newMetaFile = FSDataset.getMetaFile(blockFile, newblock))) {
            throw new IOException("Cannot rename tmp meta file to " + newMetaFile);
        }
        FSDataset.updateBlockMap(this.ongoingCreates, oldblock, newblock);
        FSDataset.updateBlockMap(this.volumeMap, oldblock, newblock);
        this.validateBlockMetadata(newblock);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void truncateBlock(File blockFile, File metaFile, long oldlen, long newlen) throws IOException {
        if (newlen == oldlen) {
            return;
        }
        if (newlen > oldlen) {
            throw new IOException("Cannout truncate block to from oldlen (=" + oldlen + ") to newlen (=" + newlen + ")");
        }
        DataChecksum dcs = BlockMetadataHeader.readHeader(metaFile).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        int bpc = dcs.getBytesPerChecksum();
        long n = (newlen - 1L) / (long)bpc + 1L;
        long newmetalen = (long)BlockMetadataHeader.getHeaderSize() + n * (long)checksumsize;
        long lastchunkoffset = (n - 1L) * (long)bpc;
        int lastchunksize = (int)(newlen - lastchunkoffset);
        byte[] b = new byte[Math.max(lastchunksize, checksumsize)];
        RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");
        try {
            blockRAF.setLength(newlen);
            blockRAF.seek(lastchunkoffset);
            blockRAF.readFully(b, 0, lastchunksize);
        }
        finally {
            blockRAF.close();
        }
        dcs.update(b, 0, lastchunksize);
        dcs.writeValue(b, 0, false);
        RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
        try {
            metaRAF.setLength(newmetalen);
            metaRAF.seek(newmetalen - (long)checksumsize);
            metaRAF.write(b, 0, checksumsize);
        }
        finally {
            metaRAF.close();
        }
    }

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith("Possible disk error on file creation: ")) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDatasetInterface.BlockWriteStreams writeToBlock(Block b, boolean isRecovery) throws IOException {
        if (this.isValidBlock(b)) {
            if (!isRecovery) {
                throw new BlockAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
            }
            this.detachBlock(b, 1);
        }
        long blockSize = b.getNumBytes();
        File f = null;
        List<Thread> threads = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            ActiveFile activeFile = this.ongoingCreates.get(b);
            if (activeFile != null) {
                f = activeFile.file;
                threads = activeFile.threads;
                if (!isRecovery) {
                    throw new BlockAlreadyExistsException("Block " + b + " has already been started (though not completed), and thus cannot be created.");
                }
                for (Thread thread : threads) {
                    thread.interrupt();
                }
                this.ongoingCreates.remove(b);
            }
            FSVolume v = null;
            if (!isRecovery) {
                v = this.volumes.getNextVolume(blockSize);
                f = this.createTmpFile(v, b);
                this.volumeMap.put(b, new DatanodeBlockInfo(v));
            } else if (f != null) {
                DataNode.LOG.info("Reopen already-open Block for append " + b);
                v = this.volumeMap.get(b).getVolume();
                this.volumeMap.put(b, new DatanodeBlockInfo(v));
            } else {
                DataNode.LOG.info("Reopen Block for append " + b);
                v = this.volumeMap.get(b).getVolume();
                f = this.createTmpFile(v, b);
                File blkfile = this.getBlockFile(b);
                File oldmeta = this.getMetaFile(b);
                File newmeta = FSDataset.getMetaFile(f, b);
                DataNode.LOG.debug("Renaming " + oldmeta + " to " + newmeta);
                if (!oldmeta.renameTo(newmeta)) {
                    throw new IOException("Block " + b + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to tmp dir " + newmeta);
                }
                DataNode.LOG.debug("Renaming " + blkfile + " to " + f);
                if (!blkfile.renameTo(f)) {
                    if (!f.delete()) {
                        throw new IOException("Block " + b + " reopen failed. " + " Unable to remove file " + f);
                    }
                    if (!blkfile.renameTo(f)) {
                        throw new IOException("Block " + b + " reopen failed. " + " Unable to move block file " + blkfile + " to tmp dir " + f);
                    }
                }
                this.volumeMap.put(b, new DatanodeBlockInfo(v));
            }
            if (f == null) {
                DataNode.LOG.warn("Block " + b + " reopen failed " + " Unable to locate tmp file.");
                throw new IOException("Block " + b + " reopen failed " + " Unable to locate tmp file.");
            }
            this.ongoingCreates.put(b, new ActiveFile(f, threads));
        }
        try {
            if (threads != null) {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Recovery waiting for thread interrupted.");
        }
        File metafile = FSDataset.getMetaFile(f, b);
        DataNode.LOG.debug("writeTo blockfile is " + f + " of size " + f.length());
        DataNode.LOG.debug("writeTo metafile is " + metafile + " of size " + metafile.length());
        return this.createBlockWriteStreams(f, metafile);
    }

    @Override
    public long getChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.dataOut;
        return file.getChannel().position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams, long dataOffset, long ckOffset) throws IOException {
        long size = 0L;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            FSVolume vol = this.volumeMap.get(b).getVolume();
            size = vol.getTmpFile(b).length();
        }
        if (size < dataOffset) {
            String msg = "Trying to change block file offset of block " + b + " to " + dataOffset + " but actual size of file is " + size;
            throw new IOException(msg);
        }
        FileOutputStream file = (FileOutputStream)streams.dataOut;
        file.getChannel().position(dataOffset);
        file = (FileOutputStream)streams.checksumOut;
        file.getChannel().position(ckOffset);
    }

    synchronized File createTmpFile(FSVolume vol, Block blk) throws IOException {
        if (vol == null && (vol = this.volumeMap.get(blk).getVolume()) == null) {
            throw new IOException("Could not find volume for block " + blk);
        }
        return vol.createTmpFile(blk);
    }

    @Override
    public synchronized void finalizeBlock(Block b) throws IOException {
        ActiveFile activeFile = this.ongoingCreates.get(b);
        if (activeFile == null) {
            throw new IOException("Block " + b + " is already finalized.");
        }
        File f = activeFile.file;
        if (f == null || !f.exists()) {
            throw new IOException("No temporary file " + f + " for block " + b);
        }
        FSVolume v = this.volumeMap.get(b).getVolume();
        if (v == null) {
            throw new IOException("No volume for temporary file " + f + " for block " + b);
        }
        File dest = null;
        dest = v.addBlock(b, f);
        this.volumeMap.put(b, new DatanodeBlockInfo(v, dest));
        this.ongoingCreates.remove(b);
    }

    @Override
    public synchronized void unfinalizeBlock(Block b) throws IOException {
        ActiveFile activefile = this.ongoingCreates.remove(b);
        if (activefile == null) {
            return;
        }
        this.volumeMap.remove(b);
        if (this.delBlockFromDisk(activefile.file, FSDataset.getMetaFile(activefile.file, b), b)) {
            DataNode.LOG.warn("Block " + b + " unfinalized and removed. ");
        }
    }

    private boolean delBlockFromDisk(File blockFile, File metaFile, Block b) {
        if (blockFile == null) {
            DataNode.LOG.warn("No file exists for block: " + b);
            return true;
        }
        if (!blockFile.delete()) {
            DataNode.LOG.warn("Not able to delete the block file: " + blockFile);
            return false;
        }
        if (metaFile != null && !metaFile.delete()) {
            DataNode.LOG.warn("Not able to delete the meta block file: " + metaFile);
            return false;
        }
        return true;
    }

    @Override
    public Block[] getBlockReport() {
        TreeSet<Block> blockSet = new TreeSet<Block>();
        this.volumes.getBlockInfo(blockSet);
        Block[] blockTable = new Block[blockSet.size()];
        int i = 0;
        Iterator<Block> it = blockSet.iterator();
        while (it.hasNext()) {
            blockTable[i] = it.next();
            ++i;
        }
        return blockTable;
    }

    @Override
    public boolean isValidBlock(Block b) {
        return this.validateBlockFile(b) != null;
    }

    File validateBlockFile(Block b) {
        File f = this.getFile(b);
        if (f != null && f.exists()) {
            return f;
        }
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.debug("b=" + b + ", f=" + f);
        }
        return null;
    }

    @Override
    public void validateBlockMetadata(Block b) throws IOException {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info == null) {
            throw new IOException("Block " + b + " does not exist in volumeMap.");
        }
        FSVolume v = info.getVolume();
        File tmp = v.getTmpFile(b);
        File f = this.getFile(b);
        if (f == null) {
            f = tmp;
        }
        if (f == null) {
            throw new IOException("Block " + b + " does not exist on disk.");
        }
        if (!f.exists()) {
            throw new IOException("Block " + b + " block file " + f + " does not exist on disk.");
        }
        if (b.getNumBytes() != f.length()) {
            throw new IOException("Block " + b + " length is " + b.getNumBytes() + " does not match block file length " + f.length());
        }
        File meta = FSDataset.getMetaFile(f, b);
        if (meta == null) {
            throw new IOException("Block " + b + " metafile does not exist.");
        }
        if (!meta.exists()) {
            throw new IOException("Block " + b + " metafile " + meta + " does not exist on disk.");
        }
        if (meta.length() == 0L) {
            throw new IOException("Block " + b + " metafile " + meta + " is empty.");
        }
        long stamp = FSDataset.parseGenerationStamp(f, meta);
        if (stamp != b.getGenerationStamp()) {
            throw new IOException("Block " + b + " genstamp is " + b.getGenerationStamp() + " does not match meta file stamp " + stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Block[] invalidBlks) throws IOException {
        boolean error = false;
        for (int i = 0; i < invalidBlks.length; ++i) {
            FSVolume v;
            File f = null;
            FSDataset fSDataset = this;
            synchronized (fSDataset) {
                f = this.getFile(invalidBlks[i]);
                DatanodeBlockInfo dinfo = this.volumeMap.get(invalidBlks[i]);
                if (dinfo == null) {
                    DataNode.LOG.warn("Unexpected error trying to delete block " + invalidBlks[i] + ". BlockInfo not found in volumeMap.");
                    error = true;
                    continue;
                }
                v = dinfo.getVolume();
                if (f == null) {
                    DataNode.LOG.warn("Unexpected error trying to delete block " + invalidBlks[i] + ". Block not found in blockMap." + (v == null ? " " : " Block found in volumeMap."));
                    error = true;
                    continue;
                }
                if (v == null) {
                    DataNode.LOG.warn("Unexpected error trying to delete block " + invalidBlks[i] + ". No volume for this block." + " Block found in blockMap. " + f + ".");
                    error = true;
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    DataNode.LOG.warn("Unexpected error trying to delete block " + invalidBlks[i] + ". Parent not found for file " + f + ".");
                    error = true;
                    continue;
                }
                v.clearPath(parent);
                this.volumeMap.remove(invalidBlks[i]);
            }
            File metaFile = FSDataset.getMetaFile(f, invalidBlks[i]);
            long blockSize = f.length() + metaFile.length();
            if (!f.delete() || !metaFile.delete() && metaFile.exists()) {
                DataNode.LOG.warn("Unexpected error trying to delete block " + invalidBlks[i] + " at file " + f);
                error = true;
                continue;
            }
            v.decDfsUsed(blockSize);
            DataNode.LOG.info("Deleting block " + invalidBlks[i] + " file " + f);
            if (!f.exists()) continue;
            DataNode.LOG.info("File " + f + " was deleted but still exists!");
        }
        if (error) {
            throw new IOException("Error in deleting blocks.");
        }
    }

    public synchronized File getFile(Block b) {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info != null) {
            return info.getFile();
        }
        return null;
    }

    @Override
    public void checkDataDir() throws DiskChecker.DiskErrorException {
        this.volumes.checkDirs();
    }

    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    @Override
    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
        if (this.volumes != null) {
            for (FSVolume volume : this.volumes.volumes) {
                if (volume == null) continue;
                volume.dfsUsage.shutdown();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActiveFile {
        final File file;
        final List<Thread> threads = new ArrayList<Thread>(2);

        ActiveFile(File f, List<Thread> list) {
            this.file = f;
            if (list != null) {
                this.threads.addAll(list);
            }
            this.threads.add(Thread.currentThread());
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(file=" + this.file + ", threads=" + this.threads + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FSVolumeSet {
        FSVolume[] volumes;
        int curVolume;

        synchronized FSVolume getNextVolume(long blockSize) throws IOException {
            int startVolume = this.curVolume;
            do {
                FSVolume volume = this.volumes[this.curVolume];
                this.curVolume = (this.curVolume + 1) % this.volumes.length;
                if (volume.getAvailable() <= blockSize) continue;
                return volume;
            } while (this.curVolume != startVolume);
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for an additional block");
        }

        long getDfsUsed() throws IOException {
            long dfsUsed = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                dfsUsed += this.volumes[idx].getDfsUsed();
            }
            return dfsUsed;
        }

        synchronized long getCapacity() throws IOException {
            long capacity = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                capacity += this.volumes[idx].getCapacity();
            }
            return capacity;
        }

        synchronized long getRemaining() throws IOException {
            long remaining = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                remaining += this.volumes[idx].getAvailable();
            }
            return remaining;
        }

        synchronized void getBlockInfo(TreeSet<Block> blockSet) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getBlockInfo(blockSet);
            }
        }

        synchronized void checkDirs() throws DiskChecker.DiskErrorException {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].checkDirs();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                sb.append(this.volumes[idx].toString());
                if (idx == this.volumes.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSVolume {
        private FSDir dataDir;
        private File tmpDir;
        private File detachDir;
        private DF usage;
        private DU dfsUsage;
        private long reserved;

        void decDfsUsed(long value) {
            this.dfsUsage.decDfsUsed(value);
        }

        long getDfsUsed() throws IOException {
            return this.dfsUsage.getUsed();
        }

        long getCapacity() throws IOException {
            if (this.reserved > this.usage.getCapacity()) {
                return 0L;
            }
            return this.usage.getCapacity() - this.reserved;
        }

        long getAvailable() throws IOException {
            long available;
            long remaining = this.getCapacity() - this.getDfsUsed();
            if (remaining > (available = this.usage.getAvailable())) {
                remaining = available;
            }
            return remaining > 0L ? remaining : 0L;
        }

        File getDir() {
            return this.dataDir.dir;
        }

        File createTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            return this.createTmpFile(b, f);
        }

        File getTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            return f;
        }

        File createDetachFile(Block b, String filename) throws IOException {
            File f = new File(this.detachDir, filename);
            return this.createTmpFile(b, f);
        }

        private File createTmpFile(Block b, File f) throws IOException {
            if (f.exists()) {
                throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
            }
            boolean fileCreated = false;
            try {
                fileCreated = f.createNewFile();
            }
            catch (IOException ioe) {
                throw (IOException)new IOException("Possible disk error on file creation: " + f).initCause(ioe);
            }
            if (!fileCreated) {
                throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
            }
            return f;
        }

        File addBlock(Block b, File f) throws IOException {
            File blockFile = this.dataDir.addBlock(b, f);
            File metaFile = FSDataset.getMetaFile(blockFile, b);
            this.dfsUsage.incDfsUsed(b.getNumBytes() + metaFile.length());
            return blockFile;
        }

        void checkDirs() throws DiskChecker.DiskErrorException {
            this.dataDir.checkDirTree();
            DiskChecker.checkDir(this.tmpDir);
        }

        void getBlockInfo(TreeSet<Block> blockSet) {
            this.dataDir.getBlockInfo(blockSet);
        }

        void clearPath(File f) {
            this.dataDir.clearPath(f);
        }

        public String toString() {
            return this.dataDir.dir.getAbsolutePath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSDir {
        File dir;
        int numBlocks = 0;
        FSDir[] children;
        int lastChildIdx = 0;

        public FSDir(File dir) throws IOException {
            this.dir = dir;
            this.children = null;
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + dir.toString());
                }
            } else {
                File[] files = dir.listFiles();
                int numChildren = 0;
                for (int idx = 0; idx < files.length; ++idx) {
                    if (files[idx].isDirectory()) {
                        ++numChildren;
                        continue;
                    }
                    if (!Block.isBlockFilename(files[idx])) continue;
                    ++this.numBlocks;
                }
                if (numChildren > 0) {
                    this.children = new FSDir[numChildren];
                    int curdir = 0;
                    for (int idx = 0; idx < files.length; ++idx) {
                        if (!files[idx].isDirectory()) continue;
                        this.children[curdir] = new FSDir(files[idx]);
                        ++curdir;
                    }
                }
            }
        }

        public File addBlock(Block b, File src) throws IOException {
            File file = this.addBlock(b, src, false, false);
            return file != null ? file : this.addBlock(b, src, true, true);
        }

        private File addBlock(Block b, File src, boolean createOk, boolean resetIdx) throws IOException {
            if (this.numBlocks < FSDataset.this.maxBlocksPerDir) {
                File newmeta;
                File dest = new File(this.dir, b.getBlockName());
                File metaData = FSDataset.getMetaFile(src, b);
                if (!metaData.renameTo(newmeta = FSDataset.getMetaFile(dest, b)) || !src.renameTo(dest)) {
                    throw new IOException("could not move files for " + b + " from tmp to " + dest.getAbsolutePath());
                }
                if (DataNode.LOG.isDebugEnabled()) {
                    DataNode.LOG.debug("addBlock: Moved " + metaData + " to " + newmeta);
                    DataNode.LOG.debug("addBlock: Moved " + src + " to " + dest);
                }
                ++this.numBlocks;
                return dest;
            }
            if (this.lastChildIdx < 0 && resetIdx) {
                this.lastChildIdx = random.nextInt(this.children.length);
            }
            if (this.lastChildIdx >= 0 && this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    int idx = (this.lastChildIdx + i) % this.children.length;
                    File file = this.children[idx].addBlock(b, src, false, resetIdx);
                    if (file == null) continue;
                    this.lastChildIdx = idx;
                    return file;
                }
                this.lastChildIdx = -1;
            }
            if (!createOk) {
                return null;
            }
            if (this.children == null || this.children.length == 0) {
                this.children = new FSDir[FSDataset.this.maxBlocksPerDir];
                for (int idx = 0; idx < FSDataset.this.maxBlocksPerDir; ++idx) {
                    this.children[idx] = new FSDir(new File(this.dir, "subdir" + idx));
                }
            }
            this.lastChildIdx = random.nextInt(this.children.length);
            return this.children[this.lastChildIdx].addBlock(b, src, true, false);
        }

        long getGenerationStampFromFile(File[] listdir, File blockFile) {
            String blockName = blockFile.getName();
            for (int j = 0; j < listdir.length; ++j) {
                String[] str;
                String[] vals;
                String path = listdir[j].getName();
                if (!path.startsWith(blockName) || (vals = path.split("_")).length != 3 || (str = vals[2].split("\\.")).length != 2) continue;
                return Long.parseLong(str[0]);
            }
            DataNode.LOG.warn("Block " + blockFile + " does not have a metafile!");
            return 0L;
        }

        public void getBlockInfo(TreeSet<Block> blockSet) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getBlockInfo(blockSet);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                long genStamp = this.getGenerationStampFromFile(blockFiles, blockFiles[i]);
                blockSet.add(new Block(blockFiles[i], blockFiles[i].length(), genStamp));
            }
        }

        public void checkDirTree() throws DiskChecker.DiskErrorException {
            DiskChecker.checkDir(this.dir);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].checkDirTree();
                }
            }
        }

        void clearPath(File f) {
            String[] dirNames;
            String root = this.dir.getAbsolutePath();
            String dir = f.getAbsolutePath();
            if (dir.startsWith(root) && this.clearPath(f, dirNames = dir.substring(root.length()).split(File.separator + "subdir"), 1)) {
                return;
            }
            this.clearPath(f, null, -1);
        }

        private boolean clearPath(File f, String[] dirNames, int idx) {
            if ((dirNames == null || idx == dirNames.length) && this.dir.compareTo(f) == 0) {
                --this.numBlocks;
                return true;
            }
            if (dirNames != null) {
                int childIdx;
                if (idx > dirNames.length - 1 || this.children == null) {
                    return false;
                }
                try {
                    childIdx = Integer.parseInt(dirNames[idx]);
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
                return childIdx >= 0 && childIdx < this.children.length ? this.children[childIdx].clearPath(f, dirNames, idx + 1) : false;
            }
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!this.children[i].clearPath(f, null, -1)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "FSDir{dir=" + this.dir + ", children=" + (this.children == null ? null : Arrays.asList(this.children)) + "}";
        }
    }
}

