/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.util.Daemon;

public class DataStorage
extends Storage {
    private String storageID = "";
    private static final Pattern PRE_GENSTAMP_META_FILE_PATTERN = Pattern.compile("(.*blk_[-]*\\d+)\\.meta$");

    DataStorage() {
        super(HdfsConstants.NodeType.DATA_NODE);
    }

    public String getStorageID() {
        return this.storageID;
    }

    void setStorageID(String newStorageID) {
        this.storageID = newStorageID;
    }

    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        props.setProperty("storageID", this.storageID);
    }

    void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = sd.getRoot().getCanonicalPath();
        LOG.info("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime());
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = sd.getFinalizedTmp();
        DataStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            public void run() {
                try {
                    DataStorage.deleteDir(tmpDir);
                }
                catch (IOException ex) {
                    Storage.LOG.error("Finalize upgrade for " + dataDirPath + " failed.", ex);
                }
                Storage.LOG.info("Finalize upgrade for " + dataDirPath + " is complete.");
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    void finalizeUpgrade() throws IOException {
        Iterator it = this.storageDirs.iterator();
        while (it.hasNext()) {
            this.doFinalize((Storage.StorageDirectory)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldF = new File(rootDir, "storage");
        if (oldF.exists()) {
            return;
        }
        if (!oldF.createNewFile()) {
            throw new IOException("Cannot create file " + oldF);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }
}

