/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.UnregisteredDatanodeException;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.UpgradeManagerDatanode;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockMetaDataInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNode
extends Configured
implements Runnable,
ClientDatanodeProtocol,
FSConstants,
InterDatanodeProtocol {
    public static final Log LOG = LogFactory.getLog(DataNode.class);
    static final Log ClientTraceLog;
    public DatanodeProtocol namenode;
    public FSDatasetInterface data;
    public DatanodeRegistration dnRegistration;
    volatile boolean shouldRun;
    private LinkedList<Block> receivedBlockList;
    private final Map<Block, Block> ongoingRecovery;
    private LinkedList<String> delHints;
    AtomicInteger xmitsInProgress;
    Daemon dataXceiverServer;
    ThreadGroup threadGroup;
    long blockReportInterval;
    long lastBlockReport;
    boolean resetBlockReportTime;
    long initialBlockReportDelay;
    long lastHeartbeat;
    long heartBeatInterval;
    private DataStorage storage;
    private HttpServer infoServer;
    DataNodeMetrics myMetrics;
    private static InetSocketAddress nameNodeAddr;
    private static DataNode datanodeObject;
    private Thread dataNodeThread;
    String machineName;
    int socketTimeout;
    int socketWriteTimeout;
    boolean transferToAllowed;
    int writePacketSize;
    public DataBlockScanner blockScanner;
    public Daemon blockScannerThread;
    private static final Random R;
    public Server ipcServer;
    UpgradeManagerDatanode upgradeManager;

    static long now() {
        return System.currentTimeMillis();
    }

    protected Socket newSocket() throws IOException {
        return this.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    public static DataNode getDataNode() {
        return datanodeObject;
    }

    public static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeID, Configuration configuration) throws IOException {
        InetSocketAddress inetSocketAddress = NetUtils.createSocketAddr(datanodeID.getHost() + ":" + datanodeID.getIpcPort());
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.info("InterDatanodeProtocol addr=" + inetSocketAddress);
        }
        return (InterDatanodeProtocol)RPC.getProxy(InterDatanodeProtocol.class, 3L, inetSocketAddress, configuration);
    }

    public InetSocketAddress getNameNodeAddr() {
        return nameNodeAddr;
    }

    DataNodeMetrics getMetrics() {
        return this.myMetrics;
    }

    public static void setNewStorageID(DatanodeRegistration dnReg) {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP("default");
        }
        catch (UnknownHostException ignored) {
            LOG.warn("Could not find ip address of \"default\" inteface.");
        }
        int rand = 0;
        try {
            rand = SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Could not use SecureRandom");
            rand = R.nextInt(Integer.MAX_VALUE);
        }
        dnReg.storageID = "DS-" + rand + "-" + ip + "-" + dnReg.getPort() + "-" + System.currentTimeMillis();
    }

    private void register() throws IOException {
        if (this.dnRegistration.getStorageID().equals("")) {
            DataNode.setNewStorageID(this.dnRegistration);
        }
        while (this.shouldRun) {
            try {
                this.dnRegistration.name = this.machineName + ":" + this.dnRegistration.getPort();
                this.dnRegistration = this.namenode.register(this.dnRegistration);
                break;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                LOG.info("Problem connecting to server: " + this.getNameNodeAddr());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        assert ("".equals(this.storage.getStorageID()) && !"".equals(this.dnRegistration.getStorageID()) || this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) : "New storageID can be assigned only if data-node is not formatted";
        if (this.storage.getStorageID().equals("")) {
            this.storage.setStorageID(this.dnRegistration.getStorageID());
            this.storage.writeAll();
            LOG.info("New storage id " + this.dnRegistration.getStorageID() + " is assigned to data-node " + this.dnRegistration.getName());
        }
        if (!this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) {
            throw new IOException("Inconsistent storage IDs. Name-node returned " + this.dnRegistration.getStorageID() + ". Expecting " + this.storage.getStorageID());
        }
        this.scheduleBlockReport(this.initialBlockReportDelay);
    }

    public void shutdown() {
        if (this.infoServer != null) {
            try {
                this.infoServer.stop();
            }
            catch (Exception exception) {
                LOG.warn("Exception shutting down DataNode", exception);
            }
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        this.shouldRun = false;
        if (this.dataXceiverServer != null) {
            ((DataXceiverServer)this.dataXceiverServer.getRunnable()).kill();
            this.dataXceiverServer.interrupt();
            if (this.threadGroup != null) {
                while (true) {
                    this.threadGroup.interrupt();
                    LOG.info("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount());
                    if (this.threadGroup.activeCount() == 0) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.dataXceiverServer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        RPC.stopProxy(this.namenode);
        if (this.upgradeManager != null) {
            this.upgradeManager.shutdownUpgrade();
        }
        if (this.blockScannerThread != null) {
            this.blockScannerThread.interrupt();
            try {
                this.blockScannerThread.join(3600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.dataNodeThread != null) {
            this.dataNodeThread.interrupt();
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.myMetrics != null) {
            this.myMetrics.shutdown();
        }
    }

    protected void checkDiskError(IOException iOException) throws IOException {
        if (iOException.getMessage() != null && iOException.getMessage().startsWith("No space left on device")) {
            throw new DiskChecker.DiskOutOfSpaceException("No space left on device");
        }
        this.checkDiskError();
    }

    protected void checkDiskError() throws IOException {
        try {
            this.data.checkDataDir();
        }
        catch (DiskChecker.DiskErrorException de) {
            this.handleDiskError(de.getMessage());
        }
    }

    private void handleDiskError(String string) {
        LOG.warn("DataNode is shutting down.\n" + string);
        this.shouldRun = false;
        try {
            this.namenode.errorReport(this.dnRegistration, 1, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int getXceiverCount() {
        return this.threadGroup == null ? 0 : this.threadGroup.activeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws Exception {
        LOG.info("using BLOCKREPORT_INTERVAL of " + this.blockReportInterval + "msec" + " Initial delay: " + this.initialBlockReportDelay + "msec");
        while (this.shouldRun) {
            try {
                int n;
                LinkedList<String> linkedList;
                Writable[] writableArray;
                long l = DataNode.now();
                if (l - this.lastHeartbeat > this.heartBeatInterval) {
                    this.lastHeartbeat = l;
                    writableArray = this.namenode.sendHeartbeat(this.dnRegistration, this.data.getCapacity(), this.data.getDfsUsed(), this.data.getRemaining(), this.xmitsInProgress.get(), this.getXceiverCount());
                    this.myMetrics.heartbeats.inc(DataNode.now() - l);
                    if (!this.processCommand((DatanodeCommand[])writableArray)) continue;
                }
                writableArray = null;
                String[] stringArray = null;
                LinkedList<Block> linkedList2 = this.receivedBlockList;
                synchronized (linkedList2) {
                    linkedList = this.delHints;
                    synchronized (linkedList) {
                        n = this.receivedBlockList.size();
                        if (n > 0) {
                            if (n != this.delHints.size()) {
                                LOG.warn("Panic: receiveBlockList and delHints are not of the same length");
                            }
                            writableArray = this.receivedBlockList.toArray(new Block[n]);
                            stringArray = this.delHints.toArray(new String[n]);
                        }
                    }
                }
                if (writableArray != null) {
                    if (stringArray == null || stringArray.length != writableArray.length) {
                        LOG.warn("Panic: block array & delHintArray are not the same");
                    }
                    this.namenode.blockReceived(this.dnRegistration, (Block[])writableArray, stringArray);
                    linkedList2 = this.receivedBlockList;
                    synchronized (linkedList2) {
                        linkedList = this.delHints;
                        synchronized (linkedList) {
                            for (n = 0; n < writableArray.length; ++n) {
                                this.receivedBlockList.remove(writableArray[n]);
                                this.delHints.remove(stringArray[n]);
                            }
                        }
                    }
                }
                if (l - this.lastBlockReport > this.blockReportInterval) {
                    long l2 = DataNode.now();
                    Block[] blockArray = this.data.getBlockReport();
                    DatanodeCommand datanodeCommand = this.namenode.blockReport(this.dnRegistration, BlockListAsLongs.convertToArrayLongs(blockArray));
                    long l3 = DataNode.now() - l2;
                    this.myMetrics.blockReports.inc(l3);
                    LOG.info("BlockReport of " + blockArray.length + " blocks got processed in " + l3 + " msecs");
                    if (this.resetBlockReportTime) {
                        this.lastBlockReport = l - (long)R.nextInt((int)this.blockReportInterval);
                        this.resetBlockReportTime = false;
                    } else {
                        this.lastBlockReport += (DataNode.now() - this.lastBlockReport) / this.blockReportInterval * this.blockReportInterval;
                    }
                    this.processCommand(datanodeCommand);
                }
                if (this.blockScanner != null && this.blockScannerThread == null && this.upgradeManager.isUpgradeCompleted()) {
                    LOG.info("Starting Periodic block scanner.");
                    this.blockScannerThread = new Daemon(this.blockScanner);
                    this.blockScannerThread.start();
                }
                long l4 = this.heartBeatInterval - (System.currentTimeMillis() - this.lastHeartbeat);
                LinkedList<Block> linkedList3 = this.receivedBlockList;
                synchronized (linkedList3) {
                    if (l4 > 0L && this.receivedBlockList.size() == 0) {
                        try {
                            this.receivedBlockList.wait(l4);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (RemoteException remoteException) {
                String string = remoteException.getClassName();
                if (UnregisteredDatanodeException.class.getName().equals(string) || DisallowedDatanodeException.class.getName().equals(string) || IncorrectVersionException.class.getName().equals(string)) {
                    LOG.warn("DataNode is shutting down: " + StringUtils.stringifyException(remoteException));
                    this.shutdown();
                    return;
                }
                LOG.warn(StringUtils.stringifyException(remoteException));
            }
            catch (IOException iOException) {
                LOG.warn(StringUtils.stringifyException(iOException));
            }
        }
    }

    private boolean processCommand(DatanodeCommand[] datanodeCommandArray) {
        if (datanodeCommandArray != null) {
            for (DatanodeCommand datanodeCommand : datanodeCommandArray) {
                try {
                    if (!this.processCommand(datanodeCommand)) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    LOG.warn("Error processing datanode Command", iOException);
                }
            }
        }
        return true;
    }

    private boolean processCommand(DatanodeCommand datanodeCommand) throws IOException {
        if (datanodeCommand == null) {
            return true;
        }
        BlockCommand blockCommand = datanodeCommand instanceof BlockCommand ? (BlockCommand)datanodeCommand : null;
        switch (datanodeCommand.getAction()) {
            case 1: {
                this.transferBlocks(blockCommand.getBlocks(), blockCommand.getTargets());
                this.myMetrics.blocksReplicated.inc(blockCommand.getBlocks().length);
                break;
            }
            case 2: {
                Block[] blockArray = blockCommand.getBlocks();
                try {
                    if (this.blockScanner != null) {
                        this.blockScanner.deleteBlocks(blockArray);
                    }
                    this.data.invalidate(blockArray);
                }
                catch (IOException iOException) {
                    this.checkDiskError();
                    throw iOException;
                }
                this.myMetrics.blocksRemoved.inc(blockArray.length);
                break;
            }
            case 3: {
                this.shutdown();
                return false;
            }
            case 4: {
                LOG.info("DatanodeCommand action: DNA_REGISTER");
                if (!this.shouldRun) break;
                this.register();
                break;
            }
            case 5: {
                this.storage.finalizeUpgrade();
                break;
            }
            case 101: {
                this.processDistributedUpgradeCommand((UpgradeCommand)datanodeCommand);
                break;
            }
            case 6: {
                this.recoverBlocks(blockCommand.getBlocks(), blockCommand.getTargets());
                break;
            }
            default: {
                LOG.warn("Unknown DatanodeCommand action: " + datanodeCommand.getAction());
            }
        }
        return true;
    }

    private void processDistributedUpgradeCommand(UpgradeCommand upgradeCommand) throws IOException {
        assert (this.upgradeManager != null) : "DataNode.upgradeManager is null.";
        this.upgradeManager.processUpgradeCommand(upgradeCommand);
    }

    private void startDistributedUpgradeIfNeeded() throws IOException {
        UpgradeManagerDatanode upgradeManagerDatanode = DataNode.getDataNode().upgradeManager;
        assert (upgradeManagerDatanode != null) : "DataNode.upgradeManager is null.";
        if (!upgradeManagerDatanode.getUpgradeState()) {
            return;
        }
        upgradeManagerDatanode.setUpgradeState(false, upgradeManagerDatanode.getUpgradeVersion());
        upgradeManagerDatanode.startUpgrade();
    }

    private void transferBlock(Block block, DatanodeInfo[] datanodeInfoArray) throws IOException {
        if (!this.data.isValidBlock(block)) {
            String string = "Can't send invalid block " + block;
            LOG.info(string);
            this.namenode.errorReport(this.dnRegistration, 2, string);
            return;
        }
        long l = this.data.getLength(block);
        if (block.getNumBytes() > l) {
            this.namenode.reportBadBlocks(new LocatedBlock[]{new LocatedBlock(block, new DatanodeInfo[]{new DatanodeInfo(this.dnRegistration)})});
            LOG.info("Can't replicate block " + block + " because on-disk length " + l + " is shorter than NameNode recorded length " + block.getNumBytes());
            return;
        }
        int n = datanodeInfoArray.length;
        if (n > 0) {
            if (LOG.isInfoEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(datanodeInfoArray[i].getName());
                    stringBuilder.append(" ");
                }
                LOG.info(this.dnRegistration + " Starting thread to transfer block " + block + " to " + stringBuilder);
            }
            new Daemon(new DataTransfer(datanodeInfoArray, block, this)).start();
        }
    }

    private void transferBlocks(Block[] blockArray, DatanodeInfo[][] datanodeInfoArray) {
        for (int i = 0; i < blockArray.length; ++i) {
            try {
                this.transferBlock(blockArray[i], datanodeInfoArray[i]);
                continue;
            }
            catch (IOException iOException) {
                LOG.warn("Failed to transfer block " + blockArray[i], iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNamenodeReceivedBlock(Block block, String string) {
        if (block == null || string == null) {
            throw new IllegalArgumentException(block == null ? "Block is null" : "delHint is null");
        }
        LinkedList<Block> linkedList = this.receivedBlockList;
        synchronized (linkedList) {
            LinkedList<String> linkedList2 = this.delHints;
            synchronized (linkedList2) {
                this.receivedBlockList.add(block);
                this.delHints.add(string);
                this.receivedBlockList.notifyAll();
            }
        }
    }

    @Override
    public void run() {
        LOG.info(this.dnRegistration + "In DataNode.run, data = " + this.data);
        this.dataXceiverServer.start();
        while (this.shouldRun) {
            try {
                this.startDistributedUpgradeIfNeeded();
                this.offerService();
            }
            catch (Exception exception) {
                LOG.error("Exception: " + StringUtils.stringifyException(exception));
                if (!this.shouldRun) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        LOG.info(this.dnRegistration + ":Finishing DataNode in: " + this.data);
        this.shutdown();
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.dnRegistration.getName() + "'" + ", storageID='" + this.dnRegistration.getStorageID() + "'" + ", xmitsInProgress=" + this.xmitsInProgress.get() + "}";
    }

    public void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? System.currentTimeMillis() - (this.blockReportInterval - (long)R.nextInt((int)delay)) : this.lastHeartbeat - this.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    @Override
    public BlockMetaDataInfo getBlockMetaDataInfo(Block block) throws IOException {
        Block block2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("block=" + block);
        }
        if ((block2 = this.data.getStoredBlock(block.getBlockId())) == null) {
            return null;
        }
        BlockMetaDataInfo blockMetaDataInfo = new BlockMetaDataInfo(block2, this.blockScanner.getLastScanTime(block2));
        if (LOG.isDebugEnabled()) {
            LOG.debug("getBlockMetaDataInfo successful block=" + block2 + " length " + block2.getNumBytes() + " genstamp " + block2.getGenerationStamp());
        }
        this.data.validateBlockMetadata(block2);
        return blockMetaDataInfo;
    }

    public Daemon recoverBlocks(final Block[] blocks, final DatanodeInfo[][] targets) {
        Daemon d = new Daemon(this.threadGroup, new Runnable(){

            public void run() {
                for (int i = 0; i < blocks.length; ++i) {
                    try {
                        DataNode.logRecoverBlock("NameNode", blocks[i], targets[i]);
                        DataNode.this.recoverBlock(blocks[i], false, targets[i], true);
                        continue;
                    }
                    catch (IOException e) {
                        LOG.warn("recoverBlocks FAILED, blocks[" + i + "]=" + blocks[i], e);
                    }
                }
            }
        });
        d.start();
        return d;
    }

    @Override
    public void updateBlock(Block block, Block block2, boolean bl) throws IOException {
        LOG.info("oldblock=" + block + "(length=" + block.getNumBytes() + "), newblock=" + block2 + "(length=" + block2.getNumBytes() + "), datanode=" + this.dnRegistration.getName());
        this.data.updateBlock(block, block2);
        if (bl) {
            this.data.finalizeBlock(block2);
            this.myMetrics.blocksWritten.inc();
            this.notifyNamenodeReceivedBlock(block2, "");
            LOG.info("Received block " + block2 + " of size " + block2.getNumBytes() + " as part of lease recovery.");
        }
    }

    @Override
    public long getProtocolVersion(String string, long l) throws IOException {
        if (string.equals(InterDatanodeProtocol.class.getName())) {
            return 3L;
        }
        if (string.equals(ClientDatanodeProtocol.class.getName())) {
            return 3L;
        }
        throw new IOException("Unknown protocol to " + this.getClass().getSimpleName() + ": " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlock recoverBlock(Block block, boolean bl, DatanodeID[] datanodeIDArray, boolean bl2) throws IOException {
        Object object = this.ongoingRecovery;
        synchronized (object) {
            Block block2 = new Block();
            block2.set(block.getBlockId(), block.getNumBytes(), 1L);
            if (this.ongoingRecovery.get(block2) != null) {
                String string = "Block " + block + " is already being recovered, " + " ignoring this request to recover it.";
                LOG.info(string);
                throw new IOException(string);
            }
            this.ongoingRecovery.put(block, block);
        }
        try {
            object = new ArrayList();
            long l = Long.MAX_VALUE;
            int n = 0;
            for (DatanodeID datanodeID : datanodeIDArray) {
                try {
                    DataNode iOException = this.dnRegistration.equals(datanodeID) ? this : DataNode.createInterDataNodeProtocolProxy(datanodeID, this.getConf());
                    BlockMetaDataInfo blockMetaDataInfo = iOException.getBlockMetaDataInfo(block);
                    if (blockMetaDataInfo == null || blockMetaDataInfo.getGenerationStamp() < block.getGenerationStamp()) continue;
                    if (bl) {
                        if (blockMetaDataInfo.getNumBytes() != block.getNumBytes()) continue;
                        object.add(new BlockRecord(datanodeID, iOException, new Block(blockMetaDataInfo)));
                        continue;
                    }
                    object.add(new BlockRecord(datanodeID, iOException, new Block(blockMetaDataInfo)));
                    if (blockMetaDataInfo.getNumBytes() >= l) continue;
                    l = blockMetaDataInfo.getNumBytes();
                }
                catch (IOException iOException) {
                    ++n;
                    InterDatanodeProtocol.LOG.warn("Failed to getBlockMetaDataInfo for block (=" + block + ") from datanode (=" + datanodeID + ")", iOException);
                }
            }
            if (object.isEmpty() && n > 0) {
                throw new IOException("All datanodes failed: block=" + block + ", datanodeids=" + Arrays.asList(datanodeIDArray));
            }
            if (!bl) {
                block.setNumBytes(l);
            }
            LocatedBlock locatedBlock = this.syncBlock(block, (List<BlockRecord>)object, bl2);
            return locatedBlock;
        }
        finally {
            Map<Block, Block> map = this.ongoingRecovery;
            synchronized (map) {
                this.ongoingRecovery.remove(block);
            }
        }
    }

    private LocatedBlock syncBlock(Block block, List<BlockRecord> list, boolean bl) throws IOException {
        DatanodeID[] datanodeIDArray;
        if (LOG.isDebugEnabled()) {
            LOG.debug("block=" + block + ", (length=" + block.getNumBytes() + "), syncList=" + list + ", closeFile=" + bl);
        }
        if (list.isEmpty()) {
            this.namenode.commitBlockSynchronization(block, 0L, 0L, bl, true, DatanodeID.EMPTY_ARRAY);
            return null;
        }
        ArrayList<DatanodeID> arrayList = new ArrayList<DatanodeID>();
        long l = this.namenode.nextGenerationStamp(block);
        Block block2 = new Block(block.getBlockId(), block.getNumBytes(), l);
        for (BlockRecord datanodeInfoArray : list) {
            try {
                datanodeInfoArray.datanode.updateBlock(datanodeInfoArray.block, block2, bl);
                arrayList.add(datanodeInfoArray.id);
            }
            catch (IOException blockRecord) {
                InterDatanodeProtocol.LOG.warn("Failed to updateBlock (newblock=" + block2 + ", datanode=" + datanodeInfoArray.id + ")", blockRecord);
            }
        }
        if (!arrayList.isEmpty()) {
            datanodeIDArray = arrayList.toArray(new DatanodeID[arrayList.size()]);
            this.namenode.commitBlockSynchronization(block, block2.getGenerationStamp(), block2.getNumBytes(), bl, false, datanodeIDArray);
            DatanodeInfo[] datanodeInfoArray = new DatanodeInfo[datanodeIDArray.length];
            for (int i = 0; i < datanodeIDArray.length; ++i) {
                datanodeInfoArray[i] = new DatanodeInfo(datanodeIDArray[i]);
            }
            return new LocatedBlock(block2, datanodeInfoArray);
        }
        datanodeIDArray = new StringBuilder();
        for (BlockRecord blockRecord : list) {
            datanodeIDArray.append("\n  " + blockRecord.id);
        }
        throw new IOException("Cannot recover " + block + ", none of these " + list.size() + " datanodes success {" + datanodeIDArray + "\n}");
    }

    @Override
    public LocatedBlock recoverBlock(Block block, boolean bl, DatanodeInfo[] datanodeInfoArray) throws IOException {
        DataNode.logRecoverBlock("Client", block, datanodeInfoArray);
        return this.recoverBlock(block, bl, datanodeInfoArray, false);
    }

    private static void logRecoverBlock(String string, Block block, DatanodeID[] datanodeIDArray) {
        StringBuilder stringBuilder = new StringBuilder(datanodeIDArray[0].getName());
        for (int i = 1; i < datanodeIDArray.length; ++i) {
            stringBuilder.append(", " + datanodeIDArray[i].getName());
        }
        LOG.info(string + " calls recoverBlock(block=" + block + ", targets=[" + stringBuilder + "])");
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        ClientTraceLog = LogFactory.getLog(DataNode.class.getName() + ".clienttrace");
        datanodeObject = null;
        R = new Random();
    }

    private static class BlockRecord {
        final DatanodeID id;
        final InterDatanodeProtocol datanode;
        final Block block;

        BlockRecord(DatanodeID id, InterDatanodeProtocol datanode, Block block) {
            this.id = id;
            this.datanode = datanode;
            this.block = block;
        }

        public String toString() {
            return "block:" + this.block + " node:" + this.id;
        }
    }

    class DataTransfer
    implements Runnable {
        DatanodeInfo[] targets;
        Block b;
        DataNode datanode;

        public DataTransfer(DatanodeInfo[] targets, Block b, DataNode datanode) throws IOException {
            this.targets = targets;
            this.b = b;
            this.datanode = datanode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                DataNode.this.xmitsInProgress.getAndIncrement();
                Socket sock = null;
                DataOutputStream out = null;
                BlockSender blockSender = null;
                try {
                    InetSocketAddress curTarget = NetUtils.createSocketAddr(this.targets[0].getName());
                    sock = DataNode.this.newSocket();
                    NetUtils.connect(sock, curTarget, DataNode.this.socketTimeout);
                    sock.setSoTimeout(this.targets.length * DataNode.this.socketTimeout);
                    long writeTimeout = DataNode.this.socketWriteTimeout + 5000 * (this.targets.length - 1);
                    OutputStream baseStream = NetUtils.getOutputStream(sock, writeTimeout);
                    out = new DataOutputStream(new BufferedOutputStream(baseStream, FSConstants.SMALL_BUFFER_SIZE));
                    blockSender = new BlockSender(this.b, 0L, this.b.getNumBytes(), false, false, false, this.datanode);
                    DatanodeInfo srcNode = new DatanodeInfo(DataNode.this.dnRegistration);
                    out.writeShort(14);
                    out.writeByte(80);
                    out.writeLong(this.b.getBlockId());
                    out.writeLong(this.b.getGenerationStamp());
                    out.writeInt(0);
                    out.writeBoolean(false);
                    Text.writeString(out, "");
                    out.writeBoolean(true);
                    srcNode.write(out);
                    out.writeInt(this.targets.length - 1);
                    for (int i = 1; i < this.targets.length; ++i) {
                        this.targets[i].write(out);
                    }
                    blockSender.sendBlock(out, baseStream, null);
                    LOG.info(DataNode.this.dnRegistration + ":Transmitted block " + this.b + " to " + curTarget);
                    DataNode.this.xmitsInProgress.getAndDecrement();
                }
                catch (IOException ie) {
                    LOG.warn(DataNode.this.dnRegistration + ":Failed to transfer " + this.b + " to " + this.targets[0].getName() + " got " + StringUtils.stringifyException(ie));
                    break block6;
                }
                finally {
                    DataNode.this.xmitsInProgress.getAndDecrement();
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeSocket(sock);
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeSocket(sock);
            }
        }
    }
}

