/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

public class DatanodeInfo
extends DatanodeID
implements Node {
    protected long capacity;
    protected long dfsUsed;
    protected long remaining;
    protected long lastUpdate;
    protected int xceiverCount;
    protected String location = "/default-rack";
    protected String hostName = null;
    protected AdminStates adminState;
    private int level;
    private Node parent;

    public DatanodeInfo() {
        this.adminState = null;
    }

    public DatanodeInfo(DatanodeID nodeID) {
        super(nodeID);
        this.capacity = 0L;
        this.dfsUsed = 0L;
        this.remaining = 0L;
        this.lastUpdate = 0L;
        this.xceiverCount = 0;
        this.adminState = null;
    }

    protected DatanodeInfo(DatanodeID nodeID, String location, String hostName) {
        this(nodeID);
        this.location = location;
        this.hostName = hostName;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public int getXceiverCount() {
        return this.xceiverCount;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public synchronized String getNetworkLocation() {
        return this.location;
    }

    public synchronized void setNetworkLocation(String location) {
        this.location = NodeBase.normalize(location);
    }

    public String getHostName() {
        return this.hostName == null || this.hostName.length() == 0 ? this.getHost() : this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public void startDecommission() {
        this.adminState = AdminStates.DECOMMISSION_INPROGRESS;
    }

    public boolean isDecommissionInProgress() {
        return this.adminState == AdminStates.DECOMMISSION_INPROGRESS;
    }

    public boolean isDecommissioned() {
        return this.adminState == AdminStates.DECOMMISSIONED;
    }

    public void setDecommissioned() {
        this.adminState = AdminStates.DECOMMISSIONED;
    }

    AdminStates getAdminState() {
        if (this.adminState == null) {
            return AdminStates.NORMAL;
        }
        return this.adminState;
    }

    protected void setAdminState(AdminStates newState) {
        this.adminState = newState == AdminStates.NORMAL ? null : newState;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.ipcPort);
        out.writeLong(this.capacity);
        out.writeLong(this.dfsUsed);
        out.writeLong(this.remaining);
        out.writeLong(this.lastUpdate);
        out.writeInt(this.xceiverCount);
        Text.writeString(out, this.location);
        Text.writeString(out, this.hostName == null ? "" : this.hostName);
        WritableUtils.writeEnum(out, this.getAdminState());
    }

    public void readFields(DataInput dataInput) throws IOException {
        super.readFields(dataInput);
        this.ipcPort = dataInput.readShort() & 0xFFFF;
        this.capacity = dataInput.readLong();
        this.dfsUsed = dataInput.readLong();
        this.remaining = dataInput.readLong();
        this.lastUpdate = dataInput.readLong();
        this.xceiverCount = dataInput.readInt();
        this.location = Text.readString(dataInput);
        this.hostName = Text.readString(dataInput);
        this.setAdminState(WritableUtils.readEnum(dataInput, AdminStates.class));
    }

    static {
        WritableFactories.setFactory(DatanodeInfo.class, new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeInfo();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdminStates {
        NORMAL,
        DECOMMISSION_INPROGRESS,
        DECOMMISSIONED;

    }
}

