/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Progressable;

public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        InetSocketAddress namenode = NameNode.getAddress(uri.getAuthority());
        this.dfs = new DFSClient(namenode, conf, this.statistics);
        this.uri = NameNode.getUri(namenode);
        this.workingDir = this.getHomeDirectory();
    }

    protected void checkPath(Path path) {
        URI thisUri = this.getUri();
        URI thatUri = path.toUri();
        String thatAuthority = thatUri.getAuthority();
        if (thatUri.getScheme() != null && thatUri.getScheme().equalsIgnoreCase(thisUri.getScheme()) && thatUri.getPort() == 8020 && thisUri.getPort() == -1 && thatAuthority.substring(0, thatAuthority.indexOf(":")).equalsIgnoreCase(thisUri.getAuthority())) {
            return;
        }
        super.checkPath(path);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public Path getHomeDirectory() {
        return new Path("/user/" + this.dfs.ugi.getUserName()).makeQualified(this);
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = this.makeAbsolute(file).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPathName(f), bufferSize, this.verifyChecksum, this.statistics));
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        DFSClient.DFSOutputStream op = (DFSClient.DFSOutputStream)this.dfs.append(this.getPathName(f), bufferSize, progress);
        return new FSDataOutputStream(op, this.statistics, op.getInitialLen());
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, overwrite, replication, blockSize, progress, bufferSize), this.statistics);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.dfs.rename(this.getPathName(src), this.getPathName(dst));
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.dfs.delete(this.getPathName(f), recursive);
    }

    private FileStatus makeQualified(FileStatus f) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getPath().makeQualified(this));
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        FileStatus[] infos = this.dfs.listPaths(this.getPathName(p));
        if (infos == null) {
            return null;
        }
        FileStatus[] stats = new FileStatus[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            stats[i] = this.makeQualified(infos[i]);
        }
        return stats;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.getPathName(f), permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.processDeleteOnExit();
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus fi = this.dfs.getFileInfo(this.getPathName(f));
        if (fi != null) {
            return this.makeQualified(fi);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.dfs.setPermission(this.getPathName(p), permission);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.dfs.setTimes(this.getPathName(p), mtime, atime);
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
    }
}

