/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import javax.net.SocketFactory;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFSClient
implements Closeable,
FSConstants {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    public final ClientProtocol namenode;
    private final ClientProtocol rpcNamenode;
    final UnixUserGroupInformation ugi;
    volatile boolean clientRunning = true;
    Random r = new Random();
    final String clientName;
    final LeaseChecker leasechecker = new LeaseChecker();
    private Configuration conf;
    private long defaultBlockSize;
    private short defaultReplication;
    private SocketFactory socketFactory;
    private int socketTimeout;
    private int datanodeWriteTimeout;
    final int writePacketSize;
    private final FileSystem.Statistics stats;
    private int maxBlockAcquireFailures;

    private static ClientProtocol createRPCNamenode(InetSocketAddress inetSocketAddress, Configuration configuration, UnixUserGroupInformation unixUserGroupInformation) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, 41L, inetSocketAddress, unixUserGroupInformation, configuration, NetUtils.getSocketFactory(configuration, ClientProtocol.class));
    }

    private static ClientProtocol createNamenode(ClientProtocol clientProtocol) throws IOException {
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(5, 60000L, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> hashMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        hashMap.put(AlreadyBeingCreatedException.class, retryPolicy);
        HashMap<Class<? extends Exception>, RetryPolicy> hashMap2 = new HashMap<Class<? extends Exception>, RetryPolicy>();
        hashMap2.put(RemoteException.class, RetryPolicies.retryByRemoteException(RetryPolicies.TRY_ONCE_THEN_FAIL, hashMap));
        RetryPolicy retryPolicy2 = RetryPolicies.retryByException(RetryPolicies.TRY_ONCE_THEN_FAIL, hashMap2);
        HashMap<String, RetryPolicy> hashMap3 = new HashMap<String, RetryPolicy>();
        hashMap3.put("create", retryPolicy2);
        return (ClientProtocol)RetryProxy.create(ClientProtocol.class, clientProtocol, hashMap3);
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeID, Configuration configuration) throws IOException {
        InetSocketAddress inetSocketAddress = NetUtils.createSocketAddr(datanodeID.getHost() + ":" + datanodeID.getIpcPort());
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.info("ClientDatanodeProtocol addr=" + inetSocketAddress);
        }
        return (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, 3L, inetSocketAddress, configuration);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeAddr, null, conf, stats);
    }

    DFSClient(InetSocketAddress inetSocketAddress, ClientProtocol clientProtocol, Configuration configuration, FileSystem.Statistics statistics) throws IOException {
        this.conf = configuration;
        this.stats = statistics;
        this.socketTimeout = configuration.getInt("dfs.socket.timeout", 60000);
        this.datanodeWriteTimeout = configuration.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.socketFactory = NetUtils.getSocketFactory(configuration, ClientProtocol.class);
        this.writePacketSize = configuration.getInt("dfs.write.packet.size", 65536);
        this.maxBlockAcquireFailures = configuration.getInt("dfs.client.max.block.acquire.failures", 3);
        try {
            this.ugi = UnixUserGroupInformation.login(configuration, true);
        }
        catch (LoginException loginException) {
            throw (IOException)new IOException().initCause(loginException);
        }
        String string = configuration.get("mapred.task.id");
        this.clientName = string != null ? "DFSClient_" + string : "DFSClient_" + this.r.nextInt();
        this.defaultBlockSize = configuration.getLong("dfs.block.size", 0x4000000L);
        this.defaultReplication = (short)configuration.getInt("dfs.replication", 3);
        if (inetSocketAddress != null && clientProtocol == null) {
            this.rpcNamenode = DFSClient.createRPCNamenode(inetSocketAddress, configuration, this.ugi);
            this.namenode = DFSClient.createNamenode(this.rpcNamenode);
        } else if (inetSocketAddress == null && clientProtocol != null) {
            this.namenode = this.rpcNamenode = clientProtocol;
        } else {
            throw new IllegalArgumentException("Expecting exactly one of nameNodeAddr and rpcNamenode being null: nameNodeAddr=" + inetSocketAddress + ", rpcNamenode=" + clientProtocol);
        }
    }

    private void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.leasechecker.close();
            this.clientRunning = false;
            try {
                this.leasechecker.interruptAndJoin();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RPC.stopProxy(this.rpcNamenode);
        }
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    private static LocatedBlocks callGetBlockLocations(ClientProtocol clientProtocol, String string, long l, long l2) throws IOException {
        try {
            return clientProtocol.getBlockLocations(string, l, l2);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException {
        this.checkOpen();
        return new DFSInputStream(src, buffersize, verifyChecksum);
    }

    public OutputStream create(String src, FsPermission permission, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask(this.conf));
        LOG.debug(src + ": masked=" + masked);
        DFSOutputStream result = new DFSOutputStream(src, masked, overwrite, replication, blockSize, progress, buffersize, this.conf.getInt("io.bytes.per.checksum", 512));
        this.leasechecker.put(src, result);
        return result;
    }

    OutputStream append(String string, int n, Progressable progressable) throws IOException {
        this.checkOpen();
        FileStatus fileStatus = null;
        LocatedBlock locatedBlock = null;
        try {
            fileStatus = this.getFileInfo(string);
            locatedBlock = this.namenode.append(string, this.clientName);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
        DFSOutputStream dFSOutputStream = new DFSOutputStream(string, n, progressable, locatedBlock, fileStatus, this.conf.getInt("io.bytes.per.checksum", 512));
        this.leasechecker.put(string, dFSOutputStream);
        return dFSOutputStream;
    }

    public boolean rename(String string, String string2) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.rename(string, string2);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
    }

    public boolean delete(String string, boolean bl) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.delete(string, bl);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class);
        }
    }

    public FileStatus[] listPaths(String string) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getListing(string);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class);
        }
    }

    public FileStatus getFileInfo(String string) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileInfo(string);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class);
        }
    }

    public void setPermission(String string, FsPermission fsPermission) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setPermission(string, fsPermission);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public boolean mkdirs(String string, FsPermission fsPermission) throws IOException {
        this.checkOpen();
        if (fsPermission == null) {
            fsPermission = FsPermission.getDefault();
        }
        FsPermission fsPermission2 = fsPermission.applyUMask(FsPermission.getUMask(this.conf));
        LOG.debug(string + ": masked=" + fsPermission2);
        try {
            return this.namenode.mkdirs(string, fsPermission2);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
    }

    public void setTimes(String string, long l, long l2) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setTimes(string, l, l2);
        }
        catch (RemoteException remoteException) {
            throw remoteException.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    private DatanodeInfo bestNode(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.containsKey(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    void reportChecksumFailure(String file, Block blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info("Found corruption while reading " + file + ".  Error repairing corrupt blocks.  Bad blocks remain. " + StringUtils.stringifyException(ie));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    static /* synthetic */ long access$100(DFSClient x0) {
        return x0.defaultBlockSize;
    }

    class DFSOutputStream
    extends FSOutputSummer {
        private Socket s;
        boolean closed;
        private String src;
        private DataOutputStream blockStream;
        private DataInputStream blockReplyStream;
        private Block block;
        private final long blockSize;
        private DataChecksum checksum;
        private LinkedList<Packet> dataQueue;
        private LinkedList<Packet> ackQueue;
        private Packet currentPacket;
        private int maxPackets;
        private DataStreamer streamer;
        private ResponseProcessor response;
        private long currentSeqno;
        private long bytesCurBlock;
        private int packetSize;
        private int chunksPerPacket;
        private DatanodeInfo[] nodes;
        private volatile boolean hasError;
        private volatile int errorIndex;
        private volatile IOException lastException;
        private long artificialSlowdown;
        private long lastFlushOffset;
        private boolean persistBlocks;
        private int recoveryErrorCount;
        private int maxRecoveryErrorCount;
        private volatile boolean appendChunk;
        private long initialFileSize;
        private Progressable progress;

        private void setLastException(IOException e) {
            if (this.lastException == null) {
                this.lastException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processDatanodeError(boolean hasError, boolean isAppend) {
            if (!hasError) {
                return false;
            }
            if (this.response != null) {
                LOG.info("Error Recovery for block " + this.block + " waiting for responder to exit. ");
                return true;
            }
            if (this.errorIndex >= 0) {
                LOG.warn("Error Recovery for block " + this.block + " bad datanode[" + this.errorIndex + "] " + (this.nodes == null ? "nodes == null" : this.nodes[this.errorIndex].getName()));
            }
            if (this.blockStream != null) {
                try {
                    this.blockStream.close();
                    this.blockReplyStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.blockStream = null;
            this.blockReplyStream = null;
            LinkedList<Packet> e = this.ackQueue;
            synchronized (e) {
                this.dataQueue.addAll(0, this.ackQueue);
                this.ackQueue.clear();
            }
            boolean success = false;
            while (!success && DFSClient.this.clientRunning) {
                DatanodeInfo[] newnodes = null;
                if (this.nodes == null) {
                    String msg = "Could not get block locations. Source file \"" + this.src + "\" - Aborting...";
                    LOG.warn(msg);
                    this.setLastException(new IOException(msg));
                    this.closed = true;
                    if (this.streamer != null) {
                        this.streamer.close();
                    }
                    return false;
                }
                StringBuilder pipelineMsg = new StringBuilder();
                for (int j = 0; j < this.nodes.length; ++j) {
                    pipelineMsg.append(this.nodes[j].getName());
                    if (j >= this.nodes.length - 1) continue;
                    pipelineMsg.append(", ");
                }
                if (this.errorIndex < 0) {
                    newnodes = this.nodes;
                } else {
                    if (this.nodes.length <= 1) {
                        this.lastException = new IOException("All datanodes " + pipelineMsg + " are bad. Aborting...");
                        this.closed = true;
                        if (this.streamer != null) {
                            this.streamer.close();
                        }
                        return false;
                    }
                    LOG.warn("Error Recovery for block " + this.block + " in pipeline " + pipelineMsg + ": bad datanode " + this.nodes[this.errorIndex].getName());
                    newnodes = new DatanodeInfo[this.nodes.length - 1];
                    System.arraycopy(this.nodes, 0, newnodes, 0, this.errorIndex);
                    System.arraycopy(this.nodes, this.errorIndex + 1, newnodes, this.errorIndex, newnodes.length - this.errorIndex);
                }
                LocatedBlock newBlock = null;
                ClientDatanodeProtocol primary = null;
                DatanodeInfo primaryNode = null;
                try {
                    primaryNode = Collections.min(Arrays.asList(newnodes));
                    primary = DFSClient.createClientDatanodeProtocolProxy(primaryNode, DFSClient.this.conf);
                    newBlock = primary.recoverBlock(this.block, isAppend, newnodes);
                }
                catch (IOException e2) {
                    block26: {
                        block27: {
                            boolean j;
                            try {
                                ++this.recoveryErrorCount;
                                if (this.recoveryErrorCount <= this.maxRecoveryErrorCount) break block26;
                                if (this.nodes.length <= 1) break block27;
                                for (j = false; j < this.nodes.length; j += 1) {
                                    if (!this.nodes[j].equals(primaryNode)) continue;
                                    this.errorIndex = j;
                                }
                                newnodes = new DatanodeInfo[this.nodes.length - 1];
                                System.arraycopy(this.nodes, 0, newnodes, 0, this.errorIndex);
                                System.arraycopy(this.nodes, this.errorIndex + 1, newnodes, this.errorIndex, newnodes.length - this.errorIndex);
                                this.nodes = newnodes;
                                LOG.warn("Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + primaryNode + " failed " + this.recoveryErrorCount + " times. " + " Pipeline was " + pipelineMsg + ". Marking primary datanode as bad.");
                                this.recoveryErrorCount = 0;
                                this.errorIndex = -1;
                                j = true;
                            }
                            catch (Throwable throwable) {
                                RPC.stopProxy(primary);
                                throw throwable;
                            }
                            RPC.stopProxy(primary);
                            return j;
                        }
                        String emsg = "Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + primaryNode + " failed " + this.recoveryErrorCount + " times. " + " Pipeline was " + pipelineMsg + ". Aborting...";
                        LOG.warn(emsg);
                        this.lastException = new IOException(emsg);
                        this.closed = true;
                        if (this.streamer != null) {
                            this.streamer.close();
                        }
                        boolean bl = false;
                        RPC.stopProxy(primary);
                        return bl;
                    }
                    LOG.warn("Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + primaryNode + " failed " + this.recoveryErrorCount + " times. " + " Pipeline was " + pipelineMsg + ". Will retry...");
                    boolean bl = true;
                    RPC.stopProxy(primary);
                    return bl;
                }
                RPC.stopProxy(primary);
                this.recoveryErrorCount = 0;
                if (newBlock != null) {
                    this.block = newBlock.getBlock();
                    this.nodes = newBlock.getLocations();
                }
                this.hasError = false;
                this.lastException = null;
                this.errorIndex = 0;
                success = this.createBlockOutputStream(this.nodes, DFSClient.this.clientName, true);
            }
            this.response = new ResponseProcessor(this.nodes);
            this.response.start();
            return false;
        }

        private void isClosed() throws IOException {
            if (this.closed && this.lastException != null) {
                throw this.lastException;
            }
        }

        private DFSOutputStream(String src, long blockSize, Progressable progress, int bytesPerChecksum) throws IOException {
            super(new CRC32(), bytesPerChecksum, 4);
            this.closed = false;
            this.dataQueue = new LinkedList();
            this.ackQueue = new LinkedList();
            this.currentPacket = null;
            this.maxPackets = 80;
            this.streamer = new DataStreamer();
            this.response = null;
            this.currentSeqno = 0L;
            this.bytesCurBlock = 0L;
            this.packetSize = 0;
            this.chunksPerPacket = 0;
            this.nodes = null;
            this.hasError = false;
            this.errorIndex = 0;
            this.lastException = null;
            this.artificialSlowdown = 0L;
            this.lastFlushOffset = -1L;
            this.persistBlocks = false;
            this.recoveryErrorCount = 0;
            this.maxRecoveryErrorCount = 5;
            this.appendChunk = false;
            this.initialFileSize = 0L;
            this.src = src;
            this.blockSize = blockSize;
            this.progress = progress;
            if (progress != null) {
                LOG.debug("Set non-null progress callback on DFSOutputStream " + src);
            }
            if (bytesPerChecksum < 1 || blockSize % (long)bytesPerChecksum != 0L) {
                throw new IOException("io.bytes.per.checksum(" + bytesPerChecksum + ") and blockSize(" + blockSize + ") do not match. " + "blockSize should be a " + "multiple of io.bytes.per.checksum");
            }
            this.checksum = DataChecksum.newDataChecksum(1, bytesPerChecksum);
        }

        DFSOutputStream(String string, FsPermission fsPermission, boolean bl, short s, long l, Progressable progressable, int n, int n2) throws IOException {
            this(string, l, progressable, n2);
            this.computePacketChunkSize(dFSClient.writePacketSize, n2);
            try {
                dFSClient.namenode.create(string, fsPermission, dFSClient.clientName, bl, s, l);
            }
            catch (RemoteException remoteException) {
                throw remoteException.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
            }
            this.streamer.start();
        }

        DFSOutputStream(String src, int buffersize, Progressable progress, LocatedBlock lastBlock, FileStatus stat2, int bytesPerChecksum) throws IOException {
            this(src, stat2.getBlockSize(), progress, bytesPerChecksum);
            this.initialFileSize = stat2.getLen();
            if (lastBlock != null) {
                this.block = lastBlock.getBlock();
                long usedInLastBlock = stat2.getLen() % this.blockSize;
                int freeInLastBlock = (int)(this.blockSize - usedInLastBlock);
                int usedInCksum = (int)(stat2.getLen() % (long)bytesPerChecksum);
                int freeInCksum = bytesPerChecksum - usedInCksum;
                if ((long)freeInLastBlock > this.blockSize) {
                    throw new IOException("The last block for file " + src + " is full.");
                }
                this.bytesCurBlock = lastBlock.getBlockSize();
                if (usedInCksum > 0 && freeInCksum > 0) {
                    this.computePacketChunkSize(0, freeInCksum);
                    this.resetChecksumChunk(freeInCksum);
                    this.appendChunk = true;
                } else {
                    this.computePacketChunkSize(Math.min(dFSClient.writePacketSize, freeInLastBlock), bytesPerChecksum);
                }
                this.nodes = lastBlock.getLocations();
                this.errorIndex = -1;
                if (this.nodes.length < 1) {
                    throw new IOException("Unable to retrieve blocks locations  for last block " + this.block + "of file " + src);
                }
                this.processDatanodeError(true, true);
                this.streamer.start();
            } else {
                this.computePacketChunkSize(dFSClient.writePacketSize, bytesPerChecksum);
                this.streamer.start();
            }
        }

        private void computePacketChunkSize(int psize, int csize) {
            int chunkSize = csize + this.checksum.getChecksumSize();
            int n = 25;
            this.chunksPerPacket = Math.max((psize - n + chunkSize - 1) / chunkSize, 1);
            this.packetSize = n + chunkSize * this.chunksPerPacket;
            if (LOG.isDebugEnabled()) {
                LOG.debug("computePacketChunkSize: src=" + this.src + ", chunkSize=" + chunkSize + ", chunksPerPacket=" + this.chunksPerPacket + ", packetSize=" + this.packetSize);
            }
        }

        private DatanodeInfo[] nextBlockOutputStream(String client) throws IOException {
            boolean success;
            DatanodeInfo[] nodes;
            LocatedBlock lb = null;
            boolean retry = false;
            int count = DFSClient.this.conf.getInt("dfs.client.block.write.retries", 3);
            do {
                this.hasError = false;
                this.lastException = null;
                this.errorIndex = 0;
                retry = false;
                nodes = null;
                success = false;
                long startTime = System.currentTimeMillis();
                lb = this.locateFollowingBlock(startTime);
                this.block = lb.getBlock();
                nodes = lb.getLocations();
                success = this.createBlockOutputStream(nodes, DFSClient.this.clientName, false);
                if (success) continue;
                LOG.info("Abandoning block " + this.block);
                DFSClient.this.namenode.abandonBlock(this.block, this.src, DFSClient.this.clientName);
                retry = true;
                try {
                    if (System.currentTimeMillis() - startTime > 5000L) {
                        LOG.info("Waiting to find target node: " + nodes[0].getName());
                    }
                    Thread.sleep(6000L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            } while (retry && --count >= 0);
            if (!success) {
                throw new IOException("Unable to create new block.");
            }
            return nodes;
        }

        private boolean createBlockOutputStream(DatanodeInfo[] nodes, String client, boolean recoveryFlag) {
            String firstBadLink = "";
            if (LOG.isDebugEnabled()) {
                for (int i = 0; i < nodes.length; ++i) {
                    LOG.debug("pipeline = " + nodes[i].getName());
                }
            }
            this.persistBlocks = true;
            try {
                LOG.debug("Connecting to " + nodes[0].getName());
                InetSocketAddress target = NetUtils.createSocketAddr(nodes[0].getName());
                this.s = DFSClient.this.socketFactory.createSocket();
                int timeoutValue = 3000 * nodes.length + DFSClient.this.socketTimeout;
                NetUtils.connect(this.s, target, timeoutValue);
                this.s.setSoTimeout(timeoutValue);
                this.s.setSendBufferSize(131072);
                LOG.debug("Send buf size " + this.s.getSendBufferSize());
                long writeTimeout = 5000 * nodes.length + DFSClient.this.datanodeWriteTimeout;
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(this.s, writeTimeout), DataNode.SMALL_BUFFER_SIZE));
                this.blockReplyStream = new DataInputStream(NetUtils.getInputStream(this.s));
                out.writeShort(14);
                out.write(80);
                out.writeLong(this.block.getBlockId());
                out.writeLong(this.block.getGenerationStamp());
                out.writeInt(nodes.length);
                out.writeBoolean(recoveryFlag);
                Text.writeString(out, client);
                out.writeBoolean(false);
                out.writeInt(nodes.length - 1);
                for (int i = 1; i < nodes.length; ++i) {
                    nodes[i].write(out);
                }
                this.checksum.writeHeader(out);
                out.flush();
                firstBadLink = Text.readString(this.blockReplyStream);
                if (firstBadLink.length() != 0) {
                    throw new IOException("Bad connect ack with firstBadLink " + firstBadLink);
                }
                this.blockStream = out;
                return true;
            }
            catch (IOException ie) {
                LOG.info("Exception in createBlockOutputStream " + ie);
                if (firstBadLink.length() != 0) {
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!nodes[i].getName().equals(firstBadLink)) continue;
                        this.errorIndex = i;
                        break;
                    }
                }
                this.hasError = true;
                this.setLastException(ie);
                this.blockReplyStream = null;
                return false;
            }
        }

        private LocatedBlock locateFollowingBlock(long l) throws IOException {
            int n = DFSClient.this.conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5);
            long l2 = 400L;
            long l3 = System.currentTimeMillis();
            while (true) {
                try {
                    return DFSClient.this.namenode.addBlock(this.src, DFSClient.this.clientName);
                }
                catch (RemoteException remoteException) {
                    IOException iOException = remoteException.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
                    if (iOException != remoteException) {
                        throw iOException;
                    }
                    if (NotReplicatedYetException.class.getName().equals(remoteException.getClassName())) {
                        if (n == 0) {
                            throw remoteException;
                        }
                        --n;
                        LOG.info(StringUtils.stringifyException(remoteException));
                        if (System.currentTimeMillis() - l3 > 5000L) {
                            LOG.info("Waiting for replication for " + (System.currentTimeMillis() - l3) / 1000L + " seconds");
                        }
                        try {
                            LOG.warn("NotReplicatedYetException sleeping " + this.src + " retries left " + n);
                            Thread.sleep(l2);
                            l2 *= 2L;
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw remoteException;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum) throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            int cklen = checksum.length;
            int bytesPerChecksum = this.checksum.getBytesPerChecksum();
            if (len > bytesPerChecksum) {
                throw new IOException("writeChunk() buffer size is " + len + " is larger than supported  bytesPerChecksum " + bytesPerChecksum);
            }
            if (checksum.length != this.checksum.getChecksumSize()) {
                throw new IOException("writeChunk() checksum size is supposed to be " + this.checksum.getChecksumSize() + " but found to be " + checksum.length);
            }
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                while (!this.closed && this.dataQueue.size() + this.ackQueue.size() > this.maxPackets) {
                    try {
                        this.dataQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                this.isClosed();
                if (this.currentPacket == null) {
                    this.currentPacket = new Packet(this.packetSize, this.chunksPerPacket, this.bytesCurBlock);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("DFSClient writeChunk allocating new packet seqno=" + this.currentPacket.seqno + ", src=" + this.src + ", packetSize=" + this.packetSize + ", chunksPerPacket=" + this.chunksPerPacket + ", bytesCurBlock=" + this.bytesCurBlock);
                    }
                }
                this.currentPacket.writeChecksum(checksum, 0, cklen);
                this.currentPacket.writeData(b, offset, len);
                ++this.currentPacket.numChunks;
                this.bytesCurBlock += (long)len;
                if (this.currentPacket.numChunks == this.currentPacket.maxChunks || this.bytesCurBlock == this.blockSize) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("DFSClient writeChunk packet full seqno=" + this.currentPacket.seqno + ", src=" + this.src + ", bytesCurBlock=" + this.bytesCurBlock + ", blockSize=" + this.blockSize + ", appendChunk=" + this.appendChunk);
                    }
                    if (this.bytesCurBlock == this.blockSize) {
                        this.currentPacket.lastPacketInBlock = true;
                        this.bytesCurBlock = 0L;
                        this.lastFlushOffset = -1L;
                    }
                    this.dataQueue.addLast(this.currentPacket);
                    this.dataQueue.notifyAll();
                    this.currentPacket = null;
                    if (this.appendChunk) {
                        this.appendChunk = false;
                        this.resetChecksumChunk(bytesPerChecksum);
                    }
                    int psize = Math.min((int)(this.blockSize - this.bytesCurBlock), DFSClient.this.writePacketSize);
                    this.computePacketChunkSize(psize, bytesPerChecksum);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void flushInternal() throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            while (!this.closed) {
                LinkedList<Packet> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    this.isClosed();
                    if (this.currentPacket != null) {
                        this.dataQueue.addLast(this.currentPacket);
                        this.dataQueue.notifyAll();
                        this.currentPacket = null;
                    }
                    if (!this.closed && this.dataQueue.size() != 0) {
                        try {
                            this.dataQueue.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                linkedList = this.ackQueue;
                synchronized (linkedList) {
                    if (!this.closed && this.ackQueue.size() != 0) {
                        try {
                            this.ackQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                linkedList = this.dataQueue;
                synchronized (linkedList) {
                    LinkedList<Packet> linkedList2 = this.ackQueue;
                    synchronized (linkedList2) {
                        if (this.dataQueue.size() + this.ackQueue.size() == 0) {
                            break;
                        }
                    }
                }
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closeInternal();
            DFSClient.this.leasechecker.remove(this.src);
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }

        private void closeThreads() throws IOException {
            try {
                this.streamer.close();
                this.streamer.join();
                if (this.response != null) {
                    this.response.close();
                    this.response.join();
                    this.response = null;
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to shutdown response thread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void closeInternal() throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            try {
                this.flushBuffer();
                LinkedList<Packet> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    if (this.currentPacket == null && this.bytesCurBlock != 0L) {
                        this.currentPacket = new Packet(this.packetSize, this.chunksPerPacket, this.bytesCurBlock);
                    }
                    if (this.currentPacket != null) {
                        this.currentPacket.lastPacketInBlock = true;
                    }
                }
                this.flushInternal();
                this.isClosed();
                this.closed = true;
                this.closeThreads();
                linkedList = this.dataQueue;
                synchronized (linkedList) {
                    if (this.blockStream != null) {
                        this.blockStream.writeInt(0);
                        this.blockStream.close();
                        this.blockReplyStream.close();
                    }
                    if (this.s != null) {
                        this.s.close();
                        this.s = null;
                    }
                }
                this.streamer = null;
                this.blockStream = null;
                this.blockReplyStream = null;
                long localstart = System.currentTimeMillis();
                boolean fileComplete = false;
                while (!fileComplete) {
                    fileComplete = DFSClient.this.namenode.complete(this.src, DFSClient.this.clientName);
                    if (fileComplete) continue;
                    try {
                        Thread.sleep(400L);
                        if (System.currentTimeMillis() - localstart <= 5000L) continue;
                        LOG.info("Could not complete file " + this.src + " retrying...");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            finally {
                this.closed = true;
            }
        }

        long getInitialLen() {
            return this.initialFileSize;
        }

        static /* synthetic */ DatanodeInfo[] access$1802(DFSOutputStream x0, DatanodeInfo[] x1) {
            x0.nodes = x1;
            return x1;
        }

        private class ResponseProcessor
        extends Thread {
            private volatile boolean closed = false;
            private DatanodeInfo[] targets = null;
            private boolean lastPacketInBlock = false;

            ResponseProcessor(DatanodeInfo[] targets) {
                this.targets = targets;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("ResponseProcessor for block " + DFSOutputStream.this.block);
                while (!this.closed && DFSClient.this.clientRunning && !this.lastPacketInBlock) {
                    block19: {
                        try {
                            long seqno = DFSOutputStream.this.blockReplyStream.readLong();
                            LOG.debug("DFSClient received ack for seqno " + seqno);
                            if (seqno == -1L) continue;
                            if (seqno != -2L) {
                                Packet one = null;
                                LinkedList linkedList = DFSOutputStream.this.ackQueue;
                                synchronized (linkedList) {
                                    one = (Packet)DFSOutputStream.this.ackQueue.getFirst();
                                }
                                if (one.seqno != seqno) {
                                    throw new IOException("Responseprocessor: Expecting seqno  for block " + DFSOutputStream.this.block + one.seqno + " but received " + seqno);
                                }
                                this.lastPacketInBlock = one.lastPacketInBlock;
                            }
                            for (int i = 0; i < this.targets.length && DFSClient.this.clientRunning; ++i) {
                                short reply = DFSOutputStream.this.blockReplyStream.readShort();
                                if (reply == 0) continue;
                                DFSOutputStream.this.errorIndex = i;
                                throw new IOException("Bad response " + reply + " for block " + DFSOutputStream.this.block + " from datanode " + this.targets[i].getName());
                            }
                            LinkedList linkedList = DFSOutputStream.this.ackQueue;
                            synchronized (linkedList) {
                                DFSOutputStream.this.ackQueue.removeFirst();
                                DFSOutputStream.this.ackQueue.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            if (this.closed) break block19;
                            DFSOutputStream.this.hasError = true;
                            if (e instanceof IOException) {
                                DFSOutputStream.this.setLastException((IOException)e);
                            }
                            LOG.warn("DFSOutputStream ResponseProcessor exception  for block " + DFSOutputStream.this.block + StringUtils.stringifyException(e));
                            this.closed = true;
                        }
                    }
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        DFSOutputStream.this.dataQueue.notifyAll();
                    }
                    linkedList = DFSOutputStream.this.ackQueue;
                    synchronized (linkedList) {
                        DFSOutputStream.this.ackQueue.notifyAll();
                    }
                }
            }

            void close() {
                this.closed = true;
                this.interrupt();
            }
        }

        private class DataStreamer
        extends Daemon {
            private volatile boolean closed = false;

            private DataStreamer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!this.closed && DFSClient.this.clientRunning) {
                    if (DFSOutputStream.this.hasError && DFSOutputStream.this.response != null) {
                        try {
                            DFSOutputStream.this.response.close();
                            DFSOutputStream.this.response.join();
                            DFSOutputStream.this.response = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    Packet one = null;
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        boolean doSleep = DFSOutputStream.this.processDatanodeError(DFSOutputStream.this.hasError, false);
                        while (!this.closed && !DFSOutputStream.this.hasError && DFSClient.this.clientRunning && DFSOutputStream.this.dataQueue.size() == 0 || doSleep) {
                            try {
                                DFSOutputStream.this.dataQueue.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            doSleep = false;
                        }
                        if (this.closed || DFSOutputStream.this.hasError || DFSOutputStream.this.dataQueue.size() == 0 || !DFSClient.this.clientRunning) {
                            continue;
                        }
                        try {
                            one = (Packet)DFSOutputStream.this.dataQueue.getFirst();
                            long offsetInBlock = one.offsetInBlock;
                            if (DFSOutputStream.this.blockStream == null) {
                                LOG.debug("Allocating new block");
                                DFSOutputStream.access$1802(DFSOutputStream.this, DFSOutputStream.this.nextBlockOutputStream(DFSOutputStream.this.src));
                                this.setName("DataStreamer for file " + DFSOutputStream.this.src + " block " + DFSOutputStream.this.block);
                                DFSOutputStream.this.response = new ResponseProcessor(DFSOutputStream.this.nodes);
                                DFSOutputStream.this.response.start();
                            }
                            if (offsetInBlock >= DFSOutputStream.this.blockSize) {
                                throw new IOException("BlockSize " + DFSOutputStream.this.blockSize + " is smaller than data size. " + " Offset of packet in block " + offsetInBlock + " Aborting file " + DFSOutputStream.this.src);
                            }
                            ByteBuffer buf = one.getBuffer();
                            DFSOutputStream.this.dataQueue.removeFirst();
                            DFSOutputStream.this.dataQueue.notifyAll();
                            LinkedList linkedList2 = DFSOutputStream.this.ackQueue;
                            synchronized (linkedList2) {
                                DFSOutputStream.this.ackQueue.addLast(one);
                                DFSOutputStream.this.ackQueue.notifyAll();
                            }
                            DFSOutputStream.this.blockStream.write(buf.array(), buf.position(), buf.remaining());
                            if (one.lastPacketInBlock) {
                                DFSOutputStream.this.blockStream.writeInt(0);
                            }
                            DFSOutputStream.this.blockStream.flush();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("DataStreamer block " + DFSOutputStream.this.block + " wrote packet seqno:" + one.seqno + " size:" + buf.remaining() + " offsetInBlock:" + one.offsetInBlock + " lastPacketInBlock:" + one.lastPacketInBlock);
                            }
                        }
                        catch (Throwable e) {
                            LOG.warn("DataStreamer Exception: " + StringUtils.stringifyException(e));
                            if (e instanceof IOException) {
                                DFSOutputStream.this.setLastException((IOException)e);
                            }
                            DFSOutputStream.this.hasError = true;
                        }
                    }
                    if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) continue;
                    if (one.lastPacketInBlock) {
                        linkedList = DFSOutputStream.this.ackQueue;
                        synchronized (linkedList) {
                            while (!DFSOutputStream.this.hasError && DFSOutputStream.this.ackQueue.size() != 0 && DFSClient.this.clientRunning) {
                                try {
                                    DFSOutputStream.this.ackQueue.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        LOG.debug("Closing old block " + DFSOutputStream.this.block);
                        this.setName("DataStreamer for file " + DFSOutputStream.this.src);
                        DFSOutputStream.this.response.close();
                        try {
                            DFSOutputStream.this.response.join();
                            DFSOutputStream.this.response = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) continue;
                        LinkedList e = DFSOutputStream.this.dataQueue;
                        synchronized (e) {
                            try {
                                DFSOutputStream.this.blockStream.close();
                                DFSOutputStream.this.blockReplyStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            DFSOutputStream.access$1802(DFSOutputStream.this, null);
                            DFSOutputStream.this.response = null;
                            DFSOutputStream.this.blockStream = null;
                            DFSOutputStream.this.blockReplyStream = null;
                        }
                    }
                    if (DFSOutputStream.this.progress != null) {
                        DFSOutputStream.this.progress.progress();
                    }
                    if (DFSOutputStream.this.artificialSlowdown == 0L || !DFSClient.this.clientRunning) continue;
                    try {
                        Thread.sleep(DFSOutputStream.this.artificialSlowdown);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void close() {
                this.closed = true;
                LinkedList linkedList = DFSOutputStream.this.dataQueue;
                synchronized (linkedList) {
                    DFSOutputStream.this.dataQueue.notifyAll();
                }
                linkedList = DFSOutputStream.this.ackQueue;
                synchronized (linkedList) {
                    DFSOutputStream.this.ackQueue.notifyAll();
                }
                this.interrupt();
            }
        }

        private class Packet {
            ByteBuffer buffer;
            byte[] buf;
            long seqno;
            long offsetInBlock;
            boolean lastPacketInBlock = false;
            int numChunks = 0;
            int maxChunks;
            int dataStart;
            int dataPos;
            int checksumStart;
            int checksumPos;

            Packet(int pktSize, int chunksPerPkt, long offsetInBlock) {
                this.offsetInBlock = offsetInBlock;
                this.seqno = DFSOutputStream.this.currentSeqno;
                DFSOutputStream.this.currentSeqno++;
                this.buffer = null;
                this.buf = new byte[pktSize];
                this.checksumPos = this.checksumStart = 25;
                this.dataPos = this.dataStart = this.checksumStart + chunksPerPkt * DFSOutputStream.this.checksum.getChecksumSize();
                this.maxChunks = chunksPerPkt;
            }

            void writeData(byte[] inarray, int off, int len) {
                if (this.dataPos + len > this.buf.length) {
                    throw new BufferOverflowException();
                }
                System.arraycopy(inarray, off, this.buf, this.dataPos, len);
                this.dataPos += len;
            }

            void writeChecksum(byte[] inarray, int off, int len) {
                if (this.checksumPos + len > this.dataStart) {
                    throw new BufferOverflowException();
                }
                System.arraycopy(inarray, off, this.buf, this.checksumPos, len);
                this.checksumPos += len;
            }

            ByteBuffer getBuffer() {
                if (this.buffer != null) {
                    return this.buffer;
                }
                int dataLen = this.dataPos - this.dataStart;
                int checksumLen = this.checksumPos - this.checksumStart;
                if (this.checksumPos != this.dataStart) {
                    System.arraycopy(this.buf, this.checksumStart, this.buf, this.dataStart - checksumLen, checksumLen);
                }
                int pktLen = 4 + dataLen + checksumLen;
                this.buffer = ByteBuffer.wrap(this.buf, this.dataStart - this.checksumPos, 21 + pktLen);
                this.buf = null;
                this.buffer.mark();
                this.buffer.putInt(pktLen);
                this.buffer.putLong(this.offsetInBlock);
                this.buffer.putLong(this.seqno);
                this.buffer.put((byte)(this.lastPacketInBlock ? 1 : 0));
                this.buffer.putInt(dataLen);
                this.buffer.reset();
                return this.buffer;
            }
        }
    }

    static class DFSDataInputStream
    extends FSDataInputStream {
        DFSDataInputStream(DFSInputStream in) throws IOException {
            super(in);
        }
    }

    class DFSInputStream
    extends FSInputStream {
        private Socket s = null;
        private boolean closed = false;
        private String src;
        private long prefetchSize = 10L * DFSClient.access$100(DFSClient.this);
        private BlockReader blockReader = null;
        private boolean verifyChecksum;
        private LocatedBlocks locatedBlocks = null;
        private DatanodeInfo currentNode = null;
        private Block currentBlock = null;
        private long pos = 0L;
        private long blockEnd = -1L;
        private int failures = 0;
        private ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
        private int buffersize = 1;
        private byte[] oneByteBuf = new byte[1];

        void addToDeadNodes(DatanodeInfo dnInfo) {
            this.deadNodes.put(dnInfo, dnInfo);
        }

        DFSInputStream(String src, int buffersize, boolean verifyChecksum) throws IOException {
            this.verifyChecksum = verifyChecksum;
            this.buffersize = buffersize;
            this.src = src;
            this.prefetchSize = DFSClient.this.conf.getLong("dfs.read.prefetch.size", this.prefetchSize);
            this.openInfo();
        }

        synchronized void openInfo() throws IOException {
            LocatedBlocks newInfo = DFSClient.callGetBlockLocations(DFSClient.this.namenode, this.src, 0L, this.prefetchSize);
            if (newInfo == null) {
                throw new IOException("Cannot open filename " + this.src);
            }
            if (this.locatedBlocks != null) {
                Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
                Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
                while (oldIter.hasNext() && newIter.hasNext()) {
                    if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                    throw new IOException("Blocklist for " + this.src + " has changed!");
                }
            }
            this.locatedBlocks = newInfo;
            this.currentNode = null;
        }

        public synchronized long getFileLength() {
            return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength();
        }

        private LocatedBlock getBlockAt(long offset) throws IOException {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(DFSClient.this.namenode, this.src, offset, this.prefetchSize);
                assert (newBlocks != null) : "Could not find target position " + offset;
                this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
            }
            LocatedBlock blk = this.locatedBlocks.get(targetBlockIdx);
            this.pos = offset;
            this.blockEnd = blk.getStartOffset() + blk.getBlockSize() - 1L;
            this.currentBlock = blk.getBlock();
            return blk;
        }

        private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
            if (target >= this.getFileLength()) {
                throw new IOException("Attempted to read past end of file");
            }
            if (this.blockReader != null) {
                this.blockReader.close();
                this.blockReader = null;
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            LocatedBlock targetBlock = this.getBlockAt(target);
            assert (target == this.pos) : "Wrong postion " + this.pos + " expect " + target;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DatanodeInfo chosenNode = null;
            while (this.s == null) {
                DNAddrPair retval = this.chooseDataNode(targetBlock);
                chosenNode = retval.info;
                InetSocketAddress targetAddr = retval.addr;
                try {
                    this.s = DFSClient.this.socketFactory.createSocket();
                    NetUtils.connect(this.s, targetAddr, DFSClient.this.socketTimeout);
                    this.s.setSoTimeout(DFSClient.this.socketTimeout);
                    Block blk = targetBlock.getBlock();
                    this.blockReader = BlockReader.newBlockReader(this.s, this.src, blk.getBlockId(), blk.getGenerationStamp(), offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, this.buffersize, this.verifyChecksum, DFSClient.this.clientName);
                    return chosenNode;
                }
                catch (IOException ex) {
                    LOG.debug("Failed to connect to " + targetAddr + ":" + StringUtils.stringifyException(ex));
                    this.addToDeadNodes(chosenNode);
                    if (this.s != null) {
                        try {
                            this.s.close();
                        }
                        catch (IOException iex) {
                            // empty catch block
                        }
                    }
                    this.s = null;
                }
            }
            return chosenNode;
        }

        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            DFSClient.this.checkOpen();
            if (this.blockReader != null) {
                this.blockReader.close();
                this.blockReader = null;
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            super.close();
            this.closed = true;
        }

        public synchronized int read() throws IOException {
            int ret = this.read(this.oneByteBuf, 0, 1);
            return ret <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
        }

        private synchronized int readBuffer(byte[] buf, int off, int len) throws IOException {
            boolean retryCurrentNode = true;
            while (true) {
                IOException ioe;
                try {
                    return this.blockReader.read(buf, off, len);
                }
                catch (ChecksumException ce) {
                    LOG.warn("Found Checksum error for " + this.currentBlock + " from " + this.currentNode.getName() + " at " + ce.getPos());
                    DFSClient.this.reportChecksumFailure(this.src, this.currentBlock, this.currentNode);
                    ioe = ce;
                    retryCurrentNode = false;
                }
                catch (IOException e) {
                    if (!retryCurrentNode) {
                        LOG.warn("Exception while reading from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException(e));
                    }
                    ioe = e;
                }
                boolean sourceFound = false;
                if (retryCurrentNode) {
                    sourceFound = this.seekToBlockSource(this.pos);
                } else {
                    this.addToDeadNodes(this.currentNode);
                    sourceFound = this.seekToNewSource(this.pos);
                }
                if (!sourceFound) {
                    throw ioe;
                }
                retryCurrentNode = false;
            }
        }

        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.pos < this.getFileLength()) {
                int retries = 2;
                while (retries > 0) {
                    try {
                        int realLen;
                        int result;
                        if (this.pos > this.blockEnd) {
                            this.currentNode = this.blockSeekTo(this.pos);
                        }
                        if ((result = this.readBuffer(buf, off, realLen = Math.min(len, (int)(this.blockEnd - this.pos + 1L)))) >= 0) {
                            this.pos += (long)result;
                        } else {
                            throw new IOException("Unexpected EOS from the reader");
                        }
                        if (DFSClient.this.stats != null && result != -1) {
                            DFSClient.this.stats.incrementBytesRead(result);
                        }
                        return result;
                    }
                    catch (ChecksumException ce) {
                        throw ce;
                    }
                    catch (IOException e) {
                        if (retries == 1) {
                            LOG.warn("DFS Read: " + StringUtils.stringifyException(e));
                        }
                        this.blockEnd = -1L;
                        if (this.currentNode != null) {
                            this.addToDeadNodes(this.currentNode);
                        }
                        if (--retries != 0) continue;
                        throw e;
                    }
                }
            }
            return -1;
        }

        private DNAddrPair chooseDataNode(LocatedBlock block) throws IOException {
            while (true) {
                DatanodeInfo[] nodes = block.getLocations();
                try {
                    DatanodeInfo chosenNode = DFSClient.this.bestNode(nodes, this.deadNodes);
                    InetSocketAddress targetAddr = NetUtils.createSocketAddr(chosenNode.getName());
                    return new DNAddrPair(chosenNode, targetAddr);
                }
                catch (IOException ie) {
                    String blockInfo = block.getBlock() + " file=" + this.src;
                    if (this.failures >= DFSClient.this.maxBlockAcquireFailures) {
                        throw new IOException("Could not obtain block: " + blockInfo);
                    }
                    if (nodes == null || nodes.length == 0) {
                        LOG.info("No node available for block: " + blockInfo);
                    }
                    LOG.info("Could not obtain block " + block.getBlock() + " from any node:  " + ie);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    this.deadNodes.clear();
                    this.openInfo();
                    ++this.failures;
                    continue;
                }
                break;
            }
        }

        public long skip(long n) throws IOException {
            if (n > 0L) {
                long fileLen;
                long curPos = this.getPos();
                if (n + curPos > (fileLen = this.getFileLength())) {
                    n = fileLen - curPos;
                }
                this.seek(curPos + n);
                return n;
            }
            return n < 0L ? -1L : 0L;
        }

        public synchronized void seek(long targetPos) throws IOException {
            int diff;
            if (targetPos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            boolean done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= 131072) {
                try {
                    this.pos += this.blockReader.skip(diff);
                    if (this.pos == targetPos) {
                        done = true;
                    }
                }
                catch (IOException e) {
                    LOG.debug("Exception while seek to " + targetPos + " from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException(e));
                }
            }
            if (!done) {
                this.pos = targetPos;
                this.blockEnd = -1L;
            }
        }

        private synchronized boolean seekToBlockSource(long targetPos) throws IOException {
            this.currentNode = this.blockSeekTo(targetPos);
            return true;
        }

        public synchronized boolean seekToNewSource(long targetPos) throws IOException {
            boolean markedDead = this.deadNodes.containsKey(this.currentNode);
            this.addToDeadNodes(this.currentNode);
            DatanodeInfo oldNode = this.currentNode;
            DatanodeInfo newNode = this.blockSeekTo(targetPos);
            if (!markedDead) {
                this.deadNodes.remove(oldNode);
            }
            if (!oldNode.getStorageID().equals(newNode.getStorageID())) {
                this.currentNode = newNode;
                return true;
            }
            return false;
        }

        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            return (int)(this.getFileLength() - this.pos);
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readLimit) {
        }

        public void reset() throws IOException {
            throw new IOException("Mark/reset not supported");
        }
    }

    public static class BlockReader
    extends FSInputChecker {
        private Socket dnSock;
        private DataInputStream in;
        private DataChecksum checksum;
        private long lastChunkOffset = -1L;
        private long lastChunkLen = -1L;
        private long lastSeqNo = -1L;
        private long startOffset;
        private long firstChunkOffset;
        private int bytesPerChecksum;
        private int checksumSize;
        private boolean gotEOS = false;
        byte[] skipBuf = null;
        ByteBuffer checksumBytes = null;
        int dataLeft = 0;
        boolean isLastPacket = false;

        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            if (this.lastChunkLen < 0L && this.startOffset > this.firstChunkOffset && len > 0) {
                int toSkip = (int)(this.startOffset - this.firstChunkOffset);
                if (this.skipBuf == null) {
                    this.skipBuf = new byte[this.bytesPerChecksum];
                }
                if (super.read(this.skipBuf, 0, toSkip) != toSkip) {
                    throw new IOException("Could not skip required number of bytes");
                }
            }
            boolean eosBefore = this.gotEOS;
            int nRead = super.read(buf, off, len);
            if (this.gotEOS && !eosBefore && nRead >= 0 && this.needChecksum()) {
                this.checksumOk(this.dnSock);
            }
            return nRead;
        }

        public synchronized long skip(long n) throws IOException {
            long nSkipped;
            int ret;
            if (this.skipBuf == null) {
                this.skipBuf = new byte[this.bytesPerChecksum];
            }
            for (nSkipped = 0L; nSkipped < n; nSkipped += (long)ret) {
                int toSkip = (int)Math.min(n - nSkipped, (long)this.skipBuf.length);
                ret = this.read(this.skipBuf, 0, toSkip);
                if (ret > 0) continue;
                return nSkipped;
            }
            return nSkipped;
        }

        public int read() throws IOException {
            throw new IOException("read() is not expected to be invoked. Use read(buf, off, len) instead.");
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public void seek(long pos) throws IOException {
            throw new IOException("Seek() is not supported in BlockInputChecker");
        }

        protected long getChunkPosition(long pos) {
            throw new RuntimeException("getChunkPosition() is not supported, since seek is not required");
        }

        private void adjustChecksumBytes(int dataLen) {
            int requiredSize = (dataLen + this.bytesPerChecksum - 1) / this.bytesPerChecksum * this.checksumSize;
            if (this.checksumBytes == null || requiredSize > this.checksumBytes.capacity()) {
                this.checksumBytes = ByteBuffer.wrap(new byte[requiredSize]);
            } else {
                this.checksumBytes.clear();
            }
            this.checksumBytes.limit(requiredSize);
        }

        protected synchronized int readChunk(long pos, byte[] buf, int offset, int len, byte[] checksumBuf) throws IOException {
            int chunkLen;
            if (this.gotEOS) {
                if (this.startOffset < 0L) {
                    throw new IOException("BlockRead: already got EOS or an error");
                }
                this.startOffset = -1L;
                return -1;
            }
            long chunkOffset = this.lastChunkOffset;
            if (this.lastChunkLen > 0L) {
                chunkOffset += this.lastChunkLen;
            }
            if (pos + this.firstChunkOffset != chunkOffset) {
                throw new IOException("Mismatch in pos : " + pos + " + " + this.firstChunkOffset + " != " + chunkOffset);
            }
            if (this.dataLeft <= 0) {
                int dataLen;
                int packetLen = this.in.readInt();
                long offsetInBlock = this.in.readLong();
                long seqno = this.in.readLong();
                boolean lastPacketInBlock = this.in.readBoolean();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DFSClient readChunk got seqno " + seqno + " offsetInBlock " + offsetInBlock + " lastPacketInBlock " + lastPacketInBlock + " packetLen " + packetLen);
                }
                if ((dataLen = this.in.readInt()) < 0 || dataLen % this.bytesPerChecksum != 0 && !lastPacketInBlock || seqno != this.lastSeqNo + 1L) {
                    throw new IOException("BlockReader: error in packet header(chunkOffset : " + chunkOffset + ", dataLen : " + dataLen + ", seqno : " + seqno + " (last: " + this.lastSeqNo + "))");
                }
                this.lastSeqNo = seqno;
                this.isLastPacket = lastPacketInBlock;
                this.dataLeft = dataLen;
                this.adjustChecksumBytes(dataLen);
                if (dataLen > 0) {
                    IOUtils.readFully(this.in, this.checksumBytes.array(), 0, this.checksumBytes.limit());
                }
            }
            if ((chunkLen = Math.min(this.dataLeft, this.bytesPerChecksum)) > 0) {
                IOUtils.readFully(this.in, buf, offset, chunkLen);
                this.checksumBytes.get(checksumBuf, 0, this.checksumSize);
            }
            this.dataLeft -= chunkLen;
            this.lastChunkOffset = chunkOffset;
            this.lastChunkLen = chunkLen;
            if (this.dataLeft == 0 && this.isLastPacket || chunkLen == 0) {
                this.gotEOS = true;
            }
            if (chunkLen == 0) {
                return -1;
            }
            return chunkLen;
        }

        private BlockReader(String file, long blockId, DataInputStream in, DataChecksum checksum, boolean verifyChecksum, long startOffset, long firstChunkOffset, Socket dnSock) {
            super(new Path("/blk_" + blockId + ":of:" + file), 1, verifyChecksum, checksum.getChecksumSize() > 0 ? checksum : null, checksum.getBytesPerChecksum(), checksum.getChecksumSize());
            this.dnSock = dnSock;
            this.in = in;
            this.checksum = checksum;
            this.startOffset = Math.max(startOffset, 0L);
            this.firstChunkOffset = firstChunkOffset;
            this.lastChunkOffset = firstChunkOffset;
            this.lastChunkLen = -1L;
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            this.checksumSize = this.checksum.getChecksumSize();
        }

        public static BlockReader newBlockReader(Socket sock, String file, long blockId, long genStamp, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(sock, 480000L)));
            out.writeShort(14);
            out.write(81);
            out.writeLong(blockId);
            out.writeLong(genStamp);
            out.writeLong(startOffset);
            out.writeLong(len);
            Text.writeString(out, clientName);
            out.flush();
            DataInputStream in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(sock), bufferSize));
            if (in.readShort() != 0) {
                throw new IOException("Got error in response to OP_READ_BLOCK for file " + file + " for block " + blockId);
            }
            DataChecksum checksum = DataChecksum.newDataChecksum(in);
            long firstChunkOffset = in.readLong();
            if (firstChunkOffset < 0L || firstChunkOffset > startOffset || firstChunkOffset >= startOffset + (long)checksum.getBytesPerChecksum()) {
                throw new IOException("BlockReader: error in first chunk offset (" + firstChunkOffset + ") startOffset is " + startOffset + " for file " + file);
            }
            return new BlockReader(file, blockId, in, checksum, verifyChecksum, startOffset, firstChunkOffset, sock);
        }

        public synchronized void close() throws IOException {
            this.startOffset = -1L;
            this.checksum = null;
        }

        private void checksumOk(Socket sock) {
            try {
                OutputStream out = NetUtils.getOutputStream(sock, 480000L);
                byte[] buf = new byte[]{0, 5};
                out.write(buf);
                out.flush();
            }
            catch (IOException e) {
                LOG.debug("Could not write to datanode " + sock.getInetAddress() + ": " + e.getMessage());
            }
        }
    }

    private static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }

    class LeaseChecker
    implements Runnable {
        private final SortedMap<String, OutputStream> pendingCreates = new TreeMap<String, OutputStream>();
        private Daemon daemon = null;

        LeaseChecker() {
        }

        synchronized void put(String src, OutputStream out) {
            if (DFSClient.this.clientRunning) {
                if (this.daemon == null) {
                    this.daemon = new Daemon(this);
                    this.daemon.start();
                }
                this.pendingCreates.put(src, out);
            }
        }

        synchronized void remove(String src) {
            this.pendingCreates.remove(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptAndJoin() throws InterruptedException {
            Daemon daemonCopy = null;
            LeaseChecker leaseChecker = this;
            synchronized (leaseChecker) {
                if (this.daemon != null) {
                    this.daemon.interrupt();
                    daemonCopy = this.daemon;
                }
            }
            if (daemonCopy != null) {
                LOG.debug("Wait for lease checker to terminate");
                daemonCopy.join();
            }
        }

        synchronized void close() {
            while (!this.pendingCreates.isEmpty()) {
                String src = this.pendingCreates.firstKey();
                OutputStream out = (OutputStream)this.pendingCreates.remove(src);
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException ie) {
                    LOG.error("Exception closing file " + src + " : " + ie, ie);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renew() throws IOException {
            LeaseChecker leaseChecker = this;
            synchronized (leaseChecker) {
                if (this.pendingCreates.isEmpty()) {
                    return;
                }
            }
            DFSClient.this.namenode.renewLease(DFSClient.this.clientName);
        }

        public void run() {
            long lastRenewed = 0L;
            while (DFSClient.this.clientRunning && !Thread.interrupted()) {
                if (System.currentTimeMillis() - lastRenewed > 30000L) {
                    try {
                        this.renew();
                        lastRenewed = System.currentTimeMillis();
                    }
                    catch (IOException ie) {
                        LOG.warn("Problem renewing lease for " + DFSClient.this.clientName, ie);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this + " is interrupted.", ie);
                    }
                    return;
                }
            }
        }

        public String toString() {
            String s = this.getClass().getSimpleName();
            if (LOG.isTraceEnabled()) {
                return s + "@" + DFSClient.this + ": " + StringUtils.stringifyException(new Throwable("for testing"));
            }
            return s;
        }
    }
}

