/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.util.Shell;

public class DU
extends Shell {
    private String dirPath;
    private AtomicLong used;
    private volatile boolean shouldRun;
    private Thread refreshUsed;
    private IOException duException;

    public void decDfsUsed(long value) {
        this.used.addAndGet(-value);
    }

    public void incDfsUsed(long value) {
        this.used.addAndGet(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsed() throws IOException {
        if (this.refreshUsed == null) {
            this.run();
        } else {
            DU dU = this;
            synchronized (dU) {
                if (this.duException != null) {
                    IOException tmp = this.duException;
                    this.duException = null;
                    throw tmp;
                }
            }
        }
        return this.used.longValue();
    }

    public void shutdown() {
        this.shouldRun = false;
        if (this.refreshUsed != null) {
            this.refreshUsed.interrupt();
        }
    }

    public String toString() {
        return "du -sk " + this.dirPath + "\n" + this.used + "\t" + this.dirPath;
    }

    protected String[] getExecString() {
        return new String[]{"du", "-sk", this.dirPath};
    }

    protected void parseExecResult(BufferedReader lines) throws IOException {
        String line = lines.readLine();
        if (line == null) {
            throw new IOException("Expecting a line not the end of stream");
        }
        String[] tokens = line.split("\t");
        if (tokens.length == 0) {
            throw new IOException("Illegal du output");
        }
        this.used.set(Long.parseLong(tokens[0]) * 1024L);
    }
}

