/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.util.Shell;

public class DF
extends Shell {
    private String dirPath;
    private String filesystem;
    private long capacity;
    private long used;
    private long available;
    private int percentUsed;
    private String mount;

    public long getCapacity() throws IOException {
        this.run();
        return this.capacity;
    }

    public long getAvailable() throws IOException {
        this.run();
        return this.available;
    }

    public String toString() {
        return "df -k " + this.mount + "\n" + this.filesystem + "\t" + this.capacity / 1024L + "\t" + this.used / 1024L + "\t" + this.available / 1024L + "\t" + this.percentUsed + "%\t" + this.mount;
    }

    protected String[] getExecString() {
        return new String[]{"bash", "-c", "exec 'df' '-k' '" + this.dirPath + "' 2>/dev/null"};
    }

    protected void parseExecResult(BufferedReader lines) throws IOException {
        lines.readLine();
        String line = lines.readLine();
        if (line == null) {
            throw new IOException("Expecting a line not the end of stream");
        }
        StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
        this.filesystem = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            line = lines.readLine();
            if (line == null) {
                throw new IOException("Expecting a line not the end of stream");
            }
            tokens = new StringTokenizer(line, " \t\n\r\f%");
        }
        this.capacity = Long.parseLong(tokens.nextToken()) * 1024L;
        this.used = Long.parseLong(tokens.nextToken()) * 1024L;
        this.available = Long.parseLong(tokens.nextToken()) * 1024L;
        this.percentUsed = Integer.parseInt(tokens.nextToken());
        this.mount = tokens.nextToken();
    }
}

