/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public abstract class SocketClient {
    private static final SocketFactory __DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    private static final ServerSocketFactory __DEFAULT_SERVER_SOCKET_FACTORY = ServerSocketFactory.getDefault();
    protected int _timeout_ = 0;
    protected Socket _socket_ = null;
    protected int _defaultPort_ = 0;
    protected InputStream _input_ = null;
    protected OutputStream _output_ = null;
    protected SocketFactory _socketFactory_ = __DEFAULT_SOCKET_FACTORY;
    protected ServerSocketFactory _serverSocketFactory_ = __DEFAULT_SERVER_SOCKET_FACTORY;
    protected int connectTimeout = 0;

    protected void _connectAction_() throws IOException {
        this._socket_.setSoTimeout(this._timeout_);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
    }

    public void connect(String hostname, int port) throws SocketException, IOException {
        this._socket_ = this._socketFactory_.createSocket();
        this._socket_.connect(new InetSocketAddress(hostname, port), this.connectTimeout);
        this._connectAction_();
    }

    public void connect(String hostname) throws SocketException, IOException {
        this.connect(hostname, this._defaultPort_);
    }

    public void disconnect() throws IOException {
        if (this._socket_ != null) {
            this._socket_.close();
        }
        if (this._input_ != null) {
            this._input_.close();
        }
        if (this._output_ != null) {
            this._output_.close();
        }
        if (this._socket_ != null) {
            this._socket_ = null;
        }
        this._input_ = null;
        this._output_ = null;
    }

    public boolean isConnected() {
        if (this._socket_ == null) {
            return false;
        }
        return this._socket_.isConnected();
    }

    public void setDefaultPort(int port) {
        this._defaultPort_ = port;
    }

    public InetAddress getLocalAddress() {
        return this._socket_.getLocalAddress();
    }

    public InetAddress getRemoteAddress() {
        return this._socket_.getInetAddress();
    }

    public boolean verifyRemote(Socket socket) {
        InetAddress host1 = socket.getInetAddress();
        InetAddress host2 = this.getRemoteAddress();
        return host1.equals(host2);
    }
}

