/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.util.LangUtils;

public class UsernamePasswordCredentials
implements Credentials {
    private String userName;
    private String password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String userName, String password) {
        if (userName == null) {
            throw new IllegalArgumentException("Username may not be null");
        }
        this.userName = userName;
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.userName);
        result.append(":");
        result.append(this.password == null ? "null" : this.password);
        return result.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.userName);
        hash = LangUtils.hashCode(hash, this.password);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
            if (LangUtils.equals(this.userName, that.userName) && LangUtils.equals(this.password, that.password)) {
                return true;
            }
        }
        return false;
    }
}

