/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcDfsRootEnum;
import jcifs.dcerpc.msrpc.MsrpcShareEnum;
import jcifs.netbios.NbtAddress;
import jcifs.smb.Dfs;
import jcifs.smb.DfsReferral;
import jcifs.smb.DosFileFilter;
import jcifs.smb.FileEntry;
import jcifs.smb.Handler;
import jcifs.smb.Info;
import jcifs.smb.NetServerEnum2;
import jcifs.smb.NetServerEnum2Response;
import jcifs.smb.NetShareEnum;
import jcifs.smb.NetShareEnumResponse;
import jcifs.smb.NtTransQuerySecurityDesc;
import jcifs.smb.NtlmAuthenticator;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComClose;
import jcifs.smb.SmbComCreateDirectory;
import jcifs.smb.SmbComDelete;
import jcifs.smb.SmbComDeleteDirectory;
import jcifs.smb.SmbComFindClose2;
import jcifs.smb.SmbComNTCreateAndX;
import jcifs.smb.SmbComNTCreateAndXResponse;
import jcifs.smb.SmbComOpenAndX;
import jcifs.smb.SmbComOpenAndXResponse;
import jcifs.smb.SmbComQueryInformation;
import jcifs.smb.SmbComQueryInformationResponse;
import jcifs.smb.SmbComReadAndX;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbComRename;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComWrite;
import jcifs.smb.SmbComWriteAndX;
import jcifs.smb.SmbComWriteAndXResponse;
import jcifs.smb.SmbComWriteResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2FindFirst2;
import jcifs.smb.Trans2FindFirst2Response;
import jcifs.smb.Trans2FindNext2;
import jcifs.smb.Trans2QueryFSInformation;
import jcifs.smb.Trans2QueryFSInformationResponse;
import jcifs.smb.Trans2QueryPathInformation;
import jcifs.smb.Trans2QueryPathInformationResponse;
import jcifs.smb.Trans2SetFileInformation;
import jcifs.smb.Trans2SetFileInformationResponse;
import jcifs.util.LogStream;

public class SmbFile
extends URLConnection
implements SmbConstants {
    static final int HASH_DOT = ".".hashCode();
    static final int HASH_DOT_DOT = "..".hashCode();
    static LogStream log = LogStream.getInstance();
    static long attrExpirationPeriod;
    private String canon;
    private String share;
    private long createTime;
    private long lastModified;
    private int attributes;
    private long attrExpiration;
    private long size;
    private long sizeExpiration;
    private boolean isExists;
    private int shareAccess = 7;
    private SmbComBlankResponse blank_resp = null;
    private DfsReferral dfsReferral = null;
    protected static Dfs dfs;
    NtlmPasswordAuthentication auth;
    SmbTree tree = null;
    String unc;
    int fid;
    int type;
    boolean opened;
    int tree_num;
    UniAddress[] addresses;
    int addressIndex;

    public SmbFile(String url) throws MalformedURLException {
        this(new URL(null, url, Handler.SMB_HANDLER));
    }

    public SmbFile(String url, NtlmPasswordAuthentication auth) throws MalformedURLException {
        this(new URL(null, url, Handler.SMB_HANDLER), auth);
    }

    public SmbFile(URL url) {
        this(url, new NtlmPasswordAuthentication(url.getUserInfo()));
    }

    public SmbFile(URL url, NtlmPasswordAuthentication auth) {
        super(url);
        this.auth = auth == null ? new NtlmPasswordAuthentication(url.getUserInfo()) : auth;
        this.getUncPath0();
    }

    SmbFile(SmbFile context, String name, int type, int attributes, long createTime, long lastModified, long size) throws MalformedURLException, UnknownHostException {
        this(context.isWorkgroup0() ? new URL(null, "smb://" + name + "/", Handler.SMB_HANDLER) : new URL(context.url, name + ((attributes & 0x10) > 0 ? "/" : "")));
        int last;
        this.auth = context.auth;
        if (context.share != null) {
            this.tree = context.tree;
            this.dfsReferral = context.dfsReferral;
        }
        if (name.charAt(last = name.length() - 1) == '/') {
            name = name.substring(0, last);
        }
        this.unc = context.share == null ? "\\" : (context.unc.equals("\\") ? '\\' + name : context.unc + '\\' + name);
        this.type = type;
        this.attributes = attributes;
        this.createTime = createTime;
        this.lastModified = lastModified;
        this.size = size;
        this.isExists = true;
        this.attrExpiration = this.sizeExpiration = System.currentTimeMillis() + attrExpirationPeriod;
    }

    private SmbComBlankResponse blank_resp() {
        if (this.blank_resp == null) {
            this.blank_resp = new SmbComBlankResponse();
        }
        return this.blank_resp;
    }

    void resolveDfs(ServerMessageBlock request) throws SmbException {
        this.connect0();
        DfsReferral dr = dfs.resolve(this.tree.session.transport.tconHostName, this.tree.share, this.unc, this.auth);
        if (dr != null) {
            String service = null;
            if (request != null) {
                block1 : switch (request.command) {
                    case 37: 
                    case 50: {
                        switch (((SmbComTransaction)request).subCommand & 0xFF) {
                            case 16: {
                                break block1;
                            }
                        }
                        service = "A:";
                        break;
                    }
                    default: {
                        service = "A:";
                    }
                }
            }
            DfsReferral start = dr;
            SmbException se = null;
            while (true) {
                try {
                    if (LogStream.level >= 2) {
                        log.println("DFS redirect: " + dr);
                    }
                    UniAddress addr = UniAddress.getByName(dr.server);
                    SmbTransport trans = SmbTransport.getSmbTransport(addr, this.url.getPort());
                    trans.connect();
                    this.tree = trans.getSmbSession(this.auth).getSmbTree(dr.share, service);
                    if (dr != start && dr.key != null) {
                        dr.map.put(dr.key, dr);
                    }
                    se = null;
                }
                catch (IOException ioe) {
                    se = ioe instanceof SmbException ? (SmbException)ioe : new SmbException(dr.server, (Throwable)ioe);
                    if ((dr = dr.next) != start) continue;
                }
                break;
            }
            if (se != null) {
                throw se;
            }
            if (LogStream.level >= 3) {
                log.println(dr);
            }
            this.dfsReferral = dr;
            if (dr.pathConsumed < 0) {
                dr.pathConsumed = 0;
            } else if (dr.pathConsumed > this.unc.length()) {
                dr.pathConsumed = this.unc.length();
            }
            String dunc = this.unc.substring(dr.pathConsumed);
            if (dunc.equals("")) {
                dunc = "\\";
            }
            if (!dr.path.equals("")) {
                dunc = "\\" + dr.path + dunc;
            }
            this.unc = dunc;
            if (request != null && request.path != null && request.path.endsWith("\\") && !dunc.endsWith("\\")) {
                dunc = dunc + "\\";
            }
            if (request != null) {
                request.path = dunc;
                request.flags2 |= 0x1000;
            }
        } else {
            if (this.tree.inDomainDfs && !(request instanceof NtTransQuerySecurityDesc) && !(request instanceof SmbComClose) && !(request instanceof SmbComFindClose2)) {
                throw new SmbException(-1073741275, false);
            }
            if (request != null) {
                request.flags2 &= 0xFFFFEFFF;
            }
        }
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        while (true) {
            this.resolveDfs(request);
            try {
                this.tree.send(request, response);
            }
            catch (DfsReferral dre) {
                if (dre.resolveHashes) {
                    throw dre;
                }
                request.reset();
                continue;
            }
            break;
        }
    }

    static String queryLookup(String query, String param) {
        String p;
        char[] in = query.toCharArray();
        int eq = 0;
        int st = 0;
        for (int i = 0; i < in.length; ++i) {
            char ch = in[i];
            if (ch == '&') {
                if (eq > st && (p = new String(in, st, eq - st)).equalsIgnoreCase(param)) {
                    return new String(in, ++eq, i - eq);
                }
                st = i + 1;
                continue;
            }
            if (ch != '=') continue;
            eq = i;
        }
        if (eq > st && (p = new String(in, st, eq - st)).equalsIgnoreCase(param)) {
            return new String(in, ++eq, in.length - eq);
        }
        return null;
    }

    UniAddress getAddress() throws UnknownHostException {
        if (this.addressIndex == 0) {
            return this.getFirstAddress();
        }
        return this.addresses[this.addressIndex - 1];
    }

    UniAddress getFirstAddress() throws UnknownHostException {
        this.addressIndex = 0;
        String host = this.url.getHost();
        String path = this.url.getPath();
        String query = this.url.getQuery();
        if (query != null) {
            String server = SmbFile.queryLookup(query, "server");
            if (server != null && server.length() > 0) {
                this.addresses = new UniAddress[1];
                this.addresses[0] = UniAddress.getByName(server);
                return this.getNextAddress();
            }
            String address = SmbFile.queryLookup(query, "address");
            if (address != null && address.length() > 0) {
                byte[] ip = InetAddress.getByName(address).getAddress();
                this.addresses = new UniAddress[1];
                this.addresses[0] = new UniAddress(InetAddress.getByAddress(host, ip));
                return this.getNextAddress();
            }
        }
        if (host.length() == 0) {
            try {
                NbtAddress addr = NbtAddress.getByName("\u0001\u0002__MSBROWSE__\u0002", 1, null);
                this.addresses = new UniAddress[1];
                this.addresses[0] = UniAddress.getByName(addr.getHostAddress());
            }
            catch (UnknownHostException uhe) {
                NtlmPasswordAuthentication.initDefaults();
                if (NtlmPasswordAuthentication.DEFAULT_DOMAIN.equals("?")) {
                    throw uhe;
                }
                this.addresses = UniAddress.getAllByName(NtlmPasswordAuthentication.DEFAULT_DOMAIN, true);
            }
        } else {
            this.addresses = path.length() == 0 || path.equals("/") ? UniAddress.getAllByName(host, true) : UniAddress.getAllByName(host, false);
        }
        return this.getNextAddress();
    }

    UniAddress getNextAddress() {
        UniAddress addr = null;
        if (this.addressIndex < this.addresses.length) {
            addr = this.addresses[this.addressIndex++];
        }
        return addr;
    }

    boolean hasNextAddress() {
        return this.addressIndex < this.addresses.length;
    }

    void connect0() throws SmbException {
        try {
            this.connect();
        }
        catch (UnknownHostException uhe) {
            throw new SmbException("Failed to connect to server", (Throwable)uhe);
        }
        catch (SmbException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SmbException("Failed to connect to server", (Throwable)ioe);
        }
    }

    void doConnect() throws IOException {
        SmbTransport trans;
        UniAddress addr = this.getAddress();
        if (this.tree != null) {
            trans = this.tree.session.transport;
        } else {
            trans = SmbTransport.getSmbTransport(addr, this.url.getPort());
            this.tree = trans.getSmbSession(this.auth).getSmbTree(this.share, null);
        }
        String hostName = this.getServerWithDfs();
        boolean bl = this.tree.inDomainDfs = dfs.resolve(hostName, this.tree.share, null, this.auth) != null;
        if (this.tree.inDomainDfs) {
            this.tree.connectionState = 2;
        }
        try {
            if (LogStream.level >= 3) {
                log.println("doConnect: " + addr);
            }
            this.tree.treeConnect(null, null);
        }
        catch (SmbAuthException sae) {
            if (this.share == null) {
                SmbSession ssn = trans.getSmbSession(NtlmPasswordAuthentication.NULL);
                this.tree = ssn.getSmbTree(null, null);
                this.tree.treeConnect(null, null);
            }
            NtlmPasswordAuthentication a = NtlmAuthenticator.requestNtlmPasswordAuthentication(this.url.toString(), sae);
            if (a != null) {
                this.auth = a;
                SmbSession ssn = trans.getSmbSession(this.auth);
                this.tree = ssn.getSmbTree(this.share, null);
                boolean bl2 = this.tree.inDomainDfs = dfs.resolve(hostName, this.tree.share, null, this.auth) != null;
                if (this.tree.inDomainDfs) {
                    this.tree.connectionState = 2;
                }
                this.tree.treeConnect(null, null);
            }
            if (LogStream.level >= 1 && this.hasNextAddress()) {
                sae.printStackTrace(log);
            }
            throw sae;
        }
    }

    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.getUncPath0();
        this.getFirstAddress();
        while (true) {
            try {
                this.doConnect();
                return;
            }
            catch (SmbException se) {
                if (this.getNextAddress() == null) {
                    throw se;
                }
                if (LogStream.level < 3) continue;
                se.printStackTrace(log);
                continue;
            }
            break;
        }
    }

    boolean isConnected() {
        return this.tree != null && this.tree.connectionState == 2;
    }

    int open0(int flags, int access, int attrs, int options) throws SmbException {
        int f;
        this.connect0();
        if (LogStream.level >= 3) {
            log.println("open0: " + this.unc);
        }
        if (this.tree.session.transport.hasCapability(16)) {
            SmbComNTCreateAndXResponse response = new SmbComNTCreateAndXResponse();
            SmbComNTCreateAndX request = new SmbComNTCreateAndX(this.unc, flags, access, this.shareAccess, attrs, options, null);
            if (this instanceof SmbNamedPipe) {
                request.flags0 |= 0x16;
                request.desiredAccess |= 0x20000;
                response.isExtended = true;
            }
            this.send(request, response);
            f = response.fid;
            this.attributes = response.extFileAttributes & Short.MAX_VALUE;
            this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
            this.isExists = true;
        } else {
            SmbComOpenAndXResponse response = new SmbComOpenAndXResponse();
            this.send(new SmbComOpenAndX(this.unc, access, flags, null), response);
            f = response.fid;
        }
        return f;
    }

    void open(int flags, int access, int attrs, int options) throws SmbException {
        if (this.isOpen()) {
            return;
        }
        this.fid = this.open0(flags, access, attrs, options);
        this.opened = true;
        this.tree_num = this.tree.tree_num;
    }

    boolean isOpen() {
        boolean ans = this.opened && this.isConnected() && this.tree_num == this.tree.tree_num;
        return ans;
    }

    void close(int f, long lastWriteTime) throws SmbException {
        if (LogStream.level >= 3) {
            log.println("close: " + f);
        }
        this.send(new SmbComClose(f, lastWriteTime), this.blank_resp());
    }

    void close(long lastWriteTime) throws SmbException {
        if (!this.isOpen()) {
            return;
        }
        this.close(this.fid, lastWriteTime);
        this.opened = false;
    }

    void close() throws SmbException {
        this.close(0L);
    }

    public String getName() {
        this.getUncPath0();
        if (this.canon.length() > 1) {
            int i = this.canon.length() - 2;
            while (this.canon.charAt(i) != '/') {
                --i;
            }
            return this.canon.substring(i + 1);
        }
        if (this.share != null) {
            return this.share + '/';
        }
        if (this.url.getHost().length() > 0) {
            return this.url.getHost() + '/';
        }
        return "smb://";
    }

    String getUncPath0() {
        if (this.unc == null) {
            int i;
            char[] in = this.url.getPath().toCharArray();
            char[] out = new char[in.length];
            int length = in.length;
            int state = 0;
            int o = 0;
            block5: for (i = 0; i < length; ++i) {
                switch (state) {
                    case 0: {
                        if (in[i] != '/') {
                            return null;
                        }
                        out[o++] = in[i];
                        state = 1;
                        continue block5;
                    }
                    case 1: {
                        if (in[i] == '/') continue block5;
                        if (in[i] == '.' && (i + 1 >= length || in[i + 1] == '/')) {
                            ++i;
                            continue block5;
                        }
                        if (i + 1 < length && in[i] == '.' && in[i + 1] == '.' && (i + 2 >= length || in[i + 2] == '/')) {
                            i += 2;
                            if (o == 1) continue block5;
                            while (--o > 1 && out[o - 1] != '/') {
                            }
                            continue block5;
                        }
                        state = 2;
                    }
                    case 2: {
                        if (in[i] == '/') {
                            state = 1;
                        }
                        out[o++] = in[i];
                    }
                }
            }
            this.canon = new String(out, 0, o);
            if (o > 1) {
                --o;
                i = this.canon.indexOf(47, 1);
                if (i < 0) {
                    this.share = this.canon.substring(1);
                    this.unc = "\\";
                } else if (i == o) {
                    this.share = this.canon.substring(1, i);
                    this.unc = "\\";
                } else {
                    this.share = this.canon.substring(1, i);
                    this.unc = this.canon.substring(i, out[o] == '/' ? o : o + 1);
                    this.unc = this.unc.replace('/', '\\');
                }
            } else {
                this.share = null;
                this.unc = "\\";
            }
        }
        return this.unc;
    }

    String getServerWithDfs() {
        if (this.dfsReferral != null) {
            return this.dfsReferral.server;
        }
        return this.getServer();
    }

    public String getServer() {
        String str = this.url.getHost();
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    public int getType() throws SmbException {
        if (this.type == 0) {
            if (this.getUncPath0().length() > 1) {
                this.type = 1;
            } else if (this.share != null) {
                this.connect0();
                this.type = this.share.equals("IPC$") ? 16 : (this.tree.service.equals("LPT1:") ? 32 : (this.tree.service.equals("COMM") ? 64 : 8));
            } else if (this.url.getAuthority() == null || this.url.getAuthority().length() == 0) {
                this.type = 2;
            } else {
                int code;
                UniAddress addr;
                try {
                    addr = this.getAddress();
                }
                catch (UnknownHostException uhe) {
                    throw new SmbException(this.url.toString(), (Throwable)uhe);
                }
                if (addr.getAddress() instanceof NbtAddress && ((code = ((NbtAddress)addr.getAddress()).getNameType()) == 29 || code == 27)) {
                    this.type = 2;
                    return this.type;
                }
                this.type = 4;
            }
        }
        return this.type;
    }

    boolean isWorkgroup0() throws UnknownHostException {
        if (this.type == 2 || this.url.getHost().length() == 0) {
            this.type = 2;
            return true;
        }
        this.getUncPath0();
        if (this.share == null) {
            int code;
            UniAddress addr = this.getAddress();
            if (addr.getAddress() instanceof NbtAddress && ((code = ((NbtAddress)addr.getAddress()).getNameType()) == 29 || code == 27)) {
                this.type = 2;
                return true;
            }
            this.type = 4;
        }
        return false;
    }

    Info queryPath(String path, int infoLevel) throws SmbException {
        this.connect0();
        if (LogStream.level >= 3) {
            log.println("queryPath: " + path);
        }
        if (this.tree.session.transport.hasCapability(16)) {
            Trans2QueryPathInformationResponse response = new Trans2QueryPathInformationResponse(infoLevel);
            this.send(new Trans2QueryPathInformation(path, infoLevel), response);
            return response.info;
        }
        SmbComQueryInformationResponse response = new SmbComQueryInformationResponse((long)(this.tree.session.transport.server.serverTimeZone * 1000) * 60L);
        this.send(new SmbComQueryInformation(path), response);
        return response;
    }

    public boolean exists() throws SmbException {
        if (this.attrExpiration > System.currentTimeMillis()) {
            return this.isExists;
        }
        this.attributes = 17;
        this.createTime = 0L;
        this.lastModified = 0L;
        this.isExists = false;
        try {
            if (this.url.getHost().length() != 0) {
                if (this.share == null) {
                    if (this.getType() == 2) {
                        UniAddress.getByName(this.url.getHost(), true);
                    } else {
                        UniAddress.getByName(this.url.getHost()).getHostName();
                    }
                } else if (this.getUncPath0().length() == 1 || this.share.equalsIgnoreCase("IPC$")) {
                    this.connect0();
                } else {
                    Info info = this.queryPath(this.getUncPath0(), 257);
                    this.attributes = info.getAttributes();
                    this.createTime = info.getCreateTime();
                    this.lastModified = info.getLastWriteTime();
                }
            }
            this.isExists = true;
        }
        catch (UnknownHostException uhe) {
        }
        catch (SmbException se) {
            switch (se.getNtStatus()) {
                case -1073741809: 
                case -1073741773: 
                case -1073741772: 
                case -1073741766: {
                    break;
                }
                default: {
                    throw se;
                }
            }
        }
        this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        return this.isExists;
    }

    public boolean canRead() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists();
    }

    public boolean canWrite() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists() && (this.attributes & 1) == 0;
    }

    public boolean isDirectory() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return true;
        }
        if (!this.exists()) {
            return false;
        }
        return (this.attributes & 0x10) == 16;
    }

    public boolean isHidden() throws SmbException {
        if (this.share == null) {
            return false;
        }
        if (this.getUncPath0().length() == 1) {
            return this.share.endsWith("$");
        }
        this.exists();
        return (this.attributes & 2) == 2;
    }

    public long lastModified() throws SmbException {
        if (this.getUncPath0().length() > 1) {
            this.exists();
            return this.lastModified;
        }
        return 0L;
    }

    public SmbFile[] listFiles(SmbFilenameFilter filter) throws SmbException {
        return this.listFiles("*", 22, filter, null);
    }

    SmbFile[] listFiles(String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        ArrayList list = new ArrayList();
        this.doEnum(list, true, wildcard, searchAttributes, fnf, ff);
        return list.toArray(new SmbFile[list.size()]);
    }

    void doEnum(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        if (ff != null && ff instanceof DosFileFilter) {
            DosFileFilter dff = (DosFileFilter)ff;
            if (dff.wildcard != null) {
                wildcard = dff.wildcard;
            }
            searchAttributes = dff.attributes;
        }
        try {
            int hostlen = this.url.getHost().length();
            if (hostlen == 0 || this.getType() == 2) {
                this.doNetServerEnum(list, files, wildcard, searchAttributes, fnf, ff);
            } else if (this.share == null) {
                this.doShareEnum(list, files, wildcard, searchAttributes, fnf, ff);
            } else {
                this.doFindFirstNext(list, files, wildcard, searchAttributes, fnf, ff);
            }
        }
        catch (UnknownHostException uhe) {
            throw new SmbException(this.url.toString(), (Throwable)uhe);
        }
        catch (MalformedURLException mue) {
            throw new SmbException(this.url.toString(), (Throwable)mue);
        }
    }

    void doShareEnum(ArrayList list, boolean files, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException, UnknownHostException, MalformedURLException {
        FileEntry e2;
        int ei;
        FileEntry[] entries;
        HashMap<FileEntry, FileEntry> map;
        IOException last;
        block18: {
            String p = this.url.getPath();
            last = null;
            if (p.lastIndexOf(47) != p.length() - 1) {
                throw new SmbException(this.url.toString() + " directory must end with '/'");
            }
            if (this.getType() != 4) {
                throw new SmbException("The requested list operations is invalid: " + this.url.toString());
            }
            map = new HashMap<FileEntry, FileEntry>();
            if (dfs.isTrustedDomain(this.getServer(), this.auth)) {
                try {
                    entries = this.doDfsRootEnum();
                    for (ei = 0; ei < entries.length; ++ei) {
                        e2 = entries[ei];
                        if (map.containsKey(e2)) continue;
                        map.put(e2, e2);
                    }
                }
                catch (IOException ioe) {
                    if (LogStream.level < 4) break block18;
                    ioe.printStackTrace(log);
                }
            }
        }
        UniAddress addr = this.getFirstAddress();
        while (addr != null) {
            try {
                this.doConnect();
                try {
                    entries = this.doMsrpcShareEnum();
                }
                catch (IOException ioe) {
                    if (LogStream.level >= 3) {
                        ioe.printStackTrace(log);
                    }
                    entries = this.doNetShareEnum();
                }
                for (ei = 0; ei < entries.length; ++ei) {
                    e2 = entries[ei];
                    if (map.containsKey(e2)) continue;
                    map.put(e2, e2);
                }
                break;
            }
            catch (IOException ioe) {
                if (LogStream.level >= 3) {
                    ioe.printStackTrace(log);
                }
                last = ioe;
                addr = this.getNextAddress();
            }
        }
        if (last != null && map.isEmpty()) {
            if (!(last instanceof SmbException)) {
                throw new SmbException(this.url.toString(), (Throwable)last);
            }
            throw (SmbException)last;
        }
        for (FileEntry e2 : map.keySet()) {
            String name = e2.getName();
            if (fnf != null && !fnf.accept(this, name) || name.length() <= 0) continue;
            SmbFile f = new SmbFile(this, name, e2.getType(), 17, 0L, 0L, 0L);
            if (ff != null && !ff.accept(f)) continue;
            if (files) {
                list.add(f);
                continue;
            }
            list.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry[] doDfsRootEnum() throws IOException {
        DcerpcHandle dcerpcHandle = null;
        dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + this.getAddress().getHostAddress() + "[\\PIPE\\netdfs]", this.auth);
        try {
            MsrpcDfsRootEnum msrpcDfsRootEnum = new MsrpcDfsRootEnum(this.getServer());
            dcerpcHandle.sendrecv(msrpcDfsRootEnum);
            if (msrpcDfsRootEnum.retval != 0) {
                throw new SmbException(msrpcDfsRootEnum.retval, true);
            }
            FileEntry[] fileEntryArray = msrpcDfsRootEnum.getEntries();
            return fileEntryArray;
        }
        finally {
            block8: {
                try {
                    dcerpcHandle.close();
                }
                catch (IOException iOException) {
                    if (LogStream.level < 4) break block8;
                    iOException.printStackTrace(log);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry[] doMsrpcShareEnum() throws IOException {
        MsrpcShareEnum msrpcShareEnum = new MsrpcShareEnum(this.url.getHost());
        DcerpcHandle dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + this.getAddress().getHostAddress() + "[\\PIPE\\srvsvc]", this.auth);
        try {
            dcerpcHandle.sendrecv(msrpcShareEnum);
            if (msrpcShareEnum.retval != 0) {
                throw new SmbException(msrpcShareEnum.retval, true);
            }
            FileEntry[] fileEntryArray = msrpcShareEnum.getEntries();
            return fileEntryArray;
        }
        finally {
            block8: {
                try {
                    dcerpcHandle.close();
                }
                catch (IOException iOException) {
                    if (LogStream.level < 4) break block8;
                    iOException.printStackTrace(log);
                }
            }
        }
    }

    FileEntry[] doNetShareEnum() throws SmbException {
        NetShareEnum req = new NetShareEnum();
        NetShareEnumResponse resp = new NetShareEnumResponse();
        this.send(req, resp);
        if (resp.status != 0) {
            throw new SmbException(resp.status, true);
        }
        return resp.results;
    }

    void doNetServerEnum(ArrayList arrayList, boolean bl, String string, int n, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException, UnknownHostException, MalformedURLException {
        boolean bl2;
        NetServerEnum2Response netServerEnum2Response;
        NetServerEnum2 netServerEnum2;
        int n2;
        int n3 = n2 = this.url.getHost().length() == 0 ? 0 : this.getType();
        if (n2 == 0) {
            this.connect0();
            netServerEnum2 = new NetServerEnum2(this.tree.session.transport.server.oemDomainName, Integer.MIN_VALUE);
            netServerEnum2Response = new NetServerEnum2Response();
        } else if (n2 == 2) {
            netServerEnum2 = new NetServerEnum2(this.url.getHost(), -1);
            netServerEnum2Response = new NetServerEnum2Response();
        } else {
            throw new SmbException("The requested list operations is invalid: " + this.url.toString());
        }
        do {
            this.send(netServerEnum2, netServerEnum2Response);
            if (netServerEnum2Response.status != 0 && netServerEnum2Response.status != 234) {
                throw new SmbException(netServerEnum2Response.status, true);
            }
            bl2 = netServerEnum2Response.status == 234;
            int n4 = bl2 ? netServerEnum2Response.numEntries - 1 : netServerEnum2Response.numEntries;
            for (int i = 0; i < n4; ++i) {
                FileEntry fileEntry = netServerEnum2Response.results[i];
                String string2 = fileEntry.getName();
                if (smbFilenameFilter != null && !smbFilenameFilter.accept(this, string2) || string2.length() <= 0) continue;
                SmbFile smbFile = new SmbFile(this, string2, fileEntry.getType(), 17, 0L, 0L, 0L);
                if (smbFileFilter != null && !smbFileFilter.accept(smbFile)) continue;
                if (bl) {
                    arrayList.add(smbFile);
                    continue;
                }
                arrayList.add(string2);
            }
            if (this.getType() != 2) break;
            netServerEnum2.subCommand = (byte)-41;
            ((SmbComTransaction)netServerEnum2).reset(0, netServerEnum2Response.lastName);
            netServerEnum2Response.reset();
        } while (bl2);
    }

    void doFindFirstNext(ArrayList arrayList, boolean bl, String string, int n, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException, UnknownHostException, MalformedURLException {
        block7: {
            String string2 = this.getUncPath0();
            String string3 = this.url.getPath();
            if (string3.lastIndexOf(47) != string3.length() - 1) {
                throw new SmbException(this.url.toString() + " directory must end with '/'");
            }
            SmbComTransaction smbComTransaction = new Trans2FindFirst2(string2, string, n);
            Trans2FindFirst2Response trans2FindFirst2Response = new Trans2FindFirst2Response();
            if (LogStream.level >= 3) {
                log.println("doFindFirstNext: " + smbComTransaction.path);
            }
            this.send(smbComTransaction, trans2FindFirst2Response);
            int n2 = trans2FindFirst2Response.sid;
            smbComTransaction = new Trans2FindNext2(n2, trans2FindFirst2Response.resumeKey, trans2FindFirst2Response.lastName);
            trans2FindFirst2Response.subCommand = (byte)2;
            while (true) {
                for (int i = 0; i < trans2FindFirst2Response.numEntries; ++i) {
                    int n3;
                    FileEntry fileEntry = trans2FindFirst2Response.results[i];
                    String string4 = fileEntry.getName();
                    if (string4.length() < 3 && ((n3 = string4.hashCode()) == HASH_DOT || n3 == HASH_DOT_DOT) && (string4.equals(".") || string4.equals("..")) || smbFilenameFilter != null && !smbFilenameFilter.accept(this, string4) || string4.length() <= 0) continue;
                    SmbFile smbFile = new SmbFile(this, string4, 1, fileEntry.getAttributes(), fileEntry.createTime(), fileEntry.lastModified(), fileEntry.length());
                    if (smbFileFilter != null && !smbFileFilter.accept(smbFile)) continue;
                    if (bl) {
                        arrayList.add(smbFile);
                        continue;
                    }
                    arrayList.add(string4);
                }
                if (trans2FindFirst2Response.isEndOfSearch || trans2FindFirst2Response.numEntries == 0) break;
                smbComTransaction.reset(trans2FindFirst2Response.resumeKey, trans2FindFirst2Response.lastName);
                trans2FindFirst2Response.reset();
                this.send(smbComTransaction, trans2FindFirst2Response);
            }
            try {
                this.send(new SmbComFindClose2(n2), this.blank_resp());
            }
            catch (SmbException smbException) {
                if (LogStream.level < 4) break block7;
                smbException.printStackTrace(log);
            }
        }
    }

    public void renameTo(SmbFile smbFile) throws SmbException {
        if (this.getUncPath0().length() == 1 || smbFile.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.resolveDfs(null);
        smbFile.resolveDfs(null);
        if (!this.tree.equals(smbFile.tree)) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (LogStream.level >= 3) {
            log.println("renameTo: " + this.unc + " -> " + smbFile.unc);
        }
        this.sizeExpiration = 0L;
        this.attrExpiration = 0L;
        smbFile.attrExpiration = 0L;
        this.send(new SmbComRename(this.unc, smbFile.unc), this.blank_resp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo0(SmbFile smbFile, byte[][] byArray, int n, WriterThread writerThread, SmbComReadAndX smbComReadAndX, SmbComReadAndXResponse smbComReadAndXResponse) throws SmbException {
        Object object;
        if (this.attrExpiration < System.currentTimeMillis()) {
            this.attributes = 17;
            this.createTime = 0L;
            this.lastModified = 0L;
            this.isExists = false;
            object = this.queryPath(this.getUncPath0(), 257);
            this.attributes = object.getAttributes();
            this.createTime = object.getCreateTime();
            this.lastModified = object.getLastWriteTime();
            this.isExists = true;
            this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        }
        if (this.isDirectory()) {
            block28: {
                String string = smbFile.getUncPath0();
                if (string.length() > 1) {
                    try {
                        smbFile.mkdir();
                        smbFile.setPathInformation(this.attributes, this.createTime, this.lastModified);
                    }
                    catch (SmbException smbException) {
                        if (smbException.getNtStatus() == -1073741790 || smbException.getNtStatus() == -1073741771) break block28;
                        throw smbException;
                    }
                }
            }
            object = this.listFiles("*", 22, null, null);
            try {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    SmbFile smbFile2 = new SmbFile(smbFile, ((SmbFile)object[i]).getName(), ((SmbFile)object[i]).type, ((SmbFile)object[i]).attributes, ((SmbFile)object[i]).createTime, ((SmbFile)object[i]).lastModified, ((SmbFile)object[i]).size);
                    ((SmbFile)object[i]).copyTo0(smbFile2, byArray, n, writerThread, smbComReadAndX, smbComReadAndXResponse);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new SmbException(this.url.toString(), (Throwable)unknownHostException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SmbException(this.url.toString(), (Throwable)malformedURLException);
            }
        }
        try {
            this.open(1, 0, 128, 0);
            try {
                smbFile.open(82, 258, this.attributes, 0);
            }
            catch (SmbAuthException smbAuthException) {
                if ((smbFile.attributes & 1) != 0) {
                    smbFile.setPathInformation(smbFile.attributes & 0xFFFFFFFE, 0L, 0L);
                    smbFile.open(82, 258, this.attributes, 0);
                }
                throw smbAuthException;
            }
            int n2 = 0;
            long l = 0L;
            while (true) {
                smbComReadAndX.setParam(this.fid, l, n);
                smbComReadAndXResponse.setParam(byArray[n2], 0);
                this.send(smbComReadAndX, smbComReadAndXResponse);
                WriterThread writerThread2 = writerThread;
                synchronized (writerThread2) {
                    if (writerThread.e != null) {
                        throw writerThread.e;
                    }
                    while (!writerThread.ready) {
                        try {
                            writerThread.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new SmbException(smbFile.url.toString(), (Throwable)interruptedException);
                        }
                    }
                    if (writerThread.e != null) {
                        throw writerThread.e;
                    }
                    if (smbComReadAndXResponse.dataLength <= 0) {
                        break;
                    }
                    writerThread.write(byArray[n2], smbComReadAndXResponse.dataLength, smbFile, l);
                }
                n2 = n2 == 1 ? 0 : 1;
                l += (long)smbComReadAndXResponse.dataLength;
            }
            smbFile.send(new Trans2SetFileInformation(smbFile.fid, this.attributes, this.createTime, this.lastModified), new Trans2SetFileInformationResponse());
            smbFile.close(0L);
        }
        catch (Exception exception) {
            if (LogStream.level > 1) {
                exception.printStackTrace(log);
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(SmbFile smbFile) throws SmbException {
        if (this.share == null || smbFile.share == null) {
            throw new SmbException("Invalid operation for workgroups or servers");
        }
        SmbComReadAndX smbComReadAndX = new SmbComReadAndX();
        SmbComReadAndXResponse smbComReadAndXResponse = new SmbComReadAndXResponse();
        this.connect0();
        smbFile.connect0();
        this.resolveDfs(null);
        try {
            if (this.getAddress().equals(smbFile.getAddress()) && this.canon.regionMatches(true, 0, smbFile.canon, 0, Math.min(this.canon.length(), smbFile.canon.length()))) {
                throw new SmbException("Source and destination paths overlap.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        WriterThread writerThread = new WriterThread();
        writerThread.setDaemon(true);
        writerThread.start();
        SmbTransport smbTransport = this.tree.session.transport;
        SmbTransport smbTransport2 = smbFile.tree.session.transport;
        if (smbTransport.snd_buf_size < smbTransport2.snd_buf_size) {
            smbTransport2.snd_buf_size = smbTransport.snd_buf_size;
        } else {
            smbTransport.snd_buf_size = smbTransport2.snd_buf_size;
        }
        int n = Math.min(smbTransport.rcv_buf_size - 70, smbTransport.snd_buf_size - 70);
        byte[][] byArray = new byte[2][n];
        try {
            this.copyTo0(smbFile, byArray, n, writerThread, smbComReadAndX, smbComReadAndXResponse);
        }
        finally {
            writerThread.write(null, -1, null, 0L);
        }
    }

    public void delete() throws SmbException {
        this.exists();
        this.getUncPath0();
        this.delete(this.unc);
    }

    void delete(String string) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (System.currentTimeMillis() > this.attrExpiration) {
            this.attributes = 17;
            this.createTime = 0L;
            this.lastModified = 0L;
            this.isExists = false;
            Info info = this.queryPath(this.getUncPath0(), 257);
            this.attributes = info.getAttributes();
            this.createTime = info.getCreateTime();
            this.lastModified = info.getLastWriteTime();
            this.attrExpiration = System.currentTimeMillis() + attrExpirationPeriod;
            this.isExists = true;
        }
        if ((this.attributes & 1) != 0) {
            this.setReadWrite();
        }
        if (LogStream.level >= 3) {
            log.println("delete: " + string);
        }
        if ((this.attributes & 0x10) != 0) {
            this.send(new SmbComDeleteDirectory(string), this.blank_resp());
        } else {
            this.send(new SmbComDelete(string), this.blank_resp());
        }
        this.sizeExpiration = 0L;
        this.attrExpiration = 0L;
    }

    public long length() throws SmbException {
        if (this.sizeExpiration > System.currentTimeMillis()) {
            return this.size;
        }
        if (this.getType() == 8) {
            int level = 1;
            Trans2QueryFSInformationResponse response = new Trans2QueryFSInformationResponse(level);
            this.send(new Trans2QueryFSInformation(level), response);
            this.size = response.info.getCapacity();
        } else if (this.getUncPath0().length() > 1 && this.type != 16) {
            Info info = this.queryPath(this.getUncPath0(), 258);
            this.size = info.getSize();
        } else {
            this.size = 0L;
        }
        this.sizeExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        return this.size;
    }

    public long getDiskFreeSpace() throws SmbException {
        if (this.getType() == 8 || this.type == 1) {
            int level = 1007;
            try {
                return this.queryFSInformation(level);
            }
            catch (SmbException ex) {
                switch (ex.getNtStatus()) {
                    case -1073741823: 
                    case -1073741821: {
                        level = 1;
                        return this.queryFSInformation(level);
                    }
                }
                throw ex;
            }
        }
        return 0L;
    }

    private long queryFSInformation(int level) throws SmbException {
        Trans2QueryFSInformationResponse response = new Trans2QueryFSInformationResponse(level);
        this.send(new Trans2QueryFSInformation(level), response);
        if (this.type == 8) {
            this.size = response.info.getCapacity();
            this.sizeExpiration = System.currentTimeMillis() + attrExpirationPeriod;
        }
        return response.info.getFree();
    }

    public void mkdir() throws SmbException {
        String string = this.getUncPath0();
        if (string.length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (LogStream.level >= 3) {
            log.println("mkdir: " + string);
        }
        this.send(new SmbComCreateDirectory(string), this.blank_resp());
        this.sizeExpiration = 0L;
        this.attrExpiration = 0L;
    }

    void setPathInformation(int attrs, long ctime, long mtime) throws SmbException {
        this.exists();
        int dir = this.attributes & 0x10;
        int f = this.open0(1, 256, dir, dir != 0 ? 1 : 64);
        this.send(new Trans2SetFileInformation(f, attrs | dir, ctime, mtime), new Trans2SetFileInformationResponse());
        this.close(f, 0L);
        this.attrExpiration = 0L;
    }

    public void setLastModified(long l) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(0, 0L, l);
    }

    public int getAttributes() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return 0;
        }
        this.exists();
        return this.attributes & Short.MAX_VALUE;
    }

    public void setAttributes(int n) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(n & 0x30A7, 0L, 0L);
    }

    public void setReadOnly() throws SmbException {
        this.setAttributes(this.getAttributes() | 1);
    }

    public void setReadWrite() throws SmbException {
        this.setAttributes(this.getAttributes() & 0xFFFFFFFE);
    }

    public int hashCode() {
        int hash;
        try {
            hash = this.getAddress().hashCode();
        }
        catch (UnknownHostException uhe) {
            hash = this.getServer().toUpperCase().hashCode();
        }
        this.getUncPath0();
        return hash + this.canon.toUpperCase().hashCode();
    }

    protected boolean pathNamesPossiblyEqual(String path1, String path2) {
        int p1 = path1.lastIndexOf(47);
        int p2 = path2.lastIndexOf(47);
        int l1 = path1.length() - p1;
        int l2 = path2.length() - p2;
        if (l1 > 1 && path1.charAt(p1 + 1) == '.') {
            return true;
        }
        if (l2 > 1 && path2.charAt(p2 + 1) == '.') {
            return true;
        }
        return l1 == l2 && path1.regionMatches(true, p1, path2, p2, l1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmbFile) {
            SmbFile f = (SmbFile)obj;
            if (this == f) {
                return true;
            }
            if (this.pathNamesPossiblyEqual(this.url.getPath(), f.url.getPath())) {
                this.getUncPath0();
                f.getUncPath0();
                if (this.canon.equalsIgnoreCase(f.canon)) {
                    boolean ret;
                    try {
                        ret = this.getAddress().equals(f.getAddress());
                    }
                    catch (UnknownHostException uhe) {
                        ret = this.getServer().equalsIgnoreCase(f.getServer());
                    }
                    return ret;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.url.toString();
    }

    public int getContentLength() {
        try {
            return (int)(this.length() & 0xFFFFFFFFL);
        }
        catch (SmbException smbException) {
            return 0;
        }
    }

    public long getDate() {
        try {
            return this.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public long getLastModified() {
        try {
            return this.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new SmbFileInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new SmbFileOutputStream(this);
    }

    static {
        try {
            Class.forName("jcifs.Config");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        attrExpirationPeriod = Config.getLong("jcifs.smb.client.attrExpirationPeriod", 5000L);
        dfs = new Dfs();
    }

    class WriterThread
    extends Thread {
        byte[] b;
        int n;
        long off;
        boolean ready;
        SmbFile dest;
        SmbException e;
        boolean useNTSmbs;
        SmbComWriteAndX reqx;
        SmbComWrite req;
        ServerMessageBlock resp;

        WriterThread() throws SmbException {
            super("JCIFS-WriterThread");
            this.e = null;
            this.useNTSmbs = SmbFile.this.tree.session.transport.hasCapability(16);
            if (this.useNTSmbs) {
                this.reqx = new SmbComWriteAndX();
                this.resp = new SmbComWriteAndXResponse();
            } else {
                this.req = new SmbComWrite();
                this.resp = new SmbComWriteResponse();
            }
            this.ready = false;
        }

        synchronized void write(byte[] b, int n, SmbFile dest, long off) {
            this.b = b;
            this.n = n;
            this.dest = dest;
            this.off = off;
            this.ready = false;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WriterThread writerThread = this;
            synchronized (writerThread) {
                try {
                    while (true) {
                        this.notify();
                        this.ready = true;
                        while (this.ready) {
                            this.wait();
                        }
                        if (this.n == -1) {
                            return;
                        }
                        if (this.useNTSmbs) {
                            this.reqx.setParam(this.dest.fid, this.off, this.n, this.b, 0, this.n);
                            this.dest.send(this.reqx, this.resp);
                            continue;
                        }
                        this.req.setParam(this.dest.fid, this.off, this.n, this.b, 0, this.n);
                        this.dest.send(this.req, this.resp);
                    }
                }
                catch (SmbException e) {
                    this.e = e;
                }
                catch (Exception x) {
                    this.e = new SmbException("WriterThread", (Throwable)x);
                }
                this.notify();
            }
        }
    }
}

