/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.TimeZone;
import jcifs.Config;
import jcifs.smb.SmbTransport;

interface SmbConstants {
    public static final InetAddress LADDR = Config.getLocalHost();
    public static final int LPORT = Config.getInt("jcifs.smb.client.lport", 0);
    public static final int MAX_MPX_COUNT = Config.getInt("jcifs.smb.client.maxMpxCount", 10);
    public static final int SND_BUF_SIZE = Config.getInt("jcifs.smb.client.snd_buf_size", 16644);
    public static final int RCV_BUF_SIZE = Config.getInt("jcifs.smb.client.rcv_buf_size", 60416);
    public static final boolean USE_UNICODE = Config.getBoolean("jcifs.smb.client.useUnicode", true);
    public static final boolean FORCE_UNICODE = Config.getBoolean("jcifs.smb.client.useUnicode", false);
    public static final boolean USE_NTSTATUS = Config.getBoolean("jcifs.smb.client.useNtStatus", true);
    public static final boolean SIGNPREF = Config.getBoolean("jcifs.smb.client.signingPreferred", false);
    public static final boolean USE_NTSMBS = Config.getBoolean("jcifs.smb.client.useNTSmbs", true);
    public static final boolean USE_EXTSEC = Config.getBoolean("jcifs.smb.client.useExtendedSecurity", true);
    public static final String NETBIOS_HOSTNAME = Config.getProperty("jcifs.netbios.hostname", null);
    public static final int LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 3);
    public static final int PID = (int)(Math.random() * 65536.0);
    public static final TimeZone TZ = TimeZone.getDefault();
    public static final boolean USE_BATCHING = Config.getBoolean("jcifs.smb.client.useBatching", true);
    public static final String OEM_ENCODING = Config.getProperty("jcifs.encoding", Config.DEFAULT_OEM_ENCODING);
    public static final int DEFAULT_FLAGS2 = 3 | (USE_EXTSEC ? 2048 : 0) | (SIGNPREF ? 4 : 0) | (USE_NTSTATUS ? 16384 : 0) | (USE_UNICODE ? 32768 : 0);
    public static final int DEFAULT_CAPABILITIES = (USE_NTSMBS ? 16 : 0) | (USE_NTSTATUS ? 64 : 0) | (USE_UNICODE ? 4 : 0) | 0x1000;
    public static final int FLAGS2 = Config.getInt("jcifs.smb.client.flags2", DEFAULT_FLAGS2);
    public static final int CAPABILITIES = Config.getInt("jcifs.smb.client.capabilities", DEFAULT_CAPABILITIES);
    public static final boolean TCP_NODELAY = Config.getBoolean("jcifs.smb.client.tcpNoDelay", false);
    public static final int RESPONSE_TIMEOUT = Config.getInt("jcifs.smb.client.responseTimeout", 30000);
    public static final LinkedList CONNECTIONS = new LinkedList();
    public static final int SSN_LIMIT = Config.getInt("jcifs.smb.client.ssnLimit", 250);
    public static final int SO_TIMEOUT = Config.getInt("jcifs.smb.client.soTimeout", 35000);
    public static final String NATIVE_OS = Config.getProperty("jcifs.smb.client.nativeOs", System.getProperty("os.name"));
    public static final String NATIVE_LANMAN = Config.getProperty("jcifs.smb.client.nativeLanMan", "jCIFS");
    public static final SmbTransport NULL_TRANSPORT = new SmbTransport(null, 0, null, 0);
}

