/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.TimeZone;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;
import jcifs.util.transport.Request;
import jcifs.util.transport.Response;

abstract class ServerMessageBlock
extends Response
implements SmbConstants,
Request {
    static LogStream log = LogStream.getInstance();
    static final byte[] header = new byte[]{-1, 83, 77, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    byte command;
    byte flags = (byte)24;
    int headerStart;
    int length;
    int batchLevel = 0;
    int errorCode;
    int flags2;
    int tid;
    int pid = PID;
    int uid;
    int mid;
    int wordCount;
    int byteCount;
    boolean useUnicode;
    boolean received;
    boolean extendedSecurity;
    long responseTimeout = 1L;
    int signSeq;
    boolean verifyFailed;
    NtlmPasswordAuthentication auth = null;
    String path;
    SigningDigest digest = null;
    ServerMessageBlock response;

    static void writeInt2(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >> 8);
    }

    static void writeInt4(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >> 8);
    }

    static int readInt2(byte[] src, int srcIndex) {
        return (src[srcIndex] & 0xFF) + ((src[srcIndex + 1] & 0xFF) << 8);
    }

    static int readInt4(byte[] src, int srcIndex) {
        return (src[srcIndex] & 0xFF) + ((src[srcIndex + 1] & 0xFF) << 8) + ((src[srcIndex + 2] & 0xFF) << 16) + ((src[srcIndex + 3] & 0xFF) << 24);
    }

    static long readInt8(byte[] src, int srcIndex) {
        return ((long)ServerMessageBlock.readInt4(src, srcIndex) & 0xFFFFFFFFL) + ((long)ServerMessageBlock.readInt4(src, srcIndex + 4) << 32);
    }

    static void writeInt8(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >> 8);
    }

    static long readTime(byte[] src, int srcIndex) {
        int low = ServerMessageBlock.readInt4(src, srcIndex);
        int hi = ServerMessageBlock.readInt4(src, srcIndex + 4);
        long t = (long)hi << 32 | (long)low & 0xFFFFFFFFL;
        t = t / 10000L - 11644473600000L;
        return t;
    }

    static void writeTime(long t, byte[] dst, int dstIndex) {
        if (t != 0L) {
            t = (t + 11644473600000L) * 10000L;
        }
        ServerMessageBlock.writeInt8(t, dst, dstIndex);
    }

    static long readUTime(byte[] buffer, int bufferIndex) {
        return (long)ServerMessageBlock.readInt4(buffer, bufferIndex) * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUTime(long t, byte[] dst, int dstIndex) {
        if (t == 0L || t == -1L) {
            ServerMessageBlock.writeInt4(-1L, dst, dstIndex);
            return;
        }
        TimeZone timeZone = TZ;
        synchronized (timeZone) {
            if (TZ.inDaylightTime(new Date())) {
                if (!TZ.inDaylightTime(new Date(t))) {
                    t -= 3600000L;
                }
            } else if (TZ.inDaylightTime(new Date(t))) {
                t += 3600000L;
            }
        }
        ServerMessageBlock.writeInt4((int)(t / 1000L), dst, dstIndex);
    }

    ServerMessageBlock() {
    }

    void reset() {
        this.flags = (byte)24;
        this.flags2 = 0;
        this.errorCode = 0;
        this.received = false;
        this.digest = null;
    }

    int writeString(String str, byte[] dst, int dstIndex) {
        return this.writeString(str, dst, dstIndex, this.useUnicode);
    }

    int writeString(String str, byte[] dst, int dstIndex, boolean useUnicode) {
        int start;
        block5: {
            start = dstIndex;
            try {
                if (useUnicode) {
                    if ((dstIndex - this.headerStart) % 2 != 0) {
                        dst[dstIndex++] = 0;
                    }
                    System.arraycopy(str.getBytes("UTF-16LE"), 0, dst, dstIndex, str.length() * 2);
                    dstIndex += str.length() * 2;
                    dst[dstIndex++] = 0;
                    dst[dstIndex++] = 0;
                } else {
                    byte[] b = str.getBytes(OEM_ENCODING);
                    System.arraycopy(b, 0, dst, dstIndex, b.length);
                    dstIndex += b.length;
                    dst[dstIndex++] = 0;
                }
            }
            catch (UnsupportedEncodingException uee) {
                if (LogStream.level <= 1) break block5;
                uee.printStackTrace(log);
            }
        }
        return dstIndex - start;
    }

    String readString(byte[] src, int srcIndex) {
        return this.readString(src, srcIndex, 256, this.useUnicode);
    }

    String readString(byte[] src, int srcIndex, int maxLen, boolean useUnicode) {
        String str;
        block9: {
            int len = 0;
            str = null;
            try {
                if (useUnicode) {
                    if ((srcIndex - this.headerStart) % 2 != 0) {
                        ++srcIndex;
                    }
                    while (src[srcIndex + len] != 0 || src[srcIndex + len + 1] != 0) {
                        if ((len += 2) <= maxLen) continue;
                        if (LogStream.level > 0) {
                            Hexdump.hexdump(System.err, src, srcIndex, maxLen < 128 ? maxLen + 8 : 128);
                        }
                        throw new RuntimeException("zero termination not found");
                    }
                    str = new String(src, srcIndex, len, "UTF-16LE");
                } else {
                    while (src[srcIndex + len] != 0) {
                        if (++len <= maxLen) continue;
                        if (LogStream.level > 0) {
                            Hexdump.hexdump(System.err, src, srcIndex, maxLen < 128 ? maxLen + 8 : 128);
                        }
                        throw new RuntimeException("zero termination not found");
                    }
                    str = new String(src, srcIndex, len, OEM_ENCODING);
                }
            }
            catch (UnsupportedEncodingException uee) {
                if (LogStream.level <= 1) break block9;
                uee.printStackTrace(log);
            }
        }
        return str;
    }

    String readString(byte[] src, int srcIndex, int srcEnd, int maxLen, boolean useUnicode) {
        String str;
        block11: {
            int len = 0;
            str = null;
            try {
                if (useUnicode) {
                    if ((srcIndex - this.headerStart) % 2 != 0) {
                        ++srcIndex;
                    }
                    len = 0;
                    while (srcIndex + len + 1 < srcEnd && (src[srcIndex + len] != 0 || src[srcIndex + len + 1] != 0)) {
                        if (len > maxLen) {
                            if (LogStream.level > 0) {
                                Hexdump.hexdump(System.err, src, srcIndex, maxLen < 128 ? maxLen + 8 : 128);
                            }
                            throw new RuntimeException("zero termination not found");
                        }
                        len += 2;
                    }
                    str = new String(src, srcIndex, len, "UTF-16LE");
                } else {
                    len = 0;
                    while (srcIndex < srcEnd && src[srcIndex + len] != 0) {
                        if (len > maxLen) {
                            if (LogStream.level > 0) {
                                Hexdump.hexdump(System.err, src, srcIndex, maxLen < 128 ? maxLen + 8 : 128);
                            }
                            throw new RuntimeException("zero termination not found");
                        }
                        ++len;
                    }
                    str = new String(src, srcIndex, len, OEM_ENCODING);
                }
            }
            catch (UnsupportedEncodingException uee) {
                if (LogStream.level <= 1) break block11;
                uee.printStackTrace(log);
            }
        }
        return str;
    }

    int stringWireLength(String str, int offset) {
        int len = str.length() + 1;
        if (this.useUnicode) {
            len = str.length() * 2 + 2;
            len = offset % 2 != 0 ? len + 1 : len;
        }
        return len;
    }

    int readStringLength(byte[] src, int srcIndex, int max) {
        int len = 0;
        while (src[srcIndex + len] != 0) {
            if (len++ <= max) continue;
            throw new RuntimeException("zero termination not found: " + this);
        }
        return len;
    }

    int encode(byte[] dst, int dstIndex) {
        int start = this.headerStart = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        this.wordCount = this.writeParameterWordsWireFormat(dst, dstIndex + 1);
        dst[dstIndex++] = (byte)(this.wordCount / 2 & 0xFF);
        this.wordCount /= 2;
        this.byteCount = this.writeBytesWireFormat(dst, (dstIndex += this.wordCount) + 2);
        dst[dstIndex++] = (byte)(this.byteCount & 0xFF);
        dst[dstIndex++] = (byte)(this.byteCount >> 8 & 0xFF);
        this.length = (dstIndex += this.byteCount) - start;
        if (this.digest != null) {
            this.digest.sign(dst, this.headerStart, this.length, this, this.response);
        }
        return this.length;
    }

    int decode(byte[] buffer, int bufferIndex) {
        int n;
        int start = this.headerStart = bufferIndex;
        bufferIndex += this.readHeaderWireFormat(buffer, bufferIndex);
        this.wordCount = buffer[bufferIndex++];
        if (this.wordCount != 0) {
            n = this.readParameterWordsWireFormat(buffer, bufferIndex);
            if (n != this.wordCount * 2) {
                if (LogStream.level >= 5) {
                    log.println("wordCount * 2=" + this.wordCount * 2 + " but readParameterWordsWireFormat returned " + n);
                }
            }
            bufferIndex += this.wordCount * 2;
        }
        this.byteCount = ServerMessageBlock.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.byteCount != 0) {
            n = this.readBytesWireFormat(buffer, bufferIndex);
            if (n != this.byteCount) {
                if (LogStream.level >= 5) {
                    log.println("byteCount=" + this.byteCount + " but readBytesWireFormat returned " + n);
                }
            }
            bufferIndex += this.byteCount;
        }
        this.length = bufferIndex - start;
        return this.length;
    }

    int writeHeaderWireFormat(byte[] dst, int dstIndex) {
        System.arraycopy(header, 0, dst, dstIndex, header.length);
        dst[dstIndex + 4] = this.command;
        dst[dstIndex + 9] = this.flags;
        ServerMessageBlock.writeInt2(this.flags2, dst, dstIndex + 9 + 1);
        ServerMessageBlock.writeInt2(this.tid, dst, dstIndex += 24);
        ServerMessageBlock.writeInt2(this.pid, dst, dstIndex + 2);
        ServerMessageBlock.writeInt2(this.uid, dst, dstIndex + 4);
        ServerMessageBlock.writeInt2(this.mid, dst, dstIndex + 6);
        return 32;
    }

    int readHeaderWireFormat(byte[] buffer, int bufferIndex) {
        this.command = buffer[bufferIndex + 4];
        this.errorCode = ServerMessageBlock.readInt4(buffer, bufferIndex + 5);
        this.flags = buffer[bufferIndex + 9];
        this.flags2 = ServerMessageBlock.readInt2(buffer, bufferIndex + 9 + 1);
        this.tid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24);
        this.pid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24 + 2);
        this.uid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24 + 4);
        this.mid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24 + 6);
        return 32;
    }

    boolean isResponse() {
        return (this.flags & 0x80) == 128;
    }

    abstract int writeParameterWordsWireFormat(byte[] var1, int var2);

    abstract int writeBytesWireFormat(byte[] var1, int var2);

    abstract int readParameterWordsWireFormat(byte[] var1, int var2);

    abstract int readBytesWireFormat(byte[] var1, int var2);

    public int hashCode() {
        return this.mid;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerMessageBlock && ((ServerMessageBlock)obj).mid == this.mid;
    }

    public String toString() {
        String c;
        switch (this.command) {
            case 114: {
                c = "SMB_COM_NEGOTIATE";
                break;
            }
            case 115: {
                c = "SMB_COM_SESSION_SETUP_ANDX";
                break;
            }
            case 117: {
                c = "SMB_COM_TREE_CONNECT_ANDX";
                break;
            }
            case 8: {
                c = "SMB_COM_QUERY_INFORMATION";
                break;
            }
            case 16: {
                c = "SMB_COM_CHECK_DIRECTORY";
                break;
            }
            case 37: {
                c = "SMB_COM_TRANSACTION";
                break;
            }
            case 50: {
                c = "SMB_COM_TRANSACTION2";
                break;
            }
            case 38: {
                c = "SMB_COM_TRANSACTION_SECONDARY";
                break;
            }
            case 52: {
                c = "SMB_COM_FIND_CLOSE2";
                break;
            }
            case 113: {
                c = "SMB_COM_TREE_DISCONNECT";
                break;
            }
            case 116: {
                c = "SMB_COM_LOGOFF_ANDX";
                break;
            }
            case 43: {
                c = "SMB_COM_ECHO";
                break;
            }
            case 42: {
                c = "SMB_COM_MOVE";
                break;
            }
            case 7: {
                c = "SMB_COM_RENAME";
                break;
            }
            case 6: {
                c = "SMB_COM_DELETE";
                break;
            }
            case 1: {
                c = "SMB_COM_DELETE_DIRECTORY";
                break;
            }
            case -94: {
                c = "SMB_COM_NT_CREATE_ANDX";
                break;
            }
            case 45: {
                c = "SMB_COM_OPEN_ANDX";
                break;
            }
            case 46: {
                c = "SMB_COM_READ_ANDX";
                break;
            }
            case 4: {
                c = "SMB_COM_CLOSE";
                break;
            }
            case 47: {
                c = "SMB_COM_WRITE_ANDX";
                break;
            }
            case 0: {
                c = "SMB_COM_CREATE_DIRECTORY";
                break;
            }
            case -96: {
                c = "SMB_COM_NT_TRANSACT";
                break;
            }
            case -95: {
                c = "SMB_COM_NT_TRANSACT_SECONDARY";
                break;
            }
            default: {
                c = "UNKNOWN";
            }
        }
        String str = this.errorCode == 0 ? "0" : SmbException.getMessageByCode(this.errorCode);
        return new String("command=" + c + ",received=" + this.received + ",errorCode=" + str + ",flags=0x" + Hexdump.toHexString(this.flags & 0xFF, 4) + ",flags2=0x" + Hexdump.toHexString(this.flags2, 4) + ",signSeq=" + this.signSeq + ",tid=" + this.tid + ",pid=" + this.pid + ",uid=" + this.uid + ",mid=" + this.mid + ",wordCount=" + this.wordCount + ",byteCount=" + this.byteCount);
    }
}

