/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.util.Hexdump;

public class Type2Message
extends NtlmMessage {
    private static final int DEFAULT_FLAGS = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
    private static final String DEFAULT_DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
    private static final byte[] DEFAULT_TARGET_INFORMATION;
    private byte[] challenge;
    private String target;
    private byte[] context;
    private byte[] targetInformation;

    public Type2Message() {
        this(Type2Message.getDefaultFlags(), null, null);
    }

    public Type2Message(int flags, byte[] challenge, String target) {
        this.setFlags(flags);
        this.setChallenge(challenge);
        this.setTarget(target);
        if (target != null) {
            this.setTargetInformation(Type2Message.getDefaultTargetInformation());
        }
    }

    public Type2Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public byte[] getTargetInformation() {
        return this.targetInformation;
    }

    public void setTargetInformation(byte[] targetInformation) {
        this.targetInformation = targetInformation;
    }

    public byte[] getContext() {
        return this.context;
    }

    public void setContext(byte[] context) {
        this.context = context;
    }

    public String toString() {
        String target = this.getTarget();
        byte[] challenge = this.getChallenge();
        byte[] context = this.getContext();
        byte[] targetInformation = this.getTargetInformation();
        return "Type2Message[target=" + target + ",challenge=" + (challenge == null ? "null" : "<" + challenge.length + " bytes>") + ",context=" + (context == null ? "null" : "<" + context.length + " bytes>") + ",targetInformation=" + (targetInformation == null ? "null" : "<" + targetInformation.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags() {
        return DEFAULT_FLAGS;
    }

    public static byte[] getDefaultTargetInformation() {
        return DEFAULT_TARGET_INFORMATION;
    }

    private void parse(byte[] material) throws IOException {
        int offset;
        for (int i = 0; i < 8; ++i) {
            if (material[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type2Message.readULong(material, 8) != 2) {
            throw new IOException("Not a Type 2 message.");
        }
        int flags = Type2Message.readULong(material, 20);
        this.setFlags(flags);
        String target = null;
        byte[] bytes = Type2Message.readSecurityBuffer(material, 12);
        if (bytes.length != 0) {
            target = new String(bytes, (flags & 1) != 0 ? "UTF-16LE" : Type2Message.getOEMEncoding());
        }
        this.setTarget(target);
        for (int i = 24; i < 32; ++i) {
            if (material[i] == 0) continue;
            byte[] challenge = new byte[8];
            System.arraycopy(material, 24, challenge, 0, 8);
            this.setChallenge(challenge);
            break;
        }
        if ((offset = Type2Message.readULong(material, 16)) == 32 || material.length == 32) {
            return;
        }
        for (int i = 32; i < 40; ++i) {
            if (material[i] == 0) continue;
            byte[] context = new byte[8];
            System.arraycopy(material, 32, context, 0, 8);
            this.setContext(context);
            break;
        }
        if (offset == 40 || material.length == 40) {
            return;
        }
        bytes = Type2Message.readSecurityBuffer(material, 40);
        if (bytes.length != 0) {
            this.setTargetInformation(bytes);
        }
    }

    static {
        byte[] domain = new byte[]{};
        if (DEFAULT_DOMAIN != null) {
            try {
                domain = DEFAULT_DOMAIN.getBytes("UTF-16LE");
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        int domainLength = domain.length;
        byte[] server = new byte[]{};
        try {
            String host = NbtAddress.getLocalHost().getHostName();
            if (host != null) {
                try {
                    server = host.getBytes("UTF-16LE");
                }
                catch (IOException ex) {}
            }
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        int serverLength = server.length;
        byte[] targetInfo = new byte[(domainLength > 0 ? domainLength + 4 : 0) + (serverLength > 0 ? serverLength + 4 : 0) + 4];
        int offset = 0;
        if (domainLength > 0) {
            Type2Message.writeUShort(targetInfo, offset, 2);
            Type2Message.writeUShort(targetInfo, offset += 2, domainLength);
            System.arraycopy(domain, 0, targetInfo, offset += 2, domainLength);
            offset += domainLength;
        }
        if (serverLength > 0) {
            Type2Message.writeUShort(targetInfo, offset, 1);
            Type2Message.writeUShort(targetInfo, offset += 2, serverLength);
            System.arraycopy(server, 0, targetInfo, offset += 2, serverLength);
        }
        DEFAULT_TARGET_INFORMATION = targetInfo;
    }
}

