/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;

public class NbtException
extends IOException {
    public int errorClass;
    public int errorCode;

    public static String getErrorString(int errorClass, int errorCode) {
        String result = "";
        block0 : switch (errorClass) {
            case 0: {
                result = result + "SUCCESS";
                break;
            }
            case 1: {
                result = result + "ERR_NAM_SRVC/";
                switch (errorCode) {
                    case 1: {
                        result = result + "FMT_ERR: Format Error";
                    }
                }
                result = result + "Unknown error code: " + errorCode;
                break;
            }
            case 2: {
                result = result + "ERR_SSN_SRVC/";
                switch (errorCode) {
                    case -1: {
                        result = result + "Connection refused";
                        break block0;
                    }
                    case 128: {
                        result = result + "Not listening on called name";
                        break block0;
                    }
                    case 129: {
                        result = result + "Not listening for calling name";
                        break block0;
                    }
                    case 130: {
                        result = result + "Called name not present";
                        break block0;
                    }
                    case 131: {
                        result = result + "Called name present, but insufficient resources";
                        break block0;
                    }
                    case 143: {
                        result = result + "Unspecified error";
                        break block0;
                    }
                }
                result = result + "Unknown error code: " + errorCode;
                break;
            }
            default: {
                result = result + "unknown error class: " + errorClass;
            }
        }
        return result;
    }

    public NbtException(int errorClass, int errorCode) {
        super(NbtException.getErrorString(errorClass, errorCode));
        this.errorClass = errorClass;
        this.errorCode = errorCode;
    }

    public String toString() {
        return new String("errorClass=" + this.errorClass + ",errorCode=" + this.errorCode + ",errorString=" + NbtException.getErrorString(this.errorClass, this.errorCode));
    }
}

