/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class Prober
extends DNSTask {
    static Logger logger = Logger.getLogger(Prober.class.getName());
    DNSState taskState = DNSState.PROBING_1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Prober(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
        if (this._jmDNSImpl.getState() == DNSState.PROBING_1) {
            this._jmDNSImpl.setTask(this);
        }
        JmDNSImpl jmDNSImpl2 = this._jmDNSImpl;
        synchronized (jmDNSImpl2) {
            for (ServiceInfoImpl serviceInfoImpl : this._jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getState() != DNSState.PROBING_1) continue;
                serviceInfoImpl.setTask(this);
            }
        }
    }

    public void start(Timer timer) {
        long now = System.currentTimeMillis();
        if (now - this._jmDNSImpl.getLastThrottleIncrement() < 5000L) {
            this._jmDNSImpl.setThrottle(this._jmDNSImpl.getThrottle() + 1);
        } else {
            this._jmDNSImpl.setThrottle(1);
        }
        this._jmDNSImpl.setLastThrottleIncrement(now);
        if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED && this._jmDNSImpl.getThrottle() < 10) {
            timer.schedule((TimerTask)this, JmDNSImpl.getRandom().nextInt(251), 250L);
        } else {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (this._jmDNSImpl.getTask() == this) {
            this._jmDNSImpl.setTask(null);
        }
        JmDNSImpl jmDNSImpl = this._jmDNSImpl;
        synchronized (jmDNSImpl) {
            for (ServiceInfoImpl serviceInfoImpl : this._jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getTask() != this) continue;
                serviceInfoImpl.setTask(null);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this._jmDNSImpl.getIoLock();
        synchronized (object) {
            DNSOutgoing out = null;
            try {
                ArrayList<ServiceInfo> list;
                if (this._jmDNSImpl.getState() == this.taskState && this._jmDNSImpl.getTask() == this) {
                    out = new DNSOutgoing(0);
                    out.addQuestion(new DNSQuestion(this._jmDNSImpl.getLocalHost().getName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
                    this._jmDNSImpl.getLocalHost().addAddressRecords(out, true);
                    this._jmDNSImpl.advanceState();
                }
                JmDNSImpl jmDNSImpl = this._jmDNSImpl;
                synchronized (jmDNSImpl) {
                    list = new ArrayList<ServiceInfo>(this._jmDNSImpl.getServices().values());
                }
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    ServiceInfoImpl info;
                    ServiceInfoImpl serviceInfoImpl = info = (ServiceInfoImpl)i.next();
                    synchronized (serviceInfoImpl) {
                        if (info.getState() == this.taskState && info.getTask() == this) {
                            info.advanceState();
                            logger.fine("run() JmDNS probing " + info.getQualifiedName() + " state " + (Object)((Object)info.getState()));
                            if (out == null) {
                                out = new DNSOutgoing(0);
                                out.addQuestion(new DNSQuestion(info.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
                            }
                            out.addAuthorativeAnswer(new DNSRecord.Service(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, false, 3600, info.getPriority(), info.getWeight(), info.getPort(), this._jmDNSImpl.getLocalHost().getName()));
                        }
                    }
                }
                if (out == null) {
                    this.cancel();
                    return;
                }
                logger.finer("run() JmDNS probing #" + (Object)((Object)this.taskState));
                this._jmDNSImpl.send(out);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "run() exception ", e);
                this._jmDNSImpl.recover();
            }
            this.taskState = this.taskState.advance();
            if (!this.taskState.isProbing()) {
                this.cancel();
                this._jmDNSImpl.startAnnouncer();
            }
        }
    }
}

