/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSState;

class SocketListener
implements Runnable {
    static Logger logger = Logger.getLogger(SocketListener.class.getName());
    private final JmDNSImpl _jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        this._jmDNSImpl = jmDNSImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            try {
                byte[] buf = new byte[8972];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (this._jmDNSImpl.getState() != DNSState.CANCELED) {
                    packet.setLength(buf.length);
                    this._jmDNSImpl.getSocket().receive(packet);
                    if (this._jmDNSImpl.getState() != DNSState.CANCELED) {
                        try {
                            if (this._jmDNSImpl.getLocalHost().shouldIgnorePacket(packet)) continue;
                            DNSIncoming msg = new DNSIncoming(packet);
                            logger.finest("SocketListener.run() JmDNS in:" + msg.print(true));
                            Object object = this._jmDNSImpl.getIoLock();
                            synchronized (object) {
                                if (msg.isQuery()) {
                                    if (packet.getPort() != 5353) {
                                        this._jmDNSImpl.handleQuery(msg, packet.getAddress(), packet.getPort());
                                    }
                                    this._jmDNSImpl.handleQuery(msg, this._jmDNSImpl.getGroup(), 5353);
                                } else {
                                    this._jmDNSImpl.handleResponse(msg);
                                }
                                continue;
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "run() exception ", e);
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this._jmDNSImpl.getState() == DNSState.CANCELED) break block12;
                logger.log(Level.WARNING, "run() exception ", e);
                this._jmDNSImpl.recover();
            }
        }
    }
}

