/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.SocketListener;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.Announcer;
import javax.jmdns.impl.tasks.Canceler;
import javax.jmdns.impl.tasks.Prober;
import javax.jmdns.impl.tasks.RecordReaper;
import javax.jmdns.impl.tasks.Renewer;
import javax.jmdns.impl.tasks.Responder;
import javax.jmdns.impl.tasks.ServiceInfoResolver;
import javax.jmdns.impl.tasks.ServiceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmDNSImpl
extends JmDNS {
    private static Logger logger = Logger.getLogger(JmDNSImpl.class.getName());
    private volatile InetAddress _group;
    private volatile MulticastSocket _socket;
    private volatile boolean _closed = false;
    private final List<DNSListener> _listeners;
    private final ConcurrentMap<String, List<ServiceListener>> _serviceListeners;
    private final Set<ServiceTypeListener> _typeListeners;
    private DNSCache _cache;
    private final ConcurrentMap<String, ServiceInfo> _services;
    private final ConcurrentMap<String, String> _serviceTypes;
    protected Thread _shutdown;
    private HostInfo _localHost;
    private final Thread _incomingListener;
    private int _throttle;
    private long _lastThrottleIncrement;
    private Timer _cancelerTimer = new Timer("JmDNS.cancelerTimer");
    private final Timer _timer;
    private static final Random _random = new Random();
    private Object _ioLock = new Object();
    private DNSIncoming _plannedAnswer;
    private DNSState _state = DNSState.PROBING_1;
    private TimerTask _task;
    private final ConcurrentMap<String, ServiceCollector> _serviceCollectors;

    public JmDNSImpl() throws IOException {
        this(null);
    }

    public JmDNSImpl(InetAddress address) throws IOException {
        logger.finer("JmDNS instance created");
        this._cache = new DNSCache(100);
        this._listeners = Collections.synchronizedList(new ArrayList());
        this._serviceListeners = new ConcurrentHashMap<String, List<ServiceListener>>();
        this._typeListeners = Collections.synchronizedSet(new HashSet());
        this._serviceCollectors = new ConcurrentHashMap<String, ServiceCollector>();
        this._services = new ConcurrentHashMap<String, ServiceInfo>(20);
        this._serviceTypes = new ConcurrentHashMap<String, String>(20);
        this._timer = new Timer("JmDNS.Timer");
        new RecordReaper(this).start(this._timer);
        this._incomingListener = new Thread((Runnable)new SocketListener(this), "JmDNS.SocketListener");
        this._incomingListener.setDaemon(true);
        try {
            int idx;
            InetAddress addr = address;
            String aName = "";
            if (addr == null) {
                addr = InetAddress.getLocalHost();
                aName = addr.getHostName();
                if (addr.isLoopbackAddress()) {
                    addr = null;
                }
            } else {
                aName = addr.getHostName();
            }
            if ((idx = aName.indexOf(".")) > 0) {
                aName = aName.substring(0, idx);
            }
            aName = aName + ".local.";
            this._localHost = new HostInfo(address, aName);
            this.openMulticastSocket(this.getLocalHost());
            this.start(this.getServices().values());
        }
        catch (IOException e) {
            this._localHost = new HostInfo(null, "computer");
            this.openMulticastSocket(this.getLocalHost());
            this.start(this.getServices().values());
        }
    }

    private void start(Collection<? extends ServiceInfo> serviceInfos) {
        this.setState(DNSState.PROBING_1);
        this._incomingListener.start();
        new Prober(this).start(this._timer);
        for (ServiceInfo serviceInfo : serviceInfos) {
            try {
                this.registerService(new ServiceInfoImpl(serviceInfo));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        if (this._group == null) {
            this._group = InetAddress.getByName("224.0.0.251");
        }
        if (this._socket != null) {
            this.closeMulticastSocket();
        }
        this._socket = new MulticastSocket(5353);
        if (hostInfo != null && this._localHost.getInterface() != null) {
            this._socket.setNetworkInterface(hostInfo.getInterface());
        }
        this._socket.setTimeToLive(255);
        this._socket.joinGroup(this._group);
    }

    private void closeMulticastSocket() {
        logger.finer("closeMulticastSocket()");
        if (this._socket != null) {
            try {
                this._socket.leaveGroup(this._group);
                this._socket.close();
                if (this._incomingListener != null) {
                    this._incomingListener.join();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "closeMulticastSocket() Close socket exception ", exception);
            }
            this._socket = null;
        }
    }

    public synchronized void advanceState() {
        this.setState(this.getState().advance());
        this.notifyAll();
    }

    synchronized void revertState() {
        this.setState(this.getState().revert());
        this.notifyAll();
    }

    public DNSState getState() {
        return this._state;
    }

    public DNSCache getCache() {
        return this._cache;
    }

    public HostInfo getLocalHost() {
        return this._localHost;
    }

    public InetAddress getInterface() throws IOException {
        return this._socket.getInterface();
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(String type, String name, int timeout) {
        ServiceInfoImpl info = new ServiceInfoImpl(type, name);
        new ServiceInfoResolver(this, info).start(this._timer);
        try {
            ServiceInfoImpl serviceInfoImpl = info;
            synchronized (serviceInfoImpl) {
                long delay;
                long end = System.currentTimeMillis() + (long)timeout;
                while (!info.hasData() && (delay = end - System.currentTimeMillis()) > 0L) {
                    info.wait(delay);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return info.hasData() ? info : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestServiceInfo(String type, String name, int timeout) {
        this.registerServiceType(type);
        ServiceInfoImpl info = new ServiceInfoImpl(type, name);
        new ServiceInfoResolver(this, info).start(this._timer);
        try {
            ServiceInfoImpl serviceInfoImpl = info;
            synchronized (serviceInfoImpl) {
                long delay;
                long end = System.currentTimeMillis() + (long)timeout;
                while (!info.hasData() && (delay = end - System.currentTimeMillis()) > 0L) {
                    info.wait(delay);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceInfoImpl info) {
        List list = (List)this._serviceListeners.get(info.getType().toLowerCase());
        List<ServiceListener> listCopy = Collections.emptyList();
        if (list != null && !list.isEmpty()) {
            List list2 = list;
            synchronized (list2) {
                listCopy = new ArrayList<ServiceListener>(list);
            }
            ServiceEventImpl event = new ServiceEventImpl(this, info.getType(), info.getName(), info);
            for (ServiceListener listener : listCopy) {
                listener.serviceResolved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        String lotype = type.toLowerCase();
        this.removeServiceListener(lotype, listener);
        List list = (List)this._serviceListeners.get(lotype);
        if (list == null) {
            this._serviceListeners.putIfAbsent(lotype, new LinkedList());
            list = (List)this._serviceListeners.get(lotype);
        }
        List list2 = list;
        synchronized (list2) {
            if (!list.contains(listener)) {
                list.add(listener);
            }
        }
        ArrayList<ServiceEventImpl> serviceEvents = new ArrayList<ServiceEventImpl>();
        Collection<DNSEntry> dnsEntryLits = this.getCache().allValues();
        for (DNSEntry dNSEntry : dnsEntryLits) {
            DNSRecord record = (DNSRecord)dNSEntry;
            if (!DNSRecordType.TYPE_SRV.equals((Object)record.getRecordType()) || !record.getName().endsWith(type)) continue;
            serviceEvents.add(new ServiceEventImpl(this, type, JmDNSImpl.toUnqualifiedName(type, record.getName()), null));
        }
        for (ServiceEvent serviceEvent : serviceEvents) {
            listener.serviceAdded(serviceEvent);
        }
        new ServiceResolver(this, type).start(this._timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String type, ServiceListener listener) {
        String aType = type.toLowerCase();
        List list = (List)this._serviceListeners.get(aType);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                list.remove(listener);
                if (list.isEmpty()) {
                    this._serviceListeners.remove(aType, list);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceInfo infoAbstract) throws IOException {
        ServiceInfoImpl info = (ServiceInfoImpl)infoAbstract;
        this.registerServiceType(info.getType());
        info.setServer(this._localHost.getName());
        info.setAddress(this._localHost.getAddress());
        this.makeServiceNameUnique(info);
        while (this._services.putIfAbsent(info.getQualifiedName().toLowerCase(), info) != null) {
            this.makeServiceNameUnique(info);
        }
        new Prober(this).start(this._timer);
        try {
            ServiceInfoImpl serviceInfoImpl = info;
            synchronized (serviceInfoImpl) {
                while (!info.getState().isAnnounced()) {
                    info.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.fine("registerService() JmDNS registered service as " + info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllServices() {
        logger.finer("unregisterAllServices()");
        if (this._services.size() == 0) {
            return;
        }
        ArrayList<ServiceInfo> list = new ArrayList<ServiceInfo>(this._services.size());
        for (Object name : this._services.keySet()) {
            ServiceInfo info = (ServiceInfo)this._services.get(name);
            if (info == null) continue;
            this._services.remove(name, info);
            ((ServiceInfoImpl)info).cancel();
            list.add(info);
        }
        Object lock = new Object();
        new Canceler(this, list, lock).start(this._cancelerTimer);
        try {
            Object name;
            name = lock;
            synchronized (name) {
                if (!this._closed) {
                    lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void registerServiceType(String type) {
        String name = type.toLowerCase();
        if (!this._serviceTypes.containsKey(name) && type.indexOf("._mdns._udp.") < 0 && !type.endsWith(".in-addr.arpa.")) {
            boolean typeAdded;
            boolean bl = typeAdded = this._serviceTypes.putIfAbsent(name, type) == null;
            if (typeAdded) {
                ServiceTypeListener[] list;
                for (ServiceTypeListener listener : list = this._typeListeners.toArray(new ServiceTypeListener[this._typeListeners.size()])) {
                    listener.serviceTypeAdded(new ServiceEventImpl(this, type, null, null));
                }
            }
        }
    }

    private boolean makeServiceNameUnique(ServiceInfoImpl info) {
        boolean collision;
        String originalQualifiedName = info.getQualifiedName();
        long now = System.currentTimeMillis();
        do {
            ServiceInfo selfService;
            collision = false;
            Collection<? extends DNSEntry> entryList = this.getCache().getDNSEntryList(info.getQualifiedName().toLowerCase());
            if (entryList != null) {
                for (DNSEntry dNSEntry : entryList) {
                    if (!DNSRecordType.TYPE_SRV.equals((Object)dNSEntry.getRecordType()) || dNSEntry.isExpired(now)) continue;
                    DNSRecord.Service s = (DNSRecord.Service)dNSEntry;
                    if (s._port == info.getPort() && s._server.equals(this._localHost.getName())) continue;
                    logger.finer("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + dNSEntry + " s.server=" + s._server + " " + this._localHost.getName() + " equals:" + s._server.equals(this._localHost.getName()));
                    info.setName(this.incrementName(info.getName()));
                    collision = true;
                    break;
                }
            }
            if ((selfService = (ServiceInfo)this._services.get(info.getQualifiedName().toLowerCase())) == null || selfService == info) continue;
            info.setName(this.incrementName(info.getName()));
            collision = true;
        } while (collision);
        return !originalQualifiedName.equals(info.getQualifiedName());
    }

    String incrementName(String name) {
        String aName = name;
        try {
            int l = aName.lastIndexOf(40);
            int r = aName.lastIndexOf(41);
            aName = l >= 0 && l < r ? aName.substring(0, l) + "(" + (Integer.parseInt(aName.substring(l + 1, r)) + 1) + ")" : aName + " (2)";
        }
        catch (NumberFormatException e) {
            aName = aName + " (2)";
        }
        return aName;
    }

    public void addListener(DNSListener listener, DNSQuestion question) {
        Collection<? extends DNSEntry> entryList;
        long now = System.currentTimeMillis();
        this._listeners.add(listener);
        if (question != null && (entryList = this.getCache().getDNSEntryList(question.getName().toLowerCase())) != null) {
            for (DNSEntry dNSEntry : entryList) {
                if (!question.answeredBy(dNSEntry) || dNSEntry.isExpired(now)) continue;
                listener.updateRecord(this.getCache(), now, dNSEntry);
            }
        }
    }

    public void removeListener(DNSListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long now, DNSRecord rec) {
        block13: {
            ArrayList<DNSListener> listenerList = null;
            List<DNSListener> list = this._listeners;
            synchronized (list) {
                listenerList = new ArrayList<DNSListener>(this._listeners);
            }
            for (DNSListener listener : listenerList) {
                listener.updateRecord(this.getCache(), now, rec);
            }
            if (!DNSRecordType.TYPE_PTR.equals((Object)rec.getRecordType()) && !DNSRecordType.TYPE_SRV.equals((Object)rec.getRecordType())) break block13;
            List list2 = (List)this._serviceListeners.get(rec.getName().toLowerCase());
            List<ServiceListener> serviceListenerList = Collections.emptyList();
            if (list2 != null) {
                List list3 = list2;
                synchronized (list3) {
                    serviceListenerList = new ArrayList<ServiceListener>(list2);
                }
            }
            if (!serviceListenerList.isEmpty()) {
                boolean expired = rec.isExpired(now);
                String type = rec.getName();
                String name = DNSRecordType.TYPE_PTR.equals((Object)rec.getRecordType()) ? ((DNSRecord.Pointer)rec).getAlias() : ((DNSRecord.Service)rec).getServer();
                ServiceEventImpl event = new ServiceEventImpl(this, type, JmDNSImpl.toUnqualifiedName(type, name), null);
                if (!expired) {
                    for (ServiceListener listener : serviceListenerList) {
                        listener.serviceAdded(event);
                    }
                } else {
                    for (ServiceListener listener : serviceListenerList) {
                        listener.serviceRemoved(event);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        block3: for (DNSRecord dNSRecord : msg.getAllAnswers()) {
            void var7_6;
            boolean isInformative = false;
            boolean expired = dNSRecord.isExpired(now);
            DNSRecord c = (DNSRecord)this.getCache().getDNSEntry(dNSRecord);
            if (c != null) {
                if (expired) {
                    isInformative = true;
                    this.getCache().remove(c);
                } else {
                    c.resetTTL(dNSRecord);
                    DNSRecord dNSRecord2 = c;
                }
            } else if (!expired) {
                isInformative = true;
                this.getCache().addDNSEntry(dNSRecord);
            }
            switch (var7_6.getRecordType()) {
                case TYPE_PTR: {
                    if (var7_6.getName().indexOf("._mdns._udp.") >= 0) {
                        if (expired || !var7_6._name.startsWith("_services._mdns._udp.")) continue block3;
                        isInformative = true;
                        this.registerServiceType(((DNSRecord.Pointer)var7_6)._alias);
                        continue block3;
                    }
                    this.registerServiceType(var7_6._name);
                    break;
                }
            }
            if (DNSRecordType.TYPE_A.equals((Object)var7_6.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)var7_6.getRecordType())) {
                hostConflictDetected |= var7_6.handleResponse(this);
            } else {
                serviceConflictDetected |= var7_6.handleResponse(this);
            }
            if (!isInformative) continue;
            this.updateRecord(now, (DNSRecord)var7_6);
        }
        if (hostConflictDetected || serviceConflictDetected) {
            new Prober(this).start(this._timer);
        }
    }

    void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        boolean conflictDetected = false;
        long expirationTime = System.currentTimeMillis() + 120L;
        for (DNSRecord dNSRecord : in.getAllAnswers()) {
            conflictDetected |= dNSRecord.handleQuery(this, expirationTime);
        }
        if (this._plannedAnswer != null) {
            this._plannedAnswer.append(in);
        } else {
            if (in.isTruncated()) {
                this._plannedAnswer = in;
            }
            new Responder(this, in, addr, port).start();
        }
        if (conflictDetected) {
            new Prober(this).start(this._timer);
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        if (newOut == null) {
            newOut = new DNSOutgoing(33792);
        }
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            newOut.setFlags(newOut.getFlags() | 0x200);
            newOut.setId(in.getId());
            newOut.finish();
            this.send(newOut);
            newOut = new DNSOutgoing(33792);
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public void send(DNSOutgoing dNSOutgoing) throws IOException {
        dNSOutgoing.finish();
        if (!dNSOutgoing.isEmpty()) {
            Object object;
            DatagramPacket datagramPacket = new DatagramPacket(dNSOutgoing._data, dNSOutgoing._off, this._group, 5353);
            try {
                object = new DNSIncoming(datagramPacket);
                logger.finest("send() JmDNS out:" + ((DNSIncoming)object).print(true));
            }
            catch (IOException iOException) {
                logger.throwing(this.getClass().toString(), "send(DNSOutgoing) - JmDNS can not parse what it sends!!!", iOException);
            }
            object = this._socket;
            if (object != null && !((DatagramSocket)object).isClosed()) {
                ((DatagramSocket)object).send(datagramPacket);
            }
        }
    }

    public void startAnnouncer() {
        new Announcer(this).start(this._timer);
    }

    public void startRenewer() {
        new Renewer(this).start(this._timer);
    }

    public void schedule(TimerTask task, int delay) {
        this._timer.schedule(task, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        logger.finer("recover()");
        if (DNSState.CANCELED != this.getState()) {
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                logger.finer("recover() Cleanning up");
                this.setState(DNSState.CANCELED);
                ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>(this.getServices().values());
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.getCache().clear();
                logger.finer("recover() All is clean");
                try {
                    this.openMulticastSocket(this.getLocalHost());
                    this.start(arrayList);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "recover() Start services exception ", exception);
                }
                logger.log(Level.WARNING, "recover() We are back!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.getState() != DNSState.CANCELED) {
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                this.setState(DNSState.CANCELED);
                this._timer.cancel();
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this._cancelerTimer.cancel();
                this.closeMulticastSocket();
                if (this._shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(this._shutdown);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t---- Services -----");
        for (String string : this._services.keySet()) {
            stringBuffer.append("\n\t\tService: " + string + ": " + this._services.get(string));
        }
        stringBuffer.append("\n");
        stringBuffer.append("\t---- Types ----");
        for (String string : this._serviceTypes.keySet()) {
            stringBuffer.append("\n\t\tType: " + string + ": " + (String)this._serviceTypes.get(string));
        }
        stringBuffer.append("\n");
        stringBuffer.append(this._cache.toString());
        stringBuffer.append("\n");
        stringBuffer.append("\t---- Service Collectors ----");
        for (String string : this._serviceCollectors.keySet()) {
            stringBuffer.append("\n\t\tService Collector: " + string + ": " + this._serviceCollectors.get(string));
        }
        return stringBuffer.toString();
    }

    private void disposeServiceCollectors() {
        logger.finer("disposeServiceCollectors()");
        for (String string : this._serviceCollectors.keySet()) {
            ServiceCollector serviceCollector = (ServiceCollector)this._serviceCollectors.get(string);
            if (serviceCollector != null) {
                this.removeServiceListener(string, serviceCollector);
            }
            this._serviceCollectors.remove(string, serviceCollector);
        }
    }

    private static String toUnqualifiedName(String type, String qualifiedName) {
        if (qualifiedName.endsWith(type)) {
            return qualifiedName.substring(0, qualifiedName.length() - type.length() - 1);
        }
        return qualifiedName;
    }

    public void setState(DNSState state) {
        this._state = state;
    }

    public void setTask(TimerTask task) {
        this._task = task;
    }

    public TimerTask getTask() {
        return this._task;
    }

    public Map<String, ServiceInfo> getServices() {
        return this._services;
    }

    public void setLastThrottleIncrement(long lastThrottleIncrement) {
        this._lastThrottleIncrement = lastThrottleIncrement;
    }

    public long getLastThrottleIncrement() {
        return this._lastThrottleIncrement;
    }

    public void setThrottle(int throttle) {
        this._throttle = throttle;
    }

    public int getThrottle() {
        return this._throttle;
    }

    public static Random getRandom() {
        return _random;
    }

    public Object getIoLock() {
        return this._ioLock;
    }

    public void setPlannedAnswer(DNSIncoming plannedAnswer) {
        this._plannedAnswer = plannedAnswer;
    }

    public DNSIncoming getPlannedAnswer() {
        return this._plannedAnswer;
    }

    public Map<String, String> getServiceTypes() {
        return this._serviceTypes;
    }

    public void setClosed(boolean closed) {
        this._closed = closed;
    }

    public MulticastSocket getSocket() {
        return this._socket;
    }

    public InetAddress getGroup() {
        return this._group;
    }

    private static class ServiceCollector
    implements ServiceListener {
        private final ConcurrentMap<String, ServiceInfo> _infos;
        private final String _type;

        public void serviceAdded(ServiceEvent event) {
            event.getDNS().requestServiceInfo(event.getType(), event.getName(), 0);
        }

        public void serviceRemoved(ServiceEvent event) {
            this._infos.remove(event.getName());
        }

        public void serviceResolved(ServiceEvent event) {
            this._infos.put(event.getName(), event.getInfo());
        }

        public String toString() {
            StringBuffer aLog = new StringBuffer();
            aLog.append("\n\ttype: " + this._type);
            for (String key : this._infos.keySet()) {
                aLog.append("\n\t\tService: " + key + ": " + this._infos.get(key));
            }
            return aLog.toString();
        }
    }
}

