/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public abstract class DNSRecord
extends DNSEntry {
    private static Logger logger = Logger.getLogger(DNSRecord.class.getName());
    private int _ttl;
    private long _created;
    private InetAddress _source;

    DNSRecord(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl) {
        super(name, type, recordClass, unique);
        this._ttl = ttl;
        this._created = System.currentTimeMillis();
    }

    public boolean equals(Object other) {
        return other instanceof DNSRecord && this.sameAs((DNSRecord)other);
    }

    boolean sameAs(DNSRecord other) {
        return super.equals(other) && this.sameValue(other);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean sameType(DNSRecord other) {
        return this._type == other._type;
    }

    abstract boolean handleQuery(JmDNSImpl var1, long var2);

    abstract boolean handleResponse(JmDNSImpl var1);

    boolean suppressedBy(DNSIncoming msg) {
        try {
            for (DNSRecord dNSRecord : msg.getAllAnswers()) {
                if (!this.suppressedBy(dNSRecord)) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "suppressedBy() message " + msg + " exception ", e);
            return false;
        }
    }

    boolean suppressedBy(DNSRecord other) {
        return this.sameAs(other) && other._ttl > this._ttl / 2;
    }

    long getExpirationTime(int percent) {
        return this._created + (long)(percent * this._ttl) * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    public boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    void resetTTL(DNSRecord other) {
        this._created = other._created;
        this._ttl = other._ttl;
    }

    abstract void write(DNSOutgoing var1) throws IOException;

    public void setRecordSource(InetAddress source) {
        this._source = source;
    }

    public InetAddress getRecordSource() {
        return this._source;
    }

    public int getTTL() {
        return this._ttl;
    }

    public static class HostInformation
    extends DNSRecord {
        String _os;
        String _cpu;

        public HostInformation(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, String cpu, String os) {
            super(name, type, recordClass, unique, ttl);
            this._cpu = cpu;
            this._os = os;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        boolean sameValue(DNSRecord other) {
            HostInformation hinfo = (HostInformation)other;
            return this._cpu.equals(hinfo._cpu) && this._os.equals(hinfo._os);
        }

        void write(DNSOutgoing out) throws IOException {
            String hostInfo = this._cpu + " " + this._os;
            out.writeUTF(hostInfo, 0, hostInfo.length());
        }

        public void toString(StringBuilder aLog) {
            aLog.append(" cpu: '" + this._cpu + "' os: '" + this._os + "'");
        }
    }

    public static class Service
    extends DNSRecord {
        private static Logger logger1 = Logger.getLogger(Service.class.getName());
        int _priority;
        int _weight;
        int _port;
        String _server;

        public Service(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, int priority, int weight, int port, String server) {
            super(name, type, recordClass, unique, ttl);
            this._priority = priority;
            this._weight = weight;
            this._port = port;
            this._server = server;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeShort(this._priority);
            out.writeShort(this._weight);
            out.writeShort(this._port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                out.writeName(this._server, false);
            } else {
                out.writeUTF(this._server, 0, this._server.length());
                out.writeByte(0);
            }
        }

        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            dout.writeShort(this._priority);
            dout.writeShort(this._weight);
            dout.writeShort(this._port);
            try {
                dout.write(this._server.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        String getServer() {
            return this._server;
        }

        boolean sameValue(DNSRecord other) {
            Service s = (Service)other;
            return this._priority == s._priority && this._weight == s._weight && this._port == s._port && this._server.equals(s._server);
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this._name.toLowerCase());
            if (!(info == null || this._port == info.getPort() && this._server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger1.finer("handleQuery() Conflicting probe detected from: " + this.getRecordSource());
                Service localService = new Service(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName());
                try {
                    if (dns.getInterface().equals(this.getRecordSource())) {
                        logger1.warning("Got conflicting probe from ourselves\nincoming: " + this.toString() + "\n" + "local   : " + localService.toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int comparison = this.compareTo(localService);
                if (comparison == 0) {
                    logger1.finer("handleQuery() Ignoring a identical service query");
                    return false;
                }
                if (!info.getState().isProbing() || comparison <= 0) {
                    return false;
                }
                String oldName = info.getQualifiedName().toLowerCase();
                info.setName(dns.incrementName(info.getName()));
                dns.getServices().remove(oldName);
                dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                logger1.finer("handleQuery() Lost tie break: new unique name chosen:" + info.getName());
                info.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this._name.toLowerCase());
            if (!(info == null || this._port == info.getPort() && this._server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger1.finer("handleResponse() Denial detected");
                if (info.getState().isProbing()) {
                    String oldName = info.getQualifiedName().toLowerCase();
                    info.setName(dns.incrementName(info.getName()));
                    dns.getServices().remove(oldName);
                    dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                    logger1.finer("handleResponse() New unique name chose:" + info.getName());
                }
                info.revertState();
                return true;
            }
            return false;
        }

        public void toString(StringBuilder aLog) {
            aLog.append(" server: '" + this._server + ":" + this._port + "'");
        }
    }

    public static class Text
    extends DNSRecord {
        byte[] _text;

        public Text(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, byte[] text) {
            super(name, type, recordClass, unique, ttl);
            this._text = text;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeBytes(this._text, 0, this._text.length);
        }

        boolean sameValue(DNSRecord other) {
            Text txt = (Text)other;
            if (txt._text.length != this._text.length) {
                return false;
            }
            int i = this._text.length;
            while (i-- > 0) {
                if (txt._text[i] == this._text[i]) continue;
                return false;
            }
            return true;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        public void toString(StringBuilder aLog) {
            aLog.append(" text: '" + (this._text.length > 10 ? new String(this._text, 0, 7) + "..." : new String(this._text)) + "'");
        }
    }

    public static class Pointer
    extends DNSRecord {
        String _alias;

        public Pointer(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, String alias) {
            super(name, type, recordClass, unique, ttl);
            this._alias = alias;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeName(this._alias);
        }

        boolean sameValue(DNSRecord other) {
            return this._alias.equals(((Pointer)other)._alias);
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        String getAlias() {
            return this._alias;
        }

        public void toString(StringBuilder aLog) {
            aLog.append(" alias: '" + (this._alias != null ? this._alias.toString() : "null") + "'");
        }
    }

    public static class Address
    extends DNSRecord {
        private static Logger logger1 = Logger.getLogger(Address.class.getName());
        InetAddress _addr;

        Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, type, recordClass, unique, ttl);
            this._addr = addr;
        }

        Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, type, recordClass, unique, ttl);
            try {
                this._addr = InetAddress.getByAddress(rawAddress);
            }
            catch (UnknownHostException exception) {
                logger1.log(Level.WARNING, "Address() exception ", exception);
            }
        }

        void write(DNSOutgoing out) throws IOException {
            if (this._addr != null) {
                byte[] tempbuffer;
                byte[] buffer = this._addr.getAddress();
                if (DNSRecordType.TYPE_A.equals((Object)this.getRecordType())) {
                    if (!(this._addr instanceof Inet4Address)) {
                        tempbuffer = buffer;
                        buffer = new byte[4];
                        System.arraycopy(tempbuffer, 12, buffer, 0, 4);
                    }
                } else if (this._addr instanceof Inet4Address) {
                    tempbuffer = buffer;
                    buffer = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        buffer[i] = i < 11 ? tempbuffer[i - 12] : (byte)0;
                    }
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        boolean sameName(DNSRecord other) {
            return this._name.equalsIgnoreCase(((Address)other)._name);
        }

        boolean sameValue(DNSRecord other) {
            return this._addr.equals(((Address)other).getAddress());
        }

        InetAddress getAddress() {
            return this._addr;
        }

        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            byte[] buffer = this._addr.getAddress();
            for (int i = 0; i < buffer.length; ++i) {
                dout.writeByte(buffer[i]);
            }
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            Address dnsAddress = dns.getLocalHost().getDNSAddressRecord(this);
            if (dnsAddress != null && dnsAddress.sameType(this) && dnsAddress.sameName(this) && !dnsAddress.sameValue(this)) {
                logger1.finer("handleQuery() Conflicting probe detected. dns state " + (Object)((Object)dns.getState()) + " lex compare " + this.compareTo(dnsAddress));
                if (dns.getState().isProbing() && this.compareTo(dnsAddress) >= 0) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfoImpl serviceInfoImpl : dns.getServices().values()) {
                        serviceInfoImpl.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            Address dnsAddress = dns.getLocalHost().getDNSAddressRecord(this);
            if (dnsAddress != null && dnsAddress.sameType(this) && dnsAddress.sameName(this) && !dnsAddress.sameValue(this)) {
                logger1.finer("handleResponse() Denial detected");
                if (dns.getState().isProbing()) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfoImpl serviceInfoImpl : dns.getServices().values()) {
                        serviceInfoImpl.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        public void toString(StringBuilder aLog) {
            aLog.append(" address: '" + (this._addr != null ? this._addr.getHostAddress() : "null") + "'");
        }
    }
}

