/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.constants.DNSLabel;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSResultCode;

public final class DNSIncoming
extends DNSMessage {
    private static Logger logger = Logger.getLogger(DNSIncoming.class.getName());
    public static boolean USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET = true;
    private DatagramPacket _packet;
    private int _off;
    private int _len;
    private byte[] _data;
    private long _receivedTime;

    DNSIncoming(DatagramPacket packet) throws IOException {
        super(0, 0, packet.getPort() == 5353);
        this._packet = packet;
        InetAddress source = packet.getAddress();
        this._data = packet.getData();
        this._len = packet.getLength();
        this._off = packet.getOffset();
        this._receivedTime = System.currentTimeMillis();
        try {
            DNSRecord rec;
            int i;
            this._id = this.readUnsignedShort();
            this._flags = this.readUnsignedShort();
            int numQuestions = this.readUnsignedShort();
            int numAnswers = this.readUnsignedShort();
            int numAuthorities = this.readUnsignedShort();
            int numAdditionals = this.readUnsignedShort();
            if (numQuestions > 0) {
                for (i = 0; i < numQuestions; ++i) {
                    this._questions.add(this.readQuestion());
                }
            }
            if (numAnswers > 0) {
                for (i = 0; i < numAnswers; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this._answers.add(rec);
                }
            }
            if (numAuthorities > 0) {
                for (i = 0; i < numAuthorities; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this._authoritativeAnswers.add(rec);
                }
            }
            if (numAdditionals > 0) {
                for (i = 0; i < numAdditionals; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this._additionals.add(rec);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "DNSIncoming() dump " + this.print(true) + "\n exception ", e);
            throw e;
        }
    }

    private DNSQuestion readQuestion() throws IOException {
        String domain = this.readName();
        DNSRecordType type = DNSRecordType.typeForIndex(this.readUnsignedShort());
        DNSRecordClass recordClass = DNSRecordClass.classForIndex(this.readUnsignedShort());
        boolean unique = recordClass != null ? recordClass.isUnique() : false;
        return new DNSQuestion(domain, type, recordClass, unique);
    }

    private DNSRecord readAnswer(InetAddress source) throws IOException {
        String domain = this.readName();
        DNSRecordType type = DNSRecordType.typeForIndex(this.readUnsignedShort());
        int recordClassIndex = this.readUnsignedShort();
        DNSRecordClass recordClass = type == DNSRecordType.TYPE_OPT ? DNSRecordClass.CLASS_UNKNOWN : DNSRecordClass.classForIndex(recordClassIndex);
        boolean unique = recordClass.isUnique();
        int ttl = this.readInt();
        int len = this.readUnsignedShort();
        int end = this._off + len;
        DNSRecord rec = null;
        switch (type) {
            case TYPE_A: 
            case TYPE_AAAA: {
                rec = new DNSRecord.Address(domain, type, recordClass, unique, ttl, this.readBytes(this._off, len));
                break;
            }
            case TYPE_CNAME: 
            case TYPE_PTR: {
                String service = "";
                try {
                    service = this.readName();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "There was a problem reading the service name of the answer.", e);
                }
                rec = new DNSRecord.Pointer(domain, type, recordClass, unique, ttl, service);
                break;
            }
            case TYPE_TXT: {
                rec = new DNSRecord.Text(domain, type, recordClass, unique, ttl, this.readBytes(this._off, len));
                break;
            }
            case TYPE_SRV: {
                int priority = this.readUnsignedShort();
                int weight = this.readUnsignedShort();
                int port = this.readUnsignedShort();
                String target = "";
                try {
                    target = USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET ? this.readName() : this.readNonNameString();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "There was a problem reading the label of the answer. This can happen if the type of the label  cannot be handled.", e);
                }
                rec = new DNSRecord.Service(domain, type, recordClass, unique, ttl, priority, weight, port, target);
                break;
            }
            case TYPE_HINFO: {
                StringBuffer buf = new StringBuffer();
                this.readUTF(buf, this._off, len);
                int index = buf.indexOf(" ");
                String cpu = (index > 0 ? buf.substring(0, index) : buf.toString()).trim();
                String os = (index > 0 ? buf.substring(index + 1) : "").trim();
                rec = new DNSRecord.HostInformation(domain, type, recordClass, unique, ttl, cpu, os);
                break;
            }
            case TYPE_OPT: {
                int senderUDPPayload = recordClassIndex;
                DNSResultCode extendedResultCode = DNSResultCode.resultCodeForFlags(this._flags, ttl);
                int version = (ttl & 0xFF0000) >> 16;
                logger.log(Level.WARNING, "There was an OPT answer. Not currently handled. Payload: " + senderUDPPayload + "extended result code: " + (Object)((Object)extendedResultCode) + " version: " + version);
                break;
            }
            default: {
                logger.finer("DNSIncoming() unknown type:" + (Object)((Object)type));
            }
        }
        if (rec != null) {
            rec.setRecordSource(source);
        }
        this._off = end;
        return rec;
    }

    private int get(int off) throws IOException {
        if (off < 0 || off >= this._len) {
            throw new IOException("parser error: offset=" + off);
        }
        return this._data[off] & 0xFF;
    }

    private int readUnsignedShort() throws IOException {
        return this.get(this._off++) << 8 | this.get(this._off++);
    }

    private int readInt() throws IOException {
        return this.readUnsignedShort() << 16 | this.readUnsignedShort();
    }

    private byte[] readBytes(int off, int len) throws IOException {
        byte[] bytes = new byte[len];
        System.arraycopy(this._data, off, bytes, 0, len);
        return bytes;
    }

    private void readUTF(StringBuffer buf, int off, int len) throws IOException {
        int offset = off;
        int end = offset + len;
        while (offset < end) {
            int ch = this.get(offset++);
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    ch = (ch & 0x1F) << 6 | this.get(offset++) & 0x3F;
                    break;
                }
                case 14: {
                    ch = (ch & 0xF) << 12 | (this.get(offset++) & 0x3F) << 6 | this.get(offset++) & 0x3F;
                    break;
                }
                default: {
                    ch = (ch & 0x3F) << 4 | this.get(offset++) & 0xF;
                }
            }
            buf.append((char)ch);
        }
    }

    private String readNonNameString() throws IOException {
        StringBuffer buf = new StringBuffer();
        int off = this._off;
        int len = this.get(off++);
        this.readUTF(buf, off, len);
        return buf.toString();
    }

    private String readName() throws IOException {
        int len;
        StringBuffer buf = new StringBuffer();
        int off = this._off;
        int next = -1;
        int first = off;
        block5: while ((len = this.get(off++)) != 0) {
            switch (DNSLabel.labelForByte(len)) {
                case Standard: {
                    this.readUTF(buf, off, len);
                    off += len;
                    buf.append('.');
                    continue block5;
                }
                case Compressed: {
                    if (next < 0) {
                        next = off + 1;
                    }
                    if ((off = DNSLabel.labelValue(len) << 8 | this.get(off++)) >= first) {
                        throw new IOException("bad domain name: possible circular name detected. name start: " + first + " bad offset: 0x" + Integer.toHexString(off));
                    }
                    first = off;
                    continue block5;
                }
                case Extended: {
                    logger.severe("Extended label are not currently supported.");
                    continue block5;
                }
            }
            throw new IOException("unsupported dns label type: '" + Integer.toHexString(len & 0xC0) + "' at " + (off - 1));
        }
        this._off = next >= 0 ? next : off;
        return buf.toString();
    }

    String print(boolean dump) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString() + "\n");
        for (DNSQuestion question : this._questions) {
            buf.append("    ques:" + question + "\n");
        }
        for (DNSRecord answer : this._answers) {
            buf.append("    answ:" + answer + "\n");
        }
        for (DNSRecord answer : this._authoritativeAnswers) {
            buf.append("    auth:" + answer + "\n");
        }
        for (DNSRecord answer : this._additionals) {
            buf.append("    addi:" + answer + "\n");
        }
        if (dump) {
            int len = this._packet.getLength();
            for (int off = 0; off < len; off += 32) {
                int i;
                int n = Math.min(32, len - off);
                if (off < 10) {
                    buf.append(' ');
                }
                if (off < 100) {
                    buf.append(' ');
                }
                buf.append(off);
                buf.append(':');
                for (i = 0; i < n; ++i) {
                    if (i % 8 == 0) {
                        buf.append(' ');
                    }
                    buf.append(Integer.toHexString((this._data[off + i] & 0xF0) >> 4));
                    buf.append(Integer.toHexString((this._data[off + i] & 0xF) >> 0));
                }
                buf.append("\n");
                buf.append("    ");
                for (i = 0; i < n; ++i) {
                    if (i % 8 == 0) {
                        buf.append(' ');
                    }
                    buf.append(' ');
                    int ch = this._data[off + i] & 0xFF;
                    buf.append(ch > 32 && ch < 127 ? (char)ch : (char)'.');
                }
                buf.append("\n");
                if (off + 32 < 256) continue;
                buf.append("....\n");
                break;
            }
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.isQuery() ? "dns[query," : "dns[response,");
        if (this._packet.getAddress() != null) {
            buf.append(this._packet.getAddress().getHostAddress());
        }
        buf.append(':');
        buf.append(this._packet.getPort());
        buf.append(",len=");
        buf.append(this._packet.getLength());
        buf.append(",id=0x");
        buf.append(Integer.toHexString(this._id));
        if (this._flags != 0) {
            buf.append(",flags=0x");
            buf.append(Integer.toHexString(this._flags));
            if ((this._flags & 0x8000) != 0) {
                buf.append(":r");
            }
            if ((this._flags & 0x400) != 0) {
                buf.append(":aa");
            }
            if ((this._flags & 0x200) != 0) {
                buf.append(":tc");
            }
        }
        if (this.getNumberOfQuestions() > 0) {
            buf.append(",questions=");
            buf.append(this.getNumberOfQuestions());
        }
        if (this.getNumberOfAnswers() > 0) {
            buf.append(",answers=");
            buf.append(this.getNumberOfAnswers());
        }
        if (this.getNumberOfAuthorities() > 0) {
            buf.append(",authorities=");
            buf.append(this.getNumberOfAuthorities());
        }
        if (this.getNumberOfAdditionals() > 0) {
            buf.append(",additionals=");
            buf.append(this.getNumberOfAdditionals());
        }
        buf.append("]");
        return buf.toString();
    }

    void append(DNSIncoming that) {
        if (!(this.isQuery() && this.isTruncated() && that.isQuery())) {
            throw new IllegalArgumentException();
        }
        this._questions.addAll(that.getQuestions());
        this._answers.addAll(that.getAnswers());
        this._authoritativeAnswers.addAll(that.getAuthorities());
        this._additionals.addAll(that.getAdditionals());
    }

    public int elapseSinceArrival() {
        return (int)(System.currentTimeMillis() - this._receivedTime);
    }
}

